/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractTotalPriceService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractTotalPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"outcontract"})
public class OutcontractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String LABOROUTCONTRACT_BILL_CODE = "ZJKJ-LABOROUTCONTRACT";
    private static final String MAJOROUTCONTRACT_BILL_CODE = "ZJKJ-MAJOROUTCONTRACT";
    private static final String MATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-MATERIALOUTCONTRACT";
    private static final String EQUIPMENTOUTCONTRACT_BILL_CODE = "ZJKJ-EQUIPMENTOUTCONTRACT";
    private static final String TURNOVERMATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-TURNOVERMATERIALOUTCONTRACT";
    private static final String DESIGNOUTCONTRACT_BILL_CODE = "ZJKJ-DESIGNOUTCONTRACT";
    private static final String CONSULTANCYOUTCONTRACT_BILL_CODE = "ZJKJ-CONSULTANCYOUTCONTRACT";
    private static final String OTHEROUTCONTRACT = "ZJKJ-OTHEROUTCONTRACT";
    @Autowired
    private IOutcontractService service;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    @Autowired
    private IOutcontractSubcontractTotalPriceService outcontractSubcontractTotalPriceService;
    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractVO> saveOrUpdate(@RequestBody OutcontractVO saveOrUpdateVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutcontractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String code = "";
            entity.setChangeState("1");
            if ("\u52b3\u52a1\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = LABOROUTCONTRACT_BILL_CODE;
            } else if ("\u4e13\u4e1a\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = MAJOROUTCONTRACT_BILL_CODE;
            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(saveOrUpdateVO.getType())) {
                code = MATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u673a\u68b0\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = EQUIPMENTOUTCONTRACT_BILL_CODE;
            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(saveOrUpdateVO.getType())) {
                code = DESIGNOUTCONTRACT_BILL_CODE;
            } else if ("\u54a8\u8be2\u670d\u52a1".equals(saveOrUpdateVO.getType())) {
                code = CONSULTANCYOUTCONTRACT_BILL_CODE;
            } else if ("\u5176\u5b83\u5408\u540c".equals(saveOrUpdateVO.getType())) {
                code = OTHEROUTCONTRACT;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)code, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getOutcontractSupplierList() != null && saveOrUpdateVO.getOutcontractSupplierList().size() > 0) {
            OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)saveOrUpdateVO.getOutcontractSupplierList().get(0);
            entity.setSupplierName(outcontractSupplierVO.getSupplierName());
            entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());
            entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());
            entity.setSupplierBank(outcontractSupplierVO.getSupplierBank());
            entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());
            entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser());
            entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress());
            entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone());
            entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail());
            entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal());
            entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone());
        } else {
            entity.setSupplierName(null);
            entity.setSupplierTaxPayerType(null);
            entity.setSupplierSocialCreditCode(null);
            entity.setSupplierBank(null);
            entity.setSupplierBankAccount(null);
            entity.setSupplierContactUser(null);
            entity.setSupplierContactUserAddress(null);
            entity.setSupplierContactUserPhone(null);
            entity.setSupplierContactUserEmail(null);
            entity.setSupplierLegal(null);
            entity.setSupplierTelephone(null);
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        vo.setOutcontractSupplierList(saveOrUpdateVO.getOutcontractSupplierList());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutcontractVO> queryDetail(Long id) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(id));
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        ArrayList<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<OutcontractSupplierVO>();
        OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)BeanMapper.map((Object)((Object)entity), OutcontractSupplierVO.class);
        outcontractSupplierVO.setRowState("add");
        outcontractSupplierList.add(outcontractSupplierVO);
        vo.setOutcontractSupplierList(outcontractSupplierList);
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"outcontract_id", (Object)vo.getId());
            List records = this.recordOutcontractService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordOutcontractList(BeanMapper.mapList((Iterable)records, RecordOutcontractVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutcontractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> refOutcontractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveintegratedCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveintegratedCode(@RequestBody OutcontractVO saveorUpdateVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e00\u4f53\u5316\u7f16\u7801\u6210\u529f");
    }

    @RequestMapping(value={"/downloadTotalPrice"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractSubcontractTotalPrice-import.xlsx", (String)"\u5206\u5305\u5de5\u7a0b\u603b\u4ef7\u6c47\u603b\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTotalPric"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OutcontractSubcontractTotalPriceVO> successList = new ArrayList<OutcontractSubcontractTotalPriceVO>();
        ArrayList<OutcontractSubcontractTotalPriceVO> errorList = new ArrayList<OutcontractSubcontractTotalPriceVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal subcontractTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                OutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new OutcontractSubcontractTotalPriceVO();
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u5206\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u6682\u5b9a\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u542b\u7a0e\u7efc\u5408\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                outcontractSubcontractTotalPriceVO.setId(Long.valueOf(IdWorker.getId()));
                outcontractSubcontractTotalPriceVO.setItemName((String)datas.get(0));
                outcontractSubcontractTotalPriceVO.setUnit((String)datas.get(1));
                outcontractSubcontractTotalPriceVO.setProvisionalQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : null);
                outcontractSubcontractTotalPriceVO.setTaxAllUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                if (outcontractSubcontractTotalPriceVO.getProvisionalQuantity() != null && outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice() != null) {
                    outcontractSubcontractTotalPriceVO.setTotalPrice(outcontractSubcontractTotalPriceVO.getProvisionalQuantity().multiply(outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()));
                }
                if (outcontractSubcontractTotalPriceVO.getTotalPrice() != null) {
                    subcontractTotalAmount = subcontractTotalAmount.add(outcontractSubcontractTotalPriceVO.getTotalPrice());
                }
                outcontractSubcontractTotalPriceVO.setRemark((String)datas.get(5));
                successList.add(outcontractSubcontractTotalPriceVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("subcontractTotalAmount", (Object)subcontractTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportTotalPricFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTotalPricFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.outcontractSubcontractTotalPriceService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTotalPricFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTotalPricFromPage(@RequestBody List<OutcontractSubcontractTotalPriceVO> list, HttpServletResponse response) {
        HashMap<String, List<OutcontractSubcontractTotalPriceVO>> beans = new HashMap<String, List<OutcontractSubcontractTotalPriceVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadUnitPrice"})
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractSubcontractUnitPrice-import.xlsx", (String)"\u5206\u5305\u5de5\u7a0b\u7efc\u5408\u5355\u4ef7\u8ba1\u4ef7\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportUnitPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OutcontractSubcontractUnitPriceVO> successList = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        ArrayList<OutcontractSubcontractUnitPriceVO> errorList = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        HashMap<String, OutcontractSubcontractUnitPriceVO> map = new HashMap<String, OutcontractSubcontractUnitPriceVO>();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                String code;
                List datas = (List)result.get(i);
                OutcontractSubcontractUnitPriceVO unitPriceVO = new OutcontractSubcontractUnitPriceVO();
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    unitPriceVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (((String)datas.get(0)).length() < 2) {
                    unitPriceVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4f4e\u4e8e2\u4f4d\u6570\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    unitPriceVO.setErrorMsg("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    unitPriceVO.setErrorMsg("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    unitPriceVO.setErrorMsg("\u9879\u76ee\u7279\u5f81\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(17)))) {
                    unitPriceVO.setErrorMsg("\u4e3b\u6750\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                unitPriceVO.setListCode((String)datas.get(0));
                unitPriceVO.setInnercode((String)datas.get(0));
                if ("01".equals(datas.get(0)) && ((String)datas.get(1)).contains("\u88c5\u9970")) {
                    unitPriceVO.setInnercode("a1");
                }
                if (((String)datas.get(0)).length() >= 4 && ("0111".equals(code = ((String)datas.get(0)).substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                    unitPriceVO.setInnercode("a1" + ((String)datas.get(0)).substring(2, ((String)datas.get(0)).length()));
                }
                unitPriceVO.setProject((String)datas.get(1));
                unitPriceVO.setJobContent((String)datas.get(2));
                unitPriceVO.setProjectCharacteristic((String)datas.get(3));
                unitPriceVO.setUnit((String)datas.get(4));
                unitPriceVO.setEngineeringQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                BigDecimal comprehensiveUnitPrice = new BigDecimal(0);
                BigDecimal laborCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null;
                BigDecimal mainMaterialCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null;
                BigDecimal materialLoss = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null;
                BigDecimal auxiliaryMaterialCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null;
                BigDecimal machineryCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null;
                BigDecimal managementCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? new BigDecimal((String)datas.get(13)) : null;
                BigDecimal profit = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? new BigDecimal((String)datas.get(14)) : null;
                BigDecimal paidGovernmentCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null;
                BigDecimal tax = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? new BigDecimal((String)datas.get(16)) : null;
                unitPriceVO.setLaborCost(laborCost);
                unitPriceVO.setMainMaterialCost(mainMaterialCost);
                unitPriceVO.setMaterialLoss(materialLoss);
                unitPriceVO.setAuxiliaryMaterialCost(auxiliaryMaterialCost);
                unitPriceVO.setMachineryCost(machineryCost);
                unitPriceVO.setManagementCost(managementCost);
                unitPriceVO.setProfit(profit);
                unitPriceVO.setPaidGovernmentCost(paidGovernmentCost);
                unitPriceVO.setTax(tax);
                if (laborCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(laborCost);
                }
                if (mainMaterialCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(mainMaterialCost);
                }
                if (materialLoss != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(materialLoss);
                }
                if (auxiliaryMaterialCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(auxiliaryMaterialCost);
                }
                if (machineryCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(machineryCost);
                }
                if (managementCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(managementCost);
                }
                if (profit != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(profit);
                }
                if (paidGovernmentCost != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(paidGovernmentCost);
                }
                if (tax != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(tax);
                }
                comprehensiveUnitPrice = comprehensiveUnitPrice.divide(new BigDecimal(9));
                unitPriceVO.setComprehensiveUnitPrice(comprehensiveUnitPrice);
                if (unitPriceVO.getEngineeringQuantity() != null) {
                    unitPriceVO.setTotalPrice(comprehensiveUnitPrice.multiply(unitPriceVO.getEngineeringQuantity()));
                }
                unitPriceVO.setMainMaterialBrand((String)datas.get(17));
                unitPriceVO.setRemark((String)datas.get(18));
                unitPriceVO.setId(Long.valueOf(IdWorker.getId()));
                successList.add(unitPriceVO);
                map.put(unitPriceVO.getInnercode(), unitPriceVO);
            }
        }
        for (OutcontractSubcontractUnitPriceVO vo : successList) {
            Long pid;
            String pcode;
            String innercode = vo.getInnercode();
            if (innercode.length() == 2) continue;
            if (innercode.length() == 4) {
                pcode = innercode.substring(0, 2);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() == 6) {
                pcode = innercode.substring(0, 4);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() <= 6) continue;
            pcode = innercode.substring(0, 6);
            pid = this.setPid(pcode, map);
            vo.setPid(pid);
        }
        result = OutcontractController.createTreeData(successList);
        BigDecimal subcontractUnitTotalAmount = this.getChildrenUnitTotalAmount(result);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", result);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        json.put("subcontractUnitTotalAmount", (Object)subcontractUnitTotalAmount);
        return CommonResponse.success((Object)json);
    }

    private BigDecimal getChildrenUnitTotalAmount(List<OutcontractSubcontractUnitPriceVO> vos) {
        BigDecimal subcontractUnitTotalAmount = new BigDecimal(0);
        for (OutcontractSubcontractUnitPriceVO vo : vos) {
            if (vo.getChildren() != null && vo.getChildren().size() > 0) {
                vo.setEngineeringQuantity(null);
                vo.setComprehensiveUnitPrice(null);
                vo.setLaborCost(null);
                vo.setMainMaterialCost(null);
                vo.setMaterialLoss(null);
                vo.setAuxiliaryMaterialCost(null);
                vo.setMachineryCost(null);
                vo.setManagementCost(null);
                vo.setProfit(null);
                vo.setPaidGovernmentCost(null);
                vo.setTax(null);
                BigDecimal childrenUnitTotalAmount = subcontractUnitTotalAmount.add(this.getChildrenUnitTotalAmount(vo.getChildren()));
                vo.setTotalPrice(childrenUnitTotalAmount);
                subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(childrenUnitTotalAmount);
                continue;
            }
            if (vo.getTotalPrice() == null) continue;
            subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(vo.getTotalPrice());
        }
        return subcontractUnitTotalAmount;
    }

    private Long setPid(String pcode, Map<String, OutcontractSubcontractUnitPriceVO> map) {
        if (map.get(pcode) != null) {
            return map.get(pcode).getId();
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public static List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
        ArrayList<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<String, OutcontractSubcontractUnitPriceVO>();
        for (OutcontractSubcontractUnitPriceVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            OutcontractSubcontractUnitPriceVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            OutcontractSubcontractUnitPriceVO parent = (OutcontractSubcontractUnitPriceVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((OutcontractSubcontractUnitPriceVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportUnitPriceFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUnitPriceFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByAsc((Object)"list_code");
        List list = this.outcontractSubcontractUnitPriceService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportUnitPriceFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUnitPriceFromPage(@RequestBody List<OutcontractSubcontractUnitPriceVO> list, HttpServletResponse response) {
        HashMap<String, List<OutcontractSubcontractUnitPriceVO>> beans = new HashMap<String, List<OutcontractSubcontractUnitPriceVO>>();
        ArrayList<OutcontractSubcontractUnitPriceVO> records = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        for (OutcontractSubcontractUnitPriceVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
    }

    private void splitList(List<OutcontractSubcontractUnitPriceVO> list, List<OutcontractSubcontractUnitPriceVO> records) {
        for (OutcontractSubcontractUnitPriceVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }
}

