/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentLeaseItemService;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentLeaseItemVO;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentRentVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"equipmentExport"})
public class ExportEquipmentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IOutcontractEquipmentLeaseItemService outcontractEquipmentLeaseItemService;
    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;

    @RequestMapping(value={"/downloadEquipmentLease"})
    @ResponseBody
    public void downloadEquipmentLease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractEquipmentLease-import.xlsx", (String)"\u79df\u8d41\u7269\u8fdb\u51fa\u573a\u8d39\u660e\u7ec6\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportEquipmentLease"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportEquipmentLease(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OutcontractEquipmentLeaseItemVO> successList = new ArrayList<OutcontractEquipmentLeaseItemVO>();
        ArrayList<OutcontractEquipmentLeaseItemVO> errorList = new ArrayList<OutcontractEquipmentLeaseItemVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal leaseItemTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                EquipmentVO backVO;
                List datas = (List)result.get(i);
                OutcontractEquipmentLeaseItemVO equipmentLeaseItemVO = new OutcontractEquipmentLeaseItemVO();
                equipmentLeaseItemVO.setId(Long.valueOf(IdWorker.getId()));
                equipmentLeaseItemVO.setEquipmentCode((String)datas.get(0));
                equipmentLeaseItemVO.setEquipmentName((String)datas.get(1));
                equipmentLeaseItemVO.setEquipmentSpec((String)datas.get(2));
                equipmentLeaseItemVO.setEntranceExitFee(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                equipmentLeaseItemVO.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? Integer.valueOf(Integer.parseInt((String)datas.get(4))) : null);
                equipmentLeaseItemVO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                equipmentLeaseItemVO.setTotalPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                if (equipmentLeaseItemVO.getTotalPrice() == null && equipmentLeaseItemVO.getEntranceExitFee() != null && equipmentLeaseItemVO.getQuantity() != null) {
                    equipmentLeaseItemVO.setTotalPrice(equipmentLeaseItemVO.getEntranceExitFee().multiply(new BigDecimal(equipmentLeaseItemVO.getQuantity())));
                }
                equipmentLeaseItemVO.setRemark((String)datas.get(7));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                CommonResponse back = this.shareEquipmentApi.queryEquipmentByCode((String)datas.get(0));
                if (back.isSuccess()) {
                    backVO = (EquipmentVO)back.getData();
                    if (backVO == null) {
                        equipmentLeaseItemVO.setErrorMsg("\u8bbe\u5907\u6863\u6848\u4e0d\u5b58\u5728");
                        errorList.add(equipmentLeaseItemVO);
                        continue;
                    }
                } else {
                    equipmentLeaseItemVO.setErrorMsg("\u8bbe\u5907\u6863\u6848\u6821\u9a8c\u5931\u8d25");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                equipmentLeaseItemVO.setEquipmentId(backVO.getId());
                equipmentLeaseItemVO.setEquipmentName(backVO.getName());
                equipmentLeaseItemVO.setEquipmentCategoryId(backVO.getCategoryId());
                equipmentLeaseItemVO.setEquipmentCategoryName(backVO.getCategoryName());
                equipmentLeaseItemVO.setEquipmentSpec(backVO.getSpec());
                equipmentLeaseItemVO.setEquipmentUnit(backVO.getUnitName());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u8fdb\u51fa\u573a\u8d39\uff08\u5143/\u53f0\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u53f0\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u7a0e\u7387\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (equipmentLeaseItemVO.getTotalPrice() != null) {
                    leaseItemTotalAmount = leaseItemTotalAmount.add(equipmentLeaseItemVO.getTotalPrice());
                }
                successList.add(equipmentLeaseItemVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("leaseItemTotalAmount", (Object)leaseItemTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportEquipmentLeaseFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentLeaseFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.outcontractEquipmentLeaseItemService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractEquipmentLease-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportEquipmentLeaseFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentLeaseFromPage(@RequestBody List<OutcontractEquipmentLeaseItemVO> list, HttpServletResponse response) {
        HashMap<String, List<OutcontractEquipmentLeaseItemVO>> beans = new HashMap<String, List<OutcontractEquipmentLeaseItemVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractEquipmentLease-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadEquipmentRent"})
    @ResponseBody
    public void downloadEquipmentRent(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractEquipmentRent-import.xlsx", (String)"\u79df\u91d1\u660e\u7ec6\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportEquipmentRent"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportEquipmentRent(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OutcontractEquipmentRentVO> successList = new ArrayList<OutcontractEquipmentRentVO>();
        ArrayList<OutcontractEquipmentRentVO> errorList = new ArrayList<OutcontractEquipmentRentVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal rentTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                EquipmentVO backVO;
                List datas = (List)result.get(i);
                OutcontractEquipmentRentVO equipmentLeaseItemVO = new OutcontractEquipmentRentVO();
                equipmentLeaseItemVO.setId(Long.valueOf(IdWorker.getId()));
                equipmentLeaseItemVO.setEquipmentCode((String)datas.get(0));
                equipmentLeaseItemVO.setEquipmentName((String)datas.get(1));
                equipmentLeaseItemVO.setEquipmentSpec((String)datas.get(2));
                equipmentLeaseItemVO.setUntaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                equipmentLeaseItemVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                equipmentLeaseItemVO.setEquipmentUnit((String)datas.get(5));
                equipmentLeaseItemVO.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? Integer.valueOf(Integer.parseInt((String)datas.get(6))) : null);
                equipmentLeaseItemVO.setLeaseTerm(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                equipmentLeaseItemVO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                equipmentLeaseItemVO.setTotalPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                if (equipmentLeaseItemVO.getTaxUnitPrice() == null && equipmentLeaseItemVO.getUntaxUnitPrice() != null && equipmentLeaseItemVO.getTaxRate() != null) {
                    equipmentLeaseItemVO.setTaxUnitPrice(equipmentLeaseItemVO.getUntaxUnitPrice().multiply(new BigDecimal(1).add(equipmentLeaseItemVO.getTaxRate().divide(new BigDecimal(100)))));
                }
                if (equipmentLeaseItemVO.getTotalPrice() == null && equipmentLeaseItemVO.getTaxUnitPrice() != null && equipmentLeaseItemVO.getQuantity() != null && equipmentLeaseItemVO.getLeaseTerm() != null) {
                    equipmentLeaseItemVO.setTotalPrice(equipmentLeaseItemVO.getTaxUnitPrice().multiply(new BigDecimal(equipmentLeaseItemVO.getQuantity())).multiply(equipmentLeaseItemVO.getLeaseTerm()));
                }
                equipmentLeaseItemVO.setRemark((String)datas.get(10));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u8bbe\u5907\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                CommonResponse back = this.shareEquipmentApi.queryEquipmentByCode((String)datas.get(0));
                if (back.isSuccess()) {
                    backVO = (EquipmentVO)back.getData();
                    if (backVO == null) {
                        equipmentLeaseItemVO.setErrorMsg("\u8bbe\u5907\u6863\u6848\u4e0d\u5b58\u5728");
                        errorList.add(equipmentLeaseItemVO);
                        continue;
                    }
                } else {
                    equipmentLeaseItemVO.setErrorMsg("\u8bbe\u5907\u6863\u6848\u6821\u9a8c\u5931\u8d25");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                equipmentLeaseItemVO.setEquipmentId(backVO.getId());
                equipmentLeaseItemVO.setEquipmentName(backVO.getName());
                equipmentLeaseItemVO.setEquipmentCategoryId(backVO.getCategoryId());
                equipmentLeaseItemVO.setEquipmentCategoryName(backVO.getCategoryName());
                equipmentLeaseItemVO.setEquipmentSpec(backVO.getSpec());
                equipmentLeaseItemVO.setEquipmentUnit(backVO.getUnitName());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u4e0d\u542b\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u53f0\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u79df\u8d41\u671f\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    equipmentLeaseItemVO.setErrorMsg("\u7a0e\u7387\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(equipmentLeaseItemVO);
                    continue;
                }
                if (equipmentLeaseItemVO.getTotalPrice() != null) {
                    rentTotalAmount = rentTotalAmount.add(equipmentLeaseItemVO.getTotalPrice());
                }
                successList.add(equipmentLeaseItemVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("rentTotalAmount", (Object)rentTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportEquipmentRentFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentRentFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.outcontractEquipmentRentService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractEquipmentRent-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportEquipmentRentFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEquipmentRentFromPage(@RequestBody List<OutcontractEquipmentRentVO> list, HttpServletResponse response) {
        HashMap<String, List<OutcontractEquipmentRentVO>> beans = new HashMap<String, List<OutcontractEquipmentRentVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractEquipmentRent-export.xlsx", beans, response);
    }
}

