package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractSubcontractTotalPriceService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSubcontractTotalPriceVO;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 分供方合同--劳务、专业导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractChangeExport")
public class ExportChangeSubcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IChangeOutcontractSubcontractTotalPriceService changeoutcontractSubcontractTotalPriceService;
    @Autowired
    private IChangeOutcontractSubcontractUnitPriceService changeOutcontractSubcontractUnitPriceService;

	/********************分包工程总价汇总表导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadTotalPrice")
	@ResponseBody
	public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractSubcontractTotalPrice-import.xlsx", "分包工程总价汇总表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportTotalPric", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ChangeOutcontractSubcontractTotalPriceVO> successList = new ArrayList<>();
		List<ChangeOutcontractSubcontractTotalPriceVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal subcontractTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					ChangeOutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new ChangeOutcontractSubcontractTotalPriceVO();
					
					outcontractSubcontractTotalPriceVO.setId(IdWorker.getId());
					outcontractSubcontractTotalPriceVO.setItemName(datas.get(0)); // 分项名称
					outcontractSubcontractTotalPriceVO.setUnit(datas.get(1)); // 单位
					outcontractSubcontractTotalPriceVO.setProvisionalQuantity(StringUtils.isNotBlank(datas.get(2))?new BigDecimal(datas.get(2)):null); // 暂定工程量
					outcontractSubcontractTotalPriceVO.setTaxAllUnitPrice(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 含税综合单价
					if(outcontractSubcontractTotalPriceVO.getProvisionalQuantity()!=null&&outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()!=null){
						outcontractSubcontractTotalPriceVO.setTotalPrice((outcontractSubcontractTotalPriceVO.getProvisionalQuantity().multiply(outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()))); // 合计
					}
					outcontractSubcontractTotalPriceVO.setRemark(datas.get(5)); // 备注
					if(StringUtils.isEmpty(datas.get(0))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("分项名称不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(2))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("暂定工程量不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(3))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("含税综合单价不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					if(outcontractSubcontractTotalPriceVO.getTotalPrice()!=null){
						subcontractTotalAmount = subcontractTotalAmount.add(outcontractSubcontractTotalPriceVO.getTotalPrice());
					}
					successList.add(outcontractSubcontractTotalPriceVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("subcontractTotalAmount", subcontractTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTotalPricFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTotalPricFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<ChangeOutcontractSubcontractTotalPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("change_outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<ChangeOutcontractSubcontractTotalPriceEntity> list = changeoutcontractSubcontractTotalPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTotalPricFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTotalPricFromPage(@RequestBody List<ChangeOutcontractSubcontractTotalPriceVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
	}
	/********************分包工程总价汇总表导入导出start**************/

    
	/********************分包工程综合单价计价表导入导出start**************/

	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadUnitPrice")
	@ResponseBody
	public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractSubcontractUnitPrice-import.xlsx", "分包工程综合单价计价模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportUnitPrice", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportUnitPrice(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ChangeOutcontractSubcontractUnitPriceVO> successList = new ArrayList<>();
		List<ChangeOutcontractSubcontractUnitPriceVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		Map<String,ChangeOutcontractSubcontractUnitPriceVO> map = new HashMap<>();
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=2;i<result.size();i++) {
					List<String> datas = result.get(i);
					ChangeOutcontractSubcontractUnitPriceVO unitPriceVO = new ChangeOutcontractSubcontractUnitPriceVO();
					
				    unitPriceVO.setListCode(datas.get(0)); // 清单编号
				    unitPriceVO.setInnercode(datas.get(0)); // 内码---为了单独区分装饰工程和建筑工程在咱们系统的表标识，装饰工程一律用a1代替
				    if("01".equals(datas.get(0))&&datas.get(1).contains("装饰")){
				    	unitPriceVO.setInnercode("a1");
				    }
				    //判断是否是装饰工程的子节点编码
				    if(datas.get(0).length()>=4){
				    	//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
				    	String code = datas.get(0).substring(0,4);
				    	if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
//				    		若是的话，将内码改为a1xx
				    		unitPriceVO.setInnercode(("a1"+datas.get(0).substring(2,datas.get(0).length())));
				    	}
				    }
				    unitPriceVO.setProject(datas.get(1)); // 项目
				    unitPriceVO.setJobContent(datas.get(2)); // 工作内容
				    unitPriceVO.setProjectCharacteristic(datas.get(3)); // 项目特征
				    unitPriceVO.setUnit(datas.get(4)); // 单位
				    unitPriceVO.setEngineeringQuantity(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 工程量
//				    unitPriceVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 综合单价
				    BigDecimal comprehensiveUnitPrice = new BigDecimal(0);
				    BigDecimal laborCost = StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null; // 人工费
				    BigDecimal mainMaterialCost = StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null; // 主材费
				    BigDecimal materialLoss = StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null; // 材料损耗
				    BigDecimal auxiliaryMaterialCost = StringUtils.isNotBlank(datas.get(11))?new BigDecimal(datas.get(11)):null; // 辅材费
				    BigDecimal machineryCost = StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null; // 机械费
				    BigDecimal managementCost = StringUtils.isNotBlank(datas.get(13))?new BigDecimal(datas.get(13)):null; // 管理费
				    BigDecimal profit = StringUtils.isNotBlank(datas.get(14))?new BigDecimal(datas.get(14)):null; // 利润
				    BigDecimal paidGovernmentCost = StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null; // 规费
				    BigDecimal tax = StringUtils.isNotBlank(datas.get(16))?new BigDecimal(datas.get(16)):null; // 税金
				    unitPriceVO.setLaborCost(laborCost); // 人工费
				    unitPriceVO.setMainMaterialCost(mainMaterialCost); // 主材费
				    unitPriceVO.setMaterialLoss(materialLoss); // 材料损耗
				    unitPriceVO.setAuxiliaryMaterialCost(auxiliaryMaterialCost); // 辅材费
				    unitPriceVO.setMachineryCost(machineryCost); // 机械费
				    unitPriceVO.setManagementCost(managementCost); // 管理费
				    unitPriceVO.setProfit(profit); // 利润
				    unitPriceVO.setPaidGovernmentCost(paidGovernmentCost); // 税金
				    unitPriceVO.setTax(tax); // 管理费
				    //综合单价=人工费+主材费*（1+材料损耗）+辅材费+机械费+管理费+利润+规费+税金
				    if(laborCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(laborCost);
				    }
				    if(mainMaterialCost!=null){
					    if(materialLoss!=null){
					    	BigDecimal a = mainMaterialCost.multiply((new BigDecimal(1).add(materialLoss.divide(new BigDecimal(100), 8, BigDecimal.ROUND_UP))));
					    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(a);
					    }else{
					    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(mainMaterialCost);
					    }
				    }
				    if(auxiliaryMaterialCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(auxiliaryMaterialCost);
				    }
				    if(machineryCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(machineryCost);
				    }
				    if(managementCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(managementCost);
				    }
				    if(profit!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(profit);
				    }
				    if(paidGovernmentCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(paidGovernmentCost);
				    }
				    if(tax!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(tax);
				    }
//				    comprehensiveUnitPrice = comprehensiveUnitPrice.divide(new BigDecimal(8), 8, BigDecimal.ROUND_UP);
				    unitPriceVO.setComprehensiveUnitPrice(comprehensiveUnitPrice);
				    if(unitPriceVO.getEngineeringQuantity()!=null){
				    	//合计
				    	unitPriceVO.setTotalPrice(comprehensiveUnitPrice.multiply(unitPriceVO.getEngineeringQuantity()));
				    }
				    unitPriceVO.setMainMaterialBrand(datas.get(17)); // 主材品牌
				    unitPriceVO.setRemark(datas.get(18)); // 备注
				    unitPriceVO.setId(IdWorker.getId());
				    if(StringUtils.isEmpty(datas.get(0))) {
						unitPriceVO.setErrorMsg("清单编号不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(datas.get(0).length()<2) {
						unitPriceVO.setErrorMsg("清单编号不能低于2位数！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(1))) {
						unitPriceVO.setErrorMsg("项目不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(2))) {
						unitPriceVO.setErrorMsg("工作内容不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(3))) {
						unitPriceVO.setErrorMsg("项目特征不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
//					if(StringUtils.isEmpty(datas.get(5))) {
//						unitPriceVO.setErrorMsg("工程量不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(8))) {
//						unitPriceVO.setErrorMsg("人工费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(9))) {
//						unitPriceVO.setErrorMsg("主材费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(10))) {
//						unitPriceVO.setErrorMsg("材料损耗不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(11))) {
//						unitPriceVO.setErrorMsg("辅材费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(12))) {
//						unitPriceVO.setErrorMsg("机械费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(13))) {
//						unitPriceVO.setErrorMsg("管理费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(14))) {
//						unitPriceVO.setErrorMsg("利润不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(15))) {
//						unitPriceVO.setErrorMsg("规费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(16))) {
//						unitPriceVO.setErrorMsg("税金不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
					if(StringUtils.isEmpty(datas.get(17))) {
						unitPriceVO.setErrorMsg("主材品牌不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					successList.add(unitPriceVO);
					map.put(unitPriceVO.getInnercode(), unitPriceVO);
				}
			}
		}
		//建筑工程
		//装饰工程
		//设置父级id
		for(ChangeOutcontractSubcontractUnitPriceVO vo : successList){
			String innercode = vo.getInnercode();
			if(innercode.length()==2){
				//最上级
			}else if(innercode.length()==4){
				String pcode = innercode.substring(0, 2);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}else if(innercode.length()==6){
				String pcode = innercode.substring(0, 4);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}else if(innercode.length()>6){
				String pcode = innercode.substring(0, 6);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}
		}
		//构建树
		List<ChangeOutcontractSubcontractUnitPriceVO> result = createTreeData(successList);
		//统计父级的合计数值
		BigDecimal subcontractUnitTotalAmount = this.getChildrenUnitTotalAmount(result); // 分包工程综合单价计价表合计金额
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", result);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		json.put("subcontractUnitTotalAmount", subcontractUnitTotalAmount);
		return CommonResponse.success(json);
	}
	
	private BigDecimal getChildrenUnitTotalAmount(List<ChangeOutcontractSubcontractUnitPriceVO> vos){
		BigDecimal total = new BigDecimal(0);
		for(ChangeOutcontractSubcontractUnitPriceVO vo: vos){
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				//有孩子节点----清空工程量和综合单价--金额字段
				vo.setEngineeringQuantity(null);
				vo.setComprehensiveUnitPrice(null);
				vo.setLaborCost(null); // 人工费
				vo.setMainMaterialCost(null); // 主材费
				vo.setMaterialLoss(null); // 材料损耗
				vo.setAuxiliaryMaterialCost(null); // 辅材费
			    vo.setMachineryCost(null); // 机械费
			    vo.setManagementCost(null); // 管理费
			    vo.setProfit(null); // 利润
			    vo.setPaidGovernmentCost(null); // 税金
			    vo.setTax(null); // 管理费
				//获取孩子节点的总计数据
			    BigDecimal childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
			    vo.setTotalPrice(childrenUnitTotalAmount);
			    total = total.add(childrenUnitTotalAmount);
			}else{
				if(vo.getTotalPrice()!=null){
					total = total.add(vo.getTotalPrice());
				}
			}
		}
		return total;
	}
	
	//清单编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode,Map<String,ChangeOutcontractSubcontractUnitPriceVO> map){
		if(map.get(pcode)!=null){
			return map.get(pcode).getId();
		}else{
			//父级没有找到，则继续往上找
			if(pcode.length()==2){
				//最上级
				return null;
			}else if(pcode.length()==4){
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			}else if(pcode.length()==6){
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			}else if(pcode.length()>6){
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			}else{
				return null;
			}
		}
	}
	
	public static List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
		List<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(ChangeOutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ChangeOutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	ChangeOutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ChangeOutcontractSubcontractUnitPriceVO> child = (List<ChangeOutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportUnitPriceFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportUnitPriceFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<ChangeOutcontractSubcontractUnitPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("change_outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByAsc("list_code");
		List<ChangeOutcontractSubcontractUnitPriceEntity> list = changeOutcontractSubcontractUnitPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportUnitPriceFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportUnitPriceFromPage(@RequestBody List<ChangeOutcontractSubcontractUnitPriceVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		List<ChangeOutcontractSubcontractUnitPriceVO> records = new ArrayList<>();
		for(ChangeOutcontractSubcontractUnitPriceVO vo : list){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
	}
	
	private void splitList(List<ChangeOutcontractSubcontractUnitPriceVO> list,List<ChangeOutcontractSubcontractUnitPriceVO> records) {
		for(ChangeOutcontractSubcontractUnitPriceVO vo : list){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
	}
	/********************分包工程综合单价计价表导入导出start**************/
}
