package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentLeaseItemService;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentLeaseItemVO;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentRentVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 分供方合同--设备租赁导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("equipmentExport")
public class ExportEquipmentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    @Autowired
    private IOutcontractEquipmentLeaseItemService outcontractEquipmentLeaseItemService;
    
    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;
    

	/********************租赁物进出场费明细表导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadEquipmentLease")
	@ResponseBody
	public void downloadEquipmentLease(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractEquipmentLease-import.xlsx", "租赁物进出场费明细表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportEquipmentLease", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportEquipmentLease(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<OutcontractEquipmentLeaseItemVO> successList = new ArrayList<>();
		List<OutcontractEquipmentLeaseItemVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal leaseItemTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					OutcontractEquipmentLeaseItemVO equipmentLeaseItemVO = new OutcontractEquipmentLeaseItemVO();
					
					equipmentLeaseItemVO.setId(IdWorker.getId());
					equipmentLeaseItemVO.setEquipmentCode(datas.get(0)); // 编码
					equipmentLeaseItemVO.setEquipmentName(datas.get(1)); // 设备名称
					equipmentLeaseItemVO.setEquipmentSpec(datas.get(2)); // 规格
					equipmentLeaseItemVO.setEntranceExitFee(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 进出场费（元/台）
					equipmentLeaseItemVO.setQuantity(StringUtils.isNotBlank(datas.get(4))?Integer.parseInt(datas.get(4)):null); // 台数
					equipmentLeaseItemVO.setTaxRate(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 税率（%）
					equipmentLeaseItemVO.setTotalPrice(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 合计（元）
					
					if(equipmentLeaseItemVO.getTotalPrice()==null){
						if(equipmentLeaseItemVO.getEntranceExitFee()!=null&&equipmentLeaseItemVO.getQuantity()!=null){
							equipmentLeaseItemVO.setTotalPrice(equipmentLeaseItemVO.getEntranceExitFee().multiply(new BigDecimal(equipmentLeaseItemVO.getQuantity()))); // 合计
						}
					}
					equipmentLeaseItemVO.setRemark(datas.get(7)); // 备注
					if(StringUtils.isEmpty(datas.get(0))) {
						equipmentLeaseItemVO.setErrorMsg("编码不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					CommonResponse<EquipmentVO> back = shareEquipmentApi.queryEquipmentByCode(datas.get(0));
                    if (back.isSuccess()) {
                        EquipmentVO backVO = back.getData();
                        if (backVO != null) {
                        	equipmentLeaseItemVO.setEquipmentId(backVO.getId());
                        	equipmentLeaseItemVO.setEquipmentName(backVO.getName());
                        	equipmentLeaseItemVO.setEquipmentCategoryId(backVO.getCategoryId());
                        	equipmentLeaseItemVO.setEquipmentCategoryName(backVO.getCategoryName());
                        	equipmentLeaseItemVO.setEquipmentSpec(backVO.getSpec());
                        	equipmentLeaseItemVO.setEquipmentUnit(backVO.getUnitName());
                        } else {
                        	equipmentLeaseItemVO.setErrorMsg("设备档案不存在");
    						errorList.add(equipmentLeaseItemVO);
    						continue;
                        }
                    } else {
                    	equipmentLeaseItemVO.setErrorMsg("设备档案校验失败");
						errorList.add(equipmentLeaseItemVO);
						continue;
                    }
					if(StringUtils.isEmpty(datas.get(3))) {
						equipmentLeaseItemVO.setErrorMsg("进出场费（元/台）不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(4))) {
						equipmentLeaseItemVO.setErrorMsg("台数不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(5))) {
						equipmentLeaseItemVO.setErrorMsg("税率（%）不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}

					if(equipmentLeaseItemVO.getTotalPrice()!=null){
						leaseItemTotalAmount = leaseItemTotalAmount.add(equipmentLeaseItemVO.getTotalPrice());
					}
					successList.add(equipmentLeaseItemVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("leaseItemTotalAmount", leaseItemTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportEquipmentLeaseFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportEquipmentLeaseFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<OutcontractEquipmentLeaseItemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<OutcontractEquipmentLeaseItemEntity> list = outcontractEquipmentLeaseItemService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractEquipmentLease-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportEquipmentLeaseFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportEquipmentLeaseFromPage(@RequestBody List<OutcontractEquipmentLeaseItemVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractEquipmentLease-export.xlsx", beans, response);
	}
	/********************租赁物进出场费明细表导入导出start**************/


	/********************租金明细表导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadEquipmentRent")
	@ResponseBody
	public void downloadEquipmentRent(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractEquipmentRent-import.xlsx", "租金明细表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportEquipmentRent", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportEquipmentRent(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<OutcontractEquipmentRentVO> successList = new ArrayList<>();
		List<OutcontractEquipmentRentVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal rentTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					OutcontractEquipmentRentVO equipmentLeaseItemVO = new OutcontractEquipmentRentVO();
					
					equipmentLeaseItemVO.setId(IdWorker.getId());
					equipmentLeaseItemVO.setEquipmentCode(datas.get(0)); // 设备编码
					equipmentLeaseItemVO.setEquipmentName(datas.get(1)); // 设备名称
					equipmentLeaseItemVO.setEquipmentSpec(datas.get(2)); // 规格
					equipmentLeaseItemVO.setUntaxUnitPrice(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 不含税单价
					equipmentLeaseItemVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 含税单价（元）
					
					equipmentLeaseItemVO.setEquipmentUnit(datas.get(5)); // 单位
					equipmentLeaseItemVO.setQuantity(StringUtils.isNotBlank(datas.get(6))?Integer.parseInt(datas.get(6)):null); // 台数
					equipmentLeaseItemVO.setLeaseTerm(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 租赁期（月）
					equipmentLeaseItemVO.setTaxRate(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 税率（%）
					equipmentLeaseItemVO.setTotalPrice(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null); // 合计（元）
					if(equipmentLeaseItemVO.getTaxUnitPrice()==null){
						//含税单价为空---手动计算
						if(equipmentLeaseItemVO.getUntaxUnitPrice()!=null&&equipmentLeaseItemVO.getTaxRate()!=null){
//							含税单价=不含税单价*（1+税率）
							equipmentLeaseItemVO.setTaxUnitPrice(equipmentLeaseItemVO.getUntaxUnitPrice().multiply(new BigDecimal(1).add(equipmentLeaseItemVO.getTaxRate().divide(new BigDecimal(100), 8, BigDecimal.ROUND_UP)))); // 合计
						}
					}
					if(equipmentLeaseItemVO.getTotalPrice()==null){
						//合价=含税单价*台数*租赁期
						if(equipmentLeaseItemVO.getTaxUnitPrice()!=null&&equipmentLeaseItemVO.getQuantity()!=null&&equipmentLeaseItemVO.getLeaseTerm()!=null){
							equipmentLeaseItemVO.setTotalPrice(equipmentLeaseItemVO.getTaxUnitPrice().multiply(new BigDecimal(equipmentLeaseItemVO.getQuantity())).multiply(equipmentLeaseItemVO.getLeaseTerm())); // 合计
						}
					}
					equipmentLeaseItemVO.setRemark(datas.get(10)); // 备注
					if(StringUtils.isEmpty(datas.get(0))) {
						equipmentLeaseItemVO.setErrorMsg("设备编码不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					CommonResponse<EquipmentVO> back = shareEquipmentApi.queryEquipmentByCode(datas.get(0));
                    if (back.isSuccess()) {
                        EquipmentVO backVO = back.getData();
                        if (backVO != null) {
                        	equipmentLeaseItemVO.setEquipmentId(backVO.getId());
                        	equipmentLeaseItemVO.setEquipmentName(backVO.getName());
                        	equipmentLeaseItemVO.setEquipmentCategoryId(backVO.getCategoryId());
                        	equipmentLeaseItemVO.setEquipmentCategoryName(backVO.getCategoryName());
                        	equipmentLeaseItemVO.setEquipmentSpec(backVO.getSpec());
                        	equipmentLeaseItemVO.setEquipmentUnit(backVO.getUnitName());
                        } else {
                        	equipmentLeaseItemVO.setErrorMsg("设备档案不存在");
    						errorList.add(equipmentLeaseItemVO);
    						continue;
                        }
                    } else {
                    	equipmentLeaseItemVO.setErrorMsg("设备档案校验失败");
						errorList.add(equipmentLeaseItemVO);
						continue;
                    }
					if(StringUtils.isEmpty(datas.get(3))) {
						equipmentLeaseItemVO.setErrorMsg("不含税单价（元）不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(6))) {
						equipmentLeaseItemVO.setErrorMsg("台数不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(7))) {
						equipmentLeaseItemVO.setErrorMsg("租赁期（月）不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(8))) {
						equipmentLeaseItemVO.setErrorMsg("税率（%）不能为空！");
						errorList.add(equipmentLeaseItemVO);
						continue;
					}

					if(equipmentLeaseItemVO.getTotalPrice()!=null){
						rentTotalAmount = rentTotalAmount.add(equipmentLeaseItemVO.getTotalPrice());
					}
					successList.add(equipmentLeaseItemVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("rentTotalAmount", rentTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportEquipmentRentFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportEquipmentRentFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<OutcontractEquipmentRentEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<OutcontractEquipmentRentEntity> list = outcontractEquipmentRentService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractEquipmentRent-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportEquipmentRentFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportEquipmentRentFromPage(@RequestBody List<OutcontractEquipmentRentVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractEquipmentRent-export.xlsx", beans, response);
	}
	/********************租金明细表导入导出start**************/
}
