package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractMaterialService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialChangeExport")
public class ExportChangeMaterialController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private IChangeOutcontractMaterialService changeoutcontractMaterialService;
    
	/********************物资采购--物资导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadMaterial")
	@ResponseBody
	public void downloadMaterial(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractMaterial-import.xlsx", "物资表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportMaterial", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ChangeOutcontractMaterialVO> successList = new ArrayList<>();
		List<ChangeOutcontractMaterialVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal contractPriceTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();
					
					materialVO.setId(IdWorker.getId());
					materialVO.setMaterialCode(datas.get(0)); // 编码
					materialVO.setMaterialName(datas.get(1)); // 标的名称
					materialVO.setStrengthGrade(datas.get(2)); // 强度等级
					materialVO.setMaterialSpec(datas.get(3)); // 规格型号
					materialVO.setBrandTrademark(datas.get(4)); // 品牌商标
					materialVO.setMaterialUnit(datas.get(5)); // 计量单位
					materialVO.setQuantity(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 暂定数量
					materialVO.setUntaxUnitPrice(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 不含税单价
					materialVO.setTaxRate(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 税金（%）
					materialVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null); // 含税单价
					materialVO.setTotalPrice(StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null); // 合价
					if(materialVO.getUntaxUnitPrice()==null){
						//不含税单价为空---手动计算
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getTaxRate()!=null){
//							含税单价=不含税单价*（1+税率）
							materialVO.setUntaxUnitPrice(materialVO.getTaxUnitPrice().divide(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100), 8, BigDecimal.ROUND_UP)), 8, BigDecimal.ROUND_UP)); // 
						}
					}
					if(materialVO.getTotalPrice()==null){
						//合价=含税单价*暂定数量
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getQuantity()!=null){
							materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity())); // 合计
						}
					}
					
					if(StringUtils.isEmpty(datas.get(0))) {
						materialVO.setErrorMsg("编码不能为空！");
						errorList.add(materialVO);
						continue;
					}
					CommonResponse<MaterialVO> back = shareMaterialApi.queryMaterialByCode(datas.get(0));
                    if (back.isSuccess()) {
                    	MaterialVO backVO = back.getData();
                        if (backVO != null) {
                        	materialVO.setMaterialId(backVO.getId());
                        	materialVO.setMaterialName(backVO.getName());
                        	materialVO.setMaterialCategoryId(backVO.getCategoryId());
                        	materialVO.setMaterialCategoryName(backVO.getCategoryName());
                        	materialVO.setMaterialSpec(backVO.getSpec());
                        	materialVO.setMaterialUnit(backVO.getUnitName());
                        } else {
                        	materialVO.setErrorMsg("物资档案不存在");
    						errorList.add(materialVO);
    						continue;
                        }
                    } else {
                    	materialVO.setErrorMsg("物资档案校验失败");
						errorList.add(materialVO);
						continue;
                    }
					if(StringUtils.isEmpty(datas.get(2))) {
						materialVO.setErrorMsg("强度等级不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(4))) {
						materialVO.setErrorMsg("品牌商标不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(6))) {
						materialVO.setErrorMsg("暂定数量不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(9))) {
						materialVO.setErrorMsg("含税单价不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(8))) {
						materialVO.setErrorMsg("税金（%）不能为空！");
						errorList.add(materialVO);
						continue;
					}

					if(materialVO.getTotalPrice()!=null){
						contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
					}
					successList.add(materialVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("contractPriceTotalAmount", contractPriceTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportMaterialFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<ChangeOutcontractMaterialEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<ChangeOutcontractMaterialEntity> list = changeoutcontractMaterialService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractMaterial-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportMaterialFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractMaterial-export.xlsx", beans, response);
	}
	/********************物资采购--物资导入导出start**************/


	/********************周转材租赁--物资表导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadTurnoverMaterial")
	@ResponseBody
	public void downloadTurnoverMaterial(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractTurnoverMaterial-import.xlsx", "物资表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportTurnoverMaterial", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportTurnoverMaterial(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ChangeOutcontractMaterialVO> successList = new ArrayList<>();
		List<ChangeOutcontractMaterialVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal contractPriceTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();
					
					materialVO.setId(IdWorker.getId());
					materialVO.setMaterialCode(datas.get(0)); // 物资编码
					materialVO.setMaterialName(datas.get(1)); // 物料名称
					materialVO.setMaterialSpec(datas.get(2)); // 规格
					materialVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 含税单价（元）
					materialVO.setUntaxUnitPrice(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 不含税单价（元）
					materialVO.setMaterialUnit(datas.get(5)); // 单位
					materialVO.setQuantity(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 数量
					materialVO.setLeaseTerm(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 租赁期（天）
					materialVO.setTaxRate(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 税率（%）
					materialVO.setTotalPrice(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null); // 合价（元）
					if(materialVO.getUntaxUnitPrice()==null){
						//不含税单价为空---手动计算
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getTaxRate()!=null){
//							含税单价=不含税单价*（1+税率）
							materialVO.setUntaxUnitPrice(materialVO.getTaxUnitPrice().divide(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100), 8, BigDecimal.ROUND_UP)), 8, BigDecimal.ROUND_UP)); // 
						}
					}
					if(materialVO.getTotalPrice()==null){
						//合价=含税单价*数量*租赁期（天）
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getQuantity()!=null&&materialVO.getLeaseTerm()!=null){
							materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity()).multiply(materialVO.getLeaseTerm())); // 合计
						}
					}
					
					materialVO.setRemark(datas.get(10)); // 备注
					
					if(StringUtils.isEmpty(datas.get(0))) {
						materialVO.setErrorMsg("物资编码不能为空！");
						errorList.add(materialVO);
						continue;
					}

					CommonResponse<MaterialVO> back = shareMaterialApi.queryMaterialByCode(datas.get(0));
                    if (back.isSuccess()) {
                    	MaterialVO backVO = back.getData();
                        if (backVO != null) {
                        	materialVO.setMaterialId(backVO.getId());
                        	materialVO.setMaterialName(backVO.getName());
                        	materialVO.setMaterialCategoryId(backVO.getCategoryId());
                        	materialVO.setMaterialCategoryName(backVO.getCategoryName());
                        	materialVO.setMaterialSpec(backVO.getSpec());
                        	materialVO.setMaterialUnit(backVO.getUnitName());
                        } else {
                        	materialVO.setErrorMsg("物资档案不存在");
    						errorList.add(materialVO);
    						continue;
                        }
                    } else {
                    	materialVO.setErrorMsg("物资档案校验失败");
						errorList.add(materialVO);
						continue;
                    }
					if(StringUtils.isEmpty(datas.get(3))) {
						materialVO.setErrorMsg("含税单价（元）不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(6))) {
						materialVO.setErrorMsg("数量不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(7))) {
						materialVO.setErrorMsg("租赁期（天）不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(8))) {
						materialVO.setErrorMsg("税率（%）不能为空！");
						errorList.add(materialVO);
						continue;
					}

					if(materialVO.getTotalPrice()!=null){
						contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
					}
					successList.add(materialVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("contractPriceTotalAmount", contractPriceTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTurnoverMaterialFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTurnoverMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<ChangeOutcontractMaterialEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<ChangeOutcontractMaterialEntity> list = changeoutcontractMaterialService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractTurnoverMaterial-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTurnoverMaterialFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTurnoverMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractTurnoverMaterial-export.xlsx", beans, response);
	}
	/********************周转材租赁--物资表导入导出start**************/

	/********************其它合同--合同价导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadOtherMaterial")
	@ResponseBody
	public void downloadOtherMaterial(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractOtherMaterial-import.xlsx", "合同价模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportOtherMaterial", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportOtherMaterial(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ChangeOutcontractMaterialVO> successList = new ArrayList<>();
		List<ChangeOutcontractMaterialVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal contractPriceTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();

					materialVO.setId(IdWorker.getId());
					materialVO.setMaterialName(datas.get(0)); // 名称
					materialVO.setMaterialSpec(datas.get(1)); // 规格
					materialVO.setUntaxUnitPrice(StringUtils.isNotBlank(datas.get(2))?new BigDecimal(datas.get(2)):null); // 不含税单价（元）
					materialVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 含税单价（元）
					materialVO.setMaterialUnit(datas.get(4)); // 单位
					materialVO.setQuantity(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 数量
					materialVO.setTaxRate(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 税金（%）
					materialVO.setTotalPrice(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 金额（元）
					if(materialVO.getUntaxUnitPrice()==null){
						//不含税单价为空---手动计算
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getTaxRate()!=null){
//							含税单价=不含税单价*（1+税率）
							materialVO.setUntaxUnitPrice(materialVO.getTaxUnitPrice().divide(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100), 8, BigDecimal.ROUND_UP)), 8, BigDecimal.ROUND_UP)); // 
						}
					}
					if(materialVO.getTotalPrice()==null){
						//合价=含税单价*数量
						if(materialVO.getTaxUnitPrice()!=null&&materialVO.getQuantity()!=null){
							materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity())); // 合计
						}
					}
					
					materialVO.setRemark(datas.get(8)); // 备注
					
					if(StringUtils.isEmpty(datas.get(0))) {
						materialVO.setErrorMsg("名称不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(1))) {
						materialVO.setErrorMsg("规格不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(3))) {
						materialVO.setErrorMsg("含税单价（元）不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(5))) {
						materialVO.setErrorMsg("数量不能为空！");
						errorList.add(materialVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(6))) {
						materialVO.setErrorMsg("税金（%）不能为空！");
						errorList.add(materialVO);
						continue;
					}
					
					if(materialVO.getTotalPrice()!=null){
						contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
					}
					successList.add(materialVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("contractPriceTotalAmount", contractPriceTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportOtherMaterialFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportOtherMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<ChangeOutcontractMaterialEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<ChangeOutcontractMaterialEntity> list = changeoutcontractMaterialService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractOtherMaterial-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportOtherMaterialFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportOtherMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractOtherMaterial-export.xlsx", beans, response);
	}
	/********************其它合同--合同价导入导出start**************/
}
