/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractSubcontractTotalPriceService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSubcontractTotalPriceVO;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"subcontractChangeExport"})
public class ExportChangeSubcontractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeOutcontractSubcontractTotalPriceService changeoutcontractSubcontractTotalPriceService;
    @Autowired
    private IChangeOutcontractSubcontractUnitPriceService changeOutcontractSubcontractUnitPriceService;

    @RequestMapping(value={"/downloadTotalPrice"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractSubcontractTotalPrice-import.xlsx", (String)"\u5206\u5305\u5de5\u7a0b\u603b\u4ef7\u6c47\u603b\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTotalPric"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeOutcontractSubcontractTotalPriceVO> successList = new ArrayList<ChangeOutcontractSubcontractTotalPriceVO>();
        ArrayList<ChangeOutcontractSubcontractTotalPriceVO> errorList = new ArrayList<ChangeOutcontractSubcontractTotalPriceVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal subcontractTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ChangeOutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new ChangeOutcontractSubcontractTotalPriceVO();
                outcontractSubcontractTotalPriceVO.setId(Long.valueOf(IdWorker.getId()));
                outcontractSubcontractTotalPriceVO.setItemName((String)datas.get(0));
                outcontractSubcontractTotalPriceVO.setUnit((String)datas.get(1));
                try {
                    outcontractSubcontractTotalPriceVO.setProvisionalQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : null);
                }
                catch (Exception e) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u6682\u5b9a\u5de5\u7a0b\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                try {
                    outcontractSubcontractTotalPriceVO.setTaxAllUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                }
                catch (Exception e) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u542b\u7a0e\u7efc\u5408\u5355\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (outcontractSubcontractTotalPriceVO.getProvisionalQuantity() != null && outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice() != null) {
                    outcontractSubcontractTotalPriceVO.setTotalPrice(outcontractSubcontractTotalPriceVO.getProvisionalQuantity().multiply(outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()));
                }
                outcontractSubcontractTotalPriceVO.setRemark((String)datas.get(5));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u5206\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u6682\u5b9a\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    outcontractSubcontractTotalPriceVO.setErrorMsg("\u542b\u7a0e\u7efc\u5408\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(outcontractSubcontractTotalPriceVO);
                    continue;
                }
                if (outcontractSubcontractTotalPriceVO.getTotalPrice() != null) {
                    subcontractTotalAmount = subcontractTotalAmount.add(outcontractSubcontractTotalPriceVO.getTotalPrice());
                }
                successList.add(outcontractSubcontractTotalPriceVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("subcontractTotalAmount", (Object)subcontractTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportTotalPricFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTotalPricFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"change_outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changeoutcontractSubcontractTotalPriceService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTotalPricFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTotalPricFromPage(@RequestBody List<ChangeOutcontractSubcontractTotalPriceVO> list, HttpServletResponse response) {
        HashMap<String, List<ChangeOutcontractSubcontractTotalPriceVO>> beans = new HashMap<String, List<ChangeOutcontractSubcontractTotalPriceVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadUnitPrice"})
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractSubcontractUnitPrice-import.xlsx", (String)"\u5206\u5305\u5de5\u7a0b\u7efc\u5408\u5355\u4ef7\u8ba1\u4ef7\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportUnitPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeOutcontractSubcontractUnitPriceVO> successList = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        ArrayList<ChangeOutcontractSubcontractUnitPriceVO> errorList = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        HashMap<String, ChangeOutcontractSubcontractUnitPriceVO> map = new HashMap<String, ChangeOutcontractSubcontractUnitPriceVO>();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                String code;
                List datas = (List)result.get(i);
                ChangeOutcontractSubcontractUnitPriceVO unitPriceVO = new ChangeOutcontractSubcontractUnitPriceVO();
                unitPriceVO.setId(Long.valueOf(IdWorker.getId()));
                unitPriceVO.setListCode((String)datas.get(0));
                unitPriceVO.setInnercode((String)datas.get(0));
                if ("01".equals(datas.get(0)) && ((String)datas.get(1)).contains("\u88c5\u9970")) {
                    unitPriceVO.setInnercode("a1");
                }
                if (((String)datas.get(0)).length() >= 4 && ("0111".equals(code = ((String)datas.get(0)).substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                    unitPriceVO.setInnercode("a1" + ((String)datas.get(0)).substring(2, ((String)datas.get(0)).length()));
                }
                unitPriceVO.setProject((String)datas.get(1));
                unitPriceVO.setJobContent((String)datas.get(2));
                unitPriceVO.setProjectCharacteristic((String)datas.get(3));
                unitPriceVO.setUnit((String)datas.get(4));
                try {
                    unitPriceVO.setEngineeringQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u5de5\u7a0b\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal laborCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null;
                    unitPriceVO.setLaborCost(laborCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u4eba\u5de5\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal mainMaterialCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null;
                    unitPriceVO.setMainMaterialCost(mainMaterialCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u4e3b\u6750\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal materialLoss = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null;
                    unitPriceVO.setMaterialLoss(materialLoss);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u6750\u6599\u635f\u8017\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal auxiliaryMaterialCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null;
                    unitPriceVO.setAuxiliaryMaterialCost(auxiliaryMaterialCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u8f85\u6750\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal machineryCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null;
                    unitPriceVO.setMachineryCost(machineryCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u673a\u68b0\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal managementCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? new BigDecimal((String)datas.get(13)) : null;
                    unitPriceVO.setManagementCost(managementCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u7ba1\u7406\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal profit = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? new BigDecimal((String)datas.get(14)) : null;
                    unitPriceVO.setProfit(profit);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u5229\u6da6\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal paidGovernmentCost = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null;
                    unitPriceVO.setPaidGovernmentCost(paidGovernmentCost);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u89c4\u8d39\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                try {
                    BigDecimal tax = StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? new BigDecimal((String)datas.get(16)) : null;
                    unitPriceVO.setTax(tax);
                }
                catch (Exception e) {
                    unitPriceVO.setErrorMsg("\u7a0e\u91d1\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                BigDecimal comprehensiveUnitPrice = new BigDecimal(0);
                if (unitPriceVO.getLaborCost() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getLaborCost());
                }
                if (unitPriceVO.getMainMaterialCost() != null) {
                    if (unitPriceVO.getMaterialLoss() != null) {
                        BigDecimal a = unitPriceVO.getMainMaterialCost().multiply(new BigDecimal(1).add(unitPriceVO.getMaterialLoss()));
                        comprehensiveUnitPrice = comprehensiveUnitPrice.add(a);
                    } else {
                        comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getMainMaterialCost());
                    }
                }
                if (unitPriceVO.getAuxiliaryMaterialCost() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getAuxiliaryMaterialCost());
                }
                if (unitPriceVO.getMachineryCost() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getMachineryCost());
                }
                if (unitPriceVO.getManagementCost() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getManagementCost());
                }
                if (unitPriceVO.getProfit() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getProfit());
                }
                if (unitPriceVO.getPaidGovernmentCost() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getPaidGovernmentCost());
                }
                if (unitPriceVO.getTax() != null) {
                    comprehensiveUnitPrice = comprehensiveUnitPrice.add(unitPriceVO.getTax());
                }
                unitPriceVO.setComprehensiveUnitPrice(comprehensiveUnitPrice);
                if (unitPriceVO.getEngineeringQuantity() != null) {
                    unitPriceVO.setTotalPrice(comprehensiveUnitPrice.multiply(unitPriceVO.getEngineeringQuantity()));
                }
                unitPriceVO.setMainMaterialBrand((String)datas.get(17));
                unitPriceVO.setRemark((String)datas.get(18));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    unitPriceVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (((String)datas.get(0)).length() < 2) {
                    unitPriceVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4f4e\u4e8e2\u4f4d\u6570\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (((String)datas.get(0)).length() == 1 || ((String)datas.get(0)).length() == 3 || ((String)datas.get(0)).length() == 5 || ((String)datas.get(0)).length() == 7 || ((String)datas.get(0)).length() == 8) {
                    unitPriceVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    unitPriceVO.setErrorMsg("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    unitPriceVO.setErrorMsg("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    unitPriceVO.setErrorMsg("\u9879\u76ee\u7279\u5f81\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(17)))) {
                    unitPriceVO.setErrorMsg("\u4e3b\u6750\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(unitPriceVO);
                    continue;
                }
                successList.add(unitPriceVO);
                map.put(unitPriceVO.getInnercode(), unitPriceVO);
            }
        }
        for (ChangeOutcontractSubcontractUnitPriceVO vo : successList) {
            Long pid;
            String pcode;
            String innercode = vo.getInnercode();
            if (innercode.length() == 2) continue;
            if (innercode.length() == 4) {
                pcode = innercode.substring(0, 2);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() == 6) {
                pcode = innercode.substring(0, 4);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() <= 6) continue;
            pcode = innercode.substring(0, 6);
            pid = this.setPid(pcode, map);
            vo.setPid(pid);
        }
        result = ExportChangeSubcontractController.createTreeData(successList);
        BigDecimal subcontractUnitTotalAmount = this.getChildrenUnitTotalAmount(result);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", result);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        json.put("subcontractUnitTotalAmount", (Object)subcontractUnitTotalAmount);
        return CommonResponse.success((Object)json);
    }

    private BigDecimal getChildrenUnitTotalAmount(List<ChangeOutcontractSubcontractUnitPriceVO> vos) {
        BigDecimal total = new BigDecimal(0);
        for (ChangeOutcontractSubcontractUnitPriceVO vo : vos) {
            if (vo.getChildren() != null && vo.getChildren().size() > 0) {
                vo.setEngineeringQuantity(null);
                vo.setComprehensiveUnitPrice(null);
                vo.setLaborCost(null);
                vo.setMainMaterialCost(null);
                vo.setMaterialLoss(null);
                vo.setAuxiliaryMaterialCost(null);
                vo.setMachineryCost(null);
                vo.setManagementCost(null);
                vo.setProfit(null);
                vo.setPaidGovernmentCost(null);
                vo.setTax(null);
                BigDecimal childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setTotalPrice(childrenUnitTotalAmount);
                total = total.add(childrenUnitTotalAmount);
                continue;
            }
            if (vo.getTotalPrice() == null) continue;
            total = total.add(vo.getTotalPrice());
        }
        return total;
    }

    private Long setPid(String pcode, Map<String, ChangeOutcontractSubcontractUnitPriceVO> map) {
        if (map.get(pcode) != null) {
            return map.get(pcode).getId();
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public static List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
        ArrayList<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<String, ChangeOutcontractSubcontractUnitPriceVO>();
        for (ChangeOutcontractSubcontractUnitPriceVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ChangeOutcontractSubcontractUnitPriceVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ChangeOutcontractSubcontractUnitPriceVO parent = (ChangeOutcontractSubcontractUnitPriceVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ChangeOutcontractSubcontractUnitPriceVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportUnitPriceFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUnitPriceFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"change_outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByAsc((Object)"list_code");
        List list = this.changeOutcontractSubcontractUnitPriceService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportUnitPriceFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportUnitPriceFromPage(@RequestBody List<ChangeOutcontractSubcontractUnitPriceVO> list, HttpServletResponse response) {
        HashMap<String, List<ChangeOutcontractSubcontractUnitPriceVO>> beans = new HashMap<String, List<ChangeOutcontractSubcontractUnitPriceVO>>();
        ArrayList<ChangeOutcontractSubcontractUnitPriceVO> records = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        for (ChangeOutcontractSubcontractUnitPriceVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
    }

    private void splitList(List<ChangeOutcontractSubcontractUnitPriceVO> list, List<ChangeOutcontractSubcontractUnitPriceVO> records) {
        for (ChangeOutcontractSubcontractUnitPriceVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ChangeOutcontractSubcontractUnitPriceVO> list, HttpServletResponse response) {
        Iterator<ChangeOutcontractSubcontractUnitPriceVO> code;
        JSONObject json = new JSONObject();
        HashMap<String, ChangeOutcontractSubcontractUnitPriceVO> map = new HashMap<String, ChangeOutcontractSubcontractUnitPriceVO>();
        ChangeOutcontractSubcontractUnitPriceVO add = list.get(0);
        add.setId(Long.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getListCode());
        if ("01".equals(add.getListCode()) && add.getProject().contains("\u88c5\u9970")) {
            add.setInnercode("a1");
        }
        if (add.getListCode().length() >= 4 && ("0111".equals(code = add.getListCode().substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
            add.setInnercode("a1" + add.getListCode().substring(2, add.getListCode().length()));
        }
        for (ChangeOutcontractSubcontractUnitPriceVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (vo.getId() == add.getId() || !vo.getInnercode().equals(add.getInnercode())) continue;
            throw new BusinessException("\u6e05\u5355\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        for (ChangeOutcontractSubcontractUnitPriceVO vo : list) {
            Long pid;
            String pcode;
            String innercode = vo.getInnercode();
            if (innercode.length() == 2) continue;
            if (innercode.length() == 4) {
                pcode = innercode.substring(0, 2);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() == 6) {
                pcode = innercode.substring(0, 4);
                pid = this.setPid(pcode, map);
                vo.setPid(pid);
                continue;
            }
            if (innercode.length() <= 6) continue;
            pcode = innercode.substring(0, 6);
            pid = this.setPid(pcode, map);
            vo.setPid(pid);
        }
        List<ChangeOutcontractSubcontractUnitPriceVO> result = ExportChangeSubcontractController.createTreeData(list);
        BigDecimal subcontractUnitTotalAmount = this.getChildrenUnitTotalAmount(result);
        json.put("dataSource", result);
        json.put("subcontractUnitTotalAmount", (Object)subcontractUnitTotalAmount);
        return CommonResponse.success((Object)json);
    }
}

