/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractReviewEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractReviewVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outcontractReview"})
public class OutcontractReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REVIEW_BILL_CODE = "ZJKJ-OUTCONTRACTREVIEW";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutcontractReviewService service;
    @Autowired
    private IOutcontractService outcontractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractReviewVO> saveOrUpdate(@RequestBody OutcontractReviewVO saveOrUpdateVO) {
        OutcontractReviewEntity entity = (OutcontractReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutcontractReviewEntity.class));
        entity.setId(saveOrUpdateVO.getOutcontractId());
        if (StringUtils.isBlank((CharSequence)entity.getApprovalFormCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)REVIEW_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setApprovalFormCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractReviewVO vo = (OutcontractReviewVO)BeanMapper.map((Object)((Object)entity), OutcontractReviewVO.class);
        vo.setProjectId(saveOrUpdateVO.getProjectId());
        vo.setContractName(saveOrUpdateVO.getContractName());
        vo.setBillCode(saveOrUpdateVO.getBillCode());
        vo.setSupplier(saveOrUpdateVO.getSupplier());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutcontractReviewVO> queryDetail(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List entitys = this.service.list((Wrapper)queryWrapper);
        OutcontractReviewVO vo = new OutcontractReviewVO();
        vo.setRowState("add");
        if (entitys != null && entitys.size() > 0) {
            vo = (OutcontractReviewVO)BeanMapper.map(entitys.get(0), OutcontractReviewVO.class);
            vo.setRowState("edit");
        }
        vo.setId(id);
        vo.setOutcontractId(id);
        OutcontractEntity outcontractEntity = (OutcontractEntity)((Object)this.outcontractService.selectById(id));
        vo.setProjectId(outcontractEntity.getProjectId());
        vo.setContractName(outcontractEntity.getContractName());
        vo.setBillCode(outcontractEntity.getBillCode());
        vo.setSupplier(outcontractEntity.getSupplier());
        vo.setContractBillState(outcontractEntity.getBillState());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractReviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

