/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignStatisticService;
import com.ejianc.foundation.report.vo.OutcontractSignStatisticVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontractSignStatisticService")
public class OutcontractSignStatisticServiceImpl
implements IOutcontractSignStatisticService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ESSignStatistic = "ejc_zjkj_outcontract_sign_statistic";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private RestHighLevelClient client;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        this.outcontractReportService.saveOrUpdate((Object)reportEntity, false);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.outcontractService.queryList(queryParam);
        BulkRequest bulkRequest = new BulkRequest();
        for (OutcontractEntity entity : list) {
            try {
                OutcontractSignStatisticVO outcontractSignStatisticVO = (OutcontractSignStatisticVO)BeanMapper.map((Object)((Object)entity), OutcontractSignStatisticVO.class);
                Map dataMap = (Map)BeanMapper.map((Object)outcontractSignStatisticVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractVO> queryPage(QueryParam param) {
        Page page = new Page();
        List<Object> resultList = new ArrayList();
        Map params = param.getParams();
        if (params.get("range") != null && "es".equals(((Parameter)param.getParams().get("range")).getValue().toString())) {
            param.getParams().remove("range");
            SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            String reportId = ((Parameter)params.get("reportId")).getValue().toString();
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"reportId", (Object)reportId));
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
            try {
                List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                ArrayList commonOrgIds = new ArrayList();
                ArrayList departmentIds = new ArrayList();
                orgVOList.stream().forEach(org -> {
                    if (5 == org.getOrgType()) {
                        departmentIds.add(org.getId());
                    } else {
                        commonOrgIds.add(org.getId());
                    }
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", commonOrgIds));
                } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectDepartmentId", departmentIds));
                }
                if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
                    BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"billCode", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"contractName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"projectName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"signUnitName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"buildUnitName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"pricingForm", (Object)param.getSearchText()));
                    boolQuery.must((QueryBuilder)shouldBuilder);
                }
                for (String key : params.keySet()) {
                    if ("range".equals(key) || "reportId".equals(key)) continue;
                    if (params != null && "advanceCharge".equals(key)) {
                        if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)params.get("advanceCharge")).getValue())) {
                            boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)"advanceCharge"));
                            continue;
                        }
                        boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"advanceCharge"));
                        continue;
                    }
                    if (params != null && "monthlyPayment".equals(key)) {
                        BoolQueryBuilder shouldBuilder;
                        if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gt((Object)0));
                            continue;
                        }
                        if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gt((Object)0));
                            continue;
                        }
                        if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("70\u4ee5\u4e0b")) {
                            shouldBuilder = QueryBuilders.boolQuery();
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").lt((Object)70));
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").lt((Object)70));
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("70-75")) {
                            shouldBuilder = QueryBuilders.boolQuery();
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)70).lt((Object)75));
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)70).lt((Object)75));
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("75-80")) {
                            shouldBuilder = QueryBuilders.boolQuery();
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)75).lt((Object)80));
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)75).lt((Object)80));
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (!((Parameter)params.get("monthlyPayment")).getValue().toString().contains("80\u4ee5\u4e0a")) continue;
                        shouldBuilder = QueryBuilders.boolQuery();
                        shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)80));
                        shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)80));
                        boolQuery.must((QueryBuilder)shouldBuilder);
                        continue;
                    }
                    if (params != null && "signDate".equals(key)) {
                        String[] signDate = ((Parameter)params.get("signDate")).getValue().toString().split(",");
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"signDate").from((Object)signDate[0]).to((Object)signDate[1]));
                        continue;
                    }
                    if (params != null && "subcontractingStatus".equals(key)) {
                        HashMap par = new HashMap();
                        Script script = new Script("doc['signDate'].size() > 0 && doc['mobilizationDate'].size() > 0 && doc['signDate'].value.getMillis() > doc['mobilizationDate'].value.getMillis()");
                        ScriptQueryBuilder scriptQueryBuilder = new ScriptQueryBuilder(script);
                        boolQuery.must((QueryBuilder)scriptQueryBuilder);
                        continue;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])((Parameter)params.get(key)).getValue().toString().split(",")));
                }
                sourceBuilder.query((QueryBuilder)boolQuery);
                if (param.getOrderMap() != null) {
                    for (String key : param.getOrderMap().keySet()) {
                        if ("desc".equals(((String)param.getOrderMap().get(key)).toString())) {
                            sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.DESC));
                            continue;
                        }
                        sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.ASC));
                    }
                }
                Integer pageIndex = param.getPageIndex();
                Integer pageSize = param.getPageSize();
                sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
                sourceBuilder.size(pageSize.intValue());
                sourceBuilder.trackTotalHits(true);
                sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
                searchRequest.source(sourceBuilder);
                ArrayList<OutcontractVO> list = new ArrayList<OutcontractVO>();
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    JSONObject json = new JSONObject(hit.getSourceAsMap());
                    OutcontractVO vo = (OutcontractVO)JSONObject.toJavaObject((JSON)json, OutcontractVO.class);
                    if (vo.getContractPrice() != null) {
                        vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
                    }
                    list.add(vo);
                }
                resultList = this.processData(list);
                page.setCurrent((long)param.getPageIndex());
                page.setRecords(resultList);
                page.setTotal(hits.getTotalHits().value);
            }
            catch (Exception e) {
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e);
            }
        } else {
            if (params.get("range") != null) {
                params.remove("range");
            }
            params.put("billState", new Parameter("in", (Object)"1,3"));
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("contractName");
            fuzzyFields.add("projectName");
            fuzzyFields.add("subcontractStatus");
            fuzzyFields.add("signUnitName");
            fuzzyFields.add("buildUnitName");
            fuzzyFields.add("pricingForm");
            params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                params.put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                params.put("projectDepartmentId", new Parameter("in", departmentIds));
            }
            if (params != null && params.get("advanceCharge") != null) {
                if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)params.get("advanceCharge")).getValue())) {
                    params.put("advanceCharge", new Parameter("ne", null));
                } else {
                    params.put("advanceCharge", new Parameter("eq", null));
                }
            }
            if (params != null && params.get("monthlyPayment") != null) {
                ComplexParam c122;
                ComplexParam c121;
                ComplexParam c12;
                ComplexParam c112;
                ComplexParam c111;
                ComplexParam c123;
                ComplexParam c11;
                ComplexParam c1;
                if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                    params.put("monthlyPayment", new Parameter("gt", (Object)0));
                } else if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                    params.put("nodePayment", new Parameter("gt", (Object)0));
                    params.remove("monthlyPayment");
                } else if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("70\u4ee5\u4e0b")) {
                    c1 = new ComplexParam();
                    c1.setLogic("and");
                    c11 = new ComplexParam();
                    c11.setLogic("or");
                    c11.getParams().put("monthlyPayment", new Parameter("lt", (Object)70));
                    c1.getComplexParams().add(c11);
                    c123 = new ComplexParam();
                    c123.setLogic("or");
                    c123.getParams().put("nodePayment", new Parameter("lt", (Object)70));
                    c1.getComplexParams().add(c123);
                    param.getComplexParams().add(c1);
                    params.remove("monthlyPayment");
                } else if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("70-75")) {
                    c1 = new ComplexParam();
                    c1.setLogic("and");
                    c11 = new ComplexParam();
                    c11.setLogic("or");
                    c111 = new ComplexParam();
                    c111.setLogic("and");
                    c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)70));
                    c11.getComplexParams().add(c111);
                    c112 = new ComplexParam();
                    c112.setLogic("and");
                    c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)75));
                    c11.getComplexParams().add(c112);
                    c1.getComplexParams().add(c11);
                    c12 = new ComplexParam();
                    c12.setLogic("or");
                    c121 = new ComplexParam();
                    c121.setLogic("and");
                    c121.getParams().put("nodePayment", new Parameter("ge", (Object)70));
                    c12.getComplexParams().add(c121);
                    c122 = new ComplexParam();
                    c122.setLogic("and");
                    c122.getParams().put("nodePayment", new Parameter("lt", (Object)75));
                    c12.getComplexParams().add(c122);
                    c1.getComplexParams().add(c12);
                    param.getComplexParams().add(c1);
                    params.remove("monthlyPayment");
                } else if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("75-80")) {
                    c1 = new ComplexParam();
                    c1.setLogic("and");
                    c11 = new ComplexParam();
                    c11.setLogic("or");
                    c111 = new ComplexParam();
                    c111.setLogic("and");
                    c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)75));
                    c11.getComplexParams().add(c111);
                    c112 = new ComplexParam();
                    c112.setLogic("and");
                    c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)80));
                    c11.getComplexParams().add(c112);
                    c1.getComplexParams().add(c11);
                    c12 = new ComplexParam();
                    c12.setLogic("or");
                    c121 = new ComplexParam();
                    c121.setLogic("and");
                    c121.getParams().put("nodePayment", new Parameter("ge", (Object)75));
                    c12.getComplexParams().add(c121);
                    c122 = new ComplexParam();
                    c122.setLogic("and");
                    c122.getParams().put("nodePayment", new Parameter("lt", (Object)80));
                    c12.getComplexParams().add(c122);
                    c1.getComplexParams().add(c12);
                    param.getComplexParams().add(c1);
                } else if (((Parameter)params.get("monthlyPayment")).getValue().toString().contains("80\u4ee5\u4e0a")) {
                    c1 = new ComplexParam();
                    c1.setLogic("and");
                    c11 = new ComplexParam();
                    c11.setLogic("or");
                    c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)80));
                    c1.getComplexParams().add(c11);
                    c123 = new ComplexParam();
                    c123.setLogic("or");
                    c123.getParams().put("nodePayment", new Parameter("ge", (Object)80));
                    c1.getComplexParams().add(c123);
                    param.getComplexParams().add(c1);
                    params.remove("monthlyPayment");
                }
            }
            if (params != null && params.get("subcontractingStatus") != null) {
                params.put("subcontractingStatus", new Parameter("sql", (Object)" sign_date > mobilization_date "));
                params.put("subcontractingStatus1", new Parameter("sql", (Object)" mobilization_date is not null "));
            }
            IPage pageData = this.outcontractService.queryPage(param, false);
            page = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
            ArrayList<OutcontractVO> voList = new ArrayList<OutcontractVO>();
            for (OutcontractEntity entity : pageData.getRecords()) {
                OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
                if (vo.getContractPrice() != null) {
                    vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
                }
                voList.add(vo);
            }
            resultList = this.processData(voList);
            page.setRecords(resultList);
        }
        return page;
    }

    public List<OutcontractVO> processData(List<OutcontractVO> list) {
        List vos = BeanMapper.mapList(list, OutcontractVO.class);
        vos.forEach(e -> {
            if ("\u52b3\u52a1\u5206\u5305".equals(e.getType())) {
                e.setLabor(e.getSubcontractingContent());
                switch (e.getPricingForm()) {
                    case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborPrice(e.getPricingForm());
                        break;
                    }
                    case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborArea(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborFixedPrice(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u603b\u4ef7": {
                        e.setLaborTotalPrice(e.getPricingForm());
                        break;
                    }
                    case "\u5b9a\u989d\u8ba1\u4ef7": {
                        e.setLaborQuotaValuation(e.getPricingForm());
                    }
                }
                if ("\u5305\u6e05\u5de5".equals(e.getLaborSubcontracteMode())) {
                    e.setPackLight(e.getLaborSubcontracteMode());
                }
                if ("\u6269\u5927\u52b3\u52a1\u5206\u5305".equals(e.getLaborSubcontracteMode())) {
                    e.setExpandSub(e.getLaborSubcontracteMode());
                }
                if ("\u5176\u4ed6\u5f62\u5f0f".equals(e.getLaborSubcontracteMode())) {
                    e.setOtherform(e.getLaborSubcontracteMode());
                }
            }
            if ("\u4e13\u4e1a\u5206\u5305".equals(e.getType())) {
                e.setMajor(e.getSubcontractingContent());
                switch (e.getPricingForm()) {
                    case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                        e.setMajorPrice(e.getPricingForm());
                        break;
                    }
                    case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                        e.setRateLower(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u603b\u4ef7": {
                        e.setMajorTotalPrice(e.getPricingForm());
                        break;
                    }
                    case "\u5b9a\u989d\u8ba1\u4ef7": {
                        e.setMajorQuotaValuation(e.getPricingForm());
                    }
                }
                if ("\u5305\u6e05\u5de5\u8f85\u6750".equals(e.getLaborSubcontracteMode())) {
                    e.setWorkersAndAuxiliaryMaterials(e.getLaborSubcontracteMode());
                }
                if ("\u5305\u5de5\u5305\u6599".equals(e.getLaborSubcontracteMode())) {
                    e.setLaborAndMaterials(e.getLaborSubcontracteMode());
                }
                if ("\u5176\u4ed6\u5f62\u5f0f".equals(e.getLaborSubcontracteMode())) {
                    e.setOtherForms(e.getLaborSubcontracteMode());
                }
            }
            if ("\u7269\u8d44\u91c7\u8d2d".equals(e.getType())) {
                e.setMaterial(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setMaterialFixedPrice(e.getPricingForm());
                }
                if ("\u53ef\u8c03\u4ef7\u683c".equals(e.getPricingForm())) {
                    e.setAdjustablePrice(e.getPricingForm());
                }
            }
            if ("\u673a\u68b0\u79df\u8d41".equals(e.getType())) {
                e.setEquipment(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setEquipmentFixedPrice("\u56fa\u5b9a\u5355\u4ef7");
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setEquipmentOther("\u5176\u4ed6");
                }
            }
            if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(e.getType())) {
                e.setTurnoverMaterial(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setTurnoverMaterialFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setTurnoverMaterialOther(e.getPricingForm());
                }
            }
            if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(e.getType())) {
                e.setDesign(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setDesignFixedPrice(e.getPricingForm());
                }
                if ("\u56fa\u5b9a\u603b\u4ef7".equals(e.getPricingForm())) {
                    e.setDesignTotalPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setDesignOther(e.getPricingForm());
                }
            }
            if ("\u54a8\u8be2\u670d\u52a1".equals(e.getType())) {
                e.setConsultancy(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setConsultancyFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setConsultancyOther(e.getPricingForm());
                }
            }
            if ("\u5176\u5b83\u5408\u540c".equals(e.getType())) {
                e.setOther(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setOtherFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setOther1(e.getPricingForm());
                }
            }
        });
        return vos;
    }
}

