package com.ejianc.foundation.outcontract.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
@Service("outcontractService")
public class OutcontractServiceImpl extends BaseServiceImpl<OutcontractMapper, OutcontractEntity> implements IOutcontractService{

	@Autowired
	private IOutcontractReviewService reviewService;

	@Autowired
	private IChangeOutcontractService changeOutcontractService;
	@Autowired
	private OutcontractMapper contractMapper;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IShareSupplierApi shareSupplierApi;

	@Override
	public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
        	reviewService.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
	}

	@Override
	public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id).set("performance_status", performanceStatus);
        this.update(null, updateWrapper);
        return CommonResponse.success("更改履约状态成功！");
	}

	@Override
	public CommonResponse<String> changeDate(Long id, String type, Date date) {
		UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
		if("mobilizationDate".equals(type)){
			updateWrapper.eq("id",id).set("mobilization_date", date);
		}else if("exitDate".equals(type)){
			updateWrapper.eq("id",id).set("exit_date", date);
		}
        this.update(null, updateWrapper);
        return CommonResponse.success("更改成功！");
	}

	@Override
	public CommonResponse<String> file(OutcontractVO outcontractVO) {
		OutcontractEntity entity = this.selectById(outcontractVO.getId());
		if("1".equals(entity.getFileState())){
			throw new BusinessException("不能重复归档");
		}
		//变更后的合同归档的签约日期更新补充协议的签约日期，原合同签约日期不变
		if("1".equals(entity.getChangeState())){
			//未变更过的
			entity.setSignDate(outcontractVO.getSignDate());
		}else{
			//查询变更的单据
			QueryParam param = new QueryParam();
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, entity.getId()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			List<ChangeOutcontractEntity> list = changeOutcontractService.queryList(param,false);
			ChangeOutcontractEntity changeEntity = new ChangeOutcontractEntity();
			if(list!=null && list.size()>0){
				changeEntity = list.get(0);
				changeEntity.setSupplementarySignTime(outcontractVO.getSignDate());
				changeOutcontractService.saveOrUpdate(changeEntity, false);
			}
		}
		entity.setFileState("1");
		this.saveOrUpdate(entity, false);
		CommonResponse<String> back = attachmentApi.updateAttachRef(outcontractVO.getId(), outcontractVO.getAttachIds());
		if(!back.isSuccess()){
			throw new BusinessException("归档失败");
		}
		return CommonResponse.success("归档成功！");
	}

	@Override
	public IPage<OutcontractSupplierVO> refSupplierList(Map<String, Object> params) {
		Long count = contractMapper.countSupplier(params);
		Integer pageIndex = (Integer) params.get("pageIndex");
		Integer pageSize = (Integer) params.get("pageSize");
		IPage<OutcontractSupplierVO> pageData = new Page<>(pageIndex, pageSize, count);
		if(count>0){
			List<OutcontractSupplierVO> list = contractMapper.querySupplierList(params);
			List<Long> ids = new ArrayList<>();
			for(OutcontractSupplierVO vo : list){
				ids.add(vo.getId());
			}
			CommonResponse<List<SupplierVO>> supplierResponse = shareSupplierApi.querySupplierByIds(ids);
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null && supplierResponse.getData().size()>0){
				Map<Long, SupplierVO> map = new HashMap<>();
				for(SupplierVO vo : supplierResponse.getData()){
					map.put(vo.getId(),vo);
				}
				for(OutcontractSupplierVO vo : list){
					if(map.get(vo.getId())!=null){
						SupplierVO supplierVO = map.get(vo.getId());
						vo.setSupplierName(supplierVO.getName());
						vo.setSupplierTaxPayerType(supplierVO.getTaxPayerType());
						vo.setSupplierSocialCreditCode(supplierVO.getSocialCreditCode());
						vo.setSupplierBank(supplierVO.getBankName());
						vo.setSupplierBankAccount(supplierVO.getBankAccount());
						vo.setSupplierLegal(supplierVO.getLegal());
						vo.setSupplierTelephone(supplierVO.getTelephone());
					}
				}
			}
			pageData.setRecords(list);
		}
		return pageData;
	}

}
