/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bidWinDisclosure.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bidWinDisclosure.bean.BidWinDisclosureEntity;
import com.ejianc.foundation.bidWinDisclosure.bean.BidWinDisclosureExtend1Entity;
import com.ejianc.foundation.bidWinDisclosure.service.IBidWinDisclosureExtend1Service;
import com.ejianc.foundation.bidWinDisclosure.service.IBidWinDisclosureService;
import com.ejianc.foundation.bidWinDisclosure.vo.BidWinDisclosureVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bidWinDisclosure"})
public class BidWinDisclosureController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBpmApi bpmApi;
    private static final String BILL_CODE = "ZJKJ-BIDWINDISCLOSURE";
    @Autowired
    private IBidWinDisclosureService service;
    @Autowired
    private IBidWinDisclosureExtend1Service extend1Service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BidWinDisclosureVO> saveOrUpdate(@RequestBody BidWinDisclosureVO saveOrUpdateVO) {
        BidWinDisclosureEntity entity = (BidWinDisclosureEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidWinDisclosureEntity.class));
        boolean add = false;
        if (entity.getId() == null || entity.getId() == 0L) {
            add = true;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        BidWinDisclosureExtend1Entity extend1Entity = (BidWinDisclosureExtend1Entity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidWinDisclosureExtend1Entity.class));
        if (add) {
            extend1Entity.setId(entity.getId());
            extend1Entity.setBidWinDisclosureId(entity.getId());
        } else {
            BidWinDisclosureExtend1Entity old1Data = (BidWinDisclosureExtend1Entity)((Object)this.extend1Service.getById(entity.getId()));
            if (old1Data != null) {
                extend1Entity.setId(old1Data.getId());
                extend1Entity.setBidWinDisclosureId(old1Data.getId());
                extend1Entity.setCreateTime(old1Data.getCreateTime());
                extend1Entity.setCreateUserCode(old1Data.getCreateUserCode());
                extend1Entity.setUpdateTime(old1Data.getUpdateTime());
                extend1Entity.setUpdateUserCode(old1Data.getUpdateUserCode());
                extend1Entity.setVersion(old1Data.getVersion());
                extend1Entity.setTenantId(old1Data.getTenantId());
            } else {
                extend1Entity.setId(entity.getId());
                extend1Entity.setBidWinDisclosureId(entity.getId());
            }
        }
        this.extend1Service.saveOrUpdate((Object)extend1Entity, false);
        BidWinDisclosureVO vo = (BidWinDisclosureVO)BeanMapper.map((Object)((Object)entity), BidWinDisclosureVO.class);
        BeanUtils.copyProperties((Object)((Object)extend1Entity), (Object)vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidWinDisclosureVO> queryDetail(Long id) {
        BidWinDisclosureEntity entity = (BidWinDisclosureEntity)((Object)this.service.selectById(id));
        BidWinDisclosureExtend1Entity extend1Entity = (BidWinDisclosureExtend1Entity)((Object)this.extend1Service.selectById(id));
        BidWinDisclosureVO vo = (BidWinDisclosureVO)BeanMapper.map((Object)((Object)entity), BidWinDisclosureVO.class);
        BeanUtils.copyProperties((Object)((Object)extend1Entity), (Object)vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidWinDisclosureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BidWinDisclosureVO bidWinDisclosureVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.extend1Service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BidWinDisclosureVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("confidant");
        fuzzyFields.add("receiver");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidWinDisclosureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("confidant");
        fuzzyFields.add("receiver");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List bidWinDisclosureVOList = BeanMapper.mapList((Iterable)list, BidWinDisclosureVO.class);
        bidWinDisclosureVOList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", bidWinDisclosureVOList);
        ExcelExport.getInstance().export("bidWinDisclosure-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/selectBidWinDisclosureByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse selectBidWinDisclosureByProjectId(@RequestParam(value="id", required=false) Long id, @RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (id != null) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.eq(BidWinDisclosureEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.service.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4e00\u4e2a\u9879\u76ee\u53ea\u80fd\u5bf9\u5e94\u4e00\u6b21\u4e2d\u6807\u4ea4\u5e95");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/cardExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void cardExcelExport(@RequestBody Long id, HttpServletResponse response) {
        BidWinDisclosureEntity entity = (BidWinDisclosureEntity)((Object)this.service.selectById(id));
        BidWinDisclosureExtend1Entity extend1Entity = (BidWinDisclosureExtend1Entity)((Object)this.extend1Service.selectById(id));
        BidWinDisclosureVO vo = (BidWinDisclosureVO)BeanMapper.map((Object)((Object)entity), BidWinDisclosureVO.class);
        BeanUtils.copyProperties((Object)((Object)extend1Entity), (Object)vo);
        if (vo.getConfessDate() != null) {
            vo.setConfessDateShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getConfessDate()));
        }
        HashMap<String, BidWinDisclosureVO> beans = new HashMap<String, BidWinDisclosureVO>();
        beans.put("data", vo);
        ExcelExport.getInstance().export("bidWinDisclosure-cardexport.xlsx", beans, response);
    }

    @RequestMapping(value={"/printDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> printDetail(@RequestParam(value="id") Long id, @RequestParam(value="billType") String billType) {
        JSONObject printData = new JSONObject();
        JSONObject voJson = new JSONObject();
        BidWinDisclosureEntity entity = (BidWinDisclosureEntity)((Object)this.service.selectById(id));
        BidWinDisclosureExtend1Entity extend1Entity = (BidWinDisclosureExtend1Entity)((Object)this.extend1Service.selectById(id));
        BidWinDisclosureVO vo = (BidWinDisclosureVO)BeanMapper.map((Object)((Object)entity), BidWinDisclosureVO.class);
        BeanUtils.copyProperties((Object)((Object)extend1Entity), (Object)vo);
        voJson = (JSONObject)BeanMapper.map((Object)vo, JSONObject.class);
        if (vo.getBillState() != null && vo.getBillState() != 0 && vo.getBillState() != 1 && vo.getBillState() != 4) {
            CommonResponse approveList = this.bpmApi.queryHistoryById(id);
            voJson.put("ApproveInfo", approveList.getData());
        } else {
            voJson.put("ApproveInfo", new ArrayList());
        }
        printData.put("BidWinDisclosure", (Object)voJson);
        return CommonResponse.success((Object)printData);
    }
}

