/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.service.impl;

import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontract")
public class OutcontractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        entity.setSubmitDate(new Date());
        this.outcontractService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        entity.setSubmitDate(null);
        this.outcontractService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        entity.setSignDate(new Date());
        if (state == 1) {
            entity.setSubmitDate(new Date());
        }
        entity.setPassedDate(new Date());
        this.outcontractService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u5408\u540c\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        entity.setSubmitDate(null);
        entity.setPassedDate(null);
        this.outcontractService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }
}

