/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportProjectEntity;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportProjectMapper;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryByProjectService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryReportProjectService;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryReportVO;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="outcontractSignSummaryByProjectService")
public class OutcontractSignSummaryByProjectServiceImpl
implements IOutcontractSignSummaryByProjectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ESSignSummaryProject = "ejc_zjkj_outcontract_sign_summary_project";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private IOutcontractSignSummaryReportProjectService outcontractSignSummaryReportProjectService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private OutcontractMapper contractMapper;
    @Autowired
    private OutcontractSignSummaryReportProjectMapper peportOrgMapper;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("\u533a\u57df\u516c\u53f8-\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        this.outcontractReportService.saveOrUpdate((Object)reportEntity, false);
        QueryParam queryParam = new QueryParam();
        CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("pl_project");
        ArrayList<String> noExitProjectName = new ArrayList<String>();
        if (defdocResponse.isSuccess() && ((List)defdocResponse.getData()).size() > 0) {
            ((List)defdocResponse.getData()).forEach(item -> noExitProjectName.add(item.getName()));
        }
        List<RecordOutcontractVO> list = this.queryList(queryParam, null, noExitProjectName);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        ArrayList<OutcontractSignSummaryReportProjectEntity> entityList = new ArrayList<OutcontractSignSummaryReportProjectEntity>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<Long, String> signDateMap = new HashMap<Long, String>();
        for (RecordOutcontractVO recordOutcontractVO : list) {
            if (recordOutcontractVO.getSignDate() == null) continue;
            if (signDateMap.get(recordOutcontractVO.getProjectId()) != null) {
                String signDate = (String)signDateMap.get(recordOutcontractVO.getProjectId());
                signDate = signDate + "," + dateFormat.format(recordOutcontractVO.getSignDate());
                signDateMap.put(recordOutcontractVO.getProjectId(), signDate);
                continue;
            }
            signDateMap.put(recordOutcontractVO.getProjectId(), dateFormat.format(recordOutcontractVO.getSignDate()));
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (RecordOutcontractVO entity : list) {
            try {
                if (!projectIds.contains(entity.getProjectId()) && entity.getProjectId() != null) {
                    projectIds.add(entity.getProjectId());
                    OutcontractSignSummaryReportProjectEntity e = new OutcontractSignSummaryReportProjectEntity();
                    e.setReportId(reportId);
                    e.setOrgId(entity.getOrgId());
                    e.setProjectDepartmentId(entity.getProjectDepartmentId());
                    e.setProjectId(entity.getProjectId());
                    e.setTenantId(entity.getTenantId());
                    e.setCreateTime(e.getCreateTime());
                    e.setSignDate((String)signDateMap.get(entity.getProjectId()));
                    entityList.add(e);
                }
                OutcontractSignSummaryVO outcontractSignSummaryVO = (OutcontractSignSummaryVO)BeanMapper.map((Object)entity, OutcontractSignSummaryVO.class);
                Map dataMap = (Map)BeanMapper.map((Object)outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummaryProject);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u533a\u57df\u516c\u53f8-\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u533a\u57df\u516c\u53f8-\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (entityList != null && entityList.size() > 0) {
                this.outcontractSignSummaryReportProjectService.saveOrUpdateBatch(entityList, entityList.size(), false);
            }
        }
        catch (IOException iOException) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + iOException.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + iOException.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u533a\u57df\u516c\u53f8-\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u533a\u57df\u516c\u53f8-\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractSignSummaryReportVO> queryPage(QueryParam param) {
        Page page = new Page();
        ArrayList<OutcontractSignSummaryReportVO> resultList = new ArrayList<OutcontractSignSummaryReportVO>();
        Map params = param.getParams();
        CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("pl_project");
        ArrayList<String> noExitProjectName = new ArrayList<String>();
        if (defdocResponse.isSuccess() && ((List)defdocResponse.getData()).size() > 0) {
            ((List)defdocResponse.getData()).forEach(item -> noExitProjectName.add(item.getName()));
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        page.setCurrent((long)param.getPageIndex());
        if (commonOrgIds.size() == 0) {
            page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)resultList.size());
            page.setRecords(resultList);
            return page;
        }
        if (params.get("range") != null && "es".equals(((Parameter)params.get("range")).getValue().toString())) {
            params.remove("range");
            String reportId = ((Parameter)params.get("reportId")).getValue().toString();
            try {
                IPage list = null;
                if (param.getParams().get("signDate") != null) {
                    list = this.outcontractSignSummaryReportProjectService.queryNewPage(param, commonOrgIds, departmentIds);
                } else {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                    if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                        queryWrapper.in((Object)"org_id", commonOrgIds);
                    } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                        queryWrapper.in((Object)"project_department_id", departmentIds);
                    }
                    queryWrapper.eq((Object)"report_id", (Object)reportId);
                    Page page1 = new Page((long)param.getPageIndex(), (long)param.getPageSize());
                    list = this.outcontractSignSummaryReportProjectService.page((IPage)page1, (Wrapper)queryWrapper);
                }
                for (OutcontractSignSummaryReportProjectEntity vo : list.getRecords()) {
                    resultList.add(this.selectProject(reportId, vo.getProjectId().toString(), param, noExitProjectName));
                }
                page.setTotal(list.getTotal());
                page.setRecords(resultList);
            }
            catch (Exception e2) {
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e2);
            }
        } else {
            if (params.get("range") != null) {
                params.remove("range");
            }
            HashMap<String, Object> paramMapper = new HashMap<String, Object>();
            long startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
            paramMapper.put("startLine", startLine);
            paramMapper.put("pageIndex", param.getPageIndex());
            paramMapper.put("pageSize", param.getPageSize());
            paramMapper.put("orgIds", commonOrgIds);
            paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
            if (param.getParams() != null && param.getParams().get("signDate") != null) {
                String[] signDate = ((Parameter)param.getParams().get("signDate")).getValue().toString().split(",");
                String sql = "( sign_date BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
                paramMapper.put("signDate", sql);
                String sql1 = "( supplementary_sign_time  BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
                paramMapper.put("supplementarySignTime", sql1);
            }
            if (paramMapper.get("signDate") == null) {
                SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
                String curDate = format2.format(new Date());
                String sql = "( sign_date > '" + curDate + "' )";
                paramMapper.put("signDate", sql);
                String sql1 = "( supplementary_sign_time > '" + curDate + "' )";
                paramMapper.put("supplementarySignTime", sql1);
            }
            paramMapper.put("noExitProjectName", noExitProjectName);
            long count = this.peportOrgMapper.countAll(paramMapper);
            List<Object> list = new ArrayList();
            if (count > 0L) {
                list = this.peportOrgMapper.queryAllList(paramMapper);
                list.forEach(e -> resultList.add(this.processData(e.getProjectId(), param)));
            }
            page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), count);
            page.setRecords(resultList);
        }
        return page;
    }

    public List<RecordOutcontractVO> queryList(@RequestBody QueryParam param, Long projectId, List<String> noExitProjectName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }
        if (param.getOrderMap() != null && param.getOrderMap().size() > 0) {
            String sql = " order by ";
            for (String key : param.getOrderMap().keySet()) {
                sql = sql + " d." + key + " " + (String)param.getOrderMap().get(key) + " ";
            }
            params.put("ordersql", sql);
        }
        if (projectId != null) {
            params.put("projectId", projectId);
        }
        params.put("noProject", "noProject");
        if (noExitProjectName != null && noExitProjectName.size() > 0) {
            params.put("noExitProjectName", noExitProjectName);
        }
        if (param.getParams() != null && param.getParams().get("signDate") != null) {
            String[] signDate = ((Parameter)param.getParams().get("signDate")).getValue().toString().split(",");
            String sql = "( sign_date BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
            params.put("signDate", sql);
            String sql1 = "( supplementary_sign_time  BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
            params.put("supplementarySignTime", sql1);
        }
        if (params.get("signDate") == null) {
            SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
            String curDate = format2.format(new Date());
            String sql = "( sign_date > '" + curDate + "' )";
            params.put("signDate", sql);
            String sql1 = "( supplementary_sign_time > '" + curDate + "' )";
            params.put("supplementarySignTime", sql1);
        }
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(1);
        billState.add(3);
        params.put("billState", billState);
        List<RecordOutcontractVO> list = this.contractMapper.queryAllList(params);
        return list;
    }

    public OutcontractSignSummaryReportVO processData(Long projectId, QueryParam param) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        vo.setPackLight(0);
        vo.setExpandSub(0);
        vo.setOtherform(0);
        vo.setLaborAndMaterials(0);
        vo.setWorkersAndAuxiliaryMaterials(0);
        vo.setOtherForms(0);
        List<RecordOutcontractVO> list = this.queryList(param, projectId, null);
        if (list.size() > 0) {
            vo.setProjectName(list.get(0).getProjectName());
            vo.setSumContract(list.size());
            vo.setSumSubcontractingContent(list.size());
            for (RecordOutcontractVO e2 : list) {
                if ("\u52b3\u52a1\u5206\u5305".equals(e2.getType())) {
                    if (!StringUtils.isNotBlank((CharSequence)e2.getLaborSubcontracteMode())) continue;
                    switch (e2.getLaborSubcontracteMode()) {
                        case "\u5305\u8f7b\u5de5": {
                            vo.setPackLight(vo.getPackLight() + 1);
                            break;
                        }
                        case "\u6269\u5927\u52b3\u52a1\u5206\u5305": {
                            vo.setExpandSub(vo.getExpandSub() + 1);
                            break;
                        }
                        case "\u5176\u4ed6\u5f62\u5f0f": {
                            vo.setOtherform(vo.getOtherform() + 1);
                        }
                    }
                    continue;
                }
                if (!"\u4e13\u4e1a\u5206\u5305".equals(e2.getType()) || !StringUtils.isNotBlank((CharSequence)e2.getLaborSubcontracteMode())) continue;
                switch (e2.getLaborSubcontracteMode()) {
                    case "\u5305\u5de5\u5305\u6599": {
                        vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                        break;
                    }
                    case "\u5305\u6e05\u5de5\u8f85\u6750": {
                        vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                        break;
                    }
                    case "\u5176\u4ed6\u5f62\u5f0f": {
                        vo.setOtherForms(vo.getOtherForms() + 1);
                    }
                }
            }
            list.forEach(e -> {
                if ("\u52b3\u52a1\u5206\u5305".equals(e.getType())) {
                    if (vo.getLabor() == null) {
                        vo.setLabor(0);
                    }
                    vo.setLabor(vo.getLabor() + 1);
                    if (vo.getSumLabor() == null) {
                        vo.setSumLabor(0);
                    }
                    vo.setSumLabor(vo.getSumLabor() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborPrice() == null) {
                                    vo.setLaborPrice(0);
                                }
                                vo.setLaborPrice(vo.getLaborPrice() + 1);
                                break;
                            }
                            case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborArea() == null) {
                                    vo.setLaborArea(0);
                                }
                                vo.setLaborArea(vo.getLaborArea() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborFixedPrice() == null) {
                                    vo.setLaborFixedPrice(0);
                                }
                                vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getLaborTotalPrice() == null) {
                                    vo.setLaborTotalPrice(0);
                                }
                                vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                break;
                            }
                            case "\u5b9a\u989d\u8ba1\u4ef7": {
                                if (vo.getLaborQuotaValuation() == null) {
                                    vo.setLaborQuotaValuation(0);
                                }
                                vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                            }
                        }
                    }
                }
                if ("\u4e13\u4e1a\u5206\u5305".equals(e.getType())) {
                    if (vo.getMajor() == null) {
                        vo.setMajor(0);
                    }
                    vo.setMajor(vo.getMajor() + 1);
                    if (vo.getSumMajor() == null) {
                        vo.setSumMajor(0);
                    }
                    vo.setSumMajor(vo.getSumMajor() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getMajorPrice() == null) {
                                    vo.setMajorPrice(0);
                                }
                                vo.setMajorPrice(vo.getMajorPrice() + 1);
                                break;
                            }
                            case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                                if (vo.getRateLower() == null) {
                                    vo.setRateLower(0);
                                }
                                vo.setRateLower(vo.getRateLower() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getMajorTotalPrice() == null) {
                                    vo.setMajorTotalPrice(0);
                                }
                                vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                break;
                            }
                            case "\u5b9a\u989d\u8ba1\u4ef7": {
                                if (vo.getMajorQuotaValuation() == null) {
                                    vo.setMajorQuotaValuation(0);
                                }
                                vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                            }
                        }
                    }
                }
                if ("\u7269\u8d44\u91c7\u8d2d".equals(e.getType())) {
                    if (vo.getMaterial() == null) {
                        vo.setMaterial(0);
                    }
                    vo.setMaterial(vo.getMaterial() + 1);
                    if (vo.getSumMaterial() == null) {
                        vo.setSumMaterial(0);
                    }
                    vo.setSumMaterial(vo.getSumMaterial() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getMaterialFixedPrice() == null) {
                                    vo.setMaterialFixedPrice(0);
                                }
                                vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                break;
                            }
                            case "\u53ef\u8c03\u4ef7\u683c": {
                                if (vo.getAdjustablePrice() == null) {
                                    vo.setAdjustablePrice(0);
                                }
                                vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                            }
                        }
                    }
                }
                if ("\u673a\u68b0\u79df\u8d41".equals(e.getType())) {
                    if (vo.getEquipment() == null) {
                        vo.setEquipment(0);
                    }
                    vo.setEquipment(vo.getEquipment() + 1);
                    if (vo.getSumEquipment() == null) {
                        vo.setSumEquipment(0);
                    }
                    vo.setSumEquipment(vo.getSumEquipment() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getEquipmentFixedPrice() == null) {
                                    vo.setEquipmentFixedPrice(0);
                                }
                                vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getEquipmentOther() == null) {
                                    vo.setEquipmentOther(0);
                                }
                                vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                            }
                        }
                    }
                }
                if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(e.getType())) {
                    if (vo.getTurnoverMaterial() == null) {
                        vo.setTurnoverMaterial(0);
                    }
                    vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                    if (vo.getSumTurnoverMaterial() == null) {
                        vo.setSumTurnoverMaterial(0);
                    }
                    vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getTurnoverMaterialFixedPrice() == null) {
                                    vo.setTurnoverMaterialFixedPrice(0);
                                }
                                vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getTurnoverMaterialOther() == null) {
                                    vo.setTurnoverMaterialOther(0);
                                }
                                vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                            }
                        }
                    }
                }
                if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(e.getType())) {
                    if (vo.getDesign() == null) {
                        vo.setDesign(0);
                    }
                    vo.setDesign(vo.getDesign() + 1);
                    if (vo.getSumDesign() == null) {
                        vo.setSumDesign(0);
                    }
                    vo.setSumDesign(vo.getSumDesign() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getDesignTotalPrice() == null) {
                                    vo.setDesignTotalPrice(0);
                                }
                                vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getDesignFixedPrice() == null) {
                                    vo.setDesignFixedPrice(0);
                                }
                                vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getDesignOther() == null) {
                                    vo.setDesignOther(0);
                                }
                                vo.setDesignOther(vo.getDesignOther() + 1);
                            }
                        }
                    }
                }
                if ("\u54a8\u8be2\u670d\u52a1".equals(e.getType())) {
                    if (vo.getConsultancy() == null) {
                        vo.setConsultancy(0);
                    }
                    vo.setConsultancy(vo.getConsultancy() + 1);
                    if (vo.getSumConsultancy() == null) {
                        vo.setSumConsultancy(0);
                    }
                    vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getConsultancyFixedPrice() == null) {
                                    vo.setConsultancyFixedPrice(0);
                                }
                                vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getConsultancyOther() == null) {
                                    vo.setConsultancyOther(0);
                                }
                                vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                            }
                        }
                    }
                }
                if ("\u5176\u5b83\u5408\u540c".equals(e.getType())) {
                    if (vo.getOther() == null) {
                        vo.setOther(0);
                    }
                    vo.setOther(vo.getOther() + 1);
                    if (vo.getSumOther() == null) {
                        vo.setSumOther(0);
                    }
                    vo.setSumOther(vo.getSumOther() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getOtherFixedPrice() == null) {
                                    vo.setOtherFixedPrice(0);
                                }
                                vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getOther1() == null) {
                                    vo.setOther1(0);
                                }
                                vo.setOther1(vo.getOther1() + 1);
                            }
                        }
                    }
                }
            });
            if (vo.getPackLight() == null) {
                vo.setPackLight(0);
            }
            if (vo.getSmallMechanical() == null) {
                vo.setSmallMechanical(0);
            }
            if (vo.getExpandSub() == null) {
                vo.setExpandSub(0);
            }
            if (vo.getOtherform() == null) {
                vo.setOtherform(0);
            }
            Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
            Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
            vo.setSumLaborSubcontracteMode(Integer.sum(a, b));
        }
        return vo;
    }

    public OutcontractSignSummaryReportVO selectProject(String reportId, String projectId, QueryParam param, List<String> noExitProjectName) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        vo.setPackLight(0);
        vo.setExpandSub(0);
        vo.setOtherform(0);
        vo.setLaborAndMaterials(0);
        vo.setWorkersAndAuxiliaryMaterials(0);
        vo.setOtherForms(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignSummaryProject});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"reportId", (Object)reportId));
        boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
        try {
            if (param.getParams().get("signDate") != null) {
                String[] signDate = ((Parameter)param.getParams().get("signDate")).getValue().toString().split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"signDate").from((Object)signDate[0]).to((Object)signDate[1]));
            }
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)projectId));
            boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"type.keyword", (Object)"\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c"));
            if (noExitProjectName != null && noExitProjectName.size() > 0) {
                for (String name : noExitProjectName) {
                    boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                }
            }
            sourceBuilder.query((QueryBuilder)boolQuery);
            CountRequest count = new CountRequest(new String[]{ESSignSummaryProject});
            count.query((QueryBuilder)boolQuery);
            CountResponse countResponse = this.client.count(count, RequestOptions.DEFAULT);
            sourceBuilder.query((QueryBuilder)boolQuery);
            sourceBuilder.from(0);
            sourceBuilder.size((int)countResponse.getCount());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
            searchRequest.source(sourceBuilder);
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            ArrayList<OutcontractSignSummaryReportVO> list = new ArrayList<OutcontractSignSummaryReportVO>();
            for (SearchHit hit : hits) {
                Map sourceAsMap = hit.getSourceAsMap();
                OutcontractSignSummaryReportVO outcontractSignSummaryReportVO = (OutcontractSignSummaryReportVO)JSON.parseObject((String)JSON.toJSONString((Object)sourceAsMap), OutcontractSignSummaryReportVO.class);
                outcontractSignSummaryReportVO.setProjectId((String)sourceAsMap.get("projectId"));
                list.add(outcontractSignSummaryReportVO);
            }
            if (list.size() > 0) {
                vo.setProjectName(((OutcontractSignSummaryReportVO)list.get(0)).getProjectName());
                vo.setSumContract(list.size());
                vo.setSumSubcontractingContent(list.size());
            }
            for (OutcontractSignSummaryReportVO e2 : list) {
                if ("\u52b3\u52a1\u5206\u5305".equals(e2.getType())) {
                    if (!StringUtils.isNotBlank((CharSequence)e2.getLaborSubcontracteMode())) continue;
                    switch (e2.getLaborSubcontracteMode()) {
                        case "\u5305\u8f7b\u5de5": {
                            vo.setPackLight(vo.getPackLight() + 1);
                            break;
                        }
                        case "\u6269\u5927\u52b3\u52a1\u5206\u5305": {
                            vo.setExpandSub(vo.getExpandSub() + 1);
                            break;
                        }
                        case "\u5176\u4ed6\u5f62\u5f0f": {
                            vo.setOtherform(vo.getOtherform() + 1);
                        }
                    }
                    continue;
                }
                if (!"\u4e13\u4e1a\u5206\u5305".equals(e2.getType()) || !StringUtils.isNotBlank((CharSequence)e2.getLaborSubcontracteMode())) continue;
                switch (e2.getLaborSubcontracteMode()) {
                    case "\u5305\u5de5\u5305\u6599": {
                        vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                        break;
                    }
                    case "\u5305\u6e05\u5de5\u8f85\u6750": {
                        vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                        break;
                    }
                    case "\u5176\u4ed6\u5f62\u5f0f": {
                        vo.setOtherForms(vo.getOtherForms() + 1);
                    }
                }
            }
            list.forEach(e -> {
                if ("\u52b3\u52a1\u5206\u5305".equals(e.getType())) {
                    if (vo.getLabor() == null) {
                        vo.setLabor(0);
                    }
                    vo.setLabor(vo.getLabor() + 1);
                    if (vo.getSumLabor() == null) {
                        vo.setSumLabor(0);
                    }
                    vo.setSumLabor(vo.getSumLabor() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborPrice() == null) {
                                    vo.setLaborPrice(0);
                                }
                                vo.setLaborPrice(vo.getLaborPrice() + 1);
                                break;
                            }
                            case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborArea() == null) {
                                    vo.setLaborArea(0);
                                }
                                vo.setLaborArea(vo.getLaborArea() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getLaborFixedPrice() == null) {
                                    vo.setLaborFixedPrice(0);
                                }
                                vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getLaborTotalPrice() == null) {
                                    vo.setLaborTotalPrice(0);
                                }
                                vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                break;
                            }
                            case "\u5b9a\u989d\u8ba1\u4ef7": {
                                if (vo.getLaborQuotaValuation() == null) {
                                    vo.setLaborQuotaValuation(0);
                                }
                                vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                            }
                        }
                    }
                }
                if ("\u4e13\u4e1a\u5206\u5305".equals(e.getType())) {
                    if (vo.getMajor() == null) {
                        vo.setMajor(0);
                    }
                    vo.setMajor(vo.getMajor() + 1);
                    if (vo.getSumMajor() == null) {
                        vo.setSumMajor(0);
                    }
                    vo.setSumMajor(vo.getSumMajor() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getMajorPrice() == null) {
                                    vo.setMajorPrice(0);
                                }
                                vo.setMajorPrice(vo.getMajorPrice() + 1);
                                break;
                            }
                            case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                                if (vo.getRateLower() == null) {
                                    vo.setRateLower(0);
                                }
                                vo.setRateLower(vo.getRateLower() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getMajorTotalPrice() == null) {
                                    vo.setMajorTotalPrice(0);
                                }
                                vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                break;
                            }
                            case "\u5b9a\u989d\u8ba1\u4ef7": {
                                if (vo.getMajorQuotaValuation() == null) {
                                    vo.setMajorQuotaValuation(0);
                                }
                                vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                            }
                        }
                    }
                }
                if ("\u7269\u8d44\u91c7\u8d2d".equals(e.getType())) {
                    if (vo.getMaterial() == null) {
                        vo.setMaterial(0);
                    }
                    vo.setMaterial(vo.getMaterial() + 1);
                    if (vo.getSumMaterial() == null) {
                        vo.setSumMaterial(0);
                    }
                    vo.setSumMaterial(vo.getSumMaterial() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getMaterialFixedPrice() == null) {
                                    vo.setMaterialFixedPrice(0);
                                }
                                vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                break;
                            }
                            case "\u53ef\u8c03\u4ef7\u683c": {
                                if (vo.getAdjustablePrice() == null) {
                                    vo.setAdjustablePrice(0);
                                }
                                vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                            }
                        }
                    }
                }
                if ("\u673a\u68b0\u79df\u8d41".equals(e.getType())) {
                    if (vo.getEquipment() == null) {
                        vo.setEquipment(0);
                    }
                    vo.setEquipment(vo.getEquipment() + 1);
                    if (vo.getSumEquipment() == null) {
                        vo.setSumEquipment(0);
                    }
                    vo.setSumEquipment(vo.getSumEquipment() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getEquipmentFixedPrice() == null) {
                                    vo.setEquipmentFixedPrice(0);
                                }
                                vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getEquipmentOther() == null) {
                                    vo.setEquipmentOther(0);
                                }
                                vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                            }
                        }
                    }
                }
                if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(e.getType())) {
                    if (vo.getTurnoverMaterial() == null) {
                        vo.setTurnoverMaterial(0);
                    }
                    vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                    if (vo.getSumTurnoverMaterial() == null) {
                        vo.setSumTurnoverMaterial(0);
                    }
                    vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getTurnoverMaterialFixedPrice() == null) {
                                    vo.setTurnoverMaterialFixedPrice(0);
                                }
                                vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getTurnoverMaterialOther() == null) {
                                    vo.setTurnoverMaterialOther(0);
                                }
                                vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                            }
                        }
                    }
                }
                if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(e.getType())) {
                    if (vo.getDesign() == null) {
                        vo.setDesign(0);
                    }
                    vo.setDesign(vo.getDesign() + 1);
                    if (vo.getSumDesign() == null) {
                        vo.setSumDesign(0);
                    }
                    vo.setSumDesign(vo.getSumDesign() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u603b\u4ef7": {
                                if (vo.getDesignTotalPrice() == null) {
                                    vo.setDesignTotalPrice(0);
                                }
                                vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                break;
                            }
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getDesignFixedPrice() == null) {
                                    vo.setDesignFixedPrice(0);
                                }
                                vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getDesignOther() == null) {
                                    vo.setDesignOther(0);
                                }
                                vo.setDesignOther(vo.getDesignOther() + 1);
                            }
                        }
                    }
                }
                if ("\u54a8\u8be2\u670d\u52a1".equals(e.getType())) {
                    if (vo.getConsultancy() == null) {
                        vo.setConsultancy(0);
                    }
                    vo.setConsultancy(vo.getConsultancy() + 1);
                    if (vo.getSumConsultancy() == null) {
                        vo.setSumConsultancy(0);
                    }
                    vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getConsultancyFixedPrice() == null) {
                                    vo.setConsultancyFixedPrice(0);
                                }
                                vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getConsultancyOther() == null) {
                                    vo.setConsultancyOther(0);
                                }
                                vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                            }
                        }
                    }
                }
                if ("\u5176\u5b83\u5408\u540c".equals(e.getType())) {
                    if (vo.getOther() == null) {
                        vo.setOther(0);
                    }
                    vo.setOther(vo.getOther() + 1);
                    if (vo.getSumOther() == null) {
                        vo.setSumOther(0);
                    }
                    vo.setSumOther(vo.getSumOther() + 1);
                    if (StringUtils.isNotBlank((CharSequence)e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "\u56fa\u5b9a\u5355\u4ef7": {
                                if (vo.getOtherFixedPrice() == null) {
                                    vo.setOtherFixedPrice(0);
                                }
                                vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                break;
                            }
                            case "\u5176\u5b83": {
                                if (vo.getOther1() == null) {
                                    vo.setOther1(0);
                                }
                                vo.setOther1(vo.getOther1() + 1);
                            }
                        }
                    }
                }
            });
            if (vo.getPackLight() == null) {
                vo.setPackLight(0);
            }
            if (vo.getSmallMechanical() == null) {
                vo.setSmallMechanical(0);
            }
            if (vo.getExpandSub() == null) {
                vo.setExpandSub(0);
            }
            if (vo.getOtherform() == null) {
                vo.setOtherform(0);
            }
            Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
            Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
            vo.setSumLaborSubcontracteMode(Integer.sum(a, b));
        }
        catch (Exception e3) {
            throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e3);
        }
        return vo;
    }
}

