package com.ejianc.foundation.outcontract.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.outcontract.mapper.RecordOutcontractMapper;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 记录分供方合同
 * 
 * @author generator
 * 
 */
@Service("recordOutcontractService")
public class RecordOutcontractServiceImpl extends BaseServiceImpl<RecordOutcontractMapper, RecordOutcontractEntity> implements IRecordOutcontractService{

    @Autowired
    private OutcontractMapper contractMapper;

    @Override
    public IPage<RecordOutcontractVO> queryAllList(Map<String, Object> params) {
        Long count = contractMapper.countAll(params);
        Integer pageIndex = params.get("pageIndex")!=null?Integer.parseInt(params.get("pageIndex").toString()):1;
        Integer pageSize = params.get("pageSize")!=null?Integer.parseInt(params.get("pageSize").toString()):10;
        IPage<RecordOutcontractVO> pageData = new Page<>(pageIndex, pageSize, count);
        if(count>0){
            List<RecordOutcontractVO> list = contractMapper.queryAllList(params);
            List<Long> contractIds = new ArrayList<>();
            List<Long> projectIds = new ArrayList<>();
            for(RecordOutcontractVO vo : list) {
                //合同额—原合同的合同额，变更单合同取变更金额（签约时间取补充签订时间，其余与合同一样）
                if (!"合同".equals(vo.getBooktype())) {
                    vo.setContractPrice(vo.getChangeAmount());
                    vo.setSignDate(vo.getSupplementarySignTime());
                }else{
                    //是主合同，查询履约情况
                    contractIds.add(vo.getId());
                    projectIds.add(vo.getProjectId());
                }
            }
            if(params.get("otherInfo")!=null && contractIds!=null && contractIds.size()>0){
                /*
                2、累计月结额，其中--工程款额度：
                1)、劳务分包专业分包：取最后一期生效的结算（过程【分包中间计量】【累计合计】或者完工结算（工程分包结算书）【累计定审金额(含税)】）表头累计合计，有分包中间计量取分包中间计量，没有取完工结算（工程分包结算书）
                2）、物资采购，取最后一期生效的过程【采购中间计量，表头累计发生(含税)】或最终【物资最终结算，表头累计结算金额(含税)】），有采购中间计量取采购中间计量，没有最终【物资最终结算，表头累计结算金额(含税)】）
                3）、周转租赁合同：取最后一期生效的【周转租赁中间计量，表头累计发生(含税)】
                4）、设备租赁合同：取最后一期生效的【月度机械设备租赁单，表头本月租赁结算合价（含税）】
                5）、咨询及其他，取最后一期生效的过程或最终结算，过程单据【咨询及其他中间计量，表头【含税合价--累计合计】；最终结算【咨询及其他类合同最终结算单，表头【含税合价--累计合计】，有咨询及其他中间计量取咨询及其他中间计量，没有最终结算【咨询及其他类合同最终结算单，表头【含税合价--累计合计】）
                6）、设计类合同：汇总过程或最终结算，最终单据【设计类结算单，表头（审核含税总价金额）】+完工结算【设计分包中间计量，表头合计】，有设计类结算单取设计类结算单，没有完工结算【设计分包中间计量，表头合计】）

                3、累计月结额，其中--劳务工资额度：取最后一期生效的【分包中间计量】中（其中累计农民工工资）---只有劳务和分包合同
                4、月度结算额，其中【工程款额度 劳务工资额度】两列删除
                5、累计已付款-工程款部分：【预结算管理-付款登记】，表体中累计付款金额（含本期）中合计列
                8、累计已付款-代付劳务工资部分：暂时取不到
                6、累计付款比例-工程款部分：等于(累计已付款-工程款部分)/累计月结额，其中--工程款额度
                7、累计付款比例-劳务费支付比例：等于(累计已付款-代付劳务工资部分)/累计月结额，其中--劳务工资额度
                */
                //供方合同签约情况统计---请求履约状况数据--从中间计量或完工结算中取
                Map<String, Object> param = new HashMap<>();
                param.put("contractIds",contractIds);
                Map<Long,RecordOutcontractVO> map = new HashMap<>();
                //劳务分包专业分包
                List<RecordOutcontractVO> subcontractMonthList = contractMapper.querySubcontractMonthlyProjectAmount(param);
                if(subcontractMonthList!=null && subcontractMonthList.size()>0){
                    for (RecordOutcontractVO vo : subcontractMonthList){
                        map.put(vo.getId(), vo);
                    }
                }
                List<RecordOutcontractVO> settlementBookList = contractMapper.querySettlementBookMonthlyProjectAmount(param);
                if(settlementBookList!=null && settlementBookList.size()>0){
                    for (RecordOutcontractVO vo : settlementBookList){
                        if(map.get(vo.getId())==null){
                            map.put(vo.getId(), vo);
                        }else{
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            if(rvo.getMonthlyProjectAmount()==null){
                                rvo.setMonthlyProjectAmount(vo.getMonthlyProjectAmount());
                                map.put(vo.getId(), rvo);
                            }
                        }
                    }
                }
                //物资采购
                List<RecordOutcontractVO> materialContractList = contractMapper.queryMaterialContractMonthlyProjectAmount(param);
                if(materialContractList!=null && materialContractList.size()>0){
                    for (RecordOutcontractVO vo : materialContractList){
                        map.put(vo.getId(), vo);
                    }
                }

                List<RecordOutcontractVO> materialSettlementList = contractMapper.queryMaterialSettlementMonthlyProjectAmount(param);
                if(materialSettlementList!=null && materialSettlementList.size()>0){
                    for (RecordOutcontractVO vo : materialSettlementList){
                        if(map.get(vo.getId())==null){
                            map.put(vo.getId(), vo);
                        }else{
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            if(rvo.getMonthlyProjectAmount()==null){
                                rvo.setMonthlyProjectAmount(vo.getMonthlyProjectAmount());
                                map.put(vo.getId(), rvo);
                            }
                        }
                    }
                }

                List<RecordOutcontractVO> machineryContractList = contractMapper.queryMachineryContractMonthlyProjectAmount(param);
                if(machineryContractList!=null && machineryContractList.size()>0){
                    for (RecordOutcontractVO vo : machineryContractList){
                        map.put(vo.getId(), vo);
                    }
                }

                List<RecordOutcontractVO> machinerySettlementList = contractMapper.queryMachinerySettlementMonthlyProjectAmount(param);
                if(machinerySettlementList!=null && machinerySettlementList.size()>0){
                    for (RecordOutcontractVO vo : machinerySettlementList){
                        if(map.get(vo.getId())==null){
                            map.put(vo.getId(), vo);
                        }else{
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            if(rvo.getMonthlyProjectAmount()==null){
                                rvo.setMonthlyProjectAmount(vo.getMonthlyProjectAmount());
                                map.put(vo.getId(), rvo);
                            }
                        }
                    }
                }

                List<RecordOutcontractVO> consultotherContractList = contractMapper.queryConsultotherContractMonthlyProjectAmount(param);
                if(consultotherContractList!=null && consultotherContractList.size()>0){
                    for (RecordOutcontractVO vo : consultotherContractList){
                        map.put(vo.getId(), vo);
                    }
                }

                List<RecordOutcontractVO> consultotherSettlementList = contractMapper.queryConsultotherSettlementMonthlyProjectAmount(param);
                if(consultotherSettlementList!=null && consultotherSettlementList.size()>0){
                    for (RecordOutcontractVO vo : consultotherSettlementList){
                        if(map.get(vo.getId())==null){
                            map.put(vo.getId(), vo);
                        }else{
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            if(rvo.getMonthlyProjectAmount()==null){
                                rvo.setMonthlyProjectAmount(vo.getMonthlyProjectAmount());
                                map.put(vo.getId(), rvo);
                            }
                        }
                    }
                }

                List<RecordOutcontractVO> designContractList = contractMapper.queryDesignContractMonthlyProjectAmount(param);
                if(designContractList!=null && designContractList.size()>0){
                    for (RecordOutcontractVO vo : designContractList){
                        map.put(vo.getId(), vo);
                    }
                }

                List<RecordOutcontractVO> designSettlementList = contractMapper.queryDesignSettlementMonthlyProjectAmount(param);
                if(designSettlementList!=null && designSettlementList.size()>0){
                    for (RecordOutcontractVO vo : designSettlementList){
                        if(map.get(vo.getId())==null){
                            map.put(vo.getId(), vo);
                        }else{
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            if(rvo.getMonthlyProjectAmount()==null){
                                rvo.setMonthlyProjectAmount(vo.getMonthlyProjectAmount());
                                map.put(vo.getId(), rvo);
                            }
                        }
                    }
                }

                param.put("projectIds",projectIds);
                List<RecordOutcontractVO> paidProjectPaymentList = contractMapper.queryPaidProjectPayment(param);
                Map<Long,RecordOutcontractVO> paidProjectPaymentMap = new HashMap<>();
                if(paidProjectPaymentList!=null && paidProjectPaymentList.size()>0){
                    for (RecordOutcontractVO vo : paidProjectPaymentList){
                        paidProjectPaymentMap.put(vo.getId(), vo);
                    }
                }

                for(RecordOutcontractVO vo : list) {
                    if ("合同".equals(vo.getBooktype()) && map.get(vo.getId())!=null) {
                        if(map.get(vo.getId())!=null){
                            RecordOutcontractVO rvo = map.get(vo.getId());
                            vo.setMonthlyProjectAmount(rvo.getMonthlyProjectAmount());
                            vo.setMonthlyLaborWagesAmount(vo.getMonthlyLaborWagesAmount());
                        }
                        if(paidProjectPaymentMap.get(vo.getId())!=null){
                            RecordOutcontractVO rvo = paidProjectPaymentMap.get(vo.getId());
                            vo.setPaidProjectPayment(rvo.getPaidProjectPayment());
                        }
//                        累计付款比例-工程款部分：等于(累计已付款-工程款部分)/累计月结额，其中--工程款额度
                        if(vo.getMonthlyProjectAmount()!=null && vo.getMonthlyProjectAmount().compareTo(BigDecimal.ZERO)!=0){
                            if(vo.getPaidProjectPayment()!=null){
                                BigDecimal paymentRatioProjectPayment = vo.getPaidProjectPayment().divide(vo.getMonthlyProjectAmount(), 8, BigDecimal.ROUND_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
                                vo.setPayProjectPayment(paymentRatioProjectPayment);
                            }else{
                                vo.setPayProjectPayment(new BigDecimal(0.00));
                            }
                        }else{
                            vo.setPayProjectPayment(new BigDecimal(0.00));
                        }
                        //累计付款比例-劳务费支付比例：等于(累计已付款-代付劳务工资部分)/累计月结额，其中--劳务工资额度
                        //未能获取，暂时为空
                    }
                }
            }
            pageData.setRecords(list);
        }
        return pageData;
    }
}
