package com.ejianc.foundation.outcontract.service.impl;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.foundation.outcontract.bean.*;
import com.ejianc.foundation.outcontract.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.mapper.ChangeOutcontractMapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 变更分供方合同
 * 
 * @author generator
 * 
 */
@Service("changeOutcontractService")
public class ChangeOutcontractServiceImpl extends BaseServiceImpl<ChangeOutcontractMapper, ChangeOutcontractEntity> implements IChangeOutcontractService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IRecordOutcontractService outcontractRecordService;
//    @Autowired
//    private IChangeOutcontractReviewService changeOutcontractReviewService;
    
//    @Autowired
//    private IOutcontractReviewService outcontractReviewservice;
    
	@Override
	public CommonResponse<ChangeOutcontractVO> saveChange(ChangeOutcontractVO saveOrUpdateVO) {

		//检验该单据是否存在
		boolean exitBill = false;
		if(saveOrUpdateVO.getId()!=null){
			ChangeOutcontractEntity e = this.getById(saveOrUpdateVO);
			if(e!=null){
				exitBill = true;
			}
		}
		ChangeOutcontractEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeOutcontractEntity.class);
    	//检验是否存在未生效的变更单据，若存在，则不能变更
    	QueryWrapper<ChangeOutcontractEntity> queryWrapper = new QueryWrapper<ChangeOutcontractEntity>();
    	queryWrapper.eq("outcontract_id", saveOrUpdateVO.getOutcontractId());
    	queryWrapper.eq("dr", 0);
    	queryWrapper.in("bill_state", "[0,4]");
    	if(saveOrUpdateVO.getId()!=null){
    		queryWrapper.ne("id", saveOrUpdateVO.getId());
    	}
    	List<ChangeOutcontractEntity> exit = this.list(queryWrapper);
    	if(exit!=null&&exit.size()>0){
    		throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
    	}

    	//处理子表数据
        // 供方信息
    	if(saveOrUpdateVO.getChangeOutcontractSupplierList()!=null&&saveOrUpdateVO.getChangeOutcontractSupplierList().size()>0){
    		ChangeOutcontractSupplierVO outcontractSupplierVO = saveOrUpdateVO.getChangeOutcontractSupplierList().get(0);
    		entity.setSupplierName(outcontractSupplierVO.getSupplierName());// 分供商名称
    		entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());// 纳税人类型
    		entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());// 统一社会信用代码
    		entity.setSupplierBank(outcontractSupplierVO.getSupplierBank()); // 开户行
    		entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());; // 开户行账号
    		entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser()); // 联系人
    		entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress()); // 联系人地址
    		entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone()); // 联系人电话
    		entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail()); // 联系人邮箱
    		entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal()); // 法定代表人
    		entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone()); // 供方电话
    	}else{
    		entity.setSupplierName(null);// 分供商名称
    		entity.setSupplierTaxPayerType(null);// 纳税人类型
    		entity.setSupplierSocialCreditCode(null);// 统一社会信用代码
    		entity.setSupplierBank(null); // 开户行
    		entity.setSupplierBankAccount(null);; // 开户行账号
    		entity.setSupplierContactUser(null); // 联系人
    		entity.setSupplierContactUserAddress(null); // 联系人地址
    		entity.setSupplierContactUserPhone(null); // 联系人电话
    		entity.setSupplierContactUserEmail(null); // 联系人邮箱
    		entity.setSupplierLegal(null); // 法定代表人
    		entity.setSupplierTelephone(null); // 供方电话
    	}

		BigDecimal changeAmount = new BigDecimal(0);
		BigDecimal afterChangeAmount = new BigDecimal(0);//变更后金额
		Date supplementarySignTime = null; // 签约时间
		List<ChangeOutcontractSupplementaryAgreementEntity> changeOutcontractSupplementaryAgreementList = entity.getChangeOutcontractSupplementaryAgreementList();
		if(changeOutcontractSupplementaryAgreementList!=null&&changeOutcontractSupplementaryAgreementList.size()>0){
			for(ChangeOutcontractSupplementaryAgreementEntity agreementEntity : changeOutcontractSupplementaryAgreementList){
				if(StringUtils.isNotBlank(agreementEntity.getThisChange())&&"1".equals(agreementEntity.getThisChange())&&agreementEntity.getChangeAmount()!=null
						&& !(StringUtils.isNotBlank(agreementEntity.getRowState()) && "del".equals(agreementEntity.getRowState()))){
					changeAmount = changeAmount.add(agreementEntity.getChangeAmount());
					if(supplementarySignTime==null){
						supplementarySignTime = entity.getSupplementarySignTime();
					}
				}
			}
		}
		entity.setSupplementarySignTime(supplementarySignTime);
		if(entity.getOldAfterChangeAmount()!=null){
			afterChangeAmount = afterChangeAmount.add(entity.getOldAfterChangeAmount()).add(changeAmount);
		}else{
			if(entity.getContractPrice()!=null){
				afterChangeAmount = afterChangeAmount.add(entity.getContractPrice()).add(changeAmount);
			}else{
				afterChangeAmount = afterChangeAmount.add(changeAmount);
			}
		}

		if("劳务分包".equals(saveOrUpdateVO.getType()) || "专业分包".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList()!=null && saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList().size()>0){
				BigDecimal subcontractTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractSubcontractTotalPriceVO item : saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractTotalAmount = subcontractTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractTotalAmount = subcontractTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractTotalAmount(subcontractTotalAmount);
			}
			if(saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList()!=null&&saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList().size()>0){
				List<ChangeOutcontractSubcontractUnitPriceVO> list = createTreeData(saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList());
				BigDecimal subcontractUnitTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractSubcontractUnitPriceVO item : list){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractUnitTotalAmount = subcontractUnitTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractUnitTotalAmount(subcontractUnitTotalAmount);
			}
			if(entity.getSubcontractTotalAmount()!=null&&entity.getSubcontractUnitTotalAmount()!=null){
				entity.setSubcontractTotalAmount(entity.getSubcontractTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				entity.setSubcontractUnitTotalAmount(entity.getSubcontractUnitTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				if(entity.getSubcontractTotalAmount().compareTo(entity.getSubcontractUnitTotalAmount())!=0){
					logger.info("分包工程总价汇总表合计金额-------------"+entity.getSubcontractTotalAmount());
					logger.info("分包工程综合单价计价表合计金额-------------"+entity.getSubcontractUnitTotalAmount());
					throw new BusinessException("分包工程总价汇总表合计金额("+entity.getSubcontractTotalAmount()+")与分包工程综合单价计价表合计金额("+entity.getSubcontractUnitTotalAmount()+")不一致，请修改后再保存");
				}
			}
		}else if("物资采购".equals(saveOrUpdateVO.getType()) || "周转材租赁".equals(saveOrUpdateVO.getType())
				|| "其它合同".equals(saveOrUpdateVO.getType()) || "课题支出类合同".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getChangeOutcontractMaterialList()!=null&&saveOrUpdateVO.getChangeOutcontractMaterialList().size()>0){
				BigDecimal contractPriceTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractMaterialVO item : saveOrUpdateVO.getChangeOutcontractMaterialList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						contractPriceTotalAmount = contractPriceTotalAmount.add(item.getTotalPrice());
					}
				}
				entity.setContractPriceTotalAmount(contractPriceTotalAmount);
			}
		}else if("机械租赁".equals(saveOrUpdateVO.getType())){
			BigDecimal leaseItemTotalAmount = new BigDecimal(0);
			BigDecimal rentTotalAmount = new BigDecimal(0);
			BigDecimal contractPrice = new BigDecimal(0);
			if(saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList()!=null&&saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList().size()>0){
				for(ChangeOutcontractEquipmentLeaseItemVO item : saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						leaseItemTotalAmount = leaseItemTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			if(saveOrUpdateVO.getChangeOutcontractEquipmentRentList()!=null&&saveOrUpdateVO.getChangeOutcontractEquipmentRentList().size()>0){
				for(ChangeOutcontractEquipmentRentVO item : saveOrUpdateVO.getChangeOutcontractEquipmentRentList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						rentTotalAmount = rentTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			entity.setLeaseItemTotalAmount(leaseItemTotalAmount);
			entity.setRentTotalAmount(rentTotalAmount);
		}
		entity.setChangeAmount(changeAmount);
		entity.setAfterChangeAmount(afterChangeAmount);
		this.saveOrUpdate(entity, false);
    	
		/*if(("劳务分包".equals(entity.getType())||"专业分包".equals(entity.getType()))&&!exitBill){
	    	//同步合同评审信息(新增时同步)
	    	ChangeOutcontractReviewEntity changeReviewEntity = new ChangeOutcontractReviewEntity();
	    	QueryWrapper<OutcontractReviewEntity> ReviewWrapper = new QueryWrapper<>();
	    	ReviewWrapper.eq("outcontract_id", entity.getOutcontractId());
	    	ReviewWrapper.eq("dr", 0);
	    	List<OutcontractReviewEntity> entitys = outcontractReviewservice.list(ReviewWrapper);
	    	if(entitys!=null&&entitys.size()>0){
	    		changeReviewEntity = BeanMapper.map(entitys.get(0), ChangeOutcontractReviewEntity.class);
	    		changeReviewEntity.setChangeOutcontractId(entity.getId());//默认和合同评审id一致
	        	changeReviewEntity.setCreateTime(null);
	        	changeReviewEntity.setCreateUserCode(null);
	        	changeReviewEntity.setTenantId(null);
	        	changeReviewEntity.setUpdateTime(null);
	        	changeReviewEntity.setUpdateUserCode(null);
	        	changeReviewEntity.setId(entity.getId());//默认和合同评审id一致
	        	changeOutcontractReviewService.saveOrUpdate(changeReviewEntity, false);
	    	}
		}*/
    	ChangeOutcontractVO vo = BeanMapper.map(entity, ChangeOutcontractVO.class);
    	vo.setChangeOutcontractSupplierList(saveOrUpdateVO.getChangeOutcontractSupplierList());
    	vo.setRecordOutcontractList(saveOrUpdateVO.getRecordOutcontractList());
    	if(vo.getChangeOutcontractSubcontractUnitPriceList()!=null&&vo.getChangeOutcontractSubcontractUnitPriceList().size()>0){
    		vo.setChangeOutcontractSubcontractUnitPriceList(createTreeData(vo.getChangeOutcontractSubcontractUnitPriceList()));
    	}
    	if(!exitBill){
        	//查询当前合同信息，将状态改为变更中
        	OutcontractEntity contractEntity = outcontractService.selectById(vo.getOutcontractId());
        	contractEntity.setChangeState("2");//状态改为变更中
        	contractEntity.setChangeId(vo.getId());
        	outcontractService.saveOrUpdate(contractEntity, false);
    	}
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}

	public static List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
		List<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(ChangeOutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ChangeOutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	ChangeOutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ChangeOutcontractSubcontractUnitPriceVO> child = (List<ChangeOutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

	@Override
	public CommonResponse<String> delete(List<ChangeOutcontractVO> vos) {
        for(ChangeOutcontractVO vo : vos){
        	ChangeOutcontractEntity entity = this.getById(vo.getId());
        	OutcontractEntity contractEntity = outcontractService.selectById(entity.getOutcontractId());
    		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("outcontract_id", contractEntity.getId());
        	List<RecordOutcontractEntity> records = outcontractRecordService.list(queryWrapper);
        	if(records!=null&&records.size()>0){
        		contractEntity.setChangeState("3");//状态改为已变更
        	}else{
        		contractEntity.setChangeState("1");//状态改为未变更
        	}
        	contractEntity.setChangeId(null);
        	outcontractService.saveOrUpdate(contractEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
//        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
//        	changeOutcontractReviewService.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
//        }
		
        return CommonResponse.success("删除成功！");
	}
}
