package com.ejianc.foundation.bidWinDisclosure.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bidWinDisclosure.bean.BidWinDisclosureEntity;
import com.ejianc.foundation.bidWinDisclosure.bean.BidWinDisclosureExtend1Entity;
import com.ejianc.foundation.bidWinDisclosure.service.IBidWinDisclosureExtend1Service;
import com.ejianc.foundation.bidWinDisclosure.service.IBidWinDisclosureService;
import com.ejianc.foundation.bidWinDisclosure.vo.BidWinDisclosureVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 中标交底
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("bidWinDisclosure")
public class BidWinDisclosureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

	@Autowired
	private IBpmApi bpmApi;

    private static final String BILL_CODE = "ZJKJ-BIDWINDISCLOSURE";//此处需要根据实际修改

    @Autowired
    private IBidWinDisclosureService service;

    @Autowired
    private IBidWinDisclosureExtend1Service extend1Service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BidWinDisclosureVO> saveOrUpdate(@RequestBody BidWinDisclosureVO saveOrUpdateVO) {
    	BidWinDisclosureEntity entity = BeanMapper.map(saveOrUpdateVO, BidWinDisclosureEntity.class);
        boolean add = false;
    	if(entity.getId() == null || entity.getId() == 0){
            add = true;
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
        BidWinDisclosureExtend1Entity extend1Entity = BeanMapper.map(saveOrUpdateVO, BidWinDisclosureExtend1Entity.class);
        if(add){
            extend1Entity.setId(entity.getId());
            extend1Entity.setBidWinDisclosureId(entity.getId());
        }else{
            BidWinDisclosureExtend1Entity old1Data = extend1Service.getById(entity.getId());
            if(old1Data!=null){
                extend1Entity.setId(old1Data.getId());
                extend1Entity.setBidWinDisclosureId(old1Data.getId());
                extend1Entity.setCreateTime(old1Data.getCreateTime());
                extend1Entity.setCreateUserCode(old1Data.getCreateUserCode());
                extend1Entity.setUpdateTime(old1Data.getUpdateTime());
                extend1Entity.setUpdateUserCode(old1Data.getUpdateUserCode());
                extend1Entity.setVersion(old1Data.getVersion());
                extend1Entity.setTenantId(old1Data.getTenantId());
            }else{
                //没查到数据则新增
                extend1Entity.setId(entity.getId());
                extend1Entity.setBidWinDisclosureId(entity.getId());
            }

        }
        extend1Service.saveOrUpdate(extend1Entity, false);
        BidWinDisclosureVO vo = BeanMapper.map(entity, BidWinDisclosureVO.class);
        BeanUtils.copyProperties(extend1Entity, vo);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BidWinDisclosureVO> queryDetail(Long id) {
    	BidWinDisclosureEntity entity = service.selectById(id);
        BidWinDisclosureExtend1Entity extend1Entity = extend1Service.selectById(id);
        BidWinDisclosureVO vo = BeanMapper.map(entity, BidWinDisclosureVO.class);
        BeanUtils.copyProperties(extend1Entity, vo);
        vo.setVersion(entity.getVersion());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidWinDisclosureVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BidWinDisclosureVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BidWinDisclosureVO::getId).collect(Collectors.toList()),true);
        extend1Service.removeByIds(vos.stream().map(BidWinDisclosureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BidWinDisclosureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("confidant");
        fuzzyFields.add("receiver");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BidWinDisclosureEntity> page = service.queryPage(param,false);
        IPage<BidWinDisclosureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidWinDisclosureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("confidant");
        fuzzyFields.add("receiver");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BidWinDisclosureEntity> list = service.queryList(param);
        List<BidWinDisclosureVO> bidWinDisclosureVOList = BeanMapper.mapList(list, BidWinDisclosureVO.class);
        bidWinDisclosureVOList.forEach(e->{
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", bidWinDisclosureVOList);
        ExcelExport.getInstance().export("bidWinDisclosure-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/selectBidWinDisclosureByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse selectBidWinDisclosureByProjectId(@RequestParam(value = "id",required = false)Long id,@RequestParam("projectId")Long projectId){
        LambdaQueryWrapper<BidWinDisclosureEntity> wrapper = new LambdaQueryWrapper<>();
        if (id!=null){
            wrapper.ne(BidWinDisclosureEntity::getId,id);
        }
        wrapper.eq(BidWinDisclosureEntity::getProjectId,projectId);
        wrapper.eq(BidWinDisclosureEntity::getDr,0);
        List<BidWinDisclosureEntity> list = service.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("一个项目只能对应一次中标交底");
        }else{
            return CommonResponse.success();
        }
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/cardExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void cardExcelExport(@RequestBody Long id, HttpServletResponse response) {
    	BidWinDisclosureEntity entity = service.selectById(id);
        BidWinDisclosureExtend1Entity extend1Entity = extend1Service.selectById(id);
        BidWinDisclosureVO vo = BeanMapper.map(entity, BidWinDisclosureVO.class);
        BeanUtils.copyProperties(extend1Entity, vo);
    	if(vo.getConfessDate()!=null){
    		vo.setConfessDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getConfessDate()));
    	}
        Map<String, Object> beans = new HashMap<>();
        beans.put("data", vo);
        ExcelExport.getInstance().export("bidWinDisclosure-cardexport.xlsx", beans, response);
    }

    /**
     * 通用打印数据获取
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/printDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> printDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "billType") String billType,
                                                  @RequestParam(value = "allApprove", required = false) Boolean allApprove) {
    	JSONObject printData = new JSONObject();
    	JSONObject voJson = new JSONObject();
    	BidWinDisclosureEntity entity = service.selectById(id);
        BidWinDisclosureExtend1Entity extend1Entity = extend1Service.selectById(id);
        BidWinDisclosureVO vo = BeanMapper.map(entity, BidWinDisclosureVO.class);
        BeanUtils.copyProperties(extend1Entity, vo);
    	voJson = BeanMapper.map(vo, JSONObject.class);

        //处理审批状态
		if(vo.getBillState()!=null&&vo.getBillState()!=0
				&&vo.getBillState()!=1&&vo.getBillState()!=4){
			//自由态，直接提交，审批不通过---不查询审批历史
            CommonResponse<List<BpmApproveHistoryInfo>> approveList = new CommonResponse<>();
            if(allApprove!=null && allApprove){
                approveList = bpmApi.queryAllHistoryByBillId(id);
            }else{
                approveList = bpmApi.queryHistoryById(id);
            }
			voJson.put("ApproveInfo", approveList.getData());
		}else{
			voJson.put("ApproveInfo", new ArrayList<>());
		}
		
    	printData.put("BidWinDisclosure", voJson);
        return CommonResponse.success(printData);
	}
}
