package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.ejianc.foundation.outcontract.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractFileUpdate")
public class OutcontractFileUpdateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractService service;

    /**
     * @Description wps回掉方法，回写附件id
     */
    @RequestMapping(value = "/updateFileInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
    	JSONObject back = new JSONObject();
    	OutcontractEntity entity = service.selectById(updateData.getLong("billId"));
    	entity.setFileId(updateData.getLong("fileId"));
    	service.saveOrUpdate(entity, false);
    	back.put("message", "合同文件信息更新成功");
    	back.put("billData", entity);
		return CommonResponse.success("合同文件信息更新成功",back);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/getBillDataJson", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutcontractVO> getBillDataJson(Long id) {
        OutcontractEntity entity = service.selectById(id);
        OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);

        List<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<>();
        OutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, OutcontractSupplierVO.class);
        outcontractSupplierVO.setRowState("add");
        outcontractSupplierList.add(outcontractSupplierVO);
        vo.setOutcontractSupplierList(outcontractSupplierList);

        // 分包工程总价汇总表
        OutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new OutcontractSubcontractTotalPriceVO();
        outcontractSubcontractTotalPriceVO.setId(11111l);
        outcontractSubcontractTotalPriceVO.setItemName("合计");
        outcontractSubcontractTotalPriceVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractSubcontractTotalPriceList().add(outcontractSubcontractTotalPriceVO);
        // 分包工程综合单价计价表
        OutcontractSubcontractUnitPriceVO outcontractSubcontractUnitPriceVO = new OutcontractSubcontractUnitPriceVO();
        outcontractSubcontractUnitPriceVO.setId(22222l);
        outcontractSubcontractUnitPriceVO.setListCode("合计");
        outcontractSubcontractUnitPriceVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractSubcontractUnitPriceList().add(outcontractSubcontractUnitPriceVO);
        // 物资（周转材）合同价
        OutcontractMaterialVO outcontractMaterialVO = new OutcontractMaterialVO();
        outcontractMaterialVO.setId(33333l);
        outcontractMaterialVO.setMaterialCode("合计");
        outcontractMaterialVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractMaterialList().add(outcontractMaterialVO);
        // 租赁物进出场费明细表
        OutcontractEquipmentLeaseItemVO outcontractEquipmentLeaseItemVO = new OutcontractEquipmentLeaseItemVO();
        outcontractEquipmentLeaseItemVO.setId(44444l);
        outcontractEquipmentLeaseItemVO.setEquipmentCode("合计");
        outcontractEquipmentLeaseItemVO.setTotalPrice(vo.getLeaseItemTotalAmount());
        vo.getOutcontractEquipmentLeaseItemList().add(outcontractEquipmentLeaseItemVO);
        // 租金明细表
        OutcontractEquipmentRentVO outcontractEquipmentRentVO = new OutcontractEquipmentRentVO();
        outcontractEquipmentRentVO.setId(55555l);
        outcontractEquipmentRentVO.setEquipmentCode("合计");
        outcontractEquipmentRentVO.setTotalPrice(vo.getRentTotalAmount());
        vo.getOutcontractEquipmentRentList().add(outcontractEquipmentRentVO);

        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
