package com.ejianc.foundation.outcontract.controller.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.service.IOutcontractMaterialService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/outcontract")
public class OutcontractApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOutcontractService service;

    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;

    @Autowired
    private IOutcontractMaterialService outcontractMaterialService;

    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;

    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description 根据合同id及清单编码查询清单详情
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryListBycontractIdAndCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutcontractSubcontractUnitPriceVO>> queryListBycontractIdAndCode(@RequestParam(value = "contractId") Long contractId, @RequestParam(value = "listCode") String listCode) {
    	QueryWrapper<OutcontractSubcontractUnitPriceEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("outcontract_id", contractId);
    	queryWrapper.eq("list_code", listCode);
    	queryWrapper.eq("dr", 0);
		List<OutcontractSubcontractUnitPriceEntity> list = outcontractSubcontractUnitPriceService.list(queryWrapper);
		List<OutcontractSubcontractUnitPriceVO> result = new ArrayList<>();
		if(list!=null&&list.size()>0){
			result = BeanMapper.mapList(list, OutcontractSubcontractUnitPriceVO.class);
		}
        return CommonResponse.success("查询数据成功！",result);
    }

    /**
     * 根据合同id及清单编码查询清单详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<OutcontractVO> queryDetail(@RequestParam(value = "id") Long id){
        OutcontractEntity entity = service.selectById(id);
        OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
        return CommonResponse.success("查询数据成功！",vo);
    }
}
