package com.ejianc.foundation.report.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.vo.OutcontractReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 报表分析表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractReport")
public class OutcontractReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractReportService service;


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutcontractReportVO>> queryList(@RequestParam String reportTime,@RequestParam String reportType) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("reportTime", new Parameter(QueryParam.EQ, reportTime));
        param.getParams().put("reportType", new Parameter(QueryParam.EQ, reportType));
        List<OutcontractReportVO> back = new ArrayList<>();
        List<OutcontractReportEntity> list = service.queryList(param,false);
        if(list!=null&&list.size()>0){
            back = BeanMapper.mapList(list, OutcontractReportVO.class);
        }
        return CommonResponse.success("查询列表数据成功！",back);
    }

    //
    /**
     * @Description 自动任务执行--每月1号00：00：00执行，保存当前数据快照
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveSnapshotData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return service.saveSnapshotData();
    }
}
