package com.ejianc.foundation.report.service.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportOrgMapper;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportProjectMapper;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportProjectEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryByProjectService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryReportProjectService;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryReportVO;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 区域公司-供方合同签约统计汇总表--项目维度
 *
 * @author generator
 */
@Service("outcontractSignSummaryByProjectService")
public class OutcontractSignSummaryByProjectServiceImpl implements IOutcontractSignSummaryByProjectService {
    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final static String ESSignSummaryProject = "ejc_zjkj_outcontract_sign_summary_project";

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private IOutcontractSignSummaryReportProjectService outcontractSignSummaryReportProjectService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private OutcontractMapper contractMapper;
    @Autowired
    private OutcontractSignSummaryReportProjectMapper peportOrgMapper;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        //1、生成关系表
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("区域公司-供方合同签约统计汇总表");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        outcontractReportService.saveOrUpdate(reportEntity, false);
        //获取当前合同数据
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
//        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
//        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        SimpleDateFormat format3 = new SimpleDateFormat("YYYY");
//        String curDate3 = format3.format(new Date());
//        queryParam.getParams().put("signDate", new Parameter(QueryParam.GT, curDate3));
        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }
//        queryParam.getParams().put("type", new Parameter(QueryParam.NE, "课题支出类合同"));
//        if(noExitProjectName!=null && noExitProjectName.size() > 0){
//            queryParam.getParams().put("projectName", new Parameter(QueryParam.NOT_IN, noExitProjectName));
//        }
//        List<OutcontractEntity> list = outcontractService.queryList(queryParam);

        List<RecordOutcontractVO> list = queryList(queryParam, null, noExitProjectName);
        List<Long> projectIds = new ArrayList<>();
        List<OutcontractSignSummaryReportProjectEntity> entityList = new ArrayList<>();

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<Long,String> signDateMap = new HashMap<>();
        for (RecordOutcontractVO entity : list) {
        	if(entity.getSignDate()!=null){
        		if(signDateMap.get(entity.getProjectId())!=null){
            		String signDate = signDateMap.get(entity.getProjectId());
            		signDate += (","+dateFormat.format(entity.getSignDate()));
            		signDateMap.put(entity.getProjectId(), signDate);
            	}else{
            		signDateMap.put(entity.getProjectId(), dateFormat.format(entity.getSignDate()));
            	}
        	}
        }

        BulkRequest bulkRequest = new BulkRequest();
        for (RecordOutcontractVO entity : list) {
            try {
                if(!projectIds.contains(entity.getProjectId())){
                	if(entity.getProjectId()!=null){
                		projectIds.add(entity.getProjectId());
                    	OutcontractSignSummaryReportProjectEntity e = new OutcontractSignSummaryReportProjectEntity();
                    	e.setReportId(reportId);
                    	e.setOrgId(entity.getOrgId());
                    	e.setProjectDepartmentId(entity.getProjectDepartmentId());
                    	e.setProjectId(entity.getProjectId());
                    	e.setTenantId(entity.getTenantId());
                    	e.setCreateTime(e.getCreateTime());
                    	e.setSignDate(signDateMap.get(entity.getProjectId()));
    					entityList.add(e);
                	}
                }
                OutcontractSignSummaryVO outcontractSignSummaryVO = BeanMapper.map(entity, OutcontractSignSummaryVO.class);
                Map<String, Object> dataMap = BeanMapper.map(outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummaryProject);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成区域公司-供方合同签约统计汇总表数据异常，", e);
                throw new BusinessException("生成区域公司-供方合同签约统计汇总表数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if(entityList!=null&&entityList.size()>0){
            	outcontractSignSummaryReportProjectService.saveOrUpdateBatch(entityList, entityList.size(), false);
            }
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成区域公司-供方合同签约统计汇总表执行 完事 *********** ");
        return CommonResponse.success("生成区域公司-供方合同签约统计汇总表成功");
    }

    @Override
    public CommonResponse<String> addESData(String curDate, String signDate) {
        //1、生成关系表
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName("区域公司-供方合同签约统计汇总表（自动）"+curDate);
        reportEntity.setReportType("区域公司-供方合同签约统计汇总表");
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        outcontractReportService.saveOrUpdate(reportEntity, false);
        //获取当前合同数据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("signDate", new Parameter(QueryParam.EQ, signDate));
        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }
        List<RecordOutcontractVO> list = queryList(queryParam, null, noExitProjectName);
        List<Long> projectIds = new ArrayList<>();
        List<OutcontractSignSummaryReportProjectEntity> entityList = new ArrayList<>();

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<Long,String> signDateMap = new HashMap<>();
        for (RecordOutcontractVO entity : list) {
            if(entity.getSignDate()!=null){
                if(signDateMap.get(entity.getProjectId())!=null){
                    String signDat = signDateMap.get(entity.getProjectId());
                    signDat += (","+dateFormat.format(entity.getSignDate()));
                    signDateMap.put(entity.getProjectId(), signDat);
                }else{
                    signDateMap.put(entity.getProjectId(), dateFormat.format(entity.getSignDate()));
                }
            }
        }

        BulkRequest bulkRequest = new BulkRequest();
        for (RecordOutcontractVO entity : list) {
            try {
                if(!projectIds.contains(entity.getProjectId())){
                    if(entity.getProjectId()!=null){
                        projectIds.add(entity.getProjectId());
                        OutcontractSignSummaryReportProjectEntity e = new OutcontractSignSummaryReportProjectEntity();
                        e.setReportId(reportId);
                        e.setOrgId(entity.getOrgId());
                        e.setProjectDepartmentId(entity.getProjectDepartmentId());
                        e.setProjectId(entity.getProjectId());
                        e.setTenantId(entity.getTenantId());
                        e.setCreateTime(e.getCreateTime());
                        e.setSignDate(signDateMap.get(entity.getProjectId()));
                        entityList.add(e);
                    }
                }
                OutcontractSignSummaryVO outcontractSignSummaryVO = BeanMapper.map(entity, OutcontractSignSummaryVO.class);
                Map<String, Object> dataMap = BeanMapper.map(outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummaryProject);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成区域公司-供方合同签约统计汇总表数据异常，", e);
                throw new BusinessException("生成区域公司-供方合同签约统计汇总表数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if(entityList!=null&&entityList.size()>0){
                outcontractSignSummaryReportProjectService.saveOrUpdateBatch(entityList, entityList.size(), false);
            }
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成区域公司-供方合同签约统计汇总表执行 完事 *********** ");
        return CommonResponse.success("生成区域公司-供方合同签约统计汇总表成功");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractSignSummaryReportVO> queryPage(QueryParam param) {
        IPage<OutcontractSignSummaryReportVO> page = new Page<>();
        List<OutcontractSignSummaryReportVO> resultList = new ArrayList<>();
        Map<String, Parameter> params = param.getParams();

        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }

        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        page.setCurrent(param.getPageIndex());
        if(commonOrgIds.size()==0){
            page = new Page<>(param.getPageIndex(), param.getPageSize(), resultList.size());
            page.setRecords(resultList);
            return page;
        }
        if (params.get("range") != null && "es".equals(params.get("range").getValue().toString())) {
            params.remove("range");
            //获取es中数据
            String reportId = params.get("reportId").getValue().toString();
            try {
            	IPage<OutcontractSignSummaryReportProjectEntity> list = null;
            	if(param.getParams().get("signDate")!=null){
            		list = outcontractSignSummaryReportProjectService.queryNewPage(param,commonOrgIds,departmentIds);
            	}else{
            		QueryWrapper<OutcontractSignSummaryReportProjectEntity> queryWrapper = new QueryWrapper<>();
                	queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
                	
                    if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                        /** 要求主表有orgId字段，保存单据所属组织 */
                		queryWrapper.in("org_id", commonOrgIds);
                    } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                        /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                		queryWrapper.in("project_department_id", departmentIds);
                    }
                	
                	queryWrapper.eq("report_id", reportId);
                    IPage<OutcontractSignSummaryReportProjectEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());
                    list = outcontractSignSummaryReportProjectService.page(page1,queryWrapper );
            	}
            	
				for (OutcontractSignSummaryReportProjectEntity vo : list.getRecords()) {
                    resultList.add(this.selectProject(reportId, vo.getProjectId().toString(), param, noExitProjectName));
                }
				page.setTotal(list.getTotal());
                page.setRecords(resultList);
            } catch (Exception e) {
                throw new BusinessException("查询全部记录索引失败，MSG：", e);
            }
        } else {
            if (params.get("range") != null) {
                params.remove("range");
            }
            Map<String, Object> paramMapper = new HashMap<>();
            long startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
            paramMapper.put("startLine", startLine);
            paramMapper.put("pageIndex", param.getPageIndex());
            paramMapper.put("pageSize", param.getPageSize());
            paramMapper.put("orgIds", commonOrgIds);
            paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
            //签约日期
            if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
                String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
                String sql = "( sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
                paramMapper.put("signDate", sql);
                String sql1 = "( supplementary_sign_time  BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
                paramMapper.put("supplementarySignTime", sql1);
            }
            //查询签约日期是本年的
            if(paramMapper.get("signDate")==null){
                SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
                String curDate = format2.format(new Date());
                String sql = "( sign_date > '"+ curDate + "' )";
                paramMapper.put("signDate", sql);
                String sql1 = "( supplementary_sign_time > '"+ curDate + "' )";
                paramMapper.put("supplementarySignTime", sql1);
            }
            paramMapper.put("noExitProjectName", noExitProjectName);
            long count = peportOrgMapper.countAll(paramMapper);
            List<RecordOutcontractVO> list = new ArrayList<>();
            if(count > 0){
                list = peportOrgMapper.queryAllList(paramMapper);
                list.forEach(e -> {
                    resultList.add(this.processData(e.getProjectId(),param));
                });
            }
            page = new Page<>(param.getPageIndex(), param.getPageSize(), count);
            page.setRecords(resultList);
        }
        return page;
    }

    public List<RecordOutcontractVO> queryList(@RequestBody QueryParam param, Long projectId, List<String> noExitProjectName) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
            String sql = " order by ";
            for(String key : param.getOrderMap().keySet()){
                sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
            }
            params.put("ordersql", sql);
        }
        if(projectId!=null){
            params.put("projectId", projectId);
        }

        params.put("noProject", "noProject");
        if(noExitProjectName!=null && noExitProjectName.size()>0){
            params.put("noExitProjectName", noExitProjectName);
        }

        //签约日期
        if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
            String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            String sql = "( o.sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("signDate", sql);
            String sql1 = "( o.supplementary_sign_time  BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("supplementarySignTime", sql1);
        }
        //查询签约日期是本年的
        if(params.get("signDate")==null){
            SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
            String curDate = format2.format(new Date());
            String sql = "( o.sign_date > '"+ curDate + "' )";
            params.put("signDate", sql);
            String sql1 = "( o.supplementary_sign_time > '"+ curDate + "' )";
            params.put("supplementarySignTime", sql1);
        }
        List<Integer> billState = new ArrayList<>();
        billState.add(1);
        billState.add(3);
        params.put("billState", billState);
        List<RecordOutcontractVO> list = contractMapper.queryAllList(params);
        return list;
    }

    //查询本地数据处理
    public OutcontractSignSummaryReportVO processData(Long projectId, QueryParam param) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        vo.setPackLight(0);
        vo.setExpandSub(0);
        vo.setOtherform(0);
        vo.setLaborAndMaterials(0);
        vo.setWorkersAndAuxiliaryMaterials(0);
        vo.setOtherForms(0);

        List<RecordOutcontractVO> list = queryList(param, projectId, null);
        if (list.size() > 0) {
            vo.setProjectName(list.get(0).getProjectName());
            vo.setSumContract(list.size());//合同个数
            vo.setSumSubcontractingContent(list.size());//分包项目内容合计

            for (RecordOutcontractVO e : list) {
                if ("劳务分包".equals(e.getType())) {
                    if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                        switch (e.getLaborSubcontracteMode()) {
                            case "包轻工":
                                vo.setPackLight(vo.getPackLight() + 1);
                                break;
                            case "扩大劳务分包":
                                vo.setExpandSub(vo.getExpandSub() + 1);
                                break;
                            case "其他形式":
                                vo.setOtherform(vo.getOtherform() + 1);
                                break;
                        }
                    }
                } else if("专业分包".equals(e.getType())){
                    if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                        switch (e.getLaborSubcontracteMode()) {
                            case "包工包料":
                                vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                                break;
                            case "包清工辅材":
                                vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                                break;
                            case "其他形式":
                                vo.setOtherForms(vo.getOtherForms() + 1);
                                break;
                        }
                    }
                }
            }

            //劳务分包方式
            list.forEach(e -> {
                if ("劳务分包".equals(e.getType())) {
                    if (vo.getLabor() == null) {
                        vo.setLabor(0);
                    }
                    vo.setLabor(vo.getLabor() + 1);
                    if (vo.getSumLabor() == null) {
                        vo.setSumLabor(0);
                    }
                    vo.setSumLabor(vo.getSumLabor() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "按实体工程量对应的固定单价":
                                if (vo.getLaborPrice() == null) {
                                    vo.setLaborPrice(0);
                                }
                                vo.setLaborPrice(vo.getLaborPrice() + 1);
                                break;
                            case "按建筑面积平米的每平米固定单价":
                                if (vo.getLaborArea() == null) {
                                    vo.setLaborArea(0);
                                }
                                vo.setLaborArea(vo.getLaborArea() + 1);
                                break;
                            case "固定单价":
                                if (vo.getLaborFixedPrice() == null) {
                                    vo.setLaborFixedPrice(0);
                                }
                                vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                break;
                            case "固定总价":
                                if (vo.getLaborTotalPrice() == null) {
                                    vo.setLaborTotalPrice(0);
                                }
                                vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                break;
                            case "定额计价":
                                if (vo.getLaborQuotaValuation() == null) {
                                    vo.setLaborQuotaValuation(0);
                                }
                                vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                                break;
                        }
                    }
                }
                if ("专业分包".equals(e.getType())) {
                    if (vo.getMajor() == null) {
                        vo.setMajor(0);
                    }
                    vo.setMajor(vo.getMajor() + 1);
                    if (vo.getSumMajor() == null) {
                        vo.setSumMajor(0);
                    }
                    vo.setSumMajor(vo.getSumMajor() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "按实体工程量对应的固定单价":
                                if (vo.getMajorPrice() == null) {
                                    vo.setMajorPrice(0);
                                }
                                vo.setMajorPrice(vo.getMajorPrice() + 1);
                                break;
                            case "按承包合同价款让利费率下浮":
                                if (vo.getRateLower() == null) {
                                    vo.setRateLower(0);
                                }
                                vo.setRateLower(vo.getRateLower() + 1);
                                break;
                            case "固定总价":
                                if (vo.getMajorTotalPrice() == null) {
                                    vo.setMajorTotalPrice(0);
                                }
                                vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                break;
                            case "定额计价":
                                if (vo.getMajorQuotaValuation() == null) {
                                    vo.setMajorQuotaValuation(0);
                                }
                                vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                                break;
                        }
                    }
                }
                if ("物资采购".equals(e.getType())) {
                    if (vo.getMaterial() == null) {
                        vo.setMaterial(0);
                    }
                    vo.setMaterial(vo.getMaterial() + 1);
                    if (vo.getSumMaterial() == null) {
                        vo.setSumMaterial(0);
                    }
                    vo.setSumMaterial(vo.getSumMaterial() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getMaterialFixedPrice() == null) {
                                    vo.setMaterialFixedPrice(0);
                                }
                                vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                break;
                            case "可调价格":
                                if (vo.getAdjustablePrice() == null) {
                                    vo.setAdjustablePrice(0);
                                }
                                vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                                break;
                        }
                    }
                }
                if ("机械租赁".equals(e.getType())) {
                    if (vo.getEquipment() == null) {
                        vo.setEquipment(0);
                    }
                    vo.setEquipment(vo.getEquipment() + 1);
                    if (vo.getSumEquipment() == null) {
                        vo.setSumEquipment(0);
                    }
                    vo.setSumEquipment(vo.getSumEquipment() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getEquipmentFixedPrice() == null) {
                                    vo.setEquipmentFixedPrice(0);
                                }
                                vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getEquipmentOther() == null) {
                                    vo.setEquipmentOther(0);
                                }
                                vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                                break;
                        }
                    }
                }
                if ("周转材租赁".equals(e.getType())) {
                    if (vo.getTurnoverMaterial() == null) {
                        vo.setTurnoverMaterial(0);
                    }
                    vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                    if (vo.getSumTurnoverMaterial() == null) {
                        vo.setSumTurnoverMaterial(0);
                    }
                    vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getTurnoverMaterialFixedPrice() == null) {
                                    vo.setTurnoverMaterialFixedPrice(0);
                                }
                                vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getTurnoverMaterialOther() == null) {
                                    vo.setTurnoverMaterialOther(0);
                                }
                                vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                                break;
                        }
                    }
                }
                if ("设计勘察".equals(e.getType())) {
                    if (vo.getDesign() == null) {
                        vo.setDesign(0);
                    }
                    vo.setDesign(vo.getDesign() + 1);
                    if (vo.getSumDesign() == null) {
                        vo.setSumDesign(0);
                    }
                    vo.setSumDesign(vo.getSumDesign() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定总价":
                                if (vo.getDesignTotalPrice() == null) {
                                    vo.setDesignTotalPrice(0);
                                }
                                vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                break;
                            case "固定单价":
                                if (vo.getDesignFixedPrice() == null) {
                                    vo.setDesignFixedPrice(0);
                                }
                                vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getDesignOther() == null) {
                                    vo.setDesignOther(0);
                                }
                                vo.setDesignOther(vo.getDesignOther() + 1);
                                break;
                        }
                    }
                }
                if ("咨询服务".equals(e.getType())) {
                    if (vo.getConsultancy() == null) {
                        vo.setConsultancy(0);
                    }
                    vo.setConsultancy(vo.getConsultancy() + 1);
                    if (vo.getSumConsultancy() == null) {
                        vo.setSumConsultancy(0);
                    }
                    vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getConsultancyFixedPrice() == null) {
                                    vo.setConsultancyFixedPrice(0);
                                }
                                vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getConsultancyOther() == null) {
                                    vo.setConsultancyOther(0);
                                }
                                vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                                break;
                        }
                    }
                }
                if ("其它合同".equals(e.getType())) {
                    if (vo.getOther() == null) {
                        vo.setOther(0);
                    }
                    vo.setOther(vo.getOther() + 1);
                    if (vo.getSumOther() == null) {
                        vo.setSumOther(0);
                    }
                    vo.setSumOther(vo.getSumOther() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getOtherFixedPrice() == null) {
                                    vo.setOtherFixedPrice(0);
                                }
                                vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getOther1() == null) {
                                    vo.setOther1(0);
                                }
                                vo.setOther1(vo.getOther1() + 1);
                                break;
                        }
                    }
                }
            });//合同价格形式
            if (vo.getPackLight() == null) {
                vo.setPackLight(0);
            }
            if (vo.getSmallMechanical() == null) {
                vo.setSmallMechanical(0);
            }
            if (vo.getExpandSub() == null) {
                vo.setExpandSub(0);
            }
            if (vo.getOtherform() == null) {
                vo.setOtherform(0);
            }
            Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
            Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
            vo.setSumLaborSubcontracteMode(Integer.sum(a, b));//劳务分包方式合计
        }
        return vo;
    }

    //es查询数据处理
    public OutcontractSignSummaryReportVO selectProject(String reportId, String projectId, QueryParam param, List<String> noExitProjectName) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        vo.setPackLight(0);
        vo.setExpandSub(0);
        vo.setOtherform(0);
        vo.setLaborAndMaterials(0);
        vo.setWorkersAndAuxiliaryMaterials(0);
        vo.setOtherForms(0);
        //查询es中数据
        SearchRequest searchRequest = new SearchRequest(ESSignSummaryProject);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        //查询参数
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //获取es中数据
        boolQuery.must(QueryBuilders.matchQuery("reportId", reportId));
        boolQuery.must(QueryBuilders.matchQuery("tenantId", InvocationInfoProxy.getTenantid()));
        try {
            if(param.getParams().get("signDate")!=null){
            	String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            	boolQuery.must(QueryBuilders.rangeQuery("signDate").from(signDate[0]).to(signDate[1]));
            }
            boolQuery.must(QueryBuilders.matchQuery("projectId", projectId));
            boolQuery.mustNot(QueryBuilders.matchQuery("type.keyword", "课题支出类合同"));
            if(noExitProjectName!=null && noExitProjectName.size() > 0){
                for(String name : noExitProjectName){
                    boolQuery.mustNot(QueryBuilders.matchQuery("projectName.keyword", name));
                }
            }

            sourceBuilder.query(boolQuery);
            CountRequest count = new CountRequest(ESSignSummaryProject);
            count.query(boolQuery);
            CountResponse countResponse = client.count(count, RequestOptions.DEFAULT);
            sourceBuilder.query(boolQuery);
            sourceBuilder.from(0);
            sourceBuilder.size((int) countResponse.getCount());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间
            searchRequest.source(sourceBuilder);
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            List<OutcontractSignSummaryReportVO> list = new ArrayList<>();
            for(SearchHit hit : hits){
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                OutcontractSignSummaryReportVO outcontractSignSummaryReportVO = JSON.parseObject(JSON.toJSONString(sourceAsMap), OutcontractSignSummaryReportVO.class);
                outcontractSignSummaryReportVO.setProjectId((String) sourceAsMap.get("projectId"));

                list.add(outcontractSignSummaryReportVO);
            }

            if (list.size() > 0) {
            	vo.setProjectName(list.get(0).getProjectName());
                vo.setSumContract(list.size());//合同个数
                vo.setSumSubcontractingContent(list.size());//分包项目内容合计
            }
            for (OutcontractSignSummaryReportVO e : list) {
                if ("劳务分包".equals(e.getType())) {
                    if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                        switch (e.getLaborSubcontracteMode()) {
                            case "包轻工":
                                vo.setPackLight(vo.getPackLight() + 1);
                                break;
                            case "扩大劳务分包":
                                vo.setExpandSub(vo.getExpandSub() + 1);
                                break;
                            case "其他形式":
                                vo.setOtherform(vo.getOtherform() + 1);
                                break;
                        }
                    }
                } else if("专业分包".equals(e.getType())){
                    if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                        switch (e.getLaborSubcontracteMode()) {
                            case "包工包料":
                                vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                                break;
                            case "包清工辅材":
                                vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                                break;
                            case "其他形式":
                                vo.setOtherForms(vo.getOtherForms() + 1);
                                break;
                        }
                    }
                }
            }

            //劳务分包方式
            list.forEach(e -> {
                if ("劳务分包".equals(e.getType())) {
                    if (vo.getLabor() == null) {
                        vo.setLabor(0);
                    }
                    vo.setLabor(vo.getLabor() + 1);
                    if (vo.getSumLabor() == null) {
                        vo.setSumLabor(0);
                    }
                    vo.setSumLabor(vo.getSumLabor() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "按实体工程量对应的固定单价":
                                if (vo.getLaborPrice() == null) {
                                    vo.setLaborPrice(0);
                                }
                                vo.setLaborPrice(vo.getLaborPrice() + 1);
                                break;
                            case "按建筑面积平米的每平米固定单价":
                                if (vo.getLaborArea() == null) {
                                    vo.setLaborArea(0);
                                }
                                vo.setLaborArea(vo.getLaborArea() + 1);
                                break;
                            case "固定单价":
                                if (vo.getLaborFixedPrice() == null) {
                                    vo.setLaborFixedPrice(0);
                                }
                                vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                break;
                            case "固定总价":
                                if (vo.getLaborTotalPrice() == null) {
                                    vo.setLaborTotalPrice(0);
                                }
                                vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                break;
                            case "定额计价":
                                if (vo.getLaborQuotaValuation() == null) {
                                    vo.setLaborQuotaValuation(0);
                                }
                                vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                                break;
                        }
                    }
                }
                if ("专业分包".equals(e.getType())) {
                    if (vo.getMajor() == null) {
                        vo.setMajor(0);
                    }
                    vo.setMajor(vo.getMajor() + 1);
                    if (vo.getSumMajor() == null) {
                        vo.setSumMajor(0);
                    }
                    vo.setSumMajor(vo.getSumMajor() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "按实体工程量对应的固定单价":
                                if (vo.getMajorPrice() == null) {
                                    vo.setMajorPrice(0);
                                }
                                vo.setMajorPrice(vo.getMajorPrice() + 1);
                                break;
                            case "按承包合同价款让利费率下浮":
                                if (vo.getRateLower() == null) {
                                    vo.setRateLower(0);
                                }
                                vo.setRateLower(vo.getRateLower() + 1);
                                break;
                            case "固定总价":
                                if (vo.getMajorTotalPrice() == null) {
                                    vo.setMajorTotalPrice(0);
                                }
                                vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                break;
                            case "定额计价":
                                if (vo.getMajorQuotaValuation() == null) {
                                    vo.setMajorQuotaValuation(0);
                                }
                                vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                                break;
                        }
                    }
                }
                if ("物资采购".equals(e.getType())) {
                    if (vo.getMaterial() == null) {
                        vo.setMaterial(0);
                    }
                    vo.setMaterial(vo.getMaterial() + 1);
                    if (vo.getSumMaterial() == null) {
                        vo.setSumMaterial(0);
                    }
                    vo.setSumMaterial(vo.getSumMaterial() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getMaterialFixedPrice() == null) {
                                    vo.setMaterialFixedPrice(0);
                                }
                                vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                break;
                            case "可调价格":
                                if (vo.getAdjustablePrice() == null) {
                                    vo.setAdjustablePrice(0);
                                }
                                vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                                break;
                        }
                    }
                }
                if ("机械租赁".equals(e.getType())) {
                    if (vo.getEquipment() == null) {
                        vo.setEquipment(0);
                    }
                    vo.setEquipment(vo.getEquipment() + 1);
                    if (vo.getSumEquipment() == null) {
                        vo.setSumEquipment(0);
                    }
                    vo.setSumEquipment(vo.getSumEquipment() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getEquipmentFixedPrice() == null) {
                                    vo.setEquipmentFixedPrice(0);
                                }
                                vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getEquipmentOther() == null) {
                                    vo.setEquipmentOther(0);
                                }
                                vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                                break;
                        }
                    }
                }
                if ("周转材租赁".equals(e.getType())) {
                    if (vo.getTurnoverMaterial() == null) {
                        vo.setTurnoverMaterial(0);
                    }
                    vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                    if (vo.getSumTurnoverMaterial() == null) {
                        vo.setSumTurnoverMaterial(0);
                    }
                    vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getTurnoverMaterialFixedPrice() == null) {
                                    vo.setTurnoverMaterialFixedPrice(0);
                                }
                                vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getTurnoverMaterialOther() == null) {
                                    vo.setTurnoverMaterialOther(0);
                                }
                                vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                                break;
                        }
                    }
                }
                if ("设计勘察".equals(e.getType())) {
                    if (vo.getDesign() == null) {
                        vo.setDesign(0);
                    }
                    vo.setDesign(vo.getDesign() + 1);
                    if (vo.getSumDesign() == null) {
                        vo.setSumDesign(0);
                    }
                    vo.setSumDesign(vo.getSumDesign() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定总价":
                                if (vo.getDesignTotalPrice() == null) {
                                    vo.setDesignTotalPrice(0);
                                }
                                vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                break;
                            case "固定单价":
                                if (vo.getDesignFixedPrice() == null) {
                                    vo.setDesignFixedPrice(0);
                                }
                                vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getDesignOther() == null) {
                                    vo.setDesignOther(0);
                                }
                                vo.setDesignOther(vo.getDesignOther() + 1);
                                break;
                        }
                    }
                }
                if ("咨询服务".equals(e.getType())) {
                    if (vo.getConsultancy() == null) {
                        vo.setConsultancy(0);
                    }
                    vo.setConsultancy(vo.getConsultancy() + 1);
                    if (vo.getSumConsultancy() == null) {
                        vo.setSumConsultancy(0);
                    }
                    vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getConsultancyFixedPrice() == null) {
                                    vo.setConsultancyFixedPrice(0);
                                }
                                vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getConsultancyOther() == null) {
                                    vo.setConsultancyOther(0);
                                }
                                vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                                break;
                        }
                    }
                }
                if ("其它合同".equals(e.getType())) {
                    if (vo.getOther() == null) {
                        vo.setOther(0);
                    }
                    vo.setOther(vo.getOther() + 1);
                    if (vo.getSumOther() == null) {
                        vo.setSumOther(0);
                    }
                    vo.setSumOther(vo.getSumOther() + 1);
                    if(StringUtils.isNotBlank(e.getPricingForm())) {
                        switch (e.getPricingForm()) {
                            case "固定单价":
                                if (vo.getOtherFixedPrice() == null) {
                                    vo.setOtherFixedPrice(0);
                                }
                                vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                break;
                            case "其它":
                                if (vo.getOther1() == null) {
                                    vo.setOther1(0);
                                }
                                vo.setOther1(vo.getOther1() + 1);
                                break;
                        }
                    }
                }
            });//合同价格形式
            if (vo.getPackLight() == null) {
                vo.setPackLight(0);
            }
            if (vo.getSmallMechanical() == null) {
                vo.setSmallMechanical(0);
            }
            if (vo.getExpandSub() == null) {
                vo.setExpandSub(0);
            }
            if (vo.getOtherform() == null) {
                vo.setOtherform(0);
            }
            Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
            Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
            vo.setSumLaborSubcontracteMode(Integer.sum(a, b));//劳务分包方式合计
        } catch (Exception e) {
            throw new BusinessException("查询全部记录索引失败，MSG：", e);
        }
        return vo;
    }
}
