package com.ejianc.foundation.report.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportOrgEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportProjectEntity;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportOrgMapper;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportProjectMapper;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryReportOrgService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 
 *
 * @author generator
 *
 */
@Service("outcontractSignSummaryReportOrgService")
public class OutcontractSignSummaryReportOrgServiceImpl extends BaseServiceImpl<OutcontractSignSummaryReportOrgMapper, OutcontractSignSummaryReportOrgEntity> implements IOutcontractSignSummaryReportOrgService{

    @Autowired
    private OutcontractSignSummaryReportOrgMapper orgMapper;
    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public IPage<OutcontractSignSummaryReportOrgEntity> queryNewPage(QueryParam param, List<Long> commonOrgIds) {
		IPage<OutcontractSignSummaryReportOrgEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Map<String, Parameter> params = param.getParams();
        String reportId = params.get("reportId").getValue().toString();
        Map<String,Object> paramMapper = new HashMap<>();
        paramMapper.put("reportId", reportId);
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
		Integer pn = param.getPageIndex();
		pn = pn - 1 < 0 ? 1 : pn;
        long startLine = (pn - 1) * param.getPageSize();
        paramMapper.put("startLine", startLine);
        paramMapper.put("pageSize", param.getPageSize());
        paramMapper.put("commonOrgIds", commonOrgIds);
        if(param.getParams().get("signDate")!=null){
        	String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            paramMapper.put("startSignDate", signDate[0]);
            paramMapper.put("endSignDate", signDate[1]);
        }
        List<OutcontractSignSummaryReportOrgEntity> list = orgMapper.queryNewPage(paramMapper);
        long total = orgMapper.count(paramMapper);
        page.setTotal(total);
        page.setRecords(list);
		return page;
	}
}

