package com.ejianc.foundation.report.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.report.service.IOutcontractSignStatisticService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供方合同签约情况统计
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractSignStatistic")
public class OutcontractSignStatisticController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractSignStatisticService service;

    /**
     * @Description addESData 手动保存当前的数据到es
     */
    @RequestMapping(value = "/addESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addESData(@RequestParam String curDate, @RequestParam String signDate) {
        return service.addESData(curDate, signDate);
    }

    /**
     * @Description saveOrUpdate 手动保存当前的数据到es
     */
    @RequestMapping(value = "/saveESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveESData() {
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return service.saveESData("供方合同签约情况统计（手动）"+curDate);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<OutcontractVO> pageData = service.queryPage(param);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        List<OutcontractVO> list = service.queryPage(param).getRecords();

        for(OutcontractVO vo : list){
            if(vo.getSignDate()!=null){
                vo.setSignDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSignDate()));
            }
            if(vo.getMobilizationDate()!=null){
                vo.setMobilizationDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getMobilizationDate()));
            }
            if(vo.getExitDate()!=null){
                vo.setExitDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getExitDate()));
            }
            if(StringUtils.isNotBlank(vo.getProjectStatus())){
                switch (vo.getProjectStatus()){
                    case "1":
                        vo.setProjectStatus("未开工");
                        break;
                    case "2":
                        vo.setProjectStatus("在建");
                        break;
                    case "3":
                        vo.setProjectStatus("完工");
                        break;
                    case "4":
                        vo.setProjectStatus("停缓建");
                        break;
                    case "5":
                        vo.setProjectStatus("竣工未结算");
                        break;
                    case "6":
                        vo.setProjectStatus("竣工已结算");
                        break;
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutcontractReport-export.xlsx", beans, response);
    }

}
