/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignStatisticService;
import com.ejianc.foundation.report.vo.OutcontractSignStatisticVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontractSignStatisticService")
public class OutcontractSignStatisticServiceImpl
implements IOutcontractSignStatisticService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ESSignStatistic = "ejc_zjkj_outcontract_sign_statistic";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        this.outcontractReportService.saveOrUpdate((Object)reportEntity, false);
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(-1);
        IPage<RecordOutcontractVO> pageData = this.queryRecordOutcontractList(queryParam, null);
        BulkRequest bulkRequest = new BulkRequest();
        for (RecordOutcontractVO entity : pageData.getRecords()) {
            try {
                OutcontractSignStatisticVO outcontractSignStatisticVO = (OutcontractSignStatisticVO)BeanMapper.map((Object)entity, OutcontractSignStatisticVO.class);
                Map dataMap = (Map)BeanMapper.map((Object)outcontractSignStatisticVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6210\u529f");
    }

    @Override
    public CommonResponse<String> addESData(String curDate, String signDate) {
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName("\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\uff08\u81ea\u52a8\uff09" + curDate);
        reportEntity.setReportType("\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1");
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        this.outcontractReportService.saveOrUpdate((Object)reportEntity, false);
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(-1);
        queryParam.getParams().put("signDate", new Parameter("eq", (Object)signDate));
        IPage<RecordOutcontractVO> pageData = this.queryRecordOutcontractList(queryParam, null);
        BulkRequest bulkRequest = new BulkRequest();
        for (RecordOutcontractVO entity : pageData.getRecords()) {
            try {
                OutcontractSignStatisticVO outcontractSignStatisticVO = (OutcontractSignStatisticVO)BeanMapper.map((Object)entity, OutcontractSignStatisticVO.class);
                Map dataMap = (Map)BeanMapper.map((Object)outcontractSignStatisticVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u60c5\u51b5\u7edf\u8ba1\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractVO> queryPage(QueryParam param) {
        Page page = new Page();
        List<Object> resultList = new ArrayList();
        Map params = param.getParams();
        CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("pl_project");
        ArrayList<String> noExitProjectName = new ArrayList<String>();
        if (defdocResponse.isSuccess() && ((List)defdocResponse.getData()).size() > 0) {
            ((List)defdocResponse.getData()).forEach(item -> noExitProjectName.add(item.getName()));
        }
        if (params.get("range") != null && "es".equals(((Parameter)param.getParams().get("range")).getValue().toString())) {
            param.getParams().remove("range");
            SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            String reportId = ((Parameter)params.get("reportId")).getValue().toString();
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"reportId.keyword", (Object)reportId));
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"tenantId.keyword", (Object)InvocationInfoProxy.getTenantid()));
            boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"type.keyword", (Object)"\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c"));
            if (noExitProjectName != null && noExitProjectName.size() > 0) {
                for (String name : noExitProjectName) {
                    boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                }
            }
            try {
                List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                ArrayList commonOrgIds = new ArrayList();
                ArrayList departmentIds = new ArrayList();
                orgVOList.stream().forEach(org -> {
                    if (5 == org.getOrgType()) {
                        departmentIds.add(org.getId());
                    } else {
                        commonOrgIds.add(org.getId());
                    }
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", commonOrgIds));
                } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectDepartmentId", departmentIds));
                }
                if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
                    BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"billCode", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"contractName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"projectName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"signUnitName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"buildUnitName", (Object)param.getSearchText()));
                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"pricingForm", (Object)param.getSearchText()));
                    boolQuery.must((QueryBuilder)shouldBuilder);
                }
                for (String key : params.keySet()) {
                    Object shouldBuilder;
                    if ("range".equals(key) || "reportId".equals(key)) continue;
                    if (params != null && "projectStatus".equals(key)) {
                        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectStatus", (Object[])new Object[]{((Parameter)params.get("projectStatus")).getValue()}));
                        continue;
                    }
                    if (params != null && "advanceCharge".equals(key)) {
                        if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)params.get("advanceCharge")).getValue())) {
                            boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)"advanceCharge"));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0"}));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0.00"}));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"/"}));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"\u7a7a"}));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"\u65e0"}));
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0%"}));
                            continue;
                        }
                        BoolQueryBuilder shouldBuilder2 = QueryBuilders.boolQuery();
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.existsQuery((String)"advanceCharge"));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0"}));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0.00"}));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"/"}));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"\u7a7a"}));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"\u65e0"}));
                        shouldBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"advanceCharge", (String[])new String[]{"0%"}));
                        boolQuery.must((QueryBuilder)shouldBuilder2);
                        continue;
                    }
                    if (param.getParams() != null) {
                        String progressPaymentTerms;
                        if (param.getParams().get("progressPaymentTerms") != null && param.getParams().get("paymentTerms") != null) {
                            progressPaymentTerms = ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString();
                            String paymentTerms = ((Parameter)param.getParams().get("paymentTerms")).getValue().toString();
                            if ("\u6708\u5ea6\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                                if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").lt((Object)70));
                                    continue;
                                }
                                if ("70-75".equals(paymentTerms)) {
                                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)70).lt((Object)75));
                                    continue;
                                }
                                if ("75-80".equals(paymentTerms)) {
                                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)75).lt((Object)80));
                                    continue;
                                }
                                if ("80\u4ee5\u4e0a".equals(paymentTerms)) {
                                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)80));
                                    continue;
                                }
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gt((Object)0));
                                continue;
                            }
                            if (!"\u8282\u70b9\u4ed8\u6b3e".equals(progressPaymentTerms)) continue;
                            if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").lt((Object)70));
                                continue;
                            }
                            if ("70-75".equals(paymentTerms)) {
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)70).lt((Object)75));
                                continue;
                            }
                            if ("75-80".equals(paymentTerms)) {
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)75).lt((Object)80));
                                continue;
                            }
                            if ("80\u4ee5\u4e0a".equals(paymentTerms)) {
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)80));
                                continue;
                            }
                            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gt((Object)0));
                            continue;
                        }
                        if (param.getParams().get("progressPaymentTerms") == null && param.getParams().get("paymentTerms") != null) {
                            String paymentTerms = ((Parameter)param.getParams().get("paymentTerms")).getValue().toString();
                            if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                                shouldBuilder = QueryBuilders.boolQuery();
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").lt((Object)70));
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").lt((Object)70));
                                boolQuery.must((QueryBuilder)shouldBuilder);
                                continue;
                            }
                            if ("70-75".equals(paymentTerms)) {
                                shouldBuilder = QueryBuilders.boolQuery();
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)70).lt((Object)75));
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)70).lt((Object)75));
                                boolQuery.must((QueryBuilder)shouldBuilder);
                                continue;
                            }
                            if ("75-80".equals(paymentTerms)) {
                                shouldBuilder = QueryBuilders.boolQuery();
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)75).lt((Object)80));
                                shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)75).lt((Object)80));
                                boolQuery.must((QueryBuilder)shouldBuilder);
                                continue;
                            }
                            if (!"80\u4ee5\u4e0a".equals(paymentTerms)) continue;
                            shouldBuilder = QueryBuilders.boolQuery();
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gte((Object)80));
                            shouldBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gte((Object)80));
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (param.getParams().get("progressPaymentTerms") != null && param.getParams().get("paymentTerms") == null) {
                            progressPaymentTerms = ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString();
                            if ("\u6708\u5ea6\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"monthlyPayment").gt((Object)0));
                                continue;
                            }
                            if (!"\u8282\u70b9\u4ed8\u6b3e".equals(progressPaymentTerms)) continue;
                            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodePayment").gt((Object)0));
                            continue;
                        }
                    }
                    if (params != null && "signDate".equals(key)) {
                        String[] signDate = ((Parameter)params.get("signDate")).getValue().toString().split(",");
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"signDate").from((Object)signDate[0]).to((Object)signDate[1]));
                        continue;
                    }
                    if (params != null && "subcontractingStatus".equals(key)) {
                        HashMap par = new HashMap();
                        Script script = new Script("doc['signDate'].size() > 0 && doc['mobilizationDate'].size() > 0 && doc['signDate'].value.getMillis() > doc['mobilizationDate'].value.getMillis()");
                        ScriptQueryBuilder scriptQueryBuilder = new ScriptQueryBuilder(script);
                        boolQuery.must((QueryBuilder)scriptQueryBuilder);
                        continue;
                    }
                    if (params != null && "projectClassify".equals(key)) {
                        String projectClassify = ((Parameter)param.getParams().get("projectClassify")).getValue().toString();
                        if (projectClassify.contains("virtually") && projectClassify.contains("physical") && projectClassify.contains("noproject")) continue;
                        if (projectClassify.contains("physical") && projectClassify.contains("noproject")) {
                            if (noExitProjectName == null || noExitProjectName.size() <= 0) continue;
                            shouldBuilder = QueryBuilders.boolQuery();
                            BoolQueryBuilder boolQuery1 = QueryBuilders.boolQuery();
                            for (String name : noExitProjectName) {
                                boolQuery1.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                            }
                            shouldBuilder.should((QueryBuilder)boolQuery1);
                            shouldBuilder.should((QueryBuilder)boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)ScoreMode.None)));
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (projectClassify.contains("virtually") && projectClassify.contains("noproject")) {
                            if (noExitProjectName != null && noExitProjectName.size() > 0) {
                                shouldBuilder = QueryBuilders.boolQuery();
                                for (String name : noExitProjectName) {
                                    shouldBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                                }
                                shouldBuilder.should((QueryBuilder)boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)ScoreMode.None)));
                                boolQuery.must((QueryBuilder)shouldBuilder);
                                continue;
                            }
                            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)ScoreMode.None));
                            continue;
                        }
                        if (projectClassify.contains("virtually") && projectClassify.contains("physical")) {
                            boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)ScoreMode.None));
                            continue;
                        }
                        if (projectClassify.contains("virtually")) {
                            if (noExitProjectName == null || noExitProjectName.size() <= 0) continue;
                            shouldBuilder = QueryBuilders.boolQuery();
                            for (String name : noExitProjectName) {
                                shouldBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                            }
                            boolQuery.must((QueryBuilder)shouldBuilder);
                            continue;
                        }
                        if (projectClassify.contains("physical")) {
                            if (noExitProjectName == null || noExitProjectName.size() <= 0) continue;
                            for (String name : noExitProjectName) {
                                boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"projectName.keyword", (Object)name));
                            }
                            continue;
                        }
                        if (!projectClassify.contains("noproject")) continue;
                        boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"projectId", (Object)ScoreMode.None));
                        continue;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])((Parameter)params.get(key)).getValue().toString().split(",")));
                }
                sourceBuilder.query((QueryBuilder)boolQuery);
                sourceBuilder.sort(new FieldSortBuilder("orgId.keyword").order(SortOrder.ASC));
                sourceBuilder.sort(new FieldSortBuilder("projectId.keyword").order(SortOrder.ASC));
                sourceBuilder.sort(new FieldSortBuilder("supplier.keyword").order(SortOrder.ASC));
                if (param.getOrderMap() != null) {
                    for (String key : param.getOrderMap().keySet()) {
                        if ("desc".equals(((String)param.getOrderMap().get(key)).toString())) {
                            sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.DESC));
                            continue;
                        }
                        sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.ASC));
                    }
                }
                Integer pageIndex = param.getPageIndex();
                Integer pageSize = param.getPageSize();
                sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
                sourceBuilder.size(pageSize.intValue());
                sourceBuilder.trackTotalHits(true);
                sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
                searchRequest.source(sourceBuilder);
                ArrayList<OutcontractVO> list = new ArrayList<OutcontractVO>();
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                this.logger.info("111111111------------" + hits.getTotalHits().value);
                for (SearchHit hit : hits) {
                    JSONObject json = new JSONObject(hit.getSourceAsMap());
                    OutcontractVO vo = (OutcontractVO)JSONObject.toJavaObject((JSON)json, OutcontractVO.class);
                    if (vo.getContractPrice() != null) {
                        vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
                    }
                    list.add(vo);
                }
                resultList = this.processData(list, param.getPageSize() == 10000);
                page.setCurrent((long)param.getPageIndex());
                page.setRecords(resultList);
                page.setTotal(hits.getTotalHits().value);
            }
            catch (Exception e) {
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e);
            }
        }
        if (params.get("range") != null) {
            params.remove("range");
        }
        IPage<RecordOutcontractVO> pageData = this.queryRecordOutcontractList(param, noExitProjectName);
        page = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        ArrayList<OutcontractVO> voList = new ArrayList<OutcontractVO>();
        for (RecordOutcontractVO entity : pageData.getRecords()) {
            OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)entity, OutcontractVO.class);
            if (vo.getContractPrice() != null) {
                vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
            }
            voList.add(vo);
        }
        resultList = this.processData(voList, param.getPageSize() == 10000);
        page.setRecords(resultList);
        return page;
    }

    public List<OutcontractVO> processData(List<OutcontractVO> list, Boolean isExport) {
        CommonResponse secondOrgResponse;
        ArrayList<OutcontractVO> vos = new ArrayList<OutcontractVO>();
        ArrayList orgIds = new ArrayList();
        List secondOrg = new ArrayList();
        CommonResponse rootOrg = this.iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
        if (rootOrg.isSuccess() && rootOrg.getData() != null && (secondOrgResponse = this.iOrgApi.getDirectChildrenByPid(((OrgVO)rootOrg.getData()).getId(), null)).isSuccess() && ((List)secondOrgResponse.getData()).size() > 0) {
            secondOrg = (List)secondOrgResponse.getData();
        }
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        for (OutcontractVO vo : list) {
            if (orgMap.get(vo.getOrgId()) != null) {
                vo.setOrgName((String)orgMap.get(vo.getOrgId()));
            } else {
                CommonResponse orgResponse = this.iOrgApi.detailById(vo.getOrgId());
                if (orgResponse.isSuccess() && orgResponse.getData() != null) {
                    String innerCode = ((OrgVO)orgResponse.getData()).getInnerCode();
                    for (OrgVO orgVO : secondOrg) {
                        if (!innerCode.contains(orgVO.getInnerCode())) continue;
                        vo.setOrgName(orgVO.getName());
                        orgMap.put(vo.getOrgId(), orgVO.getName());
                        break;
                    }
                }
            }
            vos.add(vo);
        }
        vos.forEach(e -> {
            if ("\u52b3\u52a1\u5206\u5305".equals(e.getType())) {
                e.setLabor(e.getSubcontractingContent());
                switch (e.getPricingForm()) {
                    case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborPrice(e.getPricingForm());
                        break;
                    }
                    case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborArea(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u5355\u4ef7": {
                        e.setLaborFixedPrice(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u603b\u4ef7": {
                        e.setLaborTotalPrice(e.getPricingForm());
                        break;
                    }
                    case "\u5b9a\u989d\u8ba1\u4ef7": {
                        e.setLaborQuotaValuation(e.getPricingForm());
                    }
                }
                if ("\u5305\u6e05\u5de5".equals(e.getLaborSubcontracteMode())) {
                    e.setPackLight(e.getLaborSubcontracteMode());
                }
                if ("\u6269\u5927\u52b3\u52a1\u5206\u5305".equals(e.getLaborSubcontracteMode())) {
                    e.setExpandSub(e.getLaborSubcontracteMode());
                }
                if ("\u5176\u4ed6\u5f62\u5f0f".equals(e.getLaborSubcontracteMode())) {
                    e.setOtherform(e.getLaborSubcontracteMode());
                }
            }
            if ("\u4e13\u4e1a\u5206\u5305".equals(e.getType())) {
                e.setMajor(e.getSubcontractingContent());
                switch (e.getPricingForm()) {
                    case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                        e.setMajorPrice(e.getPricingForm());
                        break;
                    }
                    case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                        e.setRateLower(e.getPricingForm());
                        break;
                    }
                    case "\u56fa\u5b9a\u603b\u4ef7": {
                        e.setMajorTotalPrice(e.getPricingForm());
                        break;
                    }
                    case "\u5b9a\u989d\u8ba1\u4ef7": {
                        e.setMajorQuotaValuation(e.getPricingForm());
                    }
                }
                if ("\u5305\u6e05\u5de5\u8f85\u6750".equals(e.getLaborSubcontracteMode())) {
                    e.setWorkersAndAuxiliaryMaterials(e.getLaborSubcontracteMode());
                }
                if ("\u5305\u5de5\u5305\u6599".equals(e.getLaborSubcontracteMode())) {
                    e.setLaborAndMaterials(e.getLaborSubcontracteMode());
                }
                if ("\u5176\u4ed6\u5f62\u5f0f".equals(e.getLaborSubcontracteMode())) {
                    e.setOtherForms(e.getLaborSubcontracteMode());
                }
            }
            if ("\u7269\u8d44\u91c7\u8d2d".equals(e.getType())) {
                e.setMaterial(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setMaterialFixedPrice(e.getPricingForm());
                }
                if ("\u53ef\u8c03\u4ef7\u683c".equals(e.getPricingForm())) {
                    e.setAdjustablePrice(e.getPricingForm());
                }
            }
            if ("\u673a\u68b0\u79df\u8d41".equals(e.getType())) {
                e.setEquipment(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setEquipmentFixedPrice("\u56fa\u5b9a\u5355\u4ef7");
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setEquipmentOther("\u5176\u4ed6");
                }
            }
            if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(e.getType())) {
                e.setTurnoverMaterial(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setTurnoverMaterialFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setTurnoverMaterialOther(e.getPricingForm());
                }
            }
            if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(e.getType())) {
                e.setDesign(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setDesignFixedPrice(e.getPricingForm());
                }
                if ("\u56fa\u5b9a\u603b\u4ef7".equals(e.getPricingForm())) {
                    e.setDesignTotalPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setDesignOther(e.getPricingForm());
                }
            }
            if ("\u54a8\u8be2\u670d\u52a1".equals(e.getType())) {
                e.setConsultancy(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setConsultancyFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setConsultancyOther(e.getPricingForm());
                }
            }
            if ("\u5176\u5b83\u5408\u540c".equals(e.getType())) {
                e.setOther(e.getSubcontractingContent());
                if ("\u56fa\u5b9a\u5355\u4ef7".equals(e.getPricingForm())) {
                    e.setOtherFixedPrice(e.getPricingForm());
                }
                if ("\u5176\u4ed6".equals(e.getPricingForm())) {
                    e.setOther1(e.getPricingForm());
                }
            }
        });
        return vos;
    }

    public IPage<RecordOutcontractVO> queryRecordOutcontractList(QueryParam param, List<String> noExitProjectName) {
        String projectClassify;
        String sql;
        String sql2;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (param.getPageIndex() != -1) {
            long startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
            params.put("startLine", startLine);
            params.put("pageIndex", param.getPageIndex());
            params.put("pageSize", param.getPageSize());
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }
        if (param.getOrderMap() != null && param.getOrderMap().size() > 0) {
            String sql3 = " order by d.orgId asc, d.projectId asc, d.supplier asc";
            for (String key : param.getOrderMap().keySet()) {
                sql3 = sql3 + " , d." + key + " " + (String)param.getOrderMap().get(key) + " ";
            }
            params.put("ordersql", sql3);
        }
        if (param.getPageIndex() != -1) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                params.put("orgIds", commonOrgIds);
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                params.put("projectDepartmentIds", departmentIds);
            }
        }
        if (param.getParams() != null && param.getParams().get("type") != null) {
            String[] type = ((Parameter)param.getParams().get("type")).getValue().toString().split(",");
            params.put("type", Arrays.asList(type));
        }
        if (param.getParams() != null && param.getParams().get("projectId") != null) {
            params.put("projectId", ((Parameter)param.getParams().get("projectId")).getValue());
        }
        if (param.getParams() != null && param.getParams().get("supplier") != null) {
            params.put("supplier", ((Parameter)param.getParams().get("supplier")).getValue());
        }
        if (param.getParams() != null && param.getParams().get("signUnit") != null) {
            params.put("signUnit", ((Parameter)param.getParams().get("signUnit")).getValue());
        }
        if (param.getParams() != null && param.getParams().get("pricingForm") != null) {
            String[] pricingForm = ((Parameter)param.getParams().get("pricingForm")).getValue().toString().split(",");
            params.put("pricingForm", Arrays.asList(pricingForm));
        }
        if (param.getParams() != null && param.getParams().get("signDate") != null) {
            String[] signDate = ((Parameter)param.getParams().get("signDate")).getValue().toString().split(",");
            sql2 = "( o.sign_date BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
            params.put("signDate", sql2);
            String sql1 = "( o.supplementary_sign_time  BETWEEN '" + signDate[0] + "' and  '" + signDate[1] + "')";
            params.put("supplementarySignTime", sql1);
        }
        if (param.getParams() != null && param.getParams().get("advanceCharge") != null) {
            if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)param.getParams().get("advanceCharge")).getValue())) {
                String sql4 = "( (d.advanceCharge != '') and (d.advanceCharge is not null) and (d.advanceCharge != '0')  and (d.advanceCharge != '/') and (d.advanceCharge != '\u7a7a') and (d.advanceCharge != '\u65e0') and (d.advanceCharge != '0.00') and (d.advanceCharge != '0%') )";
                params.put("advancePaymentProportion", sql4);
            } else {
                String sql5 = "( (d.advanceCharge = '') or (d.advanceCharge is null) or (d.advanceCharge = '0') or (d.advanceCharge = '/') or (d.advanceCharge = '\u7a7a') or (d.advanceCharge = '\u65e0') or (d.advanceCharge = '0.00') or (d.advanceCharge = '0%') )";
                params.put("advancePaymentProportion", sql5);
            }
        }
        if (param.getParams() != null) {
            if (param.getParams().get("progressPaymentTerms") != null && param.getParams().get("paymentTerms") != null) {
                String progressPaymentTerms = ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString();
                String paymentTerms = ((Parameter)param.getParams().get("paymentTerms")).getValue().toString();
                if ("\u6708\u5ea6\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                    if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                        sql = "( d.monthlyPayment < 70 )";
                        params.put("monthlyPayment", sql);
                    } else if ("70-75".equals(paymentTerms)) {
                        sql = " (d.monthlyPayment >= 70 and d.monthlyPayment < 75)";
                        params.put("monthlyPayment", sql);
                    } else if ("75-80".equals(paymentTerms)) {
                        sql = "(d.monthlyPayment >= 75 and d.monthlyPayment <80)";
                        params.put("monthlyPayment", sql);
                    } else if ("80\u4ee5\u4e0a".equals(paymentTerms)) {
                        sql = "( d.monthlyPayment >= 80)";
                        params.put("monthlyPayment", sql);
                    } else {
                        sql = "( d.monthlyPayment > 0)";
                        params.put("monthlyPayment", sql);
                    }
                } else if ("\u8282\u70b9\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                    if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                        sql = "( d.nodePayment < 70 )";
                        params.put("nodePayment", sql);
                    } else if ("70-75".equals(paymentTerms)) {
                        sql = " (d.nodePayment >= 70 and d.nodePayment < 75)";
                        params.put("nodePayment", sql);
                    } else if ("75-80".equals(paymentTerms)) {
                        sql = "(d.nodePayment >= 75 and d.nodePayment <80)";
                        params.put("nodePayment", sql);
                    } else if ("80\u4ee5\u4e0a".equals(paymentTerms)) {
                        sql = "( d.nodePayment >= 80)";
                        params.put("nodePayment", sql);
                    } else {
                        sql = "( d.nodePayment > 0)";
                        params.put("nodePayment", sql);
                    }
                }
            } else if (param.getParams().get("progressPaymentTerms") == null && param.getParams().get("paymentTerms") != null) {
                String paymentTerms = ((Parameter)param.getParams().get("paymentTerms")).getValue().toString();
                if ("70\u4ee5\u4e0b".equals(paymentTerms)) {
                    sql2 = "( d.nodePayment < 70 or d.monthlyPayment < 70 )";
                    params.put("nodePayment", sql2);
                } else if ("70-75".equals(paymentTerms)) {
                    sql2 = "( (d.nodePayment >= 70 and d.nodePayment < 75) or (d.monthlyPayment >= 70 and d.monthlyPayment <75) )";
                    params.put("nodePayment", sql2);
                } else if ("75-80".equals(paymentTerms)) {
                    sql2 = "( (d.nodePayment >= 75 and d.nodePayment < 80) or (d.monthlyPayment >= 75 and d.monthlyPayment <80) )";
                    params.put("nodePayment", sql2);
                } else if ("80\u4ee5\u4e0a".equals(paymentTerms)) {
                    sql2 = "( d.nodePayment >= 80 or d.monthlyPayment >= 80 )";
                    params.put("nodePayment", sql2);
                }
            } else if (param.getParams().get("progressPaymentTerms") != null && param.getParams().get("paymentTerms") == null) {
                String progressPaymentTerms = ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString();
                if ("\u6708\u5ea6\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                    sql2 = "( d.monthlyPayment > 0)";
                    params.put("monthlyPayment", sql2);
                } else if ("\u8282\u70b9\u4ed8\u6b3e".equals(progressPaymentTerms)) {
                    sql2 = "( d.nodePayment > 0)";
                    params.put("nodePayment", sql2);
                }
            }
        }
        if (param.getParams() != null && param.getParams().get("performanceStatus") != null) {
            params.put("performanceStatus", ((Parameter)param.getParams().get("performanceStatus")).getValue());
        }
        if (params.get("signDate") == null) {
            SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
            String curDate = format2.format(new Date());
            sql = "( o.sign_date > '" + curDate + "' )";
            params.put("signDate", sql);
            String sql1 = "( o.supplementary_sign_time > '" + curDate + "' )";
            params.put("supplementarySignTime", sql1);
        }
        if (param.getParams() != null && param.getParams().get("supplementary") != null) {
            params.put("supplementary", "\u8865\u5145\u534f\u8bae");
        }
        params.put("noProject", "noProject");
        if (param.getParams() != null && param.getParams().get("projectStatus") != null) {
            params.put("projectStatus", ((Parameter)param.getParams().get("projectStatus")).getValue());
        } else {
            params.put("projectStatus", "all");
        }
        if (!(param.getParams() == null || param.getParams().get("projectClassify") == null || (projectClassify = ((Parameter)param.getParams().get("projectClassify")).getValue().toString()).contains("virtually") && projectClassify.contains("physical") && projectClassify.contains("noproject"))) {
            if (projectClassify.contains("physical") && projectClassify.contains("noproject")) {
                if (noExitProjectName != null && noExitProjectName.size() > 0) {
                    sql2 = " and (d.projectName not in (\"" + String.join((CharSequence)"\",\"", noExitProjectName) + '\"' + ") or d.projectId is null)";
                    params.put("projectClassify", sql2);
                }
            } else if (projectClassify.contains("virtually") && projectClassify.contains("noproject")) {
                if (noExitProjectName != null && noExitProjectName.size() > 0) {
                    sql2 = " and (d.projectName in (\"" + String.join((CharSequence)"\",\"", noExitProjectName) + '\"' + ") or d.projectId is null)";
                    params.put("projectClassify", sql2);
                } else {
                    sql2 = "and d.projectId is null";
                    params.put("projectClassify", sql2);
                }
            } else if (projectClassify.contains("virtually") && projectClassify.contains("physical")) {
                sql2 = "and d.projectId is not null";
                params.put("projectClassify", sql2);
            } else if (projectClassify.contains("virtually")) {
                sql2 = " and d.projectName in (\"" + String.join((CharSequence)"\",\"", noExitProjectName) + '\"' + ")";
                params.put("projectClassify", sql2);
            } else if (projectClassify.contains("physical")) {
                if (noExitProjectName != null && noExitProjectName.size() > 0) {
                    sql2 = " and d.projectName not in (\"" + String.join((CharSequence)"\",\"", noExitProjectName) + '\"' + ")";
                    params.put("projectClassify", sql2);
                }
            } else if (projectClassify.contains("noproject")) {
                sql2 = "and d.projectId is null";
                params.put("projectClassify", sql2);
            }
        }
        if (param.getParams() != null && param.getParams().get("submitDate") != null) {
            String[] supplementarySignTime = ((Parameter)param.getParams().get("submitDate")).getValue().toString().split(",");
            sql2 = "( d.submitDate BETWEEN '" + supplementarySignTime[0] + "' and  '" + supplementarySignTime[1] + "')";
            params.put("submitDate", sql2);
        }
        if (param.getParams() != null && param.getParams().get("passedDate") != null) {
            String[] supplementarySignTime = ((Parameter)param.getParams().get("passedDate")).getValue().toString().split(",");
            sql2 = "( d.passedDate BETWEEN '" + supplementarySignTime[0] + "' and  '" + supplementarySignTime[1] + "')";
            params.put("passedDate", sql2);
        }
        params.put("otherInfo", "otherInfo");
        IPage<RecordOutcontractVO> page = this.recordOutcontractService.queryAllList(params);
        return page;
    }
}

