/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sealApproval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZjkjTianJianSyncServiceImpl
implements IZjkjTianJianSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${tianjianUrl:http://36.137.93.200:10006/open_api}")
    private String tianjianUrl;
    @Autowired
    private ISealApprovalService sealApprovalService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;

    @Override
    public void syncSeal(Long sealId) {
        CommonResponse employeeResponse;
        DeptVO dept;
        CommonResponse orgResponse;
        SealApprovalEntity sealEntity = (SealApprovalEntity)((Object)this.sealApprovalService.selectById(sealId));
        if (!StringUtils.isNotBlank((CharSequence)sealEntity.getContractSeal()) || !"contractSeal".equals(sealEntity.getContractSeal())) {
            return;
        }
        Long applyDept = sealEntity.getApplyDept();
        CommonResponse deptResponse = this.orgApi.findDeptById(applyDept);
        if (deptResponse.isSuccess() && deptResponse.getData() != null && (orgResponse = this.orgApi.detailById((dept = (DeptVO)deptResponse.getData()).getOrgId())).isSuccess() && orgResponse.getData() != null) {
            OrgVO org = (OrgVO)orgResponse.getData();
            if (org.getOrgType() == 1 && !org.getInnerCode().contains("|")) {
                this.syncOrgList(org);
            } else {
                return;
            }
        }
        ArrayList<UserVO> userList = new ArrayList<UserVO>();
        Long sendId = null;
        Long sealUserId = null;
        CommonResponse createResponse = this.userApi.queryUserByUserCode(sealEntity.getCreateUserCode());
        if (createResponse.isSuccess() && createResponse.getData() != null) {
            userList.add((UserVO)createResponse.getData());
            sendId = ((UserVO)createResponse.getData()).getId();
        }
        if (!sendId.equals(sealEntity.getEmployeeId()) && (employeeResponse = this.userApi.findUserByUserId(sealEntity.getEmployeeId())).isSuccess() && employeeResponse.getData() != null) {
            userList.add((UserVO)employeeResponse.getData());
            sealUserId = ((UserVO)employeeResponse.getData()).getId();
        }
        this.syncUserList(userList);
        this.syncSeal(sendId, sealUserId, sealEntity);
    }

    @Override
    public void syncOrgList(OrgVO org) {
        ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
        JSONObject d = new JSONObject();
        if ("1247777316689256450".equals(org.getId().toString())) {
            return;
        }
        d.put("id", (Object)org.getId().toString());
        d.put("name", (Object)org.getName());
        d.put("parentId", (Object)(org.getParentId() != null ? (org.getParentId().toString().equals("1247777316689256450") ? "1" : org.getParentId().toString()) : "0"));
        d.put("orgType", (Object)2);
        deptList.add(d);
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/depart/sync";
            JSONObject params = new JSONObject();
            params.put("deptList", deptList);
            this.logger.info("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void syncUserList(List<UserVO> users) {
        ArrayList<JSONObject> userList = new ArrayList<JSONObject>();
        for (UserVO user : users) {
            JSONObject d = new JSONObject();
            d.put("id", (Object)user.getId().toString());
            d.put("username", (Object)user.getUserCode());
            d.put("realname", (Object)user.getUserName());
            d.put("phone", (Object)user.getUserMobile());
            ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
            JSONObject org = new JSONObject();
            String orgId = user.getOrgId().toString();
            if ("1247777316689256450".equals(user.getOrgId().toString())) {
                orgId = "1";
            }
            org.put("id", (Object)orgId);
            deptList.add(org);
            d.put("deptList", deptList);
            d.put("defaultDept", (Object)org);
            d.put("email", (Object)user.getUserEmail());
            userList.add(d);
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/user/sync";
            JSONObject params = new JSONObject();
            params.put("userList", userList);
            this.logger.info("\u4eba\u5458\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            this.logger.info("\u4eba\u5458\u540c\u6b65\u6570\u636e\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void syncSeal(Long sendId, Long sealUserId, SealApprovalEntity sealEntity) {
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/authorize";
            JSONObject params = new JSONObject();
            params.put("applyUserId", (Object)sendId.toString());
            ArrayList<String> useSealUserIdList = new ArrayList<String>();
            useSealUserIdList.add(sealUserId.toString());
            params.put("useSealUserIdList", useSealUserIdList);
            ArrayList<JSONObject> sealDetailList = new ArrayList<JSONObject>();
            JSONObject sealDetail = new JSONObject();
            sealDetail.put("applyCount", (Object)(sealEntity.getSealCount() + 30));
            sealDetail.put("applyCrossPageSealCount", (Object)(sealEntity.getPageSeal() + 30));
            sealDetail.put("sealId", (Object)"7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
            sealDetailList.add(sealDetail);
            params.put("sealDetailList", sealDetailList);
            params.put("title ", (Object)("\u5408\u540c\uff1a\u3010" + sealEntity.getContractName() + "\u3011\uff0c\u7533\u8bf7\u7528\u7ae0"));
            params.put("billNo", (Object)sealEntity.getBillCode());
            params.put("remark", (Object)sealEntity.getSealReasons());
            JSONObject policy = new JSONObject();
            ArrayList<Integer> num = new ArrayList<Integer>();
            num.add(1);
            policy.put("videoRecordSealModel", num);
            policy.put("videoRecordCrossModel", num);
            policy.put("videoRecordWrongModel", num);
            params.put("policy", (Object)policy);
            this.logger.info("\u7528\u5370\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u540c\u6b65\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            String applyId = data.getString("applyId");
            JSONArray safeCodeList = data.getJSONArray("safeCodeList");
            JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
            String safeCode = safeCodeJSON.getString("safeCode");
            sealEntity.setTjPrintId(applyId);
            sealEntity.setTjPrintCode(safeCode);
            this.sealApprovalService.saveOrUpdate((Object)sealEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }

    @Override
    public String getToken() {
        String token = "";
        try {
            String url = this.tianjianUrl + "/token/get";
            JSONObject params = new JSONObject();
            params.put("restname", (Object)"root");
            params.put("password", (Object)"Zj@kj#qunje");
            String backData = HttpTookit.postByJson(url, params.toJSONString());
            this.logger.info("\u83b7\u53d6token\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            token = data.getString("token");
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
        }
        return token;
    }
}

