package com.ejianc.foundation.outcontract.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
/**
 * 记录分供方合同
 * 
 * @author generator
 * 
 */
 @TableName("ejc_record_outcontract")
public class RecordOutcontractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="user_dept_id")
    private Long userDeptId; // 创建人部门
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="change_state")
    private String changeState; // 变更单id
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="outcontract_code")
    private String outcontractCode; // 合同变更版本号
    @TableField(value="outcontract_id")
    private Long outcontractId; // 合同id
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目id
    @TableField(value="bill_code")
    private String billCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="type")
    private String type; // 合同类型
    @TableField(value="integrated_code")
    private String integratedCode; // 一体化编码
    @TableField(value="sign_unit")
    private Long signUnit; // 签约单位
    @TableField(value="sign_unit_name")
    private String signUnitName; // 签约单位名称
    @TableField(value="build_unit")
    private Long buildUnit; // 实施单位
    @TableField(value="build_unit_name")
    private String buildUnitName; // 实施单位名称
    @TableField(value="agent")
    private Long agent; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人名称

    @TableField(value="agent_dept_id")
    private Long agentDeptId; // 经办人部门
    @TableField(value="agent_dept_name")
    private String agentDeptName; // 经办人部门名称
    @TableField(value="supplier")
    private Long supplier; // 供方单位
    @TableField(value="supplier_name")
    private String supplierName; // 分供商名称
    @TableField(value="supplier_tax_payer_type")
    private Long supplierTaxPayerType; // 纳税人类型
    @TableField(value="supplier_social_credit_code")
    private String supplierSocialCreditCode; // 统一社会信用代码
    @TableField(value="supplier_bank")
    private String supplierBank; // 开户行
    @TableField(value="supplier_bank_account")
    private String supplierBankAccount; // 开户行账号
    @TableField(value="supplier_contact_user")
    private String supplierContactUser; // 联系人
    @TableField(value="supplier_contact_user_address")
    private String supplierContactUserAddress; // 联系人地址
    @TableField(value="supplier_contact_user_phone")
    private String supplierContactUserPhone; // 联系人电话
    @TableField(value="supplier_contact_user_email")
    private String supplierContactUserEmail; // 联系人邮箱
    @TableField(value="supplier_legal")
    private String supplierLegal; // 法定代表人
    @TableField(value="supplier_telephone")
    private String supplierTelephone; // 供方电话
    
    @TableField(value="subcontract_status")
    private String subcontractStatus; // 分包状态
    @TableField(value="pricing_form")
    private String pricingForm; // 计价形式
    @TableField(value="build_area")
    private BigDecimal buildArea; // 建筑面积
    @TableField(value="contract_price")
    private BigDecimal contractPrice; // 合同价格
    @TableField(value="contract_area_unit_price")
    private BigDecimal contractAreaUnitPrice; // 合同建筑面积单价
    @TableField(value="performance_status")
    private String performanceStatus; // 履约状态
    @TableField(value="mobilization_date")
    private Date mobilizationDate; // 进场日期
    @TableField(value="exit_date")
    private Date exitDate; // 退场日期
    @TableField(value="contract_template_library")
    private Long contractTemplateLibrary; // 合同文本
    @TableField(value="sign_date")
    private Date signDate; // 签订日期
    @TableField(value="labor_subcontracte_mode")
    private String laborSubcontracteMode; // 劳务分包方式
    @TableField(value="subcontracting_content")
    private String subcontractingContent; // 分包内容
    @TableField(value="remark")
    private String remark; // 备注
    
    @TableField(value="advance_charge")
    private String advanceCharge; // 预付款
    @TableField(value="monthly_payment")
    private BigDecimal monthlyPayment; // 月度付款
    @TableField(value="node_payment")
    private BigDecimal nodePayment; // 节点付款
    @TableField(value="payment_proportion")
    private BigDecimal paymentProportion; // 付款比例
    @TableField(value="balance_payment")
    private String balancePayment; // 尾款
    @TableField(value="warranty_deposit")
    private String warrantyDeposit; // 保修金
    @TableField(value="after_completion_payment")
    private String afterCompletionPayment; // 竣工后付款
    
    @TableField(value="subcontract_total_amount")
    private BigDecimal subcontractTotalAmount; // 分包工程总价汇总表合计金额
    @TableField(value="subcontract_unit_total_amount")
    private BigDecimal subcontractUnitTotalAmount; // 分包工程综合单价计价表合计金额
    @TableField(value="contract_price_total_amount")
    private BigDecimal contractPriceTotalAmount; // 合同价合计金额
    @TableField(value="lease_item_total_amount")
    private BigDecimal leaseItemTotalAmount; // 租赁物进出场费明细表合计金额
    @TableField(value="rent_total_amount")
    private BigDecimal rentTotalAmount; // 租金明细表合计金额
    @TableField(value="file_id")
    private Long fileId; // word合同编辑文件id

    //合同评审字段
    @TableField(value="adopt_text")
    private String adoptText; // 采用文本
    @TableField(value="business_sponsor")
    private String businessSponsor; // 业务主办单位
    @TableField(value="quality_standard")
    private String qualityStandard; // 质量标准

    @TableField(value="after_change_amount")
    private BigDecimal afterChangeAmount; // 变更金额
    @TableField(value="change_amount")
    private BigDecimal changeAmount; // 变更金额
    @TableField(value="supplementary_sign_time")
    private Date supplementarySignTime; // 签约时间

    @TableField(value="downward_rate")
    private BigDecimal downwardRate; // 下浮率  计价方式选择按承包合同价款让利费率下浮和定额计价，则下浮率必须填写
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractReviewService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractReviewEntity> recordOutcontractReviewList = new ArrayList<>(); // 记录分供方合同评审
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractSubcontractTotalPriceService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractSubcontractTotalPriceEntity> recordOutcontractSubcontractTotalPriceList = new ArrayList<>(); // 记录分包工程总价汇总表
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractSubcontractUnitPriceService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractSubcontractUnitPriceEntity> recordOutcontractSubcontractUnitPriceList = new ArrayList<>(); // 记录分包工程综合单价计价表
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractSupplementaryAgreementService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractSupplementaryAgreementEntity> recordOutcontractSupplementaryAgreementList = new ArrayList<>(); // 记录补充协议
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractMaterialService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractMaterialEntity> recordOutcontractMaterialList = new ArrayList<>(); // 记录物资（周转材）合同价
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractEquipmentLeaseItemService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractEquipmentLeaseItemEntity> recordOutcontractEquipmentLeaseItemList = new ArrayList<>(); // 记录租赁物进出场费明细表
    @TableField(exist=false)
    @SubEntity(serviceName="recordOutcontractEquipmentRentService", pidName="recordOutcontractId")//此处有pid="xxx"，默认值pid="pid"
    private List<RecordOutcontractEquipmentRentEntity> recordOutcontractEquipmentRentList = new ArrayList<>(); // 记录租金明细表
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    
    public String getOutcontractCode() {
		return outcontractCode;
	}

	public void setOutcontractCode(String outcontractCode) {
		this.outcontractCode = outcontractCode;
	}

	public Long getOutcontractId() {
        return outcontractId;
    }

    public void setOutcontractId(Long outcontractId) {
        this.outcontractId = outcontractId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }
    public Long getSignUnit() {
        return signUnit;
    }

    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }
    public String getSignUnitName() {
        return signUnitName;
    }

    public void setSignUnitName(String signUnitName) {
        this.signUnitName = signUnitName;
    }
    public Long getBuildUnit() {
        return buildUnit;
    }

    public void setBuildUnit(Long buildUnit) {
        this.buildUnit = buildUnit;
    }
    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
    public Long getAgent() {
        return agent;
    }

    public void setAgent(Long agent) {
        this.agent = agent;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getSupplier() {
        return supplier;
    }

    public void setSupplier(Long supplier) {
        this.supplier = supplier;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public Long getSupplierTaxPayerType() {
		return supplierTaxPayerType;
	}

	public void setSupplierTaxPayerType(Long supplierTaxPayerType) {
		this.supplierTaxPayerType = supplierTaxPayerType;
	}

	public String getSupplierSocialCreditCode() {
		return supplierSocialCreditCode;
	}

	public void setSupplierSocialCreditCode(String supplierSocialCreditCode) {
		this.supplierSocialCreditCode = supplierSocialCreditCode;
	}

	public String getSupplierLegal() {
		return supplierLegal;
	}

	public void setSupplierLegal(String supplierLegal) {
		this.supplierLegal = supplierLegal;
	}

	public String getSupplierTelephone() {
		return supplierTelephone;
	}

	public void setSupplierTelephone(String supplierTelephone) {
		this.supplierTelephone = supplierTelephone;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getSupplierBank() {
        return supplierBank;
    }

    public void setSupplierBank(String supplierBank) {
        this.supplierBank = supplierBank;
    }
    public String getSupplierBankAccount() {
        return supplierBankAccount;
    }

    public void setSupplierBankAccount(String supplierBankAccount) {
        this.supplierBankAccount = supplierBankAccount;
    }
    public String getSupplierContactUser() {
        return supplierContactUser;
    }

    public void setSupplierContactUser(String supplierContactUser) {
        this.supplierContactUser = supplierContactUser;
    }
    public String getSupplierContactUserAddress() {
        return supplierContactUserAddress;
    }

    public void setSupplierContactUserAddress(String supplierContactUserAddress) {
        this.supplierContactUserAddress = supplierContactUserAddress;
    }
    public String getSupplierContactUserPhone() {
        return supplierContactUserPhone;
    }

    public void setSupplierContactUserPhone(String supplierContactUserPhone) {
        this.supplierContactUserPhone = supplierContactUserPhone;
    }
    public String getSupplierContactUserEmail() {
        return supplierContactUserEmail;
    }

    public void setSupplierContactUserEmail(String supplierContactUserEmail) {
        this.supplierContactUserEmail = supplierContactUserEmail;
    }
    public String getSubcontractStatus() {
        return subcontractStatus;
    }

    public void setSubcontractStatus(String subcontractStatus) {
        this.subcontractStatus = subcontractStatus;
    }
    public String getPricingForm() {
        return pricingForm;
    }

    public void setPricingForm(String pricingForm) {
        this.pricingForm = pricingForm;
    }
    public BigDecimal getBuildArea() {
        return buildArea;
    }

    public void setBuildArea(BigDecimal buildArea) {
        this.buildArea = buildArea;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public BigDecimal getContractAreaUnitPrice() {
        return contractAreaUnitPrice;
    }

    public void setContractAreaUnitPrice(BigDecimal contractAreaUnitPrice) {
        this.contractAreaUnitPrice = contractAreaUnitPrice;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Date getMobilizationDate() {
        return mobilizationDate;
    }

    public void setMobilizationDate(Date mobilizationDate) {
        this.mobilizationDate = mobilizationDate;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    public Long getContractTemplateLibrary() {
        return contractTemplateLibrary;
    }

    public void setContractTemplateLibrary(Long contractTemplateLibrary) {
        this.contractTemplateLibrary = contractTemplateLibrary;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getLaborSubcontracteMode() {
        return laborSubcontracteMode;
    }

    public void setLaborSubcontracteMode(String laborSubcontracteMode) {
        this.laborSubcontracteMode = laborSubcontracteMode;
    }
    public String getSubcontractingContent() {
        return subcontractingContent;
    }

    public void setSubcontractingContent(String subcontractingContent) {
        this.subcontractingContent = subcontractingContent;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getAdvanceCharge() {
        return advanceCharge;
    }

    public void setAdvanceCharge(String advanceCharge) {
        this.advanceCharge = advanceCharge;
    }
    public BigDecimal getMonthlyPayment() {
        return monthlyPayment;
    }

    public void setMonthlyPayment(BigDecimal monthlyPayment) {
        this.monthlyPayment = monthlyPayment;
    }
    public BigDecimal getNodePayment() {
        return nodePayment;
    }

    public void setNodePayment(BigDecimal nodePayment) {
        this.nodePayment = nodePayment;
    }
    public String getBalancePayment() {
        return balancePayment;
    }

    public void setBalancePayment(String balancePayment) {
        this.balancePayment = balancePayment;
    }
    public String getWarrantyDeposit() {
        return warrantyDeposit;
    }

    public void setWarrantyDeposit(String warrantyDeposit) {
        this.warrantyDeposit = warrantyDeposit;
    }
    public BigDecimal getSubcontractTotalAmount() {
        return subcontractTotalAmount;
    }

    public void setSubcontractTotalAmount(BigDecimal subcontractTotalAmount) {
        this.subcontractTotalAmount = subcontractTotalAmount;
    }
    public BigDecimal getSubcontractUnitTotalAmount() {
        return subcontractUnitTotalAmount;
    }

    public void setSubcontractUnitTotalAmount(BigDecimal subcontractUnitTotalAmount) {
        this.subcontractUnitTotalAmount = subcontractUnitTotalAmount;
    }
    public BigDecimal getContractPriceTotalAmount() {
        return contractPriceTotalAmount;
    }

    public void setContractPriceTotalAmount(BigDecimal contractPriceTotalAmount) {
        this.contractPriceTotalAmount = contractPriceTotalAmount;
    }
    public BigDecimal getLeaseItemTotalAmount() {
        return leaseItemTotalAmount;
    }

    public void setLeaseItemTotalAmount(BigDecimal leaseItemTotalAmount) {
        this.leaseItemTotalAmount = leaseItemTotalAmount;
    }
    public BigDecimal getRentTotalAmount() {
        return rentTotalAmount;
    }

    public void setRentTotalAmount(BigDecimal rentTotalAmount) {
        this.rentTotalAmount = rentTotalAmount;
    }
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    
    public List<RecordOutcontractReviewEntity> getRecordOutcontractReviewList() {
        return recordOutcontractReviewList;
    }

    public void setRecordOutcontractReviewList(List<RecordOutcontractReviewEntity> recordOutcontractReviewList) {
        this.recordOutcontractReviewList = recordOutcontractReviewList;
    }
    public List<RecordOutcontractSubcontractTotalPriceEntity> getRecordOutcontractSubcontractTotalPriceList() {
        return recordOutcontractSubcontractTotalPriceList;
    }

    public void setRecordOutcontractSubcontractTotalPriceList(List<RecordOutcontractSubcontractTotalPriceEntity> recordOutcontractSubcontractTotalPriceList) {
        this.recordOutcontractSubcontractTotalPriceList = recordOutcontractSubcontractTotalPriceList;
    }
    public List<RecordOutcontractSubcontractUnitPriceEntity> getRecordOutcontractSubcontractUnitPriceList() {
        return recordOutcontractSubcontractUnitPriceList;
    }

    public void setRecordOutcontractSubcontractUnitPriceList(List<RecordOutcontractSubcontractUnitPriceEntity> recordOutcontractSubcontractUnitPriceList) {
        this.recordOutcontractSubcontractUnitPriceList = recordOutcontractSubcontractUnitPriceList;
    }
    public List<RecordOutcontractSupplementaryAgreementEntity> getRecordOutcontractSupplementaryAgreementList() {
        return recordOutcontractSupplementaryAgreementList;
    }

    public void setRecordOutcontractSupplementaryAgreementList(List<RecordOutcontractSupplementaryAgreementEntity> recordOutcontractSupplementaryAgreementList) {
        this.recordOutcontractSupplementaryAgreementList = recordOutcontractSupplementaryAgreementList;
    }
    public List<RecordOutcontractMaterialEntity> getRecordOutcontractMaterialList() {
        return recordOutcontractMaterialList;
    }

    public void setRecordOutcontractMaterialList(List<RecordOutcontractMaterialEntity> recordOutcontractMaterialList) {
        this.recordOutcontractMaterialList = recordOutcontractMaterialList;
    }
    public List<RecordOutcontractEquipmentLeaseItemEntity> getRecordOutcontractEquipmentLeaseItemList() {
        return recordOutcontractEquipmentLeaseItemList;
    }

    public void setRecordOutcontractEquipmentLeaseItemList(List<RecordOutcontractEquipmentLeaseItemEntity> recordOutcontractEquipmentLeaseItemList) {
        this.recordOutcontractEquipmentLeaseItemList = recordOutcontractEquipmentLeaseItemList;
    }
    public List<RecordOutcontractEquipmentRentEntity> getRecordOutcontractEquipmentRentList() {
        return recordOutcontractEquipmentRentList;
    }

    public void setRecordOutcontractEquipmentRentList(List<RecordOutcontractEquipmentRentEntity> recordOutcontractEquipmentRentList) {
        this.recordOutcontractEquipmentRentList = recordOutcontractEquipmentRentList;
    }

	public BigDecimal getPaymentProportion() {
		return paymentProportion;
	}

	public void setPaymentProportion(BigDecimal paymentProportion) {
		this.paymentProportion = paymentProportion;
	}

	public String getAfterCompletionPayment() {
		return afterCompletionPayment;
	}

	public void setAfterCompletionPayment(String afterCompletionPayment) {
		this.afterCompletionPayment = afterCompletionPayment;
	}

	public String getAdoptText() {
		return adoptText;
	}

	public void setAdoptText(String adoptText) {
		this.adoptText = adoptText;
	}

	public String getBusinessSponsor() {
		return businessSponsor;
	}

	public void setBusinessSponsor(String businessSponsor) {
		this.businessSponsor = businessSponsor;
	}

	public String getQualityStandard() {
		return qualityStandard;
	}

	public void setQualityStandard(String qualityStandard) {
		this.qualityStandard = qualityStandard;
	}

	public Long getUserDeptId() {
		return userDeptId;
	}

	public void setUserDeptId(Long userDeptId) {
		this.userDeptId = userDeptId;
	}

	public BigDecimal getAfterChangeAmount() {
		return afterChangeAmount;
	}

	public void setAfterChangeAmount(BigDecimal afterChangeAmount) {
		this.afterChangeAmount = afterChangeAmount;
	}

	public BigDecimal getChangeAmount() {
		return changeAmount;
	}

	public void setChangeAmount(BigDecimal changeAmount) {
		this.changeAmount = changeAmount;
	}

	public Date getSupplementarySignTime() {
		return supplementarySignTime;
	}

	public void setSupplementarySignTime(Date supplementarySignTime) {
		this.supplementarySignTime = supplementarySignTime;
	}

    public Long getAgentDeptId() {
        return agentDeptId;
    }

    public void setAgentDeptId(Long agentDeptId) {
        this.agentDeptId = agentDeptId;
    }

    public String getAgentDeptName() {
        return agentDeptName;
    }

    public void setAgentDeptName(String agentDeptName) {
        this.agentDeptName = agentDeptName;
    }

    public BigDecimal getDownwardRate() {
        return downwardRate;
    }

    public void setDownwardRate(BigDecimal downwardRate) {
        this.downwardRate = downwardRate;
    }
}
