package com.ejianc.foundation.sealApproval.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.mapper.SealApprovalMapper;
import com.ejianc.foundation.sealApproval.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.sealApproval.service.ISealApprovalService;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.*;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;

/**
 * 用印审批
 *
 * @author generator
 */
@Service("sealApprovalService")
public class SealApprovalServiceImpl extends BaseServiceImpl<SealApprovalMapper, SealApprovalEntity> implements ISealApprovalService {

    @Value("${callBackEncryptKey:b97298b7c65541be89e1d1826f38d338}")
    private String callBackEncryptKey;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IZjkjTianJianSyncService zjkjTianJianSyncService;

    @Autowired
    private IUserApi userApi;

    @Override
    public String tjUserEncrypt(Long userId) {
        List<UserVO> userList = new ArrayList<>();
        //获取创建人
        CommonResponse<UserVO> createResponse = userApi.findUserByUserId(userId);
        if (createResponse.isSuccess() && createResponse.getData() != null) {
            userList.add(createResponse.getData());
        }
        zjkjTianJianSyncService.syncUserList(userList);
        try {
            String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAOtoOfH7hxj47JmP5e7onbEQxynRZrALJ7lzBR3GTMguWpBpOkLM/4xnNHAeMqPyJmSVg8cF+GotCY/p0ashvEcCAwEAAQ==";
            String publicKeyString = encrypt(createResponse.getData().getUserCode(), publicKey);
            return URLEncoder.encode(publicKeyString);
        } catch (Exception e) {
            logger.info("获取公钥加密信息失败:{}", e);
            throw new BusinessException("获取公钥加密信息失败");
        }
    }

    @Override
    public void tjCallBack(JSONObject param) {
        logger.info("------------用印回调开始-------------");
        String callbackType = param.getString("callbackType");
        String data = param.getString("data");
        String dataString = this.decrypt(data, callBackEncryptKey);
        JSONObject dataJSON = JSONObject.parseObject(dataString);
        /*
        callbackTypes USE_SEAL_AUTHORIZE/用印事项授权
        callbackTypes USE_SEAL_CODE/用印码生成
        callbackTypes USE_SEAL_TASK_SUSPEND/用印任务暂停
        callbackTypes USE_SEAL_TASK_EXPIRED/用印任务过期
        callbackTypes USE_SEAL_TASK_REAUTHORIZE/用印任务重新授权
        callbackTypes USE_SEAL_TASK_END/用印任务结束
        callbackTypes USE_SEAL_MATTER_END/用印事项结束
        callbackTypes USE_SEAL_MATTER_DELETE/用印事项删除
        callbackTypes USE_SEAL_FILE_SUCCESS/水印/二维码文件生成
        callbackTypes USE_SEAL_UNLOCK/解锁用印
        callbackTypes USE_SEAL_COMMON_PROCESS/普通用印盖章
        callbackTypes USE_SEAL_CROSS_PROCESS/骑缝用印盖章
        callbackTypes USE_SEAL_MATTER_ARCHIVE/用印归档完成
        */
        if("USE_SEAL_TASK_END".equals(callbackType)){
            logger.info("USE_SEAL_TASK_END/用印任务结束");
            String applyId = dataJSON.getString("applyId");
            QueryWrapper<SealApprovalEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("tj_print_id", applyId);
            List<SealApprovalEntity> list = this.list(wrapper);
            SealApprovalEntity entity = list.get(0);
            entity.setTjPrintState("用印结束");
            this.saveOrUpdate(entity, false);
        }else if("USE_SEAL_COMMON_PROCESS".equals(callbackType) || "USE_SEAL_CROSS_PROCESS".equals(callbackType)){
            logger.info("USE_SEAL_COMMON_PROCESS/普通用印盖章");
            String applyId = dataJSON.getString("applyId");
            QueryWrapper<SealApprovalEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("tj_print_id", applyId);
            List<SealApprovalEntity> list = this.list(wrapper);
            SealApprovalEntity entity = list.get(0);
            if(!"用印中".equals(entity.getTjPrintState())){
                entity.setTjPrintState("用印中");
                this.saveOrUpdate(entity, false);
            }
        }else{
            logger.info("---------"+callbackType);
        }
        logger.info("------------用印回调结束-------------");
    }

    /**
     * RSA公钥加密
     *
     * @param str       加密字符串
     * @param publicKey 公钥
     * @return 密文
     * @throws Exception 加密过程中的异常信息
     */
    public static String encrypt(String str, String publicKey) throws Exception {
        //base64编码的公钥
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        //RSA加密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes("UTF-8")));
        return outStr;
    }

    public String decrypt(String encryptedText, String encryptKey) {
        // 使用 SHA256 对 Encrypt Key 进行哈希，得到密钥key
        try{
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            byte[] keyBytes =
                    digest.digest(encryptKey.getBytes(StandardCharsets.UTF_8));
            // AES-128 使用前 16 字节
            SecretKey secretKey = new SecretKeySpec(keyBytes, 0, 16,
                    "AES");
            // 解析 base64(iv+encrypted_event)
            byte[] combined = java.util.Base64.getDecoder().decode(encryptedText);
            // 分离 iv 和 encrypted_event
            byte[] iv = new byte[16];
            byte[] encryptedBytes = new byte[combined.length - 16];
            System.arraycopy(combined, 0, iv, 0, 16);
            System.arraycopy(combined, 16, encryptedBytes, 0,
                    encryptedBytes.length);
            // 使用 PKCS5Padding 方式（AES 默认就是 PKCS5Padding）
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            // 使用 iv 和 key 对回调内容解密
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.DECRYPT_MODE, secretKey, ivSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }catch (Exception e){
            logger.info("解析加密数据失败:{}", e);
            throw new BusinessException("解析加密数据失败");
        }
    }
}
