/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.ListFileEntity;
import com.ejianc.foundation.outcontract.service.IListFileService;
import com.ejianc.foundation.outcontract.vo.ListFileVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"listFile"})
public class ListFileController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IListFileService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ListFileVO> saveOrUpdate(@RequestBody ListFileVO saveorUpdateVO) {
        String code;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ListFileEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            String code2;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(saveorUpdateVO.getId());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ListFileEntity::getListCode, (Object)saveorUpdateVO.getListCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            List entities = this.service.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            Integer listCodeLength = saveorUpdateVO.getListCode().length();
            if (listCodeLength == 1 || listCodeLength == 3 || listCodeLength == 5) {
                throw new BusinessException("\u7f16\u7801\u89c4\u8303\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            saveorUpdateVO.setInnerCode(saveorUpdateVO.getListCode());
            if ("01".equals(saveorUpdateVO.getListCode()) && saveorUpdateVO.getListName().contains("\u88c5\u9970")) {
                saveorUpdateVO.setInnerCode("a1");
            }
            if (saveorUpdateVO.getListCode().length() >= 4 && ("0111".equals(code2 = saveorUpdateVO.getListCode().substring(0, 4)) || "0112".equals(code2) || "0113".equals(code2) || "0114".equals(code2) || "0115".equals(code2))) {
                saveorUpdateVO.setInnerCode("a1" + saveorUpdateVO.getListCode().substring(2, saveorUpdateVO.getListCode().length()));
            }
            entity = (ListFileEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ListFileEntity.class));
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ListFileEntity::getListCode, (Object)saveorUpdateVO.getListCode());
        List entities = this.service.list((Wrapper)lambda);
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        Integer listCodeLength = saveorUpdateVO.getListCode().length();
        if (listCodeLength == 1 || listCodeLength == 3 || listCodeLength == 5) {
            throw new BusinessException("\u7f16\u7801\u89c4\u8303\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        HashMap<String, ListFileVO> map = new HashMap<String, ListFileVO>();
        saveorUpdateVO.setInnerCode(saveorUpdateVO.getListCode());
        if ("01".equals(saveorUpdateVO.getListCode()) && saveorUpdateVO.getListName().contains("\u88c5\u9970")) {
            saveorUpdateVO.setInnerCode("a1");
        }
        if (saveorUpdateVO.getListCode().length() >= 4 && ("0111".equals(code = saveorUpdateVO.getListCode().substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
            saveorUpdateVO.setInnerCode("a1" + saveorUpdateVO.getListCode().substring(2, saveorUpdateVO.getListCode().length()));
        }
        map.put(saveorUpdateVO.getInnerCode(), saveorUpdateVO);
        String innercode = saveorUpdateVO.getInnerCode();
        if (innercode.length() != 2) {
            if (innercode.length() == 4) {
                String pcode = innercode.substring(0, 2);
                saveorUpdateVO.setParentId(this.getId(pcode));
            } else if (innercode.length() == 6) {
                String pcode = innercode.substring(0, 4);
                saveorUpdateVO.setParentId(this.getId(pcode));
            } else if (innercode.length() > 6) {
                String pcode = innercode.substring(0, 6);
                saveorUpdateVO.setParentId(this.getId(pcode));
            }
        }
        entity = (ListFileEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ListFileEntity.class));
        entity.setId(IdWorker.getId());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateEn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ListFileVO> updateEn(@RequestBody ListFileVO saveorUpdateVO) {
        return this.service.updateEn(saveorUpdateVO);
    }

    private Long getId(String pcode) {
        LambdaQueryWrapper lam = Wrappers.lambdaQuery();
        lam.eq(ListFileEntity::getInnerCode, (Object)pcode);
        List listFile = this.service.list((Wrapper)lam);
        if (CollectionUtils.isNotEmpty((Collection)listFile)) {
            return ((ListFileEntity)((Object)listFile.get(0))).getId();
        }
        throw new BusinessException("\u7f16\u7801\u89c4\u8303\u9519\u8bef\u672a\u627e\u5230\u7236\u7ea7\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ListFileVO> queryDetail(Long id) {
        ListFileEntity entity = (ListFileEntity)((Object)this.service.selectById(id));
        ListFileVO vo = (ListFileVO)BeanMapper.map((Object)((Object)entity), ListFileVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ListFileVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("listName");
        fuzzyFields.add("listCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("listCode", "asc");
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("listCode");
        fuzzyFields.add("listName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        ArrayList<ListFileVO> vos = new ArrayList<ListFileVO>();
        for (ListFileEntity entity : list) {
            ListFileVO vo = (ListFileVO)BeanMapper.map((Object)((Object)entity), ListFileVO.class);
            if (vo.getState() != null) {
                if (vo.getState() == 0) {
                    vo.setStateName("\u5df2\u505c\u7528");
                }
                if (vo.getState() == 1) {
                    vo.setStateName("\u5df2\u542f\u7528");
                }
            }
            vos.add(vo);
        }
        HashMap<String, ArrayList<ListFileVO>> beans = new HashMap<String, ArrayList<ListFileVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("listFileExcelExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"listFileExcelImport.xlsx", (String)"\u6e05\u5355\u6863\u6848\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ListFileVO> importVOS) {
        return CommonResponse.success((String)((String)this.service.saveImportExcel(request, importVOS)));
    }

    @RequestMapping(value={"/refListFileData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ListFileVO>> refListFileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ListFileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

