/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.service.IOutcontractMaterialService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentLeaseItemVO;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentRentVO;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractTotalPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"outcontract"})
public class OutcontractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String LABOROUTCONTRACT_BILL_CODE = "ZJKJ-LABOROUTCONTRACT";
    private static final String MAJOROUTCONTRACT_BILL_CODE = "ZJKJ-MAJOROUTCONTRACT";
    private static final String MATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-MATERIALOUTCONTRACT";
    private static final String EQUIPMENTOUTCONTRACT_BILL_CODE = "ZJKJ-EQUIPMENTOUTCONTRACT";
    private static final String TURNOVERMATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-TURNOVERMATERIALOUTCONTRACT";
    private static final String DESIGNOUTCONTRACT_BILL_CODE = "ZJKJ-DESIGNOUTCONTRACT";
    private static final String CONSULTANCYOUTCONTRACT_BILL_CODE = "ZJKJ-CONSULTANCYOUTCONTRACT";
    private static final String OTHEROUTCONTRACT = "ZJKJ-OTHEROUTCONTRACT";
    private static final String TOPICPAYOUTCONTRACT = "ZJKJ-TOPICPAYOUTCONTRACT";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${onlyOneProject:null}")
    private String onlyOneProject;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IOutcontractService service;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;
    @Autowired
    private IOutcontractMaterialService outcontractMaterialService;
    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IDefdocApi defdocApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractVO> saveOrUpdate(@RequestBody OutcontractVO saveOrUpdateVO) {
        CommonResponse user;
        String code;
        List codeExit;
        QueryWrapper queryWrapper;
        OutcontractEntity entity = (OutcontractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutcontractEntity.class));
        if (StringUtils.isNotBlank((CharSequence)this.onlyOneProject) && !"null".equals(this.onlyOneProject) && this.onlyOneProject.contains(saveOrUpdateVO.getType())) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"type", (Object)saveOrUpdateVO.getType());
            queryWrapper.eq((Object)"project_id", (Object)saveOrUpdateVO.getProjectId());
            queryWrapper.eq((Object)"contract_name", (Object)saveOrUpdateVO.getContractName());
            queryWrapper.eq((Object)"supplier", (Object)saveOrUpdateVO.getSupplier());
            if (entity.getId() != null) {
                queryWrapper.ne((Object)"id", (Object)entity.getId());
            }
            if ((codeExit = this.service.list((Wrapper)queryWrapper)) != null && codeExit.size() > 0) {
                throw new BusinessException("\u6b64\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u627f\u5305\u7c7b\u578b\u7684\u5408\u540c\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            entity.setBillCode(entity.getBillCode().trim());
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            if (entity.getId() != null) {
                queryWrapper.ne((Object)"id", (Object)entity.getId());
            }
            if ((codeExit = this.service.list((Wrapper)queryWrapper)) != null && codeExit.size() > 0) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            code = "";
            if ("\u52b3\u52a1\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = LABOROUTCONTRACT_BILL_CODE;
            } else if ("\u4e13\u4e1a\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = MAJOROUTCONTRACT_BILL_CODE;
            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(saveOrUpdateVO.getType())) {
                code = MATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u673a\u68b0\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = EQUIPMENTOUTCONTRACT_BILL_CODE;
            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(saveOrUpdateVO.getType())) {
                code = DESIGNOUTCONTRACT_BILL_CODE;
            } else if ("\u54a8\u8be2\u670d\u52a1".equals(saveOrUpdateVO.getType())) {
                code = CONSULTANCYOUTCONTRACT_BILL_CODE;
            } else if ("\u5176\u5b83\u5408\u540c".equals(saveOrUpdateVO.getType())) {
                code = OTHEROUTCONTRACT;
            } else if ("\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(saveOrUpdateVO.getType())) {
                code = TOPICPAYOUTCONTRACT;
            }
            entity.setUserDeptId(this.sessionManager.getUserContext().getDeptId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)code, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else if (saveOrUpdateVO.getUserDeptId() == null && StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getCreateUserCode()) && (user = this.userApi.queryUserByUserCode(saveOrUpdateVO.getCreateUserCode())).isSuccess() && user.getData() != null) {
            entity.setUserDeptId(((UserVO)user.getData()).getDeptId());
        }
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            throw new BusinessException("\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            code = "";
            entity.setChangeState("1");
            entity.setFileState("0");
        }
        if (saveOrUpdateVO.getOutcontractSupplierList() != null && saveOrUpdateVO.getOutcontractSupplierList().size() > 0) {
            OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)saveOrUpdateVO.getOutcontractSupplierList().get(0);
            entity.setSupplierName(outcontractSupplierVO.getSupplierName());
            entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());
            entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());
            entity.setSupplierBank(outcontractSupplierVO.getSupplierBank());
            entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());
            entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser());
            entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress());
            entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone());
            entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail());
            entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal());
            entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone());
        } else {
            entity.setSupplierName(null);
            entity.setSupplierTaxPayerType(null);
            entity.setSupplierSocialCreditCode(null);
            entity.setSupplierBank(null);
            entity.setSupplierBankAccount(null);
            entity.setSupplierContactUser(null);
            entity.setSupplierContactUserAddress(null);
            entity.setSupplierContactUserPhone(null);
            entity.setSupplierContactUserEmail(null);
            entity.setSupplierLegal(null);
            entity.setSupplierTelephone(null);
        }
        if ("\u52b3\u52a1\u5206\u5305".equals(saveOrUpdateVO.getType()) || "\u4e13\u4e1a\u5206\u5305".equals(saveOrUpdateVO.getType())) {
            if (saveOrUpdateVO.getOutcontractSubcontractTotalPriceList() != null && saveOrUpdateVO.getOutcontractSubcontractTotalPriceList().size() > 0) {
                BigDecimal subcontractTotalAmount = new BigDecimal(0);
                for (OutcontractSubcontractTotalPriceVO item : saveOrUpdateVO.getOutcontractSubcontractTotalPriceList()) {
                    if (item.getTotalPrice() == null || "del".equals(item.getRowState())) continue;
                    subcontractTotalAmount = subcontractTotalAmount.add(item.getTotalPrice());
                }
                subcontractTotalAmount = subcontractTotalAmount.setScale(8, 4);
                entity.setSubcontractTotalAmount(subcontractTotalAmount);
            }
            if (saveOrUpdateVO.getOutcontractSubcontractUnitPriceList() != null && saveOrUpdateVO.getOutcontractSubcontractUnitPriceList().size() > 0) {
                List<OutcontractSubcontractUnitPriceVO> list = OutcontractController.createTreeData(saveOrUpdateVO.getOutcontractSubcontractUnitPriceList());
                Object subcontractUnitTotalAmount = new BigDecimal(0);
                for (OutcontractSubcontractUnitPriceVO item : list) {
                    if (item.getTotalPrice() == null || "del".equals(item.getRowState())) continue;
                    subcontractUnitTotalAmount = ((BigDecimal)subcontractUnitTotalAmount).add(item.getTotalPrice());
                }
                subcontractUnitTotalAmount = ((BigDecimal)subcontractUnitTotalAmount).setScale(8, 4);
                entity.setSubcontractUnitTotalAmount((BigDecimal)subcontractUnitTotalAmount);
            }
            if (entity.getSubcontractTotalAmount() != null && entity.getSubcontractUnitTotalAmount() != null) {
                entity.setSubcontractTotalAmount(entity.getSubcontractTotalAmount().setScale(2, 4));
                entity.setSubcontractUnitTotalAmount(entity.getSubcontractUnitTotalAmount().setScale(2, 4));
                if (entity.getSubcontractTotalAmount().compareTo(entity.getSubcontractUnitTotalAmount()) != 0) {
                    this.logger.info("\u5206\u5305\u5de5\u7a0b\u603b\u4ef7\u6c47\u603b\u8868\u5408\u8ba1\u91d1\u989d-------------" + entity.getSubcontractTotalAmount());
                    this.logger.info("\u5206\u5305\u5de5\u7a0b\u7efc\u5408\u5355\u4ef7\u8ba1\u4ef7\u8868\u5408\u8ba1\u91d1\u989d-------------" + entity.getSubcontractUnitTotalAmount());
                    throw new BusinessException("\u5206\u5305\u5de5\u7a0b\u603b\u4ef7\u6c47\u603b\u8868\u5408\u8ba1\u91d1\u989d(" + entity.getSubcontractTotalAmount() + ")\u4e0e\u5206\u5305\u5de5\u7a0b\u7efc\u5408\u5355\u4ef7\u8ba1\u4ef7\u8868\u5408\u8ba1\u91d1\u989d(" + entity.getSubcontractUnitTotalAmount() + ")\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58");
                }
            }
            entity.setContractPrice(entity.getSubcontractTotalAmount());
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(saveOrUpdateVO.getType()) || "\u5468\u8f6c\u6750\u79df\u8d41".equals(saveOrUpdateVO.getType()) || "\u5176\u5b83\u5408\u540c".equals(saveOrUpdateVO.getType()) || "\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(saveOrUpdateVO.getType())) {
            if (saveOrUpdateVO.getOutcontractMaterialList() != null && saveOrUpdateVO.getOutcontractMaterialList().size() > 0) {
                BigDecimal contractPriceTotalAmount = new BigDecimal(0);
                for (OutcontractSubcontractTotalPriceVO item : saveOrUpdateVO.getOutcontractMaterialList()) {
                    if (item.getTotalPrice() == null || "del".equals(item.getRowState())) continue;
                    contractPriceTotalAmount = contractPriceTotalAmount.add(item.getTotalPrice());
                }
                entity.setContractPriceTotalAmount(contractPriceTotalAmount);
                entity.setContractPrice(contractPriceTotalAmount);
            }
        } else if ("\u673a\u68b0\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
            BigDecimal leaseItemTotalAmount = new BigDecimal(0);
            BigDecimal rentTotalAmount = new BigDecimal(0);
            BigDecimal contractPrice = new BigDecimal(0);
            if (saveOrUpdateVO.getOutcontractEquipmentLeaseItemList() != null && saveOrUpdateVO.getOutcontractEquipmentLeaseItemList().size() > 0) {
                for (OutcontractEquipmentLeaseItemVO item : saveOrUpdateVO.getOutcontractEquipmentLeaseItemList()) {
                    if (item.getTotalPrice() == null || "del".equals(item.getRowState())) continue;
                    leaseItemTotalAmount = leaseItemTotalAmount.add(item.getTotalPrice());
                }
            }
            if (saveOrUpdateVO.getOutcontractEquipmentRentList() != null && saveOrUpdateVO.getOutcontractEquipmentRentList().size() > 0) {
                for (OutcontractEquipmentLeaseItemVO item : saveOrUpdateVO.getOutcontractEquipmentRentList()) {
                    if (item.getTotalPrice() == null || "del".equals(item.getRowState())) continue;
                    rentTotalAmount = rentTotalAmount.add(item.getTotalPrice());
                }
            }
            entity.setLeaseItemTotalAmount(leaseItemTotalAmount);
            entity.setRentTotalAmount(rentTotalAmount);
            contractPrice = leaseItemTotalAmount.add(rentTotalAmount);
            entity.setContractPrice(contractPrice);
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        vo.setOutcontractSupplierList(saveOrUpdateVO.getOutcontractSupplierList());
        if (vo.getOutcontractSubcontractUnitPriceList() == null || vo.getOutcontractSubcontractUnitPriceList().size() <= 0) return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutcontractVO> queryDetail(Long id) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(id));
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        ArrayList<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<OutcontractSupplierVO>();
        OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)BeanMapper.map((Object)((Object)entity), OutcontractSupplierVO.class);
        outcontractSupplierVO.setRowState("add");
        outcontractSupplierList.add(outcontractSupplierVO);
        vo.setOutcontractSupplierList(outcontractSupplierList);
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"outcontract_id", (Object)vo.getId());
            List records = this.recordOutcontractService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordOutcontractList(BeanMapper.mapList((Iterable)records, RecordOutcontractVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {
        String sql;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
        fuzzyFields.add("subcontractingContent");
        fuzzyFields.add("agentDeptName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean userSearchFlag = false;
        CommonResponse roleResponse = this.roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if (roleResponse.isSuccess() && roleResponse.getData() != null) {
            for (RoleVO roleVO : (List)roleResponse.getData()) {
                if (!"ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())) continue;
                userSearchFlag = true;
                break;
            }
        }
        if (userSearchFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)this.sessionManager.getUserContext().getUserCode()));
        } else {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
        }
        if (param.getParams() != null && param.getParams().get("advanceCharge") != null) {
            if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)param.getParams().get("advanceCharge")).getValue())) {
                sql = "( (advance_charge != '') and (advance_charge is not null) and (advance_charge != '0') and (advance_charge != '/') and (advance_charge != '\u7a7a') and (advance_charge != '\u65e0') and (advance_charge != '0.00') and (advance_charge != '0%') )";
                param.getParams().put("advanceCharge", new Parameter("sql", (Object)sql));
            } else {
                sql = "( (advance_charge = '') or (advance_charge is null) or (advance_charge = '0') or (advance_charge = '/') or (advance_charge = '\u7a7a') or (advance_charge = '\u65e0') or (advance_charge = '0.00') or (advance_charge = '0%') )";
                param.getParams().put("advanceCharge", new Parameter("sql", (Object)sql));
            }
        }
        if (param.getParams() != null && param.getParams().get("progressPaymentTerms") != null) {
            ComplexParam c12;
            ComplexParam c112;
            ComplexParam c111;
            ComplexParam c122;
            ComplexParam c11;
            ComplexParam c1;
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                param.getParams().put("monthlyPayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().put("nodePayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70\u4ee5\u4e0b")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c11);
                c122 = new ComplexParam();
                c122.setLogic("or");
                c122.getParams().put("nodePayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c122);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70-75")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)70));
                c11.getComplexParams().add(c111);
                c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)75));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                c12 = new ComplexParam();
                c12.setLogic("or");
                ComplexParam c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)70));
                c12.getComplexParams().add(c121);
                ComplexParam c1222 = new ComplexParam();
                c1222.setLogic("and");
                c1222.getParams().put("nodePayment", new Parameter("lt", (Object)75));
                c12.getComplexParams().add(c1222);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("75-80")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)75));
                c11.getComplexParams().add(c111);
                c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)80));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                c12 = new ComplexParam();
                c12.setLogic("or");
                ComplexParam c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)75));
                c12.getComplexParams().add(c121);
                ComplexParam c1223 = new ComplexParam();
                c1223.setLogic("and");
                c1223.getParams().put("nodePayment", new Parameter("lt", (Object)80));
                c12.getComplexParams().add(c1223);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("80\u4ee5\u4e0a")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c11);
                c122 = new ComplexParam();
                c122.setLogic("or");
                c122.getParams().put("nodePayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c122);
                param.getComplexParams().add(c1);
            }
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e") && ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().remove("monthlyPayment");
                param.getParams().remove("nodePayment");
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)0));
                c1.getComplexParams().add(c11);
                c122 = new ComplexParam();
                c122.setLogic("or");
                c122.getParams().put("nodePayment", new Parameter("ge", (Object)0));
                c1.getComplexParams().add(c122);
                param.getComplexParams().add(c1);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        if (param.getParams() != null && param.getParams().get("hasProject") != null) {
            if ("\u662f".equals(((Parameter)param.getParams().get("hasProject")).getValue())) {
                param.getParams().put("projectId", new Parameter("ne", null));
            } else if ("\u5426".equals(((Parameter)param.getParams().get("hasProject")).getValue())) {
                param.getParams().put("projectId", new Parameter("eq", null));
            }
            param.getParams().remove("hasProject");
        }
        if (param.getParams() != null && param.getParams().get("performanceStatus") != null && "\u65e0".equals(((Parameter)param.getParams().get("performanceStatus")).getValue())) {
            sql = "( (performance_status = '') or (performance_status is null) )";
            param.getParams().put("performanceStatus", new Parameter("sql", (Object)sql));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        String sql;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
        fuzzyFields.add("subcontractingContent");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        boolean userSearchFlag = false;
        CommonResponse roleResponse = this.roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if (roleResponse.isSuccess() && roleResponse.getData() != null) {
            for (RoleVO roleVO : (List)roleResponse.getData()) {
                if (!"ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())) continue;
                userSearchFlag = true;
                break;
            }
        }
        if (userSearchFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)this.sessionManager.getUserContext().getUserCode()));
        } else {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
        }
        if (param.getParams() != null && param.getParams().get("advanceCharge") != null) {
            if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)param.getParams().get("advanceCharge")).getValue())) {
                sql = "( (advance_charge != '') and (advance_charge is not null) and (advance_charge != '0') and (advance_charge != '/') and (advance_charge != '\u7a7a') and (advance_charge != '\u65e0') and (advance_charge != '0.00') and (advance_charge != '0%') )";
                param.getParams().put("advanceCharge", new Parameter("sql", (Object)sql));
            } else {
                sql = "( (advance_charge = '') or (advance_charge is null) or (advance_charge = '0')  or (advance_charge = '/') or (advance_charge = '\u7a7a') or (advance_charge = '\u65e0') or (advance_charge = '0.00') or (advance_charge = '0%') )";
                param.getParams().put("advanceCharge", new Parameter("sql", (Object)sql));
            }
        }
        if (param.getParams() != null && param.getParams().get("progressPaymentTerms") != null) {
            ComplexParam c122;
            ComplexParam c121;
            ComplexParam c12;
            ComplexParam c112;
            ComplexParam c111;
            ComplexParam c123;
            ComplexParam c11;
            ComplexParam c1;
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                param.getParams().put("monthlyPayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().put("nodePayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70\u4ee5\u4e0b")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c11);
                c123 = new ComplexParam();
                c123.setLogic("or");
                c123.getParams().put("nodePayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c123);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70-75")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)70));
                c11.getComplexParams().add(c111);
                c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)75));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                c12 = new ComplexParam();
                c12.setLogic("or");
                c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)70));
                c12.getComplexParams().add(c121);
                c122 = new ComplexParam();
                c122.setLogic("and");
                c122.getParams().put("nodePayment", new Parameter("lt", (Object)75));
                c12.getComplexParams().add(c122);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("75-80")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)75));
                c11.getComplexParams().add(c111);
                c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)80));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                c12 = new ComplexParam();
                c12.setLogic("or");
                c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)75));
                c12.getComplexParams().add(c121);
                c122 = new ComplexParam();
                c122.setLogic("and");
                c122.getParams().put("nodePayment", new Parameter("lt", (Object)80));
                c12.getComplexParams().add(c122);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("80\u4ee5\u4e0a")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c11);
                c123 = new ComplexParam();
                c123.setLogic("or");
                c123.getParams().put("nodePayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c123);
                param.getComplexParams().add(c1);
            }
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e") && ((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().remove("monthlyPayment");
                param.getParams().remove("nodePayment");
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)0));
                c1.getComplexParams().add(c11);
                c123 = new ComplexParam();
                c123.setLogic("or");
                c123.getParams().put("nodePayment", new Parameter("ge", (Object)0));
                c1.getComplexParams().add(c123);
                param.getComplexParams().add(c1);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        if (param.getParams() != null && param.getParams().get("performanceStatus") != null && "\u65e0".equals(((Parameter)param.getParams().get("performanceStatus")).getValue())) {
            sql = "( (performance_status = '') or (performance_status is null) )";
            param.getParams().put("performanceStatus", new Parameter("sql", (Object)sql));
        }
        if (param.getParams() != null && param.getParams().get("hasProject") != null) {
            if ("\u662f".equals(((Parameter)param.getParams().get("hasProject")).getValue())) {
                param.getParams().put("projectId", new Parameter("ne", null));
            } else if ("\u5426".equals(((Parameter)param.getParams().get("hasProject")).getValue())) {
                param.getParams().put("projectId", new Parameter("eq", null));
            }
            param.getParams().remove("hasProject");
        }
        List list = this.service.queryList(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        ArrayList<OutcontractVO> vos = new ArrayList<OutcontractVO>();
        String type = "";
        String templateName = "\u627f\u5305\u5408\u540c\u4fe1\u606f";
        String exportXlsx = "outcontract-export.xlsx";
        if (param.getParams() != null && param.getParams().get("type") != null) {
            type = ((Parameter)param.getParams().get("type")).getValue().toString();
        }
        if ("\u52b3\u52a1\u5206\u5305".equals(type)) {
            templateName = "\u52b3\u52a1\u5206\u5305\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u4e13\u4e1a\u5206\u5305".equals(type)) {
            templateName = "\u4e13\u4e1a\u5206\u5305\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(type)) {
            templateName = "\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u673a\u68b0\u79df\u8d41".equals(type)) {
            templateName = "\u673a\u68b0\u79df\u8d41\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(type)) {
            templateName = "\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(type)) {
            templateName = "\u8bbe\u8ba1\u52d8\u5bdf\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u54a8\u8be2\u670d\u52a1".equals(type)) {
            templateName = "\u54a8\u8be2\u670d\u52a1\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u5176\u5b83\u5408\u540c".equals(type)) {
            templateName = "\u5176\u5b83\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(type)) {
            templateName = "\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        }
        for (OutcontractEntity entity : list) {
            OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
            if (vo.getSignDate() != null) {
                vo.setSignDateShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getSignDate()));
            }
            if (vo.getChangeState() != null) {
                if ("1".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u672a\u53d8\u66f4");
                } else if ("2".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u53d8\u66f4\u4e2d");
                } else if ("3".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u5df2\u53d8\u66f4");
                }
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vos.add(vo);
        }
        beans.put("templateName", templateName);
        beans.put("records", vos);
        ExcelExport.getInstance().export(exportXlsx, beans, response);
    }

    @RequestMapping(value={"/refOutcontractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> refOutcontractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getOrderMap().put("createTime", "desc");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"twoOrg") != null && _con.get((Object)"projectDepartmentId") != null) {
            Long projectDepartmentId = _con.getLong("projectDepartmentId");
            CommonResponse orgResponse = this.iOrgApi.detailById(projectDepartmentId);
            if (orgResponse.isSuccess() && orgResponse.getData() != null) {
                String innerCode = ((OrgVO)orgResponse.getData()).getInnerCode();
                String[] orgIds = innerCode.split("\\|");
                if (orgIds.length > 1) {
                    Long twoOrgId = Long.parseLong(orgIds[1]);
                    authOrgIds = twoOrgId.toString();
                }
            } else {
                throw new BusinessException("\u672a\u83b7\u53d6\u4e8c\u7ea7\u7ec4\u7ec7\u4fe1\u606f");
            }
        }
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con2 = JSONObject.parseObject((String)condition);
            if (_con2.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con2.get((Object)"projectId")));
            }
            if (_con2.get((Object)"type") != null) {
                param.getParams().put("type", new Parameter("in", _con2.get((Object)"type")));
            }
            if (_con2.get((Object)"nameType") != null && "1".equals(_con2.get((Object)"nameType").toString())) {
                param.getParams().put("contractName", new Parameter("not_like", (Object)"\u5907\u6848"));
            }
            if (_con2.get((Object)"plProject") != null) {
                CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("pl_project");
                ArrayList equalProjectName = new ArrayList();
                if (defdocResponse.isSuccess() && ((List)defdocResponse.getData()).size() > 0) {
                    ((List)defdocResponse.getData()).forEach(item -> equalProjectName.add(item.getName()));
                }
                if ("1".equals(_con2.get((Object)"plProject").toString())) {
                    param.getParams().put("projectName", new Parameter("in", equalProjectName));
                } else if ("0".equals(_con2.get((Object)"plProject").toString())) {
                    param.getParams().put("projectName", new Parameter("not_in", equalProjectName));
                }
            }
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveintegratedCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractVO> saveintegratedCode(@RequestBody OutcontractVO saveorUpdateVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        vo.setOutcontractSupplierList(saveorUpdateVO.getOutcontractSupplierList());
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e00\u4f53\u5316\u7f16\u7801\u6210\u529f", (Object)vo);
    }

    public static List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
        ArrayList<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<String, OutcontractSubcontractUnitPriceVO>();
        for (OutcontractSubcontractUnitPriceVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            OutcontractSubcontractUnitPriceVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            OutcontractSubcontractUnitPriceVO parent = (OutcontractSubcontractUnitPriceVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((OutcontractSubcontractUnitPriceVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/querySubUnitPriceListByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OutcontractSubcontractUnitPriceVO>> querySubUnitPriceListByContractId(@RequestParam Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.outcontractSubcontractUnitPriceService.list((Wrapper)queryWrapper);
        List<Object> result = new ArrayList();
        if (list != null && list.size() > 0) {
            result = OutcontractController.createTreeData(BeanMapper.mapList((Iterable)list, OutcontractSubcontractUnitPriceVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/queryOutcontractMaterialByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OutcontractMaterialVO>> queryOutcontractMaterialByContractId(@RequestParam Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("outcontractId", new Parameter("eq", (Object)contractId));
        List entitys = this.outcontractMaterialService.queryList(param);
        List list = BeanMapper.mapList((Iterable)entitys, OutcontractMaterialVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)list);
    }

    @RequestMapping(value={"/refOutcontractMaterialList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractMaterialVO>> refOutcontractMaterialList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"contractId") != null) {
            param.getParams().put("outcontractId", new Parameter("eq", _con.get((Object)"contractId")));
        }
        IPage page = this.outcontractMaterialService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRefMaterialCostmanageList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractMaterialVO>> queryRefMaterialCostmanageList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            params.put("searchText", searchText);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                params.put("projectId", _con.get((Object)"projectId"));
            }
        } else {
            throw new BusinessException("\u7f3a\u5c11\u9879\u76eeid\u53c2\u6570");
        }
        IPage<OutcontractMaterialVO> page = this.outcontractMaterialService.queryRefMaterialCostmanageList(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"/refOutcontractEquipmentRentList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractEquipmentRentVO>> refOutcontractEquipmentRentList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentSpec");
        fuzzyFields.add("equipmentUnit");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"contractId") != null) {
            param.getParams().put("outcontractId", new Parameter("eq", _con.get((Object)"contractId")));
        }
        IPage page = this.outcontractEquipmentRentService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractEquipmentRentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/excelImportContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportContract(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<String> errorList;
        List<List<String>> result;
        block56: {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            Long tenantId = InvocationInfoProxy.getTenantid();
            boolean isFailed = false;
            MultipartFile mf = null;
            for (Map.Entry entity : fileMap.entrySet()) {
                mf = (MultipartFile)entity.getValue();
                String originalFileName = mf.getOriginalFilename();
                String extName = null;
                originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFileName.replaceAll("00.", "");
                extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
                if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
                isFailed = true;
                break;
            }
            if (isFailed) {
                return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
            }
            result = ExcelReader.readExcel(mf);
            errorList = new ArrayList<String>();
            if (result == null || result.size() <= 0) break block56;
            HashMap<String, Long> orgMap = new HashMap<String, Long>();
            for (int i = 0; i < result.size(); ++i) {
                OutcontractEntity outcontractVO = new OutcontractEntity();
                try {
                    block55: {
                        CommonResponse orgVO;
                        List<String> datas;
                        block54: {
                            block53: {
                                block58: {
                                    block59: {
                                        CommonResponse supplier;
                                        block57: {
                                            outcontractVO.setChangeState("1");
                                            outcontractVO.setBillState(1);
                                            datas = result.get(i);
                                            outcontractVO.setType(datas.get(0));
                                            String code = "";
                                            if ("\u52b3\u52a1\u5206\u5305".equals(datas.get(0))) {
                                                code = LABOROUTCONTRACT_BILL_CODE;
                                            } else if ("\u4e13\u4e1a\u5206\u5305".equals(datas.get(0))) {
                                                code = MAJOROUTCONTRACT_BILL_CODE;
                                            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(datas.get(0))) {
                                                code = MATERIALOUTCONTRACT_BILL_CODE;
                                            } else if ("\u673a\u68b0\u79df\u8d41".equals(datas.get(0))) {
                                                code = EQUIPMENTOUTCONTRACT_BILL_CODE;
                                            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(datas.get(0))) {
                                                code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
                                            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(datas.get(0))) {
                                                code = DESIGNOUTCONTRACT_BILL_CODE;
                                            } else if ("\u54a8\u8be2\u670d\u52a1".equals(datas.get(0))) {
                                                code = CONSULTANCYOUTCONTRACT_BILL_CODE;
                                            } else if ("\u5176\u5b83\u5408\u540c".equals(datas.get(0))) {
                                                code = OTHEROUTCONTRACT;
                                            }
                                            if (StringUtils.isNotEmpty((CharSequence)datas.get(1))) {
                                                outcontractVO.setBillCode(datas.get(1));
                                            } else {
                                                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
                                                if (billCode.isSuccess()) {
                                                    outcontractVO.setBillCode((String)billCode.getData());
                                                }
                                            }
                                            outcontractVO.setIntegratedCode(datas.get(2));
                                            if (StringUtils.isEmpty((CharSequence)datas.get(3))) {
                                                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                                            } else {
                                                outcontractVO.setProjectName(datas.get(3));
                                                HashMap<String, String> param = new HashMap<String, String>();
                                                param.put("projectName", datas.get(3));
                                                CommonResponse project = this.zjkjProjectApi.queryDetailByparam(param);
                                                if (project.isSuccess() && project.getData() != null) {
                                                    outcontractVO.setProjectId(((ProjectVO)project.getData()).getId());
                                                    outcontractVO.setOrgId(((ProjectVO)project.getData()).getOrgId());
                                                    outcontractVO.setOrgName(((ProjectVO)project.getData()).getOrgName());
                                                    outcontractVO.setProjectDepartmentId(((ProjectVO)project.getData()).getProjectDepartmentId());
                                                } else {
                                                    this.logger.info("\u9879\u76ee\u672a\u83b7\u53d6\u5230,data:{},    msg:{}", project.getData(), (Object)project.getMsg());
                                                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u9879\u76ee\u672a\u83b7\u53d6\u5230\uff01");
                                                    continue;
                                                }
                                            }
                                            outcontractVO.setContractName(datas.get(4));
                                            if (StringUtils.isEmpty((CharSequence)datas.get(4))) {
                                                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                                                continue;
                                            }
                                            outcontractVO.setSupplierName(datas.get(5));
                                            HashMap<String, Object> params = new HashMap<String, Object>();
                                            params.put("name", datas.get(5));
                                            params.put("tenantId", tenantId);
                                            supplier = this.shareSupplierApi.findOneByName(datas.get(5), tenantId);
                                            if (!supplier.isSuccess() || supplier.getData() == null) break block57;
                                            outcontractVO.setSupplier(((SupplierVO)supplier.getData()).getId());
                                            outcontractVO.setSupplierName(((SupplierVO)supplier.getData()).getName());
                                            outcontractVO.setSupplierTaxPayerType(((SupplierVO)supplier.getData()).getTaxPayerType());
                                            if (StringUtils.isNotEmpty((CharSequence)datas.get(6))) {
                                                outcontractVO.setSupplierSocialCreditCode(datas.get(6));
                                            } else {
                                                outcontractVO.setSupplierSocialCreditCode(((SupplierVO)supplier.getData()).getSocialCreditCode());
                                            }
                                            outcontractVO.setSupplierBank(((SupplierVO)supplier.getData()).getBankName());
                                            outcontractVO.setSupplierBankAccount(((SupplierVO)supplier.getData()).getBankAccount());
                                            outcontractVO.setSupplierContactUser(((SupplierVO)supplier.getData()).getLegal());
                                            outcontractVO.setSupplierContactUserAddress(((SupplierVO)supplier.getData()).getArea());
                                            outcontractVO.setSupplierContactUserPhone(((SupplierVO)supplier.getData()).getTelephone());
                                            outcontractVO.setSupplierLegal(((SupplierVO)supplier.getData()).getLegal());
                                            outcontractVO.setSubcontractStatus(datas.get(7));
                                            if (!StringUtils.isNotEmpty((CharSequence)datas.get(8))) break block58;
                                            break block59;
                                        }
                                        this.logger.info("\u4f9b\u65b9\u5355\u4f4d\u672a\u83b7\u53d6\u5230-----------\u300b\u540d\u79f0:{}, msg:{}", (Object)datas.get(5), (Object)supplier.getMsg());
                                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u5355\u4f4d\u672a\u83b7\u53d6\u5230\uff01");
                                        continue;
                                    }
                                    this.logger.info("\u7b7e\u7ea6\u65e5\u671f\uff1a------------->" + datas.get(8));
                                    if (datas.get(8).contains("-")) {
                                        outcontractVO.setSignDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(8)));
                                    } else {
                                        outcontractVO.setSignDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(8)));
                                    }
                                }
                                if (!StringUtils.isEmpty((CharSequence)datas.get(9))) {
                                    outcontractVO.setSignUnitName(datas.get(9));
                                    if (orgMap.get(datas.get(9)) == null) {
                                        orgVO = this.iOrgApi.findByNameAndTenantId(datas.get(9), InvocationInfoProxy.getTenantid());
                                        if (orgVO.isSuccess() && orgVO.getData() != null) {
                                            outcontractVO.setSignUnit(((OrgVO)orgVO.getData()).getId());
                                            orgMap.put(datas.get(9), ((OrgVO)orgVO.getData()).getId());
                                            break block53;
                                        } else {
                                            errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7b7e\u7ea6\u5355\u4f4d\u672a\u83b7\u53d6\u5230\uff01");
                                            continue;
                                        }
                                    }
                                    outcontractVO.setSignUnit((Long)orgMap.get(datas.get(9)));
                                }
                            }
                            if (!StringUtils.isEmpty((CharSequence)datas.get(10))) {
                                outcontractVO.setBuildUnitName(datas.get(10));
                                if (orgMap.get(datas.get(10)) == null) {
                                    orgVO = this.iOrgApi.findByNameAndTenantId(datas.get(10), InvocationInfoProxy.getTenantid());
                                    if (orgVO.isSuccess() && orgVO.getData() != null) {
                                        outcontractVO.setBuildUnit(((OrgVO)orgVO.getData()).getId());
                                        orgMap.put(datas.get(10), ((OrgVO)orgVO.getData()).getId());
                                        break block54;
                                    } else {
                                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b9e\u65bd\u5355\u4f4d\u672a\u83b7\u53d6\u5230\uff01");
                                        continue;
                                    }
                                }
                                outcontractVO.setBuildUnit((Long)orgMap.get(datas.get(10)));
                            }
                        }
                        outcontractVO.setBuildArea(StringUtils.isNotBlank((CharSequence)datas.get(11)) ? new BigDecimal(datas.get(11)) : null);
                        outcontractVO.setSubcontractingContent(datas.get(12));
                        if (StringUtils.isNotEmpty((CharSequence)datas.get(13))) {
                            outcontractVO.setLaborSubcontracteMode(datas.get(13));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)datas.get(14))) {
                            outcontractVO.setLaborSubcontracteMode(datas.get(14));
                        }
                        outcontractVO.setContractPrice(StringUtils.isNotBlank((CharSequence)datas.get(15)) ? new BigDecimal(datas.get(15)) : null);
                        outcontractVO.setContractAreaUnitPrice(StringUtils.isNotBlank((CharSequence)datas.get(16)) ? new BigDecimal(datas.get(16)) : null);
                        outcontractVO.setPricingForm(datas.get(17));
                        outcontractVO.setAdvanceCharge(datas.get(18));
                        outcontractVO.setMonthlyPayment(StringUtils.isNotBlank((CharSequence)datas.get(19)) ? new BigDecimal(datas.get(19)) : null);
                        outcontractVO.setNodePayment(StringUtils.isNotBlank((CharSequence)datas.get(20)) ? new BigDecimal(datas.get(20)) : null);
                        outcontractVO.setPaymentProportion(StringUtils.isNotBlank((CharSequence)datas.get(21)) ? new BigDecimal(datas.get(21)) : null);
                        outcontractVO.setAfterCompletionPayment(datas.get(22));
                        outcontractVO.setBalancePayment(datas.get(23));
                        outcontractVO.setWarrantyDeposit(datas.get(24));
                        outcontractVO.setPerformanceStatus(datas.get(25));
                        if (StringUtils.isNotEmpty((CharSequence)datas.get(26))) {
                            this.logger.info("\u8fdb\u573a\u65e5\u671f\uff1a------------->" + datas.get(26));
                            if (datas.get(26).contains("-")) {
                                outcontractVO.setMobilizationDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(26)));
                            } else {
                                outcontractVO.setMobilizationDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(26)));
                            }
                        }
                        if (StringUtils.isNotEmpty((CharSequence)datas.get(27))) {
                            this.logger.info("\u9000\u573a\u65e5\u671f\uff1a------------->" + datas.get(27));
                            if (datas.get(27).contains("-")) {
                                outcontractVO.setExitDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(27)));
                            } else {
                                outcontractVO.setExitDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(27)));
                            }
                        }
                        outcontractVO.setAdoptText(datas.get(28));
                        outcontractVO.setQualityStandard(datas.get(29));
                        outcontractVO.setRemark(datas.get(30));
                        if (StringUtils.isNotEmpty((CharSequence)datas.get(31))) {
                            outcontractVO.setOrgName(datas.get(31));
                            if (orgMap.get(datas.get(31)) == null) {
                                orgVO = this.iOrgApi.findByNameAndTenantId(datas.get(31), InvocationInfoProxy.getTenantid());
                                if (orgVO.isSuccess() && orgVO.getData() != null) {
                                    outcontractVO.setOrgId(((OrgVO)orgVO.getData()).getId());
                                    orgMap.put(datas.get(31), ((OrgVO)orgVO.getData()).getId());
                                    break block55;
                                } else {
                                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6240\u5c5e\u7ec4\u7ec7\u672a\u83b7\u53d6\u5230\uff01");
                                    continue;
                                }
                            }
                            outcontractVO.setOrgId((Long)orgMap.get(datas.get(18)));
                        }
                    }
                    this.service.saveOrUpdate((Object)outcontractVO, false);
                    continue;
                }
                catch (Exception e) {
                    errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                    this.logger.error("\u5bfc\u5165\u5f02\u5e38-------------\u300b{}", (Throwable)e);
                }
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @GetMapping(value={"/changePerformanceStatus"})
    @ResponseBody
    public CommonResponse<String> changePerformanceStatus(@RequestParam(value="id") Long id, @RequestParam(value="performanceStatus") String performanceStatus) {
        return this.service.changePerformanceStatus(id, performanceStatus);
    }

    @GetMapping(value={"/changeDate"})
    @ResponseBody
    public CommonResponse<String> changeDate(@RequestParam(value="id") Long id, @RequestParam(value="type") String type, @RequestParam(value="date") Date date) {
        return this.service.changeDate(id, type, date);
    }

    @RequestMapping(value={"/file"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> file(@RequestBody OutcontractVO outcontractVO) {
        return this.service.file(outcontractVO);
    }

    @RequestMapping(value={"/refSupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractSupplierVO>> refSupplierList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        long startLine = (pageNumber < 1 ? 0 : pageNumber - 1) * pageSize;
        params.put("startLine", startLine);
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                params.put("projectId", _con.get((Object)"projectId"));
            }
            if (_con.get((Object)"contractId") != null) {
                params.put("contractId", _con.get((Object)"contractId"));
            }
            if (_con.get((Object)"type") != null) {
                String[] types = _con.getString("type").split(",");
                params.put("type", new ArrayList<String>(Arrays.asList(types)));
            }
        }
        IPage<OutcontractSupplierVO> page = this.service.refSupplierList(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", page);
    }
}

