package com.ejianc.foundation.sealApproval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class ZjkjTianJianSyncServiceImpl implements IZjkjTianJianSyncService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${tianjianUrl:http://36.137.93.200:10006/open_api}")
	private String tianjianUrl;
	@Autowired
	private ISealApprovalService sealApprovalService;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IUserApi userApi;

	@Override
	public void syncSeal(Long sealId) {
		SealApprovalEntity sealEntity = sealApprovalService.selectById(sealId);
		if(!(StringUtils.isNotBlank(sealEntity.getContractSeal()) && "contractSeal".equals(sealEntity.getContractSeal()))){
			//是合同章
			return;
		}
		//获取申请部门的所属组织，并判断是否是集团的
		Long applyDept = sealEntity.getApplyDept();
		CommonResponse<DeptVO> deptResponse = orgApi.findDeptById(applyDept);
		if(deptResponse.isSuccess() && deptResponse.getData()!=null){
			DeptVO dept = deptResponse.getData();
			CommonResponse<OrgVO> orgResponse = orgApi.detailById(dept.getOrgId());
			if(orgResponse.isSuccess() && orgResponse.getData()!=null){
				OrgVO org = orgResponse.getData();
				if(org.getOrgType()==1&&!org.getInnerCode().contains("|")){
					this.syncOrgList(org);
				}else{
					return;
				}
			}
		}
		List<UserVO> userList = new ArrayList<>();
		Long sendId = null;
		Long sealUserId = null;
		//获取创建人
		CommonResponse<UserVO> createResponse = userApi.queryUserByUserCode(sealEntity.getCreateUserCode());
		if(createResponse.isSuccess() && createResponse.getData()!=null){
			userList.add(createResponse.getData());
			sendId = createResponse.getData().getId();
		}
		if(!sendId.equals(sealEntity.getEmployeeId())){
			//获取经办人
			CommonResponse<UserVO> employeeResponse = userApi.findUserByUserId(sealEntity.getEmployeeId());
			if(employeeResponse.isSuccess() && employeeResponse.getData()!=null){
				userList.add(employeeResponse.getData());
				sealUserId = employeeResponse.getData().getId();
			}
		}else{
			sealUserId = sendId;
		}
		this.syncUserList(userList);

		this.syncSeal(sendId, sealUserId, sealEntity);
	}

	@Override
	public void syncOrgList(OrgVO org) {
		List<JSONObject> deptList = new ArrayList<>();
		JSONObject d = new JSONObject();
		if("1247777316689256450".equals(org.getId().toString())){
			return;
		}
		d.put("id", org.getId().toString());
		d.put("name", org.getName());
		d.put("parentId", org.getParentId()!=null?(org.getParentId().toString().equals("1247777316689256450")?"1": org.getParentId().toString()):"0");
		d.put("orgType", 2);
		deptList.add(d);
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/depart/sync";
			JSONObject params = new JSONObject();
			params.put("deptList", deptList);
			logger.info("组织同步数据参数：-------------{}",params.toJSONString());
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("组织同步数据返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("组织同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("组织同步数据失败");
		}
	}

	@Override
	public void syncUserList(List<UserVO> users) {
		List<JSONObject> userList = new ArrayList<>();
		for (UserVO user : users) {
			JSONObject d = new JSONObject();
			d.put("id", user.getId().toString());
			d.put("username", user.getUserCode());
			d.put("realname", user.getUserName());
			d.put("phone", user.getUserMobile());
			List<JSONObject> deptList = new ArrayList<>();
			JSONObject org = new JSONObject();
			String orgId = user.getOrgId().toString();
			if("1247777316689256450".equals(user.getOrgId().toString())){
				orgId = "1";
			}
			org.put("id", orgId);
			deptList.add(org);
			d.put("deptList", deptList);
			JSONObject defaultOrg = new JSONObject();
			defaultOrg.put("id", orgId);
			d.put("defaultDept", defaultOrg);
			d.put("email", user.getUserEmail());
			userList.add(d);
		}
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/user/sync";
			JSONObject params = new JSONObject();
			params.put("userList", userList);
			logger.info("人员同步数据参数：-------------{}",params.toJSONString());
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			JSONObject jsonResponse = JSON.parseObject(backData);
			logger.info("人员同步数据返回数据：-------------{}",backData);
			if("0".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("人员同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("人员同步数据失败");
		}
	}

	@Override
	public void syncSeal(Long sendId, Long sealUserId, SealApprovalEntity sealEntity){
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/use_seal/authorize";
			JSONObject params = new JSONObject();
			params.put("applyUserId", sendId.toString());
			List<String> useSealUserIdList = new ArrayList<>();
			useSealUserIdList.add(sealUserId.toString());
			params.put("useSealUserIdList", useSealUserIdList);
			List<JSONObject> sealDetailList = new ArrayList<>();
			JSONObject sealDetail = new JSONObject();
			sealDetail.put("applyCount", sealEntity.getSealCount()+30);
			sealDetail.put("applyCrossPageSealCount", sealEntity.getPageSeal()+30);
			sealDetail.put("sealId", "7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
			sealDetailList.add(sealDetail);
			params.put("sealDetailList", sealDetailList);
			params.put("title ", "合同：【"+sealEntity.getContractName()+"】，申请用章");
			params.put("billNo", sealEntity.getBillCode());
			params.put("remark", sealEntity.getSealReasons());
			JSONObject policy = new JSONObject();
			List<Integer> num = new ArrayList<>();
			num.add(1);
			policy.put("videoRecordSealModel", num);
			policy.put("videoRecordCrossModel", num);
			policy.put("videoRecordWrongModel", num);
			params.put("policy", policy);
			logger.info("用印同步数据参数：-------------{}",params.toJSONString());

			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("用印同步返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				String applyId = data.getString("applyId");
				JSONArray safeCodeList = data.getJSONArray("safeCodeList");
				JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
				String safeCode = safeCodeJSON.getString("safeCode");
				sealEntity.setTjPrintId(applyId);
				sealEntity.setTjPrintCode(safeCode);
				sealApprovalService.saveOrUpdate(sealEntity, false);
			}else{
				throw new BusinessException("用印同步失败");
			}
		}catch (Exception e){
			logger.info("用印同步失败:{}",e);
			throw new BusinessException("用印同步失败");
		}
	}

	@Override
	public String getToken() {
		String token = "";
		try{
			String url = tianjianUrl + "/token/get";
			JSONObject params = new JSONObject();
			params.put("restname", "root");
			params.put("password", "Zj@kj#qunje");
			String backData = HttpTookit.postByJson(url, params.toJSONString());
			logger.info("获取token返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				token = data.getString("token");
			}else{
				throw new BusinessException("获取token失败");
			}
		}catch (Exception e){
			throw new BusinessException("获取token失败");
		}
		return token;
	}
}
