/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.calibration.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.mapper.CalibrationMapper;
import com.ejianc.foundation.calibration.service.ICalibrationService;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="calibrationService")
public class CalibrationServiceImpl
extends BaseServiceImpl<CalibrationMapper, CalibrationEntity>
implements ICalibrationService {
    @Autowired
    private IYzwSyncService yzwSyncService;

    @Override
    public void syncList(String beginTime, String endTime) {
        List<String> idList = this.yzwSyncService.queryTenderCompletedList(beginTime, endTime);
        if (idList != null && idList.size() > 0) {
            List<JSONObject> listJson = this.yzwSyncService.getTenderCompletedList(idList);
            ArrayList<CalibrationEntity> list = new ArrayList<CalibrationEntity>();
            for (JSONObject jsonObject : listJson) {
                CalibrationEntity entity = new CalibrationEntity();
                entity.setYsNo(jsonObject.getString("ysNo"));
                entity.setTenderCode(jsonObject.getString("tenderCode"));
                entity.setName(jsonObject.getString("name"));
                entity.setOrganizationSysNo(jsonObject.getString("organizationSysNo"));
                entity.setOrganizationCode(jsonObject.getString("organizationCode"));
                entity.setOrganizationName(jsonObject.getString("organizationName"));
                entity.setContractType(jsonObject.getString("contractType"));
                entity.setSystemCategoryType(jsonObject.getString("systemCategoryType"));
                if (jsonObject.get((Object)"amount") != null) {
                    entity.setAmount(jsonObject.getBigDecimal("amount"));
                }
                if (jsonObject.get((Object)"calibrationResultNoticeDate") != null) {
                    entity.setCalibrationResultNoticeDate(new Date(jsonObject.getString("calibrationResultNoticeDate")));
                }
                entity.setTenderType(jsonObject.getString("tenderType"));
                entity.setStatus(jsonObject.getString("status"));
                list.add(entity);
            }
            this.saveOrUpdateBatch(list, list.size(), false);
        }
    }
}

