package com.ejianc.foundation.yzwSync.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.foundation.yzwSync.util.AESUtil;
import com.ejianc.foundation.yzwSync.util.DataToYzwUtil;
import com.ejianc.foundation.yzwSync.util.DataToYzwUtil1;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 云筑网同步
 *
 * @author generator
 */
@Service("yzwSyncService")
public class YzwSyncServiceImpl implements IYzwSyncService {

    @Value("${yzwSignUrl:https://zyq-rpc.yzwqa.cn/api/e-sign/rpc}")
    private String yzwSignUrl;
    @Value("${yzwUrl1:http://api.jc.yzw.cn/open.api}")
    private String yzwUrl1;
    @Value("${yzwVersion:1.0}")
    private String yzwVersion;
    @Value("${yzwAppKey1:T000101000111}")
    private String yzwAppKey1;
    @Value("${yzwAppSecret1:1d0b5e85a2ed4f5cbc4b7b50736dd666}")
    private String yzwAppSecret1;
    @Value("${yzwUrl2:https://open.yzw.cn/api}")
    private String yzwUrl2;
    @Value("${yzwAppKey:wFpnPZ1g}")
    private String yzwAppKey2;
    @Value("${yzwAppSecret:8jh2lzg9ccrlrbjndp775xjjqb84fe3w}")
    private String yzwAppSecret2;
    @Autowired
    private  IAttachmentApi attachmentApi;
    @Autowired
    private IShareSupplierApi supplierApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private EnvironmentTools environmentTools;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void getData(){

    }

    //读取招标任务列表
    @Override
    public List<String> queryTenderCompletedList(String beginTime, String endTime){
        List<String> listJson = new ArrayList<>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("CalibrationDateBegin", beginTime);
        queryListJson.put("CalibrationDateEnd", endTime);
        queryListJson.put("LimitRows", 100);
        String method = "BaseData.QueryTenderCompletedList";
        boolean flag = true;
        int pageNumber = 1;
        try {
            while (flag) {
                queryListJson.put("PageIndex", pageNumber);
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("读取招标任务列表结果：" );
                logger.info(response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                    JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        listJson.add(jsonObject.getString("SysNo"));
                    }
                    if(jsonArray.size() < 100){
                        logger.info("normal end pageNumber is "  + pageNumber);
                        flag = false;
                    }
                }else{
                    flag = false;
                    logger.info(respone.toJSONString());
                    logger.info("no data pageNumber is "  + pageNumber);
                }
                pageNumber++;
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        return listJson;
    }

    //读取招标任务详情
    @Override
    public List<JSONObject> getTenderCompletedList(List<String> idList){
        List<JSONObject> listJson = new ArrayList<>();
        //10条一次
        Map<Integer, List<String>> idMap = new HashMap<>();
        for (int i=0; i<idList.size(); i++) {
            String id = idList.get(i);
            Integer index = i/10;
            List<String> ids = idMap.get(index);
            if(ids!=null){
                ids.add(id);
            }else{
                ids = new ArrayList<>();
                ids.add(id);
            }
            idMap.put(index, ids);
        }
        for (Integer index : idMap.keySet()) {
            List<String> ids = idMap.get(index);
            JSONObject queryListJson = new JSONObject();
            queryListJson.put("SysNoList", ids);
            String method = "BaseData.GetTenderCompletedList";
            try {
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("query list result is" + response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONArray("Data")){
                    JSONArray jsonArray = respone.getJSONArray("Data");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        listJson.add(jsonObject);
                    }
                }else{
                    logger.info(respone.toJSONString());
                }
            } catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return listJson;
    }

    //查询供应商投标详情
    @Override
    public List<JSONObject> getTenderSupplierBidDetailList(List<String> SupplierSysNos){
        List<JSONObject> list = new ArrayList<>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("LimitRows", 100);
        queryListJson.put("SupplierSysNoList", SupplierSysNos);
        String method = "BaseData.GetSupplierList";
        boolean flag = true;
        int pageNumber = 1;
        try {
            while (flag) {
                queryListJson.put("PageIndex", pageNumber);
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("读取招标任务列表结果：" );
                logger.info(response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                    JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        list.add(jsonObject);
                    }
                    if(jsonArray.size() < 100){
                        logger.info("normal end pageNumber is "  + pageNumber);
                        flag = false;
                    }
                }else{
                    flag = false;
                    logger.info(respone.toJSONString());
                    logger.info("no data pageNumber is "  + pageNumber);
                }
                pageNumber++;
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        return list;
    }

    //合同同步
    @Override
    public JSONObject syncContract(OutcontractEntity entity){
        JSONObject result = new JSONObject();
        JSONObject param = new JSONObject();
        BigDecimal amount = new BigDecimal(0);
        CommonResponse<ProjectVO> projectResponse = zjkjProjectApi.queryDetailById(entity.getProjectId());
        ProjectVO projectVO = null;
        if(projectResponse.isSuccess() && projectResponse.getData()!=null){
            projectVO = projectResponse.getData();
        }else{
            throw new BusinessException("未获取到项目信息");
        }
        String yzwProjectCode = projectVO.getYzwProjectCode();
        String yzwUser = projectVO.getYzwUser();
        if(StringUtils.isBlank(yzwProjectCode)){
            yzwProjectCode = "yzwProjectCode";
//            throw new BusinessException("项目未关联云筑网数据");
        }
        if(StringUtils.isBlank(yzwUser)){
            yzwUser = "ceshi";
//            throw new BusinessException("项目人员未关联云筑网数据");
        }
        String buildUnit = null;
        if(entity.getBuildUnit()!=null){
            CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getBuildUnit());
            if(orgResponse.isSuccess() && orgResponse.getData()!=null){
                buildUnit = orgResponse.getData().getYzwOrgCode();
                if(StringUtils.isBlank(buildUnit)){
                    buildUnit = "orgCode";
//                    throw new BusinessException("实施单位未关联云筑网数据");
                }
            }
        }
        String signUnit = null;
        if(entity.getSignUnit()!=null){
            if(entity.getBuildUnit()!=entity.getSignUnit()){
                CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getSignUnit());
                if(orgResponse.isSuccess() && orgResponse.getData()!=null){
                    signUnit = orgResponse.getData().getYzwOrgCode();
                    if(StringUtils.isBlank(signUnit)){
                        signUnit = "orgCode";
//                        throw new BusinessException("签约单位未关联云筑网数据");
                    }
                }
            }else{
                signUnit = buildUnit;
            }
        }
        String partyBCompanyId = null;
        if(entity.getSupplier()!=null){
            CommonResponse<SupplierVO> supplierResponse = supplierApi.queryById(entity.getSupplier());
            if(supplierResponse.isSuccess() && supplierResponse.getData()!=null){
                partyBCompanyId = supplierResponse.getData().getYzwSupplierCode();
            }
            if(StringUtils.isBlank(partyBCompanyId)){
                partyBCompanyId = "supplierCode";
//                throw new BusinessException("供应商未关联云筑网数据");
            }
        }
        String leaseFlag = "否";
        if("劳务分包".equals(entity.getType())){
            amount = entity.getSubcontractTotalAmount();
        }else if("专业分包".equals(entity.getType())){
            amount = entity.getSubcontractTotalAmount();
        }else if("物资采购".equals(entity.getType())){
            amount = entity.getContractPriceTotalAmount();
        }else if("机械租赁".equals(entity.getType())){
            amount = entity.getLeaseItemTotalAmount();
            leaseFlag = "是";
        }else if("周转材租赁".equals(entity.getType())){
            amount = entity.getContractPriceTotalAmount();
            leaseFlag = "是";
        }else if("设计勘察".equals(entity.getType())){
            amount = entity.getContractPrice();
        }else if("咨询服务".equals(entity.getType())){
            amount = entity.getContractPrice();
        }else if("其它合同".equals(entity.getType())){
            amount = entity.getContractPrice();
        }else if("课题支出类合同".equals(entity.getType())){
            amount = entity.getContractPrice();
        }

        param.put("amount", amount);//合同金额
        param.put("categoryCode", "招标采购合同");//合同类型      招标采购合同;招标框架协议;  无招标采购合同；无招标框架协议;招标执行合同;无招标执行合同
        param.put("createUserId", yzwUser);//创建人Id(项目上配置一个字段，云筑用户id，一个项目固定一个人)
        param.put("currency", "CNY");//币种
        param.put("customNo", entity.getBillCode());//合同编号
        if(entity.getMobilizationDate()!=null){
            param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getMobilizationDate()));//合同开始日期
        }
        if(entity.getExitDate()!=null){
            param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getExitDate()));//合同结束日期
        }
        param.put("name", entity.getContractName());//合同名称

        param.put("organizationList", buildUnit);//实施单位---中建科技在云筑内组织id
        param.put("partyACode", signUnit);//签约单位	中建科技在云筑内组织id
        param.put("partyAManagerId", yzwUser);//甲方经办人Id:项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
        param.put("partyBCompanyId", partyBCompanyId);//中标供应商的id	供应商	供应商对应的云筑ID
        param.put("projectListId", yzwProjectCode);//合同项目	项目	项目对应的云筑ID
        param.put("remark", entity.getRemark());//备注
        param.put("settlementAfterInspection", "否");//是否收验货后结算
        param.put("signOrgName", entity.getSignUnitName());//甲方名称	签约单位
        if(entity.getSignDate()!=null){
            param.put("signTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getSignDate()));//签约日期
        }
        param.put("status", "已上架");//合同状态	固定值	SHELF_ON=已上架,、已归档
        param.put("sysNo", entity.getBillCode());//合同编号
        param.put("tenderCode", entity.getCalibrationTenderCode());//云筑招标编号
        param.put("thirdPartyId", entity.getId().toString());//合同ID
        param.put("updateUserId", yzwUser);//创建人Id	项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
        param.put("paymentMethod", "INSTALLMENTS");//付款方式 ONE_TIME=一次性付款;INSTALLMENTS=分期付款;OTHER=其它;
        String pricingMethod = null;
        switch (entity.getPricingForm()) {
            case "按建筑面积平米的每平米固定单价":
            case "按实体工程量对应的固定单价":
            case "按承包合同价款让利费率下浮":
            case "固定单价":
            case "可调价格":
                pricingMethod = "UNIT_PRICE";//单价合同
                break;
            case "固定总价":
                pricingMethod = "LUMP_SUM";//总价合同
                break;
            case "定额计价":
            case "其他":
                pricingMethod = "OTHER";//其他形式合同
                break;
        }
        param.put("pricingMethod", pricingMethod);//计价方式 LUMP_SUM=总价合同;UNIT_PRICE=单价合同;COST_PLUS=成本加酬金合同;OTHER=其他形式合同;
        param.put("leaseFlag", leaseFlag);//根据合同类型判断	周材租赁，设备租赁传“是”

//        param.put("frameworkOpenSysNo", );//框架协议openSysNo编号
//
//
//        param.put("majorOpenSysNo", );//主合同openSysNo编号
//        param.put("majorSysNo", );//主合同编号


//        param.put("otherAttachmentList", );//其他附件说明（参数详情见otherAttachmentList）

        param.put("signType", "主合同");//合同签订类型	固定值	主合同，变更合同，补充协议，解除合同
        param.put("signWay", "电子签章");//签章方式	固定值/签章方式	线上电子签章，线下签章

//        param.put("signedAttachmentList", );//已签章附件（参数详情见signedAttachmentList）
        if("劳务分包".equals(entity.getType()) || "专业分包".equals(entity.getType())){
            JSONArray listData = this.dealListData(entity.getOutcontractSubcontractUnitPriceList());
            param.put("listData", listData);//
        }

        JSONObject queryListJson = new JSONObject();
        queryListJson.put("data", param);
        String method = "pintegration.ecc.contract.standard.create";
        try {
            String response = DataToYzwUtil.queryByYzw(queryListJson,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
            logger.info("query list result is" + response);
            JSONObject respone = JSONObject.parseObject(response);
            if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                JSONArray jsonArrayjsonArray = respone.getJSONArray("Data");
                result = jsonArrayjsonArray.getJSONObject(0);
            }else{
                logger.info(respone.toJSONString());
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        return result;
    }

    private JSONArray dealListData(List<OutcontractSubcontractUnitPriceEntity> unitPriceList) {
        JSONArray listData = new JSONArray();

        JSONObject data = new JSONObject();
        data.put("listName", "分包工程综合单价计价清单");
        data.put("source", "yql");
        data.put("listType", "PRODUCT");
        data.put("priceTaxSeparation", true);
        data.put("quoteType", "FLOAT");
        data.put("systemCategory", "0001");
        JSONArray columns = new JSONArray();
        columns.add(this.createColumn("listCode","清单编号","TEXT",1));
        columns.add(this.createColumn("project","项目","TEXT",2));
        columns.add(this.createColumn("jobContent","工作内容","TEXT",3));
        columns.add(this.createColumn("projectCharacteristic","项目特征","TEXT",4));
        columns.add(this.createColumn("unit","单位","TEXT",5));
        columns.add(this.createColumn("engineeringQuantity","工程量","NUMBER",6));
        columns.add(this.createColumn("comprehensiveUnitPrice","综合单价","NUMBER",7));
        columns.add(this.createColumn("totalPrice","合计","NUMBER",8));
        columns.add(this.createColumn("laborCost","人工费","NUMBER",9));
        columns.add(this.createColumn("mainMaterialCost","主材费","NUMBER",10));
        columns.add(this.createColumn("materialLoss","材料损耗","NUMBER",11));
        columns.add(this.createColumn("auxiliaryMaterialCost","辅材费","NUMBER",12));
        columns.add(this.createColumn("machineryCost","机械费","NUMBER",13));
        columns.add(this.createColumn("managementCost","管理费","NUMBER",14));
        columns.add(this.createColumn("profit","利润","NUMBER",15));
        columns.add(this.createColumn("paidGovernmentCost","规费","NUMBER",16));
        columns.add(this.createColumn("tax","税金","NUMBER",17));
        columns.add(this.createColumn("mainMaterialBrand","主材品牌","TEXT",18));
        columns.add(this.createColumn("remark","备注","TEXT",19));
        data.put("columns", columns);

        JSONArray instance = new JSONArray();
        for (OutcontractSubcontractUnitPriceEntity vo : unitPriceList) {
            JSONObject ins = new JSONObject();
            ins.put("listCode", vo.getListCode());
            ins.put("project", vo.getProject());
            ins.put("jobContent", vo.getJobContent());
            ins.put("projectCharacteristic", vo.getProjectCharacteristic());
            ins.put("unit", vo.getUnit());
            ins.put("engineeringQuantity", vo.getEngineeringQuantity());
            ins.put("comprehensiveUnitPrice", vo.getComprehensiveUnitPrice());
            ins.put("totalPrice", vo.getTotalPrice());
            ins.put("laborCost", vo.getLaborCost());
            ins.put("mainMaterialCost", vo.getMainMaterialCost());
            ins.put("materialLoss", vo.getMaterialLoss());
            ins.put("auxiliaryMaterialCost", vo.getAuxiliaryMaterialCost());
            ins.put("machineryCost", vo.getMachineryCost());
            ins.put("profit", vo.getProfit());
            ins.put("paidGovernmentCost", vo.getPaidGovernmentCost());
            ins.put("tax", vo.getTax());
            ins.put("mainMaterialBrand", vo.getMainMaterialBrand());
            ins.put("remark", vo.getRemark());
            instance.add(ins);
        }
        data.put("instance", instance);
        return listData;
    }

    private JSONObject createColumn(String columnCode, String columnName, String valueType, Integer sortIndex){
        JSONObject column = new JSONObject();
        column.put("columnCode", columnCode);
        column.put("columnName", columnName);
        column.put("valueType", valueType);
        column.put("sortIndex", sortIndex);
        return column;
    }

    @Override
    public void uploadYzwSign(Long contractId, String fileId) {
        CommonResponse<AttachmentVO> attachmentResponse = attachmentApi.queryDetail(fileId);
        if(attachmentResponse.isSuccess() && attachmentResponse.getData()!=null){
            String fileName = attachmentResponse.getData().getFileName();
            String fileType = fileName.split("\\.")[1];
            String downloadUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/no_auth/download?fileId="+fileId;
            byte[] fileData = null;
            try{
                // 获取文件大小
                URL download = new URL(downloadUrl);
                HttpURLConnection conn = (HttpURLConnection) download.openConnection();
                conn.setRequestMethod("HEAD");
                // 下载文件
                InputStream in = new BufferedInputStream(download.openStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                fileData = out.toByteArray();
            }catch (Exception e){
                throw new BusinessException("获取文件失败");
            }
            String signature = null;
            try{
                signature = AESUtil.signature(yzwAppSecret1, yzwAppKey1, InvocationInfoProxy.getUsercode());
            }catch (Exception e){
                throw new BusinessException("生成签名信息失败");
            }
            String attachmentId = null;
            try{
                String url = yzwSignUrl + "/open/v1/attachment/uploadFile2Pdf";
                JSONObject params = new JSONObject();
                params.put("signature", signature);
                params.put("appId", yzwAppKey1);
                params.put("openUId", InvocationInfoProxy.getUsercode());
                JSONObject body = new JSONObject();
                body.put("fileName", fileName);
                body.put("fileData", fileData);
                body.put("fileType", fileType);
                params.put("body", body);
                String response = HttpTookit.postByJson(url, params.toJSONString(), null);
                logger.info("上传云筑文件返回结果："+response);
                JSONObject respone = JSONObject.parseObject(response);
                if("200".equals(respone.getString("code"))){
                    JSONObject data = respone.getJSONObject("data");
                    attachmentId = data.getString("attachmentId");
                }else{
                }
            }catch (Exception e){
                throw new BusinessException("上传文件失败");
            }

            OutcontractEntity outcontract = outcontractService.selectById(contractId);
            try{
                String url = yzwSignUrl + "/open/v1/contract/create";
                JSONObject params = new JSONObject();
                params.put("signature", signature);
                params.put("appId", yzwAppKey1);
                params.put("openUId", InvocationInfoProxy.getUsercode());
                JSONObject body = new JSONObject();
                body.put("name", outcontract.getContractName());
                body.put("businessCode", outcontract.getId());
                body.put("businessSourceCode", outcontract.getBillCode());
                body.put("sourceType", 46);
                body.put("contractType", 46);
                JSONArray fileList = new JSONArray();
                JSONObject file = new JSONObject();
                file.put("name", fileName);
                file.put("attachmentId", attachmentId);
                file.put("originSourceCode", fileId);
                fileList.add(file);
                body.put("fileList", fileList);
                params.put("body", body);

                String response = HttpTookit.postByJson(url, params.toJSONString(), null);
                logger.info("云筑签章返回结果："+response);
                JSONObject respone = JSONObject.parseObject(response);
                if("200".equals(respone.getString("code"))){
                    String data = respone.getString("data");
                    outcontract.setYzwSignCode(data);
                    outcontractService.saveOrUpdate(outcontract, false);
                }else{
                    throw new BusinessException("云筑签章创建失败");
                }
            }catch (Exception e){
                throw new BusinessException("上传文件失败");
            }

        }

    }

    public static void main(String[] args) {
        String yzwSignUrl = "https://zyq-gw.yzwqa.cn/api/e-sign-rpc";
        String yzwAppKey1 = "T000101000111";
        String yzwAppSecret1 = "1d0b5e85a2ed4f5cbc4b7b50736dd666";
        String fileId = "643025753093062723";
        String fileName = "合同上传测试文件.pdf";
        String fileType = fileName.split("\\.")[1];
        String downloadUrl = "https://dev.17elian.com/ejc-file-web/attachment/no_auth/download?fileId="+fileId;
        byte[] fileData = null;
        try{
            // 获取文件大小
            URL download = new URL(downloadUrl);
            HttpURLConnection conn = (HttpURLConnection) download.openConnection();
            conn.setRequestMethod("HEAD");
            // 下载文件
            InputStream in = new BufferedInputStream(download.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            fileData = out.toByteArray();
        }catch (Exception e){
            throw new BusinessException("获取文件失败");
        }
        String signature = null;
        try{
            signature = AESUtil.signature(yzwAppSecret1, yzwAppKey1, "ceshi");
        }catch (Exception e){
            throw new BusinessException("生成签名信息失败");
        }
        String attachmentId = null;
        try{
            String url = yzwSignUrl + "/open/v1/attachment/uploadFile2Pdf";
            JSONObject params = new JSONObject();
            params.put("signature", signature);
            params.put("appId", yzwAppKey1);
            params.put("openUId", "ceshi");
            JSONObject body = new JSONObject();
            body.put("fileName", fileName);
            body.put("fileData", fileData);
            body.put("fileType", fileType);
            params.put("body", body);
            String response = HttpTookit.postByJson(url, params.toJSONString(), null);
            System.out.println("上传云筑文件返回结果："+response);
            JSONObject respone = JSONObject.parseObject(response);
            if("200".equals(respone.getString("code"))){
                JSONObject data = respone.getJSONObject("data");
                attachmentId = data.getString("attachmentId");
            }else{
            }
        }catch (Exception e){
            System.out.println(e);
            throw new BusinessException("上传文件失败");
        }

        try{
            String url = yzwSignUrl + "/open/v1/contract/create";
            JSONObject params = new JSONObject();
            params.put("signature", signature);
            params.put("openUId", "ceshi");
            params.put("appId", yzwAppKey1);

            JSONObject body = new JSONObject();
            body.put("name", "签章测试.pdf");
            body.put("businessCode", "11111");
            body.put("businessSourceCode", "11111");
            body.put("sourceType", 46);
            body.put("contractType", 18);
            JSONArray fileList = new JSONArray();
            JSONObject file = new JSONObject();
            file.put("name", fileName);
            file.put("attachmentId", attachmentId);
            file.put("originSourceCode", fileId);
            fileList.add(file);
            body.put("fileList", fileList);
            params.put("body", body);
            String response = HttpTookit.postByJson(url, params.toJSONString(), null);
            System.out.println("云筑签章返回结果："+response);
            JSONObject respone = JSONObject.parseObject(response);
            if("200".equals(respone.getString("code"))){
                String data = respone.getString("data");
            }else{
            }
        }catch (Exception e){
            System.out.println(e);
            throw new BusinessException("上传文件失败");
        }

    }
}
