/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.calibration.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.service.ICalibrationService;
import com.ejianc.foundation.calibration.vo.CalibrationVO;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"calibration"})
public class CalibrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalibrationService service;
    @Autowired
    private IYzwSyncService yzwSyncService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CalibrationVO> saveOrUpdate(@RequestBody CalibrationVO saveOrUpdateVO) {
        CalibrationEntity entity = (CalibrationEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), CalibrationEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CalibrationVO vo = (CalibrationVO)((Object)BeanMapper.map((Object)((Object)entity), CalibrationVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CalibrationVO> queryDetail(Long id) {
        CalibrationEntity entity = (CalibrationEntity)((Object)this.service.selectById(id));
        CalibrationVO vo = (CalibrationVO)((Object)BeanMapper.map((Object)((Object)entity), CalibrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CalibrationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CalibrationVO calibrationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("organizationName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CalibrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("organizationName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Calibration-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryTenderCompletedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> queryTenderCompletedList(String beginTime, String endTime) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.yzwSyncService.queryTenderCompletedList(beginTime, endTime));
    }

    @RequestMapping(value={"/syncList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncList(String beginTime, String endTime) {
        this.service.syncList(beginTime, endTime);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refCalibrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> refCalibrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        long startLine = (pageNumber < 1 ? 0 : pageNumber - 1) * pageSize;
        params.put("startLine", startLine);
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage<CalibrationVO> page = this.service.refCalibrationData(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", page);
    }
}

