package com.ejianc.foundation.outcontract.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractSubcontractTotalPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分供方合同--劳务、专业导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractRecordExport")
public class ExportRecordSubcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRecordOutcontractSubcontractTotalPriceService recordSubcontractTotalPriceService;

    @Autowired
    private IRecordOutcontractSubcontractUnitPriceService recordSubcontractUnitPriceService;

	/**
	 * excel导出数据库数据
	 * 
	 * @return
	 */
	@RequestMapping(value = "/excelExportTotalPricFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTotalPricFromDatabase(@RequestBody RecordOutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<RecordOutcontractSubcontractTotalPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("record_outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<RecordOutcontractSubcontractTotalPriceEntity> list = recordSubcontractTotalPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
	}

	/**
	 * excel导出数据库数据
	 * 
	 * @return
	 */
	@RequestMapping(value = "/excelExportUnitPriceFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportUnitPriceFromDatabase(@RequestBody RecordOutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<RecordOutcontractSubcontractUnitPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("record_outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByAsc("list_code");
		List<RecordOutcontractSubcontractUnitPriceEntity> list = recordSubcontractUnitPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
	}

}
