package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractReviewEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractReviewEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractReviewVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractReviewVO;

/**
 * 记录分供方合同评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("recordOutcontractReview")
public class RecordOutcontractReviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRecordOutcontractReviewService service;

    @Autowired
    private IRecordOutcontractService outcontractService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecordOutcontractReviewVO> queryDetail(Long id) {
    	QueryWrapper<RecordOutcontractReviewEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("record_outcontract_id", id);
    	queryWrapper.eq("dr", 0);
    	List<RecordOutcontractReviewEntity> entitys = service.list(queryWrapper);
    	RecordOutcontractReviewVO vo = new RecordOutcontractReviewVO();
    	if(entitys!=null&&entitys.size()>0){
    		vo = BeanMapper.map(entitys.get(0), RecordOutcontractReviewVO.class);
    	}
    	vo.setRecordOutcontractId(id);
    	//查询项目信息
    	RecordOutcontractEntity outcontractEntity = outcontractService.selectById(id);
    	vo.setProjectId(outcontractEntity.getProjectId());
    	vo.setContractName(outcontractEntity.getContractName());
    	vo.setBillCode(outcontractEntity.getBillCode());
    	vo.setSupplier(outcontractEntity.getSupplier());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
