package com.ejianc.foundation.outcontractDisclosure.service.impl;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.outcontractDisclosure.bean.OutcontractDisclosureEntity;
import com.ejianc.foundation.outcontractDisclosure.service.IOutcontractDisclosureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("outcontractDisclosure") 
public class OutcontractDisclosureBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
    private static final String outcontractDisclosure_sourceType = "zjkj-outcontractDisclosure";//供方合同交底
    
    private static final String outcontractDisclosure_billtype_code = "BT220112000000001";//供方合同交底

	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi attachmentApi;

	@Autowired
	private IOutcontractDisclosureService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectApprovingByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个审批中的单据，不可提交！");
		}
		CommonResponse<List<AttachmentVO>> list = attachmentApi.queryListBySourceId(billId, outcontractDisclosure_billtype_code, outcontractDisclosure_sourceType, "desc");
		if(list.isSuccess()){
			if(!(list.getData()!=null&&list.getData().size()>0)){
				throw new BusinessException("无附件，不能提交");
			}
		}else{
			throw new BusinessException("校验附件信息失败");
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if(state==0){
//			直审
			CommonResponse<List<AttachmentVO>> list = attachmentApi.queryListBySourceId(billId, outcontractDisclosure_billtype_code, outcontractDisclosure_sourceType, "desc");
			if(list.isSuccess()){
				if(!(list.getData()!=null&&list.getData().size()>0)){
					throw new BusinessException("无附件，不能提交");
				}
			}else{
				throw new BusinessException("校验附件信息失败");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//发送消息给接受人
		OutcontractDisclosureEntity entity = service.getById(billId);
		if(StringUtils.isNotBlank(entity.getReceiverId())){
			entity.setCcInfo("已抄送给接受人【"+ entity.getReceiver() +"】");
			service.saveOrUpdate(entity, false);

			String subject = getUserName(entity.getCreateUserCode()) + "创建的供方合同交底单据【单据编码：" + entity.getBillCode() +", 合同名称：" + entity.getContractName()
					+", 项目名称：" + entity.getProjectName() + "】已审批结束，抄送给您查看，请查收";
			String pcurl = environmentTools.getBaseHost() + "ejc-outcontract-frontend/#/outcontractDisclosure/card?id=" + billId;
			String maurl = environmentTools.getBaseHost() + "ejc-zjkjapproval-mobile/#/disclosure/outcontractDisclosure?userid={userid}&id=" + billId;
			String content = subject + "。<a href=" + '"' + pcurl + '"' + ">前往点击</a>";

			PushMsgParameter parameter = new PushMsgParameter();
			List<String> channel = new ArrayList<>();
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
			channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);

			JSONObject dingdingParams = new JSONObject();
			dingdingParams.put("title", subject);
			String ddcontent = subject + (",通知时间:"+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
			dingdingParams.put("content", ddcontent);
			dingdingParams.put("maurl", maurl);
			dingdingParams.put("pcurl", pcurl);
			parameter.setDingdingParams(dingdingParams);

			String[] receivers = entity.getReceiverId().split(",");
			parameter.setReceivers(receivers);// 收信人
			parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
			parameter.setMsgType("notice");
			parameter.setSubject(subject);// 标题
			parameter.setContent(content);// 内容
			parameter.setPcUrl(pcurl);//
			parameter.setMobileUrl(maurl);//
			parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
			parameter.setSendUserId(InvocationInfoProxy.getUserid());
			try {
				CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
				if (result.isSuccess()) {
					logger.error("消息发送成功---------------->" + result.getMsg());
				} else {
					logger.error("消息发送失败---------------->" + result.getMsg());
				}
			} catch (Exception e) {
				logger.error("调用消息中心RPC服务异常--------------" + e);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public String getUserName(String userCode) {
		try {
			MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
			if (StringUtils.isNotBlank(userCode) && StringUtils.isNotBlank(urlconstants.getBaseHost()) && !(
					userCode.startsWith("admin") || "guoming".equals(userCode)) ) {
				String cacheKey = "refer_cache_key:idm-employee:" + userCode;
				RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);

				Object cacheValue = redisTemplate.opsForValue().get(cacheKey);

				JSONObject jsonObject = null;
				if (cacheValue != null) {
					jsonObject = JSON.parseObject(cacheValue.toString());
				} else {
					String baseHost = urlconstants.getBaseHost();
					if(StringUtils.isNotBlank(baseHost)) {
						Map<String, Object> reflist = new HashMap<>();
						reflist.put("userCode", userCode);
						String url = baseHost + "ejc-idm-web/commonrefer/getAuditInfo";
						String jsonbackstr = null;
						try {
							jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
						} catch (Exception e) {
						}
						if (StringUtils.isNotBlank(jsonbackstr)) {
							jsonObject = JSON.parseObject(jsonbackstr);
							redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 1, TimeUnit.DAYS);
						}else{
							redisTemplate.opsForValue().set(cacheKey, userCode, 10, TimeUnit.MINUTES);
						}
					}
				}
				if (jsonObject != null) {
					return jsonObject.getString("userName");
				}
			}
		} catch (Exception e) {
		}
		return userCode;
	}
}
