/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractReviewEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractReviewVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"changeOutcontractReview"})
public class ChangeOutcontractReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String REVIEW_BILL_CODE = "ZJKJ-OUTCONTRACTREVIEW";
    @Autowired
    private IChangeOutcontractReviewService service;
    @Autowired
    private IChangeOutcontractService changeOutcontractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangeOutcontractReviewVO> saveOrUpdate(@RequestBody ChangeOutcontractReviewVO saveOrUpdateVO) {
        ChangeOutcontractReviewEntity entity = (ChangeOutcontractReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ChangeOutcontractReviewEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getApprovalFormCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)REVIEW_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setApprovalFormCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ChangeOutcontractReviewVO vo = (ChangeOutcontractReviewVO)BeanMapper.map((Object)((Object)entity), ChangeOutcontractReviewVO.class);
        vo.setProjectId(saveOrUpdateVO.getProjectId());
        vo.setContractName(saveOrUpdateVO.getContractName());
        vo.setBillCode(saveOrUpdateVO.getBillCode());
        vo.setSupplier(saveOrUpdateVO.getSupplier());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeOutcontractReviewVO> queryDetail(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"change_outcontract_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List entitys = this.service.list((Wrapper)queryWrapper);
        ChangeOutcontractReviewVO vo = new ChangeOutcontractReviewVO();
        vo.setRowState("add");
        if (entitys != null && entitys.size() > 0) {
            vo = (ChangeOutcontractReviewVO)BeanMapper.map(entitys.get(0), ChangeOutcontractReviewVO.class);
            vo.setRowState("edit");
        }
        vo.setChangeOutcontractId(id);
        ChangeOutcontractEntity outcontractEntity = (ChangeOutcontractEntity)((Object)this.changeOutcontractService.selectById(id));
        vo.setProjectId(outcontractEntity.getProjectId());
        vo.setContractName(outcontractEntity.getContractName());
        vo.setBillCode(outcontractEntity.getBillCode());
        vo.setSupplier(outcontractEntity.getSupplier());
        vo.setContractBillState(outcontractEntity.getBillState());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

