package com.ejianc.foundation.yzwSync.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.foundation.yzwSync.util.AESUtil;
import com.ejianc.foundation.yzwSync.util.DataToYzwUtil;
import com.ejianc.foundation.yzwSync.util.DataToYzwUtil1;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 云筑网同步
 *
 * @author generator
 */
@Service("yzwSyncService")
public class YzwSyncServiceImpl implements IYzwSyncService {

    @Value("${yzwSignUrl:https://zyq-rpc.yzwqa.cn/api/e-sign/rpc}")
    private String yzwSignUrl;
    @Value("${yzwUrl1:http://api-jc.yzwqa.cn/open.api}")
    private String yzwUrl1;
    @Value("${yzwVersion:1.0}")
    private String yzwVersion;
    @Value("${yzwAppKey1:T000101000111}")
    private String yzwAppKey1;
    @Value("${yzwAppSecret1:fffe9bcba10f4abf8816b358d4d4a4d1}")
    private String yzwAppSecret1;
    @Value("${yzwUrl2:https://open.yzwqa.cn/api}")
    private String yzwUrl2;
    @Value("${yzwAppKey2:ltCIIzc0}")
    private String yzwAppKey2;
    @Value("${yzwAppSecret2:3pr152viev63r91q2o2ahduf9q3wielt}")
    private String yzwAppSecret2;
    @Autowired
    private  IAttachmentApi attachmentApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private EnvironmentTools environmentTools;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void getData(){

    }

    //读取招标任务列表
    @Override
    public List<String> queryTenderCompletedList(String beginTime, String endTime){
        List<String> listJson = new ArrayList<>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("CalibrationDateBegin", beginTime);
        queryListJson.put("CalibrationDateEnd", endTime);
        queryListJson.put("LimitRows", 100);
        String method = "BaseData.QueryTenderCompletedList";
        boolean flag = true;
        int pageNumber = 1;
        try {
            while (flag) {
                queryListJson.put("PageIndex", pageNumber);
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("读取招标任务列表结果：" );
                logger.info(response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                    JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        listJson.add(jsonObject.getString("SysNo"));
                    }
                    if(jsonArray.size() < 100){
                        logger.info("normal end pageNumber is "  + pageNumber);
                        flag = false;
                    }
                }else{
                    flag = false;
                    logger.info(respone.toJSONString());
                    logger.info("no data pageNumber is "  + pageNumber);
                    throw new BusinessException(respone.toJSONString());
                }
                pageNumber++;
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("读取招标任务详情失败"+e.getMessage());
        }
        return listJson;
    }

    //读取招标任务详情
    @Override
    public List<JSONObject> getTenderCompletedList(List<String> idList){
        List<JSONObject> listJson = new ArrayList<>();
        //10条一次
        Map<Integer, List<String>> idMap = new HashMap<>();
        for (int i=0; i<idList.size(); i++) {
            String id = idList.get(i);
            Integer index = i/10;
            List<String> ids = idMap.get(index);
            if(ids!=null){
                ids.add(id);
            }else{
                ids = new ArrayList<>();
                ids.add(id);
            }
            idMap.put(index, ids);
        }
        for (Integer index : idMap.keySet()) {
            List<String> ids = idMap.get(index);
            JSONObject queryListJson = new JSONObject();
            queryListJson.put("SysNoList", ids);
            String method = "BaseData.GetTenderCompletedList";
            try {
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("query list result is" + response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONArray("Data")){
                    JSONArray jsonArray = respone.getJSONArray("Data");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        listJson.add(jsonObject);
                    }
                }else{
                    logger.info(respone.toJSONString());
                    throw new BusinessException(respone.toJSONString());
                }
            } catch (Exception e) {
                logger.info(e.getMessage());
                throw new BusinessException("读取招标任务详情失败"+e.getMessage());
            }
        }
        return listJson;
    }

    //查询供应商投标详情
    @Override
    public List<JSONObject> getTenderSupplierBidDetailList(List<Integer> SupplierSysNos){
//        SupplierSysNos = new ArrayList<>();
//        SupplierSysNos.add(200067);
//        SupplierSysNos.add(200197);
//        SupplierSysNos.add(200197);
//        SupplierSysNos.add(200244);
//        SupplierSysNos.add(200194);
//        SupplierSysNos.add(200093);
        List<JSONObject> list = new ArrayList<>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("LimitRows", 100);
        queryListJson.put("SupplierSysNoList", SupplierSysNos);
        String method = "BaseData.GetSupplierList";
        boolean flag = true;
        int pageNumber = 1;
        try {
            while (flag) {
                queryListJson.put("PageIndex", pageNumber);
                String response = DataToYzwUtil1.queryByYzwList(queryListJson,yzwUrl1,method,yzwAppKey1,yzwAppSecret1);
                logger.info("查询供应商投标详情结果：" );
                logger.info(response);
                JSONObject respone = JSONObject.parseObject(response);
                if(0 == (respone.getInteger("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                    JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
                    for(Object obj : jsonArray){
                        JSONObject jsonObject = (JSONObject) obj;
                        list.add(jsonObject);
                    }
                    if(jsonArray.size() < 100){
                        logger.info("normal end pageNumber is "  + pageNumber);
                        flag = false;
                    }
                }else{
                    flag = false;
                    logger.info(respone.toJSONString());
                    logger.info("no data pageNumber is "  + pageNumber);
                    throw new BusinessException(respone.toJSONString());
                }
                pageNumber++;
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("查询供应商投标详情失败"+e.getMessage());
        }
        return list;
    }

    //合同同步
    @Override
    public JSONObject syncContract(JSONObject param){
        JSONObject result = new JSONObject();
//        JSONObject queryListJson = new JSONObject();
//        queryListJson.put("data", param);
        String method = "pintegration.ecc.contract.standard.create";
        try {
            logger.info("参数：{}",param.toJSONString());
            String response = DataToYzwUtil.queryByYzw(param,yzwUrl2,method,yzwVersion,yzwAppKey2,yzwAppSecret2);
            logger.info("query list result is" + response);
            JSONObject respone = JSONObject.parseObject(response);
            if(0 == ((Integer)respone.get("Code")) && null != respone.getJSONObject("Data").getJSONArray("Rows")){
                JSONArray jsonArrayjsonArray = respone.getJSONArray("Data");
                result = jsonArrayjsonArray.getJSONObject(0);
            }else{
                logger.info(respone.toJSONString());
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject uploadYzwSign(String fileId, Long contractId, String contractName, String billCode) {
        JSONObject result = new JSONObject();
        CommonResponse<AttachmentVO> attachmentResponse = attachmentApi.queryDetail(fileId);
        if(attachmentResponse.isSuccess() && attachmentResponse.getData()!=null){
            String fileName = attachmentResponse.getData().getFileName();
            String fileType = fileName.split("\\.")[1];
            String downloadUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/no_auth/download?fileId="+fileId;
            byte[] fileData = null;
            try{
                // 获取文件大小
                URL download = new URL(downloadUrl);
                HttpURLConnection conn = (HttpURLConnection) download.openConnection();
                conn.setRequestMethod("HEAD");
                // 下载文件
                InputStream in = new BufferedInputStream(download.openStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                fileData = out.toByteArray();
            }catch (Exception e){
                throw new BusinessException("获取文件失败");
            }
            String signature = null;
            try{
                signature = AESUtil.signature(yzwAppSecret1, yzwAppKey1, InvocationInfoProxy.getUsercode());
            }catch (Exception e){
                throw new BusinessException("生成签名信息失败");
            }
            String attachmentId = null;
            try{
                String url = yzwSignUrl + "/open/v1/attachment/uploadFile2Pdf";
                JSONObject params = new JSONObject();
                params.put("signature", signature);
                params.put("appId", yzwAppKey1);
                params.put("openUId", InvocationInfoProxy.getUsercode());
                JSONObject body = new JSONObject();
                body.put("fileName", fileName);
                body.put("fileData", fileData);
                body.put("fileType", fileType);
                params.put("body", body);
                String response = HttpTookit.postByJson(url, params.toJSONString(), null);
                logger.info("上传云筑文件返回结果："+response);
                JSONObject respone = JSONObject.parseObject(response);
                if("200".equals(respone.getString("code"))){
                    JSONObject data = respone.getJSONObject("data");
                    attachmentId = data.getString("attachmentId");
                }else{
                }
            }catch (Exception e){
                throw new BusinessException("上传文件失败");
            }

            try{
                String url = yzwSignUrl + "/open/v1/contract/create";
                JSONObject params = new JSONObject();
                params.put("signature", signature);
                params.put("appId", yzwAppKey1);
                params.put("openUId", InvocationInfoProxy.getUsercode());
                JSONObject body = new JSONObject();
                body.put("name", contractName);
                body.put("businessCode", contractId);
                body.put("businessSourceCode", billCode);
                body.put("sourceType", 46);
                body.put("contractType", 46);
                JSONArray fileList = new JSONArray();
                JSONObject file = new JSONObject();
                file.put("name", fileName);
                file.put("attachmentId", attachmentId);
                file.put("originSourceCode", fileId);
                fileList.add(file);
                body.put("fileList", fileList);
                params.put("body", body);

                String response = HttpTookit.postByJson(url, params.toJSONString(), null);
                logger.info("云筑签章返回结果："+response);
                JSONObject respone = JSONObject.parseObject(response);
                if("200".equals(respone.getString("code"))){
                    String data = respone.getString("data");
                }else{
                    throw new BusinessException("云筑签章创建失败");
                }
                result = respone;
            }catch (Exception e){
                throw new BusinessException("上传文件失败");
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String yzwSignUrl = "https://zyq-gw.yzwqa.cn/api/e-sign-rpc";
        String yzwAppKey1 = "T000101000111";
        String yzwAppSecret1 = "1d0b5e85a2ed4f5cbc4b7b50736dd666";
        String fileId = "643025753093062723";
        String fileName = "合同上传测试文件.pdf";
        String fileType = fileName.split("\\.")[1];
        String downloadUrl = "https://dev.17elian.com/ejc-file-web/attachment/no_auth/download?fileId="+fileId;
        byte[] fileData = null;
        try{
            // 获取文件大小
            URL download = new URL(downloadUrl);
            HttpURLConnection conn = (HttpURLConnection) download.openConnection();
            conn.setRequestMethod("HEAD");
            // 下载文件
            InputStream in = new BufferedInputStream(download.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            fileData = out.toByteArray();
        }catch (Exception e){
            throw new BusinessException("获取文件失败");
        }
        String signature = null;
        try{
            signature = AESUtil.signature(yzwAppSecret1, yzwAppKey1, "ceshi");
        }catch (Exception e){
            throw new BusinessException("生成签名信息失败");
        }
        String attachmentId = null;
        try{
            String url = yzwSignUrl + "/open/v1/attachment/uploadFile2Pdf";
            JSONObject params = new JSONObject();
            params.put("signature", signature);
            params.put("appId", yzwAppKey1);
            params.put("openUId", "ceshi");
            JSONObject body = new JSONObject();
            body.put("fileName", fileName);
            body.put("fileData", fileData);
            body.put("fileType", fileType);
            params.put("body", body);
            String response = HttpTookit.postByJson(url, params.toJSONString(), null);
            System.out.println("上传云筑文件返回结果："+response);
            JSONObject respone = JSONObject.parseObject(response);
            if("200".equals(respone.getString("code"))){
                JSONObject data = respone.getJSONObject("data");
                attachmentId = data.getString("attachmentId");
            }else{
            }
        }catch (Exception e){
            System.out.println(e);
            throw new BusinessException("上传文件失败");
        }

        try{
            String url = yzwSignUrl + "/open/v1/contract/create";
            JSONObject params = new JSONObject();
            params.put("signature", signature);
            params.put("openUId", "ceshi");
            params.put("appId", yzwAppKey1);

            JSONObject body = new JSONObject();
            body.put("name", "签章测试.pdf");
            body.put("businessCode", "11111");
            body.put("businessSourceCode", "11111");
            body.put("sourceType", 46);
            body.put("contractType", 18);
            JSONArray fileList = new JSONArray();
            JSONObject file = new JSONObject();
            file.put("name", fileName);
            file.put("attachmentId", attachmentId);
            file.put("originSourceCode", fileId);
            fileList.add(file);
            body.put("fileList", fileList);
            params.put("body", body);
            String response = HttpTookit.postByJson(url, params.toJSONString(), null);
            System.out.println("云筑签章返回结果："+response);
            JSONObject respone = JSONObject.parseObject(response);
            if("200".equals(respone.getString("code"))){
                String data = respone.getString("data");
            }else{
            }
        }catch (Exception e){
            System.out.println(e);
            throw new BusinessException("上传文件失败");
        }

    }
}
