package com.ejianc.foundation.outcontract.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.*;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontractDisclosure.mapper.OutcontractDisclosureMapper;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
@Service("outcontractService")
public class OutcontractServiceImpl extends BaseServiceImpl<OutcontractMapper, OutcontractEntity> implements IOutcontractService{

	@Autowired
	private IOutcontractReviewService reviewService;
	@Autowired
	private OutcontractDisclosureMapper outcontractDisclosureMapper;

	@Autowired
	private IChangeOutcontractService changeOutcontractService;
	@Autowired
	private OutcontractMapper contractMapper;
	@Autowired
	private IYzwSyncService yzwSyncService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IShareSupplierApi supplierApi;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private IZjkjProjectApi zjkjProjectApi;

	@Override
	public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
        	reviewService.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
	}

	@Override
	public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id).set("performance_status", performanceStatus);
        this.update(null, updateWrapper);
        return CommonResponse.success("更改履约状态成功！");
	}

	@Override
	public CommonResponse<String> changeDate(Long id, String type, Date date) {
		UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
		if("mobilizationDate".equals(type)){
			updateWrapper.eq("id",id).set("mobilization_date", date);
		}else if("exitDate".equals(type)){
			updateWrapper.eq("id",id).set("exit_date", date);
		}
        this.update(null, updateWrapper);
        return CommonResponse.success("更改成功！");
	}

	@Override
	public CommonResponse<String> file(OutcontractVO outcontractVO) {
		OutcontractEntity entity = this.selectById(outcontractVO.getId());
		if("1".equals(entity.getFileState())){
			throw new BusinessException("不能重复归档");
		}
		//变更后的合同归档的签约日期更新补充协议的签约日期，原合同签约日期不变
		if("1".equals(entity.getChangeState())){
			//未变更过的
			entity.setSignDate(outcontractVO.getSignDate());
		}else{
			//查询变更的单据
			QueryParam param = new QueryParam();
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, entity.getId()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			List<ChangeOutcontractEntity> list = changeOutcontractService.queryList(param,false);
			ChangeOutcontractEntity changeEntity = new ChangeOutcontractEntity();
			if(list!=null && list.size()>0){
				changeEntity = list.get(0);
				changeEntity.setSupplementarySignTime(outcontractVO.getSignDate());
				changeOutcontractService.saveOrUpdate(changeEntity, false);
			}
		}
		entity.setFileState("1");
		this.saveOrUpdate(entity, false);
		//处理冗余其他单据中的合同金额及签约日期
		this.redundanceData(entity);
		CommonResponse<String> back = attachmentApi.updateAttachRef(outcontractVO.getId(), outcontractVO.getAttachIds());
		if(!back.isSuccess()){
			throw new BusinessException("归档失败");
		}
		return CommonResponse.success("归档成功！");
	}

	@Override
	public IPage<OutcontractSupplierVO> refSupplierList(Map<String, Object> params) {
		Long count = contractMapper.countSupplier(params);
		Integer pageIndex = (Integer) params.get("pageIndex");
		Integer pageSize = (Integer) params.get("pageSize");
		IPage<OutcontractSupplierVO> pageData = new Page<>(pageIndex, pageSize, count);
		if(count>0){
			List<OutcontractSupplierVO> list = contractMapper.querySupplierList(params);
			List<Long> ids = new ArrayList<>();
			for(OutcontractSupplierVO vo : list){
				ids.add(vo.getId());
			}
			CommonResponse<List<SupplierVO>> supplierResponse = shareSupplierApi.querySupplierByIds(ids);
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null && supplierResponse.getData().size()>0){
				Map<Long, SupplierVO> map = new HashMap<>();
				for(SupplierVO vo : supplierResponse.getData()){
					map.put(vo.getId(),vo);
				}
				for(OutcontractSupplierVO vo : list){
					if(map.get(vo.getId())!=null){
						SupplierVO supplierVO = map.get(vo.getId());
						vo.setSupplierName(supplierVO.getName());
						vo.setSupplierTaxPayerType(supplierVO.getTaxPayerType());
						vo.setSupplierSocialCreditCode(supplierVO.getSocialCreditCode());
						vo.setSupplierBank(supplierVO.getBankName());
						vo.setSupplierBankAccount(supplierVO.getBankAccount());
						vo.setSupplierLegal(supplierVO.getLegal());
						vo.setSupplierTelephone(supplierVO.getTelephone());
					}
				}
			}
			pageData.setRecords(list);
		}
		return pageData;
	}


	@Override
	public void redundanceData(OutcontractEntity entity) {
		String signDate = null;
		if(entity.getSignDate()!=null){
			signDate = DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSignDate());
		}
		outcontractDisclosureMapper.updateContract(entity.getContractPrice(), signDate, entity.getId());
	}

	@Override
	public void syncYzwContract(Long id) {
		OutcontractEntity entity = this.selectById(id);

		//判断是否公共项目
		CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
		Boolean publicProject = false;
		List<String> plProjectName = new ArrayList<>();
		if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
			defdocResponse.getData().forEach(item -> {
				plProjectName.add(item.getName());
			});
		}
		if(plProjectName.contains(entity.getProjectName())){
			publicProject = true;
		}
		JSONObject param = new JSONObject();
		BigDecimal amount = new BigDecimal(0);
		CommonResponse<ProjectVO> projectResponse = zjkjProjectApi.queryDetailById(entity.getProjectId());
		ProjectVO projectVO = null;
		if(projectResponse.isSuccess() && projectResponse.getData()!=null){
			projectVO = projectResponse.getData();
		}else{
			throw new BusinessException("未获取到项目信息");
		}
		String yzwProjectCode = projectVO.getYzwProjectCode();
		String yzwUser = projectVO.getYzwUser();
		if(StringUtils.isBlank(yzwProjectCode) && !publicProject){
			throw new BusinessException("项目未关联云筑网数据");
		}
		if(StringUtils.isBlank(yzwUser)){
//            yzwUser = "ceshi";
			throw new BusinessException("项目人员未关联云筑网数据");
		}
		String buildUnit = null;
		if(entity.getBuildUnit()!=null){
			CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getBuildUnit());
			if(orgResponse.isSuccess() && orgResponse.getData()!=null){
				buildUnit = orgResponse.getData().getYzwOrgCode();
				if(StringUtils.isBlank(buildUnit)){
//                    buildUnit = "orgCode";
					throw new BusinessException("实施单位未关联云筑网数据");
				}
			}
		}
		String signUnit = null;
		if(entity.getSignUnit()!=null){
			if(entity.getBuildUnit()!=entity.getSignUnit()){
				CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getSignUnit());
				if(orgResponse.isSuccess() && orgResponse.getData()!=null){
					signUnit = orgResponse.getData().getYzwOrgCode();
					if(StringUtils.isBlank(signUnit)){
//                        signUnit = "orgCode";
						throw new BusinessException("签约单位未关联云筑网数据");
					}
				}
			}else{
				signUnit = buildUnit;
			}
		}
		String partyBCompanyId = null;
		if(entity.getSupplier()!=null){
			CommonResponse<SupplierVO> supplierResponse = supplierApi.queryById(entity.getSupplier());
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null){
				partyBCompanyId = supplierResponse.getData().getYzwSupplierCode();
			}
			if(StringUtils.isBlank(partyBCompanyId)){
//                partyBCompanyId = "supplierCode";
				throw new BusinessException("供应商未关联云筑网数据");
			}
		}
		Boolean leaseFlag = false;
		if("劳务分包".equals(entity.getType())){
			amount = entity.getSubcontractTotalAmount();
		}else if("专业分包".equals(entity.getType())){
			amount = entity.getSubcontractTotalAmount();
		}else if("物资采购".equals(entity.getType())){
			amount = entity.getContractPriceTotalAmount();
		}else if("机械租赁".equals(entity.getType())){
			amount = entity.getLeaseItemTotalAmount();
			leaseFlag = true;
		}else if("周转材租赁".equals(entity.getType())){
			amount = entity.getContractPriceTotalAmount();
			leaseFlag = true;
		}else if("设计勘察".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("咨询服务".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("其它合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("课题支出类合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}

		param.put("amount", amount);//合同金额
		param.put("categoryCode", "招标采购合同");//合同类型      招标采购合同;招标框架协议;  无招标采购合同；无招标框架协议;招标执行合同;无招标执行合同
		param.put("createUserId", yzwUser);//创建人Id(项目上配置一个字段，云筑用户id，一个项目固定一个人)
		param.put("currency", "CNY");//币种
		param.put("customNo", entity.getBillCode());//合同编号
		if(entity.getMobilizationDate()!=null){
			param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getMobilizationDate()));//合同开始日期
		}
		if(entity.getExitDate()!=null){
			param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getExitDate()));//合同结束日期
		}
		param.put("name", entity.getContractName());//合同名称
		List<String> organizationList = new ArrayList<>();
		organizationList.add(buildUnit);
		param.put("organizationList", organizationList);//实施单位---中建科技在云筑内组织id
		param.put("partyACode", signUnit);//签约单位	中建科技在云筑内组织id
		param.put("partyAManagerId", yzwUser);//甲方经办人Id:项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("partyBCompanyId", partyBCompanyId);//中标供应商的id	供应商	供应商对应的云筑ID
		List<String> projectListId = new ArrayList<>();
		if(publicProject){
			projectListId.add("-1000");
		}else{
			projectListId.add(yzwProjectCode);
		}
		param.put("projectListId", projectListId);//合同项目	项目	项目对应的云筑ID
		param.put("remark", entity.getRemark());//备注
		param.put("settlementAfterInspection", false);//是否收验货后结算
		param.put("signOrgName", entity.getSignUnitName());//甲方名称	签约单位
		if(entity.getSignDate()!=null){
			param.put("signTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getSignDate()));//签约日期
		}
		/*
		PREPARATION("PREPARATION", "编制中"),
				UNDER_APPROVAL("UNDER_APPROVAL", "审批中"),
				APPROVED("APPROVED", "审批通过"),
				APPROVAL_FAILED("APPROVAL_FAILED", "审批不通过"),
				CONFIRMING("CONFIRMING", "确认中"),
				CONFIRM_REJECTION("CONFIRM_REJECTION", "确认不通过"),
				CONFIRMED("CONFIRMED", "确认通过"),
				SIGNATURE_APPROVAL("SIGNATURE_APPROVAL", "签章审批中"),
				SIGNATURE_APPROVED("SIGNATURE_APPROVED", "签章审批通过"),
				SIGNATURE_APPROVAL_FAILED("SIGNATURE_APPROVAL_FAILED", "签章审批不通过"),
				SIGNING("SIGNING", "签章中"),
				SIGNATURE_COMPLETED("SIGNATURE_COMPLETED", "签章完成"),
				INVALID_APPROVAL("INVALID_APPROVAL", "作废审批中"),
				INVALID_APPROVAL_FAILED("INVALID_APPROVAL_FAILED", "作废审批不通过"),
				ABOLISHED("ABOLISHED", "已作废"),
				DELETED("DELETED", "已删除"),
				SHELF_ON("SHELF_ON", "已上架"),
				SHELF_OFF("SHELF_OFF", "已下架"),
				TERMINATE_APPROVAL("TERMINATE_APPROVAL", "解除审批中"),
				TERMINATE_APPROVAL_FAILED("TERMINATE_APPROVAL_FAILED", "解除审批不通过"),
				TERMINATING("TERMINATING", "解除中"),
				TERMINATED("TERMINATED", "已解除"),
				ARCHIVED("ARCHIVED", "已归档");*/
		param.put("status", "APPROVED");//合同状态	固定值	SHELF_ON=已上架,、已归档
		param.put("sysNo", entity.getBillCode());//合同编号
		param.put("tenderCode", entity.getCalibrationTenderCode());//云筑招标编号
		param.put("thirdPartyId", entity.getId().toString());//合同ID
		param.put("updateUserId", yzwUser);//创建人Id	项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("paymentMethod", "INSTALLMENTS");//付款方式 ONE_TIME=一次性付款;INSTALLMENTS=分期付款;OTHER=其它;
		String pricingMethod = null;
		switch (entity.getPricingForm()) {
			case "按建筑面积平米的每平米固定单价":
			case "按实体工程量对应的固定单价":
			case "按承包合同价款让利费率下浮":
			case "固定单价":
			case "可调价格":
				pricingMethod = "UNIT_PRICE";//单价合同
				break;
			case "固定总价":
				pricingMethod = "LUMP_SUM";//总价合同
				break;
			case "定额计价":
			case "其他":
				pricingMethod = "OTHER";//其他形式合同
				break;
		}
		param.put("pricingMethod", pricingMethod);//计价方式 LUMP_SUM=总价合同;UNIT_PRICE=单价合同;COST_PLUS=成本加酬金合同;OTHER=其他形式合同;
		param.put("leaseFlag", leaseFlag);//根据合同类型判断	周材租赁，设备租赁传“是”

//        param.put("majorOpenSysNo", );//主合同openSysNo编号
//        param.put("majorSysNo", );//主合同编号

//        param.put("otherAttachmentList", );//其他附件说明（参数详情见otherAttachmentList）
		param.put("signType", "MAJOR_CONTRACT");//合同签订类型	固定值	MAJOR_CONTRACT主合同，CHANGE_CONTRACT变更合同，SUPPLEMENTARY_PACT补充协议，解除合同
		param.put("signWay", "ONLINE");//签章方式	固定值/签章方式	线上电子签章，OFFLINE线下签章

		JSONArray signedAttachmentList = new JSONArray();
		JSONObject signedAttachment = new JSONObject();
		signedAttachment.put("fileName", "签章占位附件.pdf");
		signedAttachment.put("ossUrl", "xx.pdf");
		signedAttachmentList.add(signedAttachment);
        param.put("signedAttachmentList", signedAttachmentList);//已签章附件（参数详情见signedAttachmentList）

		if("劳务分包".equals(entity.getType()) || "专业分包".equals(entity.getType())){
			JSONArray listData = this.dealUnitListData(entity.getOutcontractSubcontractUnitPriceList());
			param.put("listData", listData);//
		}else if("物资采购".equals(entity.getType()) || "周转材租赁".equals(entity.getType())){
			JSONArray listData = this.dealMaterialListData(entity.getOutcontractMaterialList());
			param.put("listData", listData);//
		}else if("机械租赁".equals(entity.getType())){
			JSONArray listData = this.dealEquipmentListLeaseItemData(entity.getOutcontractEquipmentLeaseItemList());
			param.put("listData", listData);//
		}
		JSONObject result = yzwSyncService.syncContract(param);
		String sysNo = result.getString("sysNo");
		String openSysNo = result.getString("openSysNo");
		entity.setYzwOpenContractCode(openSysNo);
		entity.setYzwContractCode(sysNo);
		this.saveOrUpdate(entity, false);
	}

	private void upadteYzwFile(Long id, String type){
		String billType = null;
		String sourceType = "zjkj-outcontract-yzw-sign";
		if("劳务分包".equals(type)){
			billType = "BT220105000000001";
		}else if("专业分包".equals(type)){
			billType = "BT220105000000002";
		}else if("物资采购".equals(type)){
			billType = "BT220105000000003";
		}else if("机械租赁".equals(type)){
			billType = "BT220105000000004";
		}else if("周转材租赁".equals(type)){
			billType = "BT220105000000005";
		}else if("设计勘察".equals(type)){
			billType = "BT220105000000006";
		}else if("咨询服务".equals(type)){
			billType = "BT220105000000007";
		}else if("其它合同".equals(type)){
			billType = "BT220105000000008";
		}else if("课题支出类合同".equals(type)){
			billType = "EJCBT202207000040";
		}
		CommonResponse<List<AttachmentVO>> att = attachmentApi.queryListBySourceId(id, billType, sourceType, null);
		if(att.isSuccess() && att.getData()!=null){

		}else{
			throw new BusinessException("未获取到合同签章文件");
		}
	}

	@Override
	public void syncYzwSign(Long id) {
		OutcontractEntity entity = this.selectById(id);
		String billType = null;
		String sourceType = "zjkj-outcontract-yzw-sign";
		if("劳务分包".equals(entity.getType())){
			billType = "BT220105000000001";
		}else if("专业分包".equals(entity.getType())){
			billType = "BT220105000000002";
		}else if("物资采购".equals(entity.getType())){
			billType = "BT220105000000003";
		}else if("机械租赁".equals(entity.getType())){
			billType = "BT220105000000004";
		}else if("周转材租赁".equals(entity.getType())){
			billType = "BT220105000000005";
		}else if("设计勘察".equals(entity.getType())){
			billType = "BT220105000000006";
		}else if("咨询服务".equals(entity.getType())){
			billType = "BT220105000000007";
		}else if("其它合同".equals(entity.getType())){
			billType = "BT220105000000008";
		}else if("课题支出类合同".equals(entity.getType())){
			billType = "EJCBT202207000040";
		}
		CommonResponse<List<AttachmentVO>> att = attachmentApi.queryListBySourceId(entity.getId(), billType, sourceType, null);
		if(att.isSuccess() && att.getData()!=null){
			JSONObject result = yzwSyncService.uploadYzwSign(att.getData().get(0).getId().toString(), entity.getId(), entity.getContractName(), entity.getBillCode());
			String data = result.getString("data");
			entity.setYzwSignCode(data);
			this.saveOrUpdate(entity, false);
		}else{
			throw new BusinessException("未获取到合同签章文件");
		}
	}

	private JSONArray dealUnitListData(List<OutcontractSubcontractUnitPriceEntity> unitPriceList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "分包工程综合单价计价清单");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0001");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("listCode","清单编号","TEXT",1));
		columns.add(this.createColumn("project","项目","TEXT",2));
		columns.add(this.createColumn("jobContent","工作内容","TEXT",3));
		columns.add(this.createColumn("projectCharacteristic","项目特征","TEXT",4));
		columns.add(this.createColumn("unit","单位","TEXT",5));
		columns.add(this.createColumn("engineeringQuantity","工程量","NUMBER",6));
		columns.add(this.createColumn("comprehensiveUnitPrice","综合单价","NUMBER",7));
		columns.add(this.createColumn("totalPrice","合计","NUMBER",8));
		columns.add(this.createColumn("laborCost","人工费","NUMBER",9));
		columns.add(this.createColumn("mainMaterialCost","主材费","NUMBER",10));
		columns.add(this.createColumn("materialLoss","材料损耗","NUMBER",11));
		columns.add(this.createColumn("auxiliaryMaterialCost","辅材费","NUMBER",12));
		columns.add(this.createColumn("machineryCost","机械费","NUMBER",13));
		columns.add(this.createColumn("managementCost","管理费","NUMBER",14));
		columns.add(this.createColumn("profit","利润","NUMBER",15));
		columns.add(this.createColumn("paidGovernmentCost","规费","NUMBER",16));
		columns.add(this.createColumn("tax","税金","NUMBER",17));
		columns.add(this.createColumn("mainMaterialBrand","主材品牌","TEXT",18));
		columns.add(this.createColumn("remark","备注","TEXT",19));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		for (OutcontractSubcontractUnitPriceEntity vo : unitPriceList) {
			JSONObject ins = new JSONObject();
			ins.put("listCode", vo.getListCode());
			ins.put("project", vo.getProject());
			ins.put("jobContent", vo.getJobContent());
			ins.put("projectCharacteristic", vo.getProjectCharacteristic());
			ins.put("unit", vo.getUnit());
			ins.put("engineeringQuantity", vo.getEngineeringQuantity());
			ins.put("comprehensiveUnitPrice", vo.getComprehensiveUnitPrice());
			ins.put("totalPrice", vo.getTotalPrice());
			ins.put("laborCost", vo.getLaborCost());
			ins.put("mainMaterialCost", vo.getMainMaterialCost());
			ins.put("materialLoss", vo.getMaterialLoss());
			ins.put("auxiliaryMaterialCost", vo.getAuxiliaryMaterialCost());
			ins.put("machineryCost", vo.getMachineryCost());
			ins.put("profit", vo.getProfit());
			ins.put("paidGovernmentCost", vo.getPaidGovernmentCost());
			ins.put("tax", vo.getTax());
			ins.put("mainMaterialBrand", vo.getMainMaterialBrand());
			ins.put("remark", vo.getRemark());
			instance.add(ins);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	private JSONArray dealMaterialListData(List<OutcontractMaterialEntity> materialList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "物资清单");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0002");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("materialCode","物资编码","TEXT",1));
		columns.add(this.createColumn("materialName","标的名称","TEXT",2));
		columns.add(this.createColumn("strengthGrade","强度等级","TEXT",3));
		columns.add(this.createColumn("materialSpec","规格型号","TEXT",4));
		columns.add(this.createColumn("brandTrademark","品牌商标","TEXT",5));
		columns.add(this.createColumn("materialUnit","计量单位","TEXT",6));
		columns.add(this.createColumn("quantity","暂定数量","NUMBER",7));
		columns.add(this.createColumn("untaxUnitPrice","不含税单价","NUMBER",8));
		columns.add(this.createColumn("taxRate","税金（%）","NUMBER",9));
		columns.add(this.createColumn("taxUnitPrice","含税单价","NUMBER",10));
		columns.add(this.createColumn("totalPrice","合价","NUMBER",11));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		for (OutcontractMaterialEntity vo : materialList) {
			JSONObject ins = new JSONObject();
			ins.put("materialCode", vo.getMaterialCode());
			ins.put("materialName", vo.getMaterialName());
			ins.put("strengthGrade", vo.getStrengthGrade());
			ins.put("materialSpec", vo.getMaterialSpec());
			ins.put("brandTrademark", vo.getBrandTrademark());
			ins.put("materialUnit", vo.getMaterialUnit());
			ins.put("quantity", vo.getQuantity());
			ins.put("untaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("taxRate", vo.getTaxRate());
			ins.put("taxUnitPrice", vo.getTaxUnitPrice());
			ins.put("totalPrice", vo.getTotalPrice());
			instance.add(ins);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	private JSONArray dealEquipmentListLeaseItemData(List<OutcontractEquipmentLeaseItemEntity> outcontractEquipmentLeaseItemList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "租赁物进出场费明细");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0003");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("equipmentCode","编码","TEXT",1));
		columns.add(this.createColumn("equipmentName","设备名称","TEXT",2));
		columns.add(this.createColumn("equipmentSpec","规格","TEXT",3));
		columns.add(this.createColumn("entranceExitFee","进出场费（元/台）","NUMBER",4));
		columns.add(this.createColumn("quantity","台数","NUMBER",5));
		columns.add(this.createColumn("taxRate","税率（%）","NUMBER",6));
		columns.add(this.createColumn("totalPrice","合计（元）","NUMBER",7));
		columns.add(this.createColumn("remark","备注","TEXT",8));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		for (OutcontractEquipmentLeaseItemEntity vo : outcontractEquipmentLeaseItemList) {
			JSONObject ins = new JSONObject();
			ins.put("equipmentCode", vo.getEquipmentCode());
			ins.put("equipmentName", vo.getEquipmentName());
			ins.put("equipmentSpec", vo.getEquipmentSpec());
			ins.put("entranceExitFee", vo.getEntranceExitFee());
			ins.put("quantity", vo.getQuantity());
			ins.put("taxRate", vo.getTaxRate());
			ins.put("totalPrice", vo.getTotalPrice());
			ins.put("remark", vo.getRemark());
			instance.add(ins);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	private JSONObject createColumn(String columnCode, String columnName, String valueType, Integer sortIndex){
		JSONObject column = new JSONObject();
		column.put("columnCode", columnCode);
		column.put("columnName", columnName);
		column.put("valueType", valueType);
		column.put("sortIndex", sortIndex);
		return column;
	}

}
