package com.ejianc.foundation.util;
import cn.hutool.poi.excel.ExcelUtil;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * Excel多sheet页相关处理
 *
 * @author ruoyi
 */
public class ExcelUtilManySheet {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    /**
     * @param sheetsName
     *            工作空间名称
     * @param titleNames
     *            表头名称
     * @param datas
     *            带导出的数据
     * @throws InvalidFormatException
     */
    public static void exportSheets(List<String> sheetsName, List<String> titleNames, List<List<List<Object>>> datas, HttpServletResponse response) {
        //创建HSSFWorkbook对象(excel的文档对象)
        XSSFWorkbook wb =  new  XSSFWorkbook();
        try {
            //.....省略部分代码6
            dealSheets(sheetsName,titleNames,datas,wb);
            String filename = "test";//设置下载时客户端Excel的名称

            response.setContentType("application/octet-stream");
            response.setHeader("content-type", "application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            OutputStream ouputStream = response.getOutputStream();
            wb.write(ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }catch (Exception e){
            log.error("导出失败,错误：{}",e);
            throw new BusinessException("导出失败！");
        }
    }

    public static void dealSheets(List<String> sheetsName, List<String> titleNames, List<List<List<Object>>> datas, XSSFWorkbook wb) throws IOException {
        for(int i=0; i<sheetsName.size(); i++){
            String sheetName = sheetsName.get(i);
            //建立新的sheet对象（excel的表单）
            XSSFSheet sheet=wb.createSheet( sheetName );
            if(titleNames!=null && titleNames.size()>0){
                String titleName = titleNames.get(i);
                //在sheet里创建第一行，参数为行索引(excel的行)，可以是0～65535之间的任何一个
                XSSFRow row1=sheet.createRow( 0 );
                //创建单元格（excel的单元格，参数为列索引，可以是0～255之间的任何一个
                XSSFCell cell=row1.createCell( 0 );
                //设置单元格内容
                cell.setCellValue( titleName );
                //合并单元格CellRangeAddress构造参数依次表示起始行，截至行，起始列， 截至列
                if(datas.get(i).size()>0){
                    sheet.addMergedRegion( new CellRangeAddress( 0 , 0 , 0 , datas.get(i).get(0).size()-1 ));
                }
                cell.getCellStyle().setBorderBottom(BorderStyle.THIN);
                cell.getCellStyle().setBorderLeft(BorderStyle.THIN);
                cell.getCellStyle().setBorderRight(BorderStyle.THIN);
                cell.getCellStyle().setBorderTop(BorderStyle.THIN);
                cell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
                cell.getCellStyle().setVerticalAlignment(VerticalAlignment.CENTER);
                cell.getCellStyle().setFillBackgroundColor(new XSSFColor(new Color(230,230,230)));
                XSSFFont font = wb.createFont();
                font.setBold(true); // 字体加粗
                cell.getCellStyle().setFont(font);
            }
            List<List<Object>> data = datas.get(i);
            if(data!=null && data.size()>0){
                for(int k=0; k<data.size(); k++){
                    List<Object> da = data.get(k);
                    XSSFRow row=sheet.createRow( k+1 );//创建第n行
                    for(int j=0; j<da.size(); j++) {
                        String value = null;
                        if(da.get(j) instanceof BigDecimal){
                            if(da.get(j)!=null){
                                BigDecimal va = (BigDecimal) da.get(j);
                                va = va.setScale(2, BigDecimal.ROUND_HALF_UP);
                                value = va.toString();
                            }
                        }else{
                            value = da.get(j)!=null? da.get(j).toString():null;
                        }
                        XSSFCell cell=row.createCell( j );
                        cell.setCellValue( value );
                        cell.getCellStyle().setBorderBottom(BorderStyle.THIN);
                        cell.getCellStyle().setBorderLeft(BorderStyle.THIN);
                        cell.getCellStyle().setBorderRight(BorderStyle.THIN);
                        cell.getCellStyle().setBorderTop(BorderStyle.THIN);
                    }
                }
            }
        }
    }
}