package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.outcontract.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSupplementaryAgreementEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 变更分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeOutcontract")
public class ChangeOutcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IChangeOutcontractService service;

    @Autowired
    private IOutcontractService outcontractService;

    @Autowired
    private IRecordOutcontractService recordOutcontractService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeOutcontractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("outcontractId")==null){
        	throw new BusinessException("缺少合同id");
        }
        IPage<ChangeOutcontractEntity> page = service.queryPage(param,false);
        IPage<ChangeOutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeOutcontractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByContractId")
    @ResponseBody
    public CommonResponse<ChangeOutcontractVO> queryDetailByContractId(@RequestParam(value = "contractId") Long contractId) {
    	OutcontractEntity contractVO = outcontractService.selectById(contractId);
		//获取历史版本条数
		QueryWrapper<RecordOutcontractEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("outcontract_id", contractId);
		recordWrapper.eq("dr", 0);
		Integer count = recordOutcontractService.count(recordWrapper);

    	ChangeOutcontractVO changeVO = BeanMapper.map(contractVO, ChangeOutcontractVO.class);
    	Long id = IdWorker.getId();
    	changeVO.setOutcontractId(contractId);
    	changeVO.setBillState(null);
    	changeVO.setCreateTime(null);
    	changeVO.setCreateUserCode(null);
    	changeVO.setTenantId(null);
    	changeVO.setUpdateTime(null);
    	changeVO.setUpdateUserCode(null);
    	changeVO.setId(id);
		changeVO.setChangeAmount(null);
		changeVO.setOutcontractCode(contractVO.getBillCode()+"-"+(count+1));
		changeVO.setBillCode(contractVO.getBillCode());
		changeVO.setOldAfterChangeAmount(contractVO.getAfterChangeAmount());

    	List<ChangeOutcontractSupplierVO> changeOutcontractSupplierList = new ArrayList<>();
    	ChangeOutcontractSupplierVO changeOutcontractSupplierVO = BeanMapper.map(changeVO, ChangeOutcontractSupplierVO.class);
    	changeOutcontractSupplierVO.setRowState("add");
    	changeOutcontractSupplierList.add(changeOutcontractSupplierVO);
    	changeVO.setChangeOutcontractSupplierList(changeOutcontractSupplierList);
    	
    	//处理分包工程总价汇总表变更
    	List<OutcontractSubcontractTotalPriceEntity> outcontractSubcontractTotalPriceList = contractVO.getOutcontractSubcontractTotalPriceList();
    	if(outcontractSubcontractTotalPriceList!=null&&outcontractSubcontractTotalPriceList.size()>0){
    	    List<ChangeOutcontractSubcontractTotalPriceVO> changeOutcontractSubcontractTotalPriceVos = new ArrayList<>();
    		for(OutcontractSubcontractTotalPriceEntity entity : outcontractSubcontractTotalPriceList){
    			ChangeOutcontractSubcontractTotalPriceVO vo = BeanMapper.map(entity, ChangeOutcontractSubcontractTotalPriceVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setUpdateUserCode(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    			changeOutcontractSubcontractTotalPriceVos.add(vo);
    		}
    		changeVO.setChangeOutcontractSubcontractTotalPriceList(changeOutcontractSubcontractTotalPriceVos);
    	}
    	//处理分包工程综合单价计价表变更
    	List<OutcontractSubcontractUnitPriceEntity> outcontractSubcontractUnitPriceList = contractVO.getOutcontractSubcontractUnitPriceList();
    	if(outcontractSubcontractUnitPriceList!=null&&outcontractSubcontractUnitPriceList.size()>0){
    	    List<ChangeOutcontractSubcontractUnitPriceVO> changeOutcontractSubcontractUnitPriceVos = new ArrayList<>();
    		Map<String,ChangeOutcontractSubcontractUnitPriceVO> map = new HashMap<>();
    	    for(OutcontractSubcontractUnitPriceEntity entity : outcontractSubcontractUnitPriceList){
    			ChangeOutcontractSubcontractUnitPriceVO vo = BeanMapper.map(entity, ChangeOutcontractSubcontractUnitPriceVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setUpdateUserCode(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    	    	changeOutcontractSubcontractUnitPriceVos.add(vo);
				map.put(vo.getInnercode(), vo);
    		}
    		//设置父级id
    		for(ChangeOutcontractSubcontractUnitPriceVO vo : changeOutcontractSubcontractUnitPriceVos){
    			String innercode = vo.getInnercode();
    			if(innercode.length()==2){
    				//最上级
    			}else if(innercode.length()==4){
    				String pcode = innercode.substring(0, 2);
    				//有父节点
    				Long pid = this.setPid(pcode, map);
    				vo.setPid(pid);
    			}else if(innercode.length()==6){
    				String pcode = innercode.substring(0, 4);
    				//有父节点
    				Long pid = this.setPid(pcode, map);
    				vo.setPid(pid);
    			}else if(innercode.length()>6){
    				String pcode = innercode.substring(0, 6);
    				//有父节点
    				Long pid = this.setPid(pcode, map);
    				vo.setPid(pid);
    			}
    		}
    		//构建树
    		changeVO.setChangeOutcontractSubcontractUnitPriceList(createTreeData(changeOutcontractSubcontractUnitPriceVos));
    	}
    	
    	//处理补充协议变更
    	List<OutcontractSupplementaryAgreementEntity> outcontractSupplementaryAgreementList = contractVO.getOutcontractSupplementaryAgreementList();
    	if(outcontractSupplementaryAgreementList!=null&&outcontractSupplementaryAgreementList.size()>0){
    	    List<ChangeOutcontractSupplementaryAgreementVO> changeOutcontractSupplementaryAgreementVos = new ArrayList<>(); // 补充协议变更
    		for(OutcontractSupplementaryAgreementEntity entity : outcontractSupplementaryAgreementList){
    			ChangeOutcontractSupplementaryAgreementVO vo = BeanMapper.map(entity, ChangeOutcontractSupplementaryAgreementVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    			changeOutcontractSupplementaryAgreementVos.add(vo);
    		}
    		changeVO.setChangeOutcontractSupplementaryAgreementList(changeOutcontractSupplementaryAgreementVos);
    	}
    	
    	//处理物资（周转材）合同价变更
    	List<OutcontractMaterialEntity> outcontractMaterialList = contractVO.getOutcontractMaterialList();
    	if(outcontractMaterialList!=null&&outcontractMaterialList.size()>0){
    	    List<ChangeOutcontractMaterialVO> changeOutcontractMaterialVos = new ArrayList<>(); 
    		for(OutcontractMaterialEntity entity : outcontractMaterialList){
    			ChangeOutcontractMaterialVO vo = BeanMapper.map(entity, ChangeOutcontractMaterialVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setUpdateUserCode(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    	    	changeOutcontractMaterialVos.add(vo);
    		}
    		changeVO.setChangeOutcontractMaterialList(changeOutcontractMaterialVos);
    	}
    	
    	//处理租赁物进出场费明细表变更
    	List<OutcontractEquipmentLeaseItemEntity> outcontractEquipmentLeaseItemList = contractVO.getOutcontractEquipmentLeaseItemList();
    	if(outcontractEquipmentLeaseItemList!=null&&outcontractEquipmentLeaseItemList.size()>0){
    	    List<ChangeOutcontractEquipmentLeaseItemVO> changeOutcontractEquipmentLeaseItemVos = new ArrayList<>(); // 甲指分包变更
    		for(OutcontractEquipmentLeaseItemEntity entity : outcontractEquipmentLeaseItemList){
    			ChangeOutcontractEquipmentLeaseItemVO vo = BeanMapper.map(entity, ChangeOutcontractEquipmentLeaseItemVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setUpdateUserCode(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    	    	changeOutcontractEquipmentLeaseItemVos.add(vo);
    		}
    		changeVO.setChangeOutcontractEquipmentLeaseItemList(changeOutcontractEquipmentLeaseItemVos);
    	}
    	
    	//处理租金明细表变更
    	List<OutcontractEquipmentRentEntity> outcontractEquipmentRentList = contractVO.getOutcontractEquipmentRentList();
    	if(outcontractEquipmentRentList!=null&&outcontractEquipmentRentList.size()>0){
    	    List<ChangeOutcontractEquipmentRentVO> changeOutcontractEquipmentRentVos = new ArrayList<>();
    		for(OutcontractEquipmentRentEntity entity : outcontractEquipmentRentList){
    			ChangeOutcontractEquipmentRentVO vo = BeanMapper.map(entity, ChangeOutcontractEquipmentRentVO.class);
    			vo.setChangeOutcontractId(id);
    			vo.setCreateTime(null);
    			vo.setCreateUserCode(null);
    			vo.setTenantId(null);
    			vo.setUpdateTime(null);
    			vo.setUpdateUserCode(null);
    			vo.setRowState("edit");
    			vo.setId(IdWorker.getId());
    	    	changeOutcontractEquipmentRentVos.add(vo);
    		}
    		changeVO.setChangeOutcontractEquipmentRentList(changeOutcontractEquipmentRentVos);
    	}

		//当前单据变更过则显示变更记录
		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("outcontract_id", changeVO.getOutcontractId());
    	List<RecordOutcontractEntity> records = recordOutcontractService.list(queryWrapper);
    	if(records!=null&&records.size()>0){
    		changeVO.setRecordOutcontractList(BeanMapper.mapList(records, RecordOutcontractVO.class));
    	}
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeOutcontractVO> queryDetail(Long id) {
    	ChangeOutcontractEntity entity = service.selectById(id);
    	ChangeOutcontractVO vo = BeanMapper.map(entity, ChangeOutcontractVO.class);
    	
    	List<ChangeOutcontractSupplierVO> outcontractSupplierList = new ArrayList<>();
    	ChangeOutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, ChangeOutcontractSupplierVO.class);
    	outcontractSupplierVO.setRowState("add");
    	outcontractSupplierList.add(outcontractSupplierVO);
		vo.setChangeOutcontractSupplierList(outcontractSupplierList);

		if(vo.getChangeOutcontractSubcontractUnitPriceList()!=null&&vo.getChangeOutcontractSubcontractUnitPriceList().size()>0){
			vo.setChangeOutcontractSubcontractUnitPriceList(createTreeData(vo.getChangeOutcontractSubcontractUnitPriceList()));
		}
		//当前单据变更过则显示变更记录
		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("outcontract_id", vo.getOutcontractId());
    	List<RecordOutcontractEntity> records = recordOutcontractService.list(queryWrapper);
    	if(records!=null&&records.size()>0){
    		vo.setRecordOutcontractList(BeanMapper.mapList(records, RecordOutcontractVO.class));
    	}
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeOutcontractVO> saveChange(@RequestBody ChangeOutcontractVO saveOrUpdateVO) {
    	return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeOutcontractVO> vos) {
        return service.delete(vos);
    }
    
    /**
     * @Description saveintegratedCode 保存一体化编码
     */
    @RequestMapping(value = "/saveintegratedCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeOutcontractVO> saveintegratedCode(@RequestBody ChangeOutcontractVO saveorUpdateVO) {
    	ChangeOutcontractEntity entity = service.selectById(saveorUpdateVO.getId());
    	entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
    	service.saveOrUpdate(entity, false);
    	ChangeOutcontractVO vo = BeanMapper.map(entity, ChangeOutcontractVO.class);
    	vo.setChangeOutcontractSupplierList(saveorUpdateVO.getChangeOutcontractSupplierList());
    	vo.setRecordOutcontractList(saveorUpdateVO.getRecordOutcontractList());
    	if(vo.getChangeOutcontractSubcontractUnitPriceList()!=null&&vo.getChangeOutcontractSubcontractUnitPriceList().size()>0){
    		vo.setChangeOutcontractSubcontractUnitPriceList(createTreeData(vo.getChangeOutcontractSubcontractUnitPriceList()));
    	}
		return CommonResponse.success("保存一体化编码成功", vo);
    }

	//清单编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode,Map<String,ChangeOutcontractSubcontractUnitPriceVO> map){
		if(map.get(pcode)!=null){
			return map.get(pcode).getId();
		}else{
			//父级没有找到，则继续往上找
			if(pcode.length()==2){
				//最上级
				return null;
			}else if(pcode.length()==4){
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			}else if(pcode.length()==6){
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			}else if(pcode.length()>6){
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			}else{
				return null;
			}
		}
	}
	
	public static List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
		List<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(ChangeOutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ChangeOutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	ChangeOutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ChangeOutcontractSubcontractUnitPriceVO> child = (List<ChangeOutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

	/**
	 * @Description 参照---根据合同id查询变更单
	 * @Return void
	 */
	@RequestMapping(value = "/refOutcontractChangeList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ChangeOutcontractVO>> refOutcontractChangeList(
			@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {

		QueryParam param = new QueryParam();
		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");

		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		if(StringUtils.isNotEmpty(condition)){
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("contractId")!=null){
				param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
			}
		}
		IPage<ChangeOutcontractEntity> page = service.queryPage(param,false);
		IPage<ChangeOutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeOutcontractVO.class));

		return CommonResponse.success("查询参照数据成功！",pageData);
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/syncYzwContract", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncYzwContract(Long id) {
		service.syncYzwContract(id);
		return CommonResponse.success("同步数据成功！");
	}
}
