/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.service.impl;

import cn.yzw.infra.component.base.model.YzwResult;
import cn.yzw.infra.component.fss.bean.FssClient;
import cn.yzw.infra.component.fss.model.response.UploadResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontractDisclosure.mapper.OutcontractDisclosureMapper;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontractService")
public class OutcontractServiceImpl
extends BaseServiceImpl<OutcontractMapper, OutcontractEntity>
implements IOutcontractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutcontractReviewService reviewService;
    @Autowired
    private OutcontractDisclosureMapper outcontractDisclosureMapper;
    @Autowired
    private IChangeOutcontractService changeOutcontractService;
    @Autowired
    private OutcontractMapper contractMapper;
    @Autowired
    private IYzwSyncService yzwSyncService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IShareSupplierApi supplierApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private FssClient fssClient;

    @Override
    public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if ("\u52b3\u52a1\u5206\u5305".equals(vos.get(0).getType()) || "\u4e13\u4e1a\u5206\u5305".equals(vos.get(0).getType())) {
            this.reviewService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"performance_status", (Object)performanceStatus);
        this.update(null, (Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u6539\u5c65\u7ea6\u72b6\u6001\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> changeDate(Long id, String type, Date date) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if ("mobilizationDate".equals(type)) {
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"mobilization_date", (Object)date);
        } else if ("exitDate".equals(type)) {
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"exit_date", (Object)date);
        }
        this.update(null, (Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u6539\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> file(OutcontractVO outcontractVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.selectById(outcontractVO.getId()));
        if ("1".equals(entity.getFileState())) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5f52\u6863");
        }
        if ("1".equals(entity.getChangeState())) {
            entity.setSignDate(outcontractVO.getSignDate());
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("outcontractId", new Parameter("eq", (Object)entity.getId()));
            param.getOrderMap().put("createTime", "desc");
            List list = this.changeOutcontractService.queryList(param, false);
            ChangeOutcontractEntity changeEntity = new ChangeOutcontractEntity();
            if (list != null && list.size() > 0) {
                changeEntity = (ChangeOutcontractEntity)((Object)list.get(0));
                changeEntity.setSupplementarySignTime(outcontractVO.getSignDate());
                this.changeOutcontractService.saveOrUpdate((Object)changeEntity, false);
            }
        }
        entity.setFileState("1");
        this.saveOrUpdate((Object)entity, false);
        this.redundanceData(entity);
        CommonResponse back = this.attachmentApi.updateAttachRef(outcontractVO.getId(), outcontractVO.getAttachIds());
        if (!back.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }

    @Override
    public IPage<OutcontractSupplierVO> refSupplierList(Map<String, Object> params) {
        Long count = this.contractMapper.countSupplier(params);
        Integer pageIndex = (Integer)params.get("pageIndex");
        Integer pageSize = (Integer)params.get("pageSize");
        Page pageData = new Page((long)pageIndex.intValue(), (long)pageSize.intValue(), count.longValue());
        if (count > 0L) {
            List<OutcontractSupplierVO> list = this.contractMapper.querySupplierList(params);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (OutcontractSupplierVO vo : list) {
                ids.add(vo.getId());
            }
            CommonResponse supplierResponse = this.shareSupplierApi.querySupplierByIds(ids);
            if (supplierResponse.isSuccess() && supplierResponse.getData() != null && ((List)supplierResponse.getData()).size() > 0) {
                HashMap<Long, SupplierVO> map = new HashMap<Long, SupplierVO>();
                for (SupplierVO supplierVO : (List)supplierResponse.getData()) {
                    map.put(supplierVO.getId(), supplierVO);
                }
                for (OutcontractSupplierVO outcontractSupplierVO : list) {
                    if (map.get(outcontractSupplierVO.getId()) == null) continue;
                    SupplierVO supplierVO = (SupplierVO)map.get(outcontractSupplierVO.getId());
                    outcontractSupplierVO.setSupplierName(supplierVO.getName());
                    outcontractSupplierVO.setSupplierTaxPayerType(supplierVO.getTaxPayerType());
                    outcontractSupplierVO.setSupplierSocialCreditCode(supplierVO.getSocialCreditCode());
                    outcontractSupplierVO.setSupplierBank(supplierVO.getBankName());
                    outcontractSupplierVO.setSupplierBankAccount(supplierVO.getBankAccount());
                    outcontractSupplierVO.setSupplierLegal(supplierVO.getLegal());
                    outcontractSupplierVO.setSupplierTelephone(supplierVO.getTelephone());
                }
            }
            pageData.setRecords(list);
        }
        return pageData;
    }

    @Override
    public void redundanceData(OutcontractEntity entity) {
        String signDate = null;
        if (entity.getSignDate() != null) {
            signDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getSignDate());
        }
        this.outcontractDisclosureMapper.updateContract(entity.getContractPrice(), signDate, entity.getId());
    }

    @Override
    public void syncYzwContract(Long id) {
        JSONArray listData;
        CommonResponse orgResponse;
        OutcontractEntity entity = (OutcontractEntity)((Object)this.selectById(id));
        CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("pl_project");
        Boolean publicProject = false;
        ArrayList plProjectName = new ArrayList();
        if (defdocResponse.isSuccess() && ((List)defdocResponse.getData()).size() > 0) {
            ((List)defdocResponse.getData()).forEach(item -> plProjectName.add(item.getName()));
        }
        if (plProjectName.contains(entity.getProjectName())) {
            publicProject = true;
        }
        JSONObject param = new JSONObject();
        BigDecimal amount = new BigDecimal(0);
        CommonResponse projectResponse = this.zjkjProjectApi.queryDetailById(entity.getProjectId());
        ProjectVO projectVO = null;
        if (!projectResponse.isSuccess() || projectResponse.getData() == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9879\u76ee\u4fe1\u606f");
        }
        projectVO = (ProjectVO)projectResponse.getData();
        String yzwProjectCode = projectVO.getYzwProjectCode();
        String yzwUser = projectVO.getYzwUser();
        if (StringUtils.isBlank((CharSequence)yzwProjectCode) && !publicProject.booleanValue()) {
            throw new BusinessException("\u9879\u76ee\u672a\u5173\u8054\u4e91\u7b51\u7f51\u6570\u636e");
        }
        if (StringUtils.isBlank((CharSequence)yzwUser)) {
            throw new BusinessException("\u9879\u76ee\u4eba\u5458\u672a\u5173\u8054\u4e91\u7b51\u7f51\u6570\u636e");
        }
        String buildUnit = null;
        if (entity.getBuildUnit() != null && (orgResponse = this.orgApi.detailById(entity.getBuildUnit())).isSuccess() && orgResponse.getData() != null && StringUtils.isBlank((CharSequence)(buildUnit = ((OrgVO)orgResponse.getData()).getYzwOrgCode()))) {
            throw new BusinessException("\u5b9e\u65bd\u5355\u4f4d\u672a\u5173\u8054\u4e91\u7b51\u7f51\u6570\u636e");
        }
        String signUnit = null;
        if (entity.getSignUnit() != null) {
            if (entity.getBuildUnit() != entity.getSignUnit()) {
                CommonResponse orgResponse2 = this.orgApi.detailById(entity.getSignUnit());
                if (orgResponse2.isSuccess() && orgResponse2.getData() != null && StringUtils.isBlank((CharSequence)(signUnit = ((OrgVO)orgResponse2.getData()).getYzwOrgCode()))) {
                    throw new BusinessException("\u7b7e\u7ea6\u5355\u4f4d\u672a\u5173\u8054\u4e91\u7b51\u7f51\u6570\u636e");
                }
            } else {
                signUnit = buildUnit;
            }
        }
        String partyBCompanyId = null;
        if (entity.getSupplier() != null) {
            CommonResponse supplierResponse = this.supplierApi.queryById(entity.getSupplier());
            if (supplierResponse.isSuccess() && supplierResponse.getData() != null) {
                partyBCompanyId = ((SupplierVO)supplierResponse.getData()).getYzwSupplierCode();
            }
            if (StringUtils.isBlank(partyBCompanyId)) {
                throw new BusinessException("\u4f9b\u5e94\u5546\u672a\u5173\u8054\u4e91\u7b51\u7f51\u6570\u636e");
            }
        }
        Boolean leaseFlag = false;
        if ("\u52b3\u52a1\u5206\u5305".equals(entity.getType())) {
            amount = entity.getSubcontractTotalAmount();
        } else if ("\u4e13\u4e1a\u5206\u5305".equals(entity.getType())) {
            amount = entity.getSubcontractTotalAmount();
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(entity.getType())) {
            amount = entity.getContractPriceTotalAmount();
        } else if ("\u673a\u68b0\u79df\u8d41".equals(entity.getType())) {
            amount = entity.getLeaseItemTotalAmount();
            leaseFlag = true;
        } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(entity.getType())) {
            amount = entity.getContractPriceTotalAmount();
            leaseFlag = true;
        } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(entity.getType())) {
            amount = entity.getContractPrice();
        } else if ("\u54a8\u8be2\u670d\u52a1".equals(entity.getType())) {
            amount = entity.getContractPrice();
        } else if ("\u5176\u5b83\u5408\u540c".equals(entity.getType())) {
            amount = entity.getContractPrice();
        } else if ("\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(entity.getType())) {
            amount = entity.getContractPrice();
        }
        param.put("amount", (Object)amount);
        param.put("categoryCode", (Object)"TENDER_PURCHASE_CONTRACT");
        param.put("createUserId", (Object)yzwUser);
        param.put("currency", (Object)"CNY");
        param.put("customNo", (Object)entity.getBillCode());
        if (entity.getMobilizationDate() != null) {
            param.put("effectiveStartTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(entity.getMobilizationDate()));
        }
        if (entity.getExitDate() != null) {
            param.put("effectiveEndTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(entity.getExitDate()));
        }
        param.put("name", (Object)entity.getContractName());
        ArrayList<String> organizationList = new ArrayList<String>();
        organizationList.add(buildUnit);
        param.put("organizationList", organizationList);
        param.put("partyACode", (Object)signUnit);
        param.put("partyAManagerId", (Object)yzwUser);
        param.put("partyBCompanyId", (Object)partyBCompanyId);
        ArrayList<String> projectListId = new ArrayList<String>();
        if (publicProject.booleanValue()) {
            projectListId.add("-1000");
        } else {
            projectListId.add(yzwProjectCode);
        }
        param.put("projectListId", projectListId);
        param.put("remark", (Object)entity.getRemark());
        param.put("settlementAfterInspection", (Object)false);
        param.put("signOrgName", (Object)entity.getSignUnitName());
        if (entity.getSignDate() != null) {
            param.put("signTime", (Object)new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getSignDate()));
        }
        param.put("status", (Object)"APPROVED");
        param.put("tenderCode", (Object)entity.getCalibrationTenderCode());
        param.put("thirdPartyId", (Object)entity.getId().toString());
        param.put("updateUserId", (Object)yzwUser);
        param.put("paymentMethod", (Object)"INSTALLMENTS");
        String pricingMethod = null;
        switch (entity.getPricingForm()) {
            case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": 
            case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": 
            case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": 
            case "\u56fa\u5b9a\u5355\u4ef7": 
            case "\u53ef\u8c03\u4ef7\u683c": {
                pricingMethod = "UNIT_PRICE";
                break;
            }
            case "\u56fa\u5b9a\u603b\u4ef7": {
                pricingMethod = "LUMP_SUM";
                break;
            }
            case "\u5b9a\u989d\u8ba1\u4ef7": 
            case "\u5176\u4ed6": {
                pricingMethod = "OTHER";
            }
        }
        param.put("pricingMethod", (Object)pricingMethod);
        param.put("leaseFlag", (Object)leaseFlag);
        param.put("signType", (Object)"MAJOR_CONTRACT");
        param.put("signWay", (Object)"ONLINE");
        JSONArray signedAttachmentList = new JSONArray();
        JSONObject signedAttachment = new JSONObject();
        signedAttachment.put("fileName", (Object)"\u7b7e\u7ae0\u5360\u4f4d\u9644\u4ef6.pdf");
        signedAttachment.put("ossUrl", (Object)"xx.pdf");
        signedAttachmentList.add((Object)signedAttachment);
        param.put("signedAttachmentList", (Object)signedAttachmentList);
        if ("\u52b3\u52a1\u5206\u5305".equals(entity.getType()) || "\u4e13\u4e1a\u5206\u5305".equals(entity.getType())) {
            listData = this.dealUnitListData(entity.getOutcontractSubcontractUnitPriceList());
            param.put("listData", (Object)listData);
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(entity.getType()) || "\u5468\u8f6c\u6750\u79df\u8d41".equals(entity.getType())) {
            listData = this.dealMaterialListData(entity.getOutcontractMaterialList());
            param.put("listData", (Object)listData);
        } else if ("\u673a\u68b0\u79df\u8d41".equals(entity.getType())) {
            listData = this.dealEquipmentListLeaseItemData(entity.getOutcontractEquipmentLeaseItemList());
            param.put("listData", (Object)listData);
        }
        JSONObject result = this.yzwSyncService.syncContract(param);
        String sysNo = result.getString("sysNo");
        String openSysNo = result.getString("openSysNo");
        entity.setYzwOpenContractCode(openSysNo);
        entity.setYzwContractCode(sysNo);
        this.saveOrUpdate((Object)entity, false);
    }

    @Override
    public JSONArray upadteYzwFile(Long id, String type) {
        JSONArray signedAttachmentList = new JSONArray();
        String billType = null;
        String sourceType = "zjkj-outcontract";
        if ("\u52b3\u52a1\u5206\u5305".equals(type)) {
            billType = "BT220105000000001";
        } else if ("\u4e13\u4e1a\u5206\u5305".equals(type)) {
            billType = "BT220105000000002";
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(type)) {
            billType = "BT220105000000003";
        } else if ("\u673a\u68b0\u79df\u8d41".equals(type)) {
            billType = "BT220105000000004";
        } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(type)) {
            billType = "BT220105000000005";
        } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(type)) {
            billType = "BT220105000000006";
        } else if ("\u54a8\u8be2\u670d\u52a1".equals(type)) {
            billType = "BT220105000000007";
        } else if ("\u5176\u5b83\u5408\u540c".equals(type)) {
            billType = "BT220105000000008";
        } else if ("\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(type)) {
            billType = "EJCBT202207000040";
        }
        CommonResponse att = this.attachmentApi.queryListBySourceId(id, billType, sourceType, null);
        if (att.isSuccess() && att.getData() != null) {
            for (AttachmentVO datum : (List)att.getData()) {
                String downloadUrl = this.environmentTools.getBaseHost() + "ejc-file-web/attachment/no_auth/download?fileId=" + datum.getId();
                byte[] fileData = null;
                try {
                    int bytesRead;
                    URL download = new URL(downloadUrl);
                    HttpURLConnection conn = (HttpURLConnection)download.openConnection();
                    conn.setRequestMethod("HEAD");
                    BufferedInputStream in = new BufferedInputStream(download.openStream());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    fileData = out.toByteArray();
                }
                catch (Exception e) {
                    throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
                }
                YzwResult fssResult = this.fssClient.upload(datum.getFileName(), fileData, null, new Map[0]);
                this.logger.info(((JSONObject)BeanMapper.map((Object)fssResult, JSONObject.class)).toJSONString());
                if (fssResult.getCode() != 200) continue;
                JSONObject signedAttachment = new JSONObject();
                signedAttachment.put("fileName", (Object)datum.getFileName());
                signedAttachment.put("ossUrl", (Object)((UploadResponse)fssResult.getData()).getUrl());
                signedAttachmentList.add((Object)signedAttachment);
            }
        } else {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6");
        }
        return signedAttachmentList;
    }

    @Override
    public void syncYzwSign(Long id) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.selectById(id));
        String billType = null;
        String sourceType = "zjkj-outcontract-yzw-sign";
        if ("\u52b3\u52a1\u5206\u5305".equals(entity.getType())) {
            billType = "BT220105000000001";
        } else if ("\u4e13\u4e1a\u5206\u5305".equals(entity.getType())) {
            billType = "BT220105000000002";
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(entity.getType())) {
            billType = "BT220105000000003";
        } else if ("\u673a\u68b0\u79df\u8d41".equals(entity.getType())) {
            billType = "BT220105000000004";
        } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(entity.getType())) {
            billType = "BT220105000000005";
        } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(entity.getType())) {
            billType = "BT220105000000006";
        } else if ("\u54a8\u8be2\u670d\u52a1".equals(entity.getType())) {
            billType = "BT220105000000007";
        } else if ("\u5176\u5b83\u5408\u540c".equals(entity.getType())) {
            billType = "BT220105000000008";
        } else if ("\u8bfe\u9898\u652f\u51fa\u7c7b\u5408\u540c".equals(entity.getType())) {
            billType = "EJCBT202207000040";
        }
        CommonResponse att = this.attachmentApi.queryListBySourceId(entity.getId(), billType, sourceType, null);
        if (!att.isSuccess() || att.getData() == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6");
        }
        JSONObject result = this.yzwSyncService.uploadYzwSign(((AttachmentVO)((List)att.getData()).get(0)).getId().toString(), entity.getId(), entity.getContractName(), entity.getBillCode());
        String data = result.getString("data");
        entity.setYzwSignCode(data);
        this.saveOrUpdate((Object)entity, false);
    }

    private JSONArray dealUnitListData(List<OutcontractSubcontractUnitPriceEntity> unitPriceList) {
        JSONArray listData = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("listName", (Object)"\u5206\u5305\u5de5\u7a0b\u7efc\u5408\u5355\u4ef7\u8ba1\u4ef7\u6e05\u5355");
        data.put("source", (Object)"yql");
        data.put("listType", (Object)"BOQ");
        data.put("priceTaxSeparation", (Object)true);
        data.put("quoteType", (Object)"FLOAT");
        data.put("systemCategory", (Object)"0001");
        JSONArray columns = new JSONArray();
        columns.add((Object)this.createColumn("yzwForeignId", "\u4e91\u7b51\u5de5\u7a0b\u91cf\u5206\u7c7bid", "TEXT", 1));
        columns.add((Object)this.createColumn("outForeignId", "\u4e09\u65b9\u5de5\u7a0b\u91cf\u5206\u7c7bid", "TEXT", 1));
        columns.add((Object)this.createColumn("listCode", "\u6e05\u5355\u7f16\u53f7", "TEXT", 1));
        columns.add((Object)this.createColumn("project", "\u9879\u76ee", "TEXT", 2));
        columns.add((Object)this.createColumn("jobContent", "\u5de5\u4f5c\u5185\u5bb9", "TEXT", 3));
        columns.add((Object)this.createColumn("projectCharacteristic", "\u9879\u76ee\u7279\u5f81", "TEXT", 4));
        columns.add((Object)this.createColumn("engineeringQuantity", "\u5de5\u7a0b\u91cf", "NUMBER", 6));
        columns.add((Object)this.createColumn("comprehensiveUnitPrice", "\u7efc\u5408\u5355\u4ef7", "NUMBER", 7));
        columns.add((Object)this.createColumn("totalPrice", "\u5408\u8ba1", "NUMBER", 8));
        columns.add((Object)this.createColumn("laborCost", "\u4eba\u5de5\u8d39", "NUMBER", 9));
        columns.add((Object)this.createColumn("mainMaterialCost", "\u4e3b\u6750\u8d39", "NUMBER", 10));
        columns.add((Object)this.createColumn("materialLoss", "\u6750\u6599\u635f\u8017", "NUMBER", 11));
        columns.add((Object)this.createColumn("auxiliaryMaterialCost", "\u8f85\u6750\u8d39", "NUMBER", 12));
        columns.add((Object)this.createColumn("machineryCost", "\u673a\u68b0\u8d39", "NUMBER", 13));
        columns.add((Object)this.createColumn("managementCost", "\u7ba1\u7406\u8d39", "NUMBER", 14));
        columns.add((Object)this.createColumn("profit", "\u5229\u6da6", "NUMBER", 15));
        columns.add((Object)this.createColumn("paidGovernmentCost", "\u89c4\u8d39", "NUMBER", 16));
        columns.add((Object)this.createColumn("tax", "\u7a0e\u91d1", "NUMBER", 17));
        columns.add((Object)this.createColumn("mainMaterialBrand", "\u4e3b\u6750\u54c1\u724c", "TEXT", 18));
        columns.add((Object)this.createColumn("remark", "\u5907\u6ce8", "TEXT", 19));
        columns.add((Object)this.createColumn("ForeignCode", "\u5206\u90e8\u5206\u9879\u9879\u76ee\u7f16\u7801", "TEXT", 20));
        columns.add((Object)this.createColumn("Name", "\u5206\u90e8\u5206\u9879\u9879\u76ee\u540d\u79f0", "TEXT", 20));
        columns.add((Object)this.createColumn("Character", "\u5206\u90e8\u5206\u9879\u9879\u76ee\u7279\u5f81", "TEXT", 20));
        columns.add((Object)this.createColumn("GCL", "\u5de5\u7a0b\u91cf", "NUMBER", 21));
        columns.add((Object)this.createColumn("Quantity", "\u6570\u91cf", "NUMBER", 24));
        columns.add((Object)this.createColumn("Unit", "\u5355\u4f4d", "TEXT", 25));
        columns.add((Object)this.createColumn("TaxRate", "\u7a0e\u7387", "NUMBER", 26));
        columns.add((Object)this.createColumn("TaxAmount", "\u7a0e\u989d", "NUMBER", 27));
        columns.add((Object)this.createColumn("ExcludeTaxUnitPrice", "\u4e0d\u542b\u7a0e\u5355\u4ef7", "NUMBER", 29));
        columns.add((Object)this.createColumn("ComUnitPrice", "\u7efc\u5408\u5355\u4ef7/\u542b\u7a0e\u5355\u4ef7", "NUMBER", 28));
        columns.add((Object)this.createColumn("Valence", "\u5408\u4ef7", "NUMBER", 30));
        columns.add((Object)this.createColumn("ExcludeTaxTotalPrice", "\u4e0d\u542b\u7a0e\u5408\u4ef7", "NUMBER", 31));
        data.put("columns", (Object)columns);
        JSONArray instance = new JSONArray();
        JSONObject par = new JSONObject();
        JSONObject dataValue = new JSONObject();
        dataValue.put("yzwForeignId", (Object)"20036773");
        par.put("dataValue", (Object)dataValue);
        JSONArray chil = new JSONArray();
        for (OutcontractSubcontractUnitPriceEntity vo : unitPriceList) {
            JSONObject re = new JSONObject();
            JSONObject ins = new JSONObject();
            ins.put("GCL", (Object)vo.getEngineeringQuantity());
            ins.put("Unit", (Object)vo.getUnit());
            ins.put("Character", (Object)vo.getProject());
            ins.put("TaxRate", (Object)0);
            ins.put("TaxAmount", (Object)0);
            ins.put("ComUnitPrice", (Object)vo.getComprehensiveUnitPrice());
            ins.put("ExcludeTaxUnitPrice", (Object)vo.getComprehensiveUnitPrice());
            ins.put("Valence", (Object)vo.getTotalPrice());
            ins.put("ExcludeTaxTotalPrice", (Object)vo.getTotalPrice());
            ins.put("listCode", (Object)vo.getListCode());
            ins.put("project", (Object)vo.getProject());
            ins.put("jobContent", (Object)vo.getJobContent());
            ins.put("projectCharacteristic", (Object)vo.getProjectCharacteristic());
            ins.put("engineeringQuantity", (Object)vo.getEngineeringQuantity());
            ins.put("comprehensiveUnitPrice", (Object)vo.getComprehensiveUnitPrice());
            ins.put("totalPrice", (Object)vo.getTotalPrice());
            ins.put("laborCost", (Object)vo.getLaborCost());
            ins.put("mainMaterialCost", (Object)vo.getMainMaterialCost());
            ins.put("materialLoss", (Object)vo.getMaterialLoss());
            ins.put("auxiliaryMaterialCost", (Object)vo.getAuxiliaryMaterialCost());
            ins.put("machineryCost", (Object)vo.getMachineryCost());
            ins.put("profit", (Object)vo.getProfit());
            ins.put("paidGovernmentCost", (Object)vo.getPaidGovernmentCost());
            ins.put("tax", (Object)vo.getTax());
            ins.put("mainMaterialBrand", (Object)vo.getMainMaterialBrand());
            ins.put("remark", (Object)vo.getRemark());
            re.put("dataValue", (Object)ins);
            chil.add((Object)re);
        }
        par.put("childList", (Object)chil);
        instance.add((Object)par);
        data.put("instance", (Object)instance);
        listData.add((Object)data);
        return listData;
    }

    private JSONArray dealMaterialListData(List<OutcontractMaterialEntity> materialList) {
        JSONArray listData = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("listName", (Object)"\u7269\u8d44\u6e05\u5355");
        data.put("source", (Object)"yql");
        data.put("listType", (Object)"PRODUCT");
        data.put("priceTaxSeparation", (Object)true);
        data.put("quoteType", (Object)"FLOAT");
        data.put("systemCategory", (Object)"0002");
        JSONArray columns = new JSONArray();
        columns.add((Object)this.createColumn("outSkuNo", "\u4e09\u65b9sku\u7f16\u53f7", "TEXT", 1));
        columns.add((Object)this.createColumn("CategoryName", "\u5546\u54c1\u7c7b\u522b", "TEXT", 20));
        columns.add((Object)this.createColumn("ProductCommonName", "\u5546\u54c1\u540d\u79f0", "TEXT", 21));
        columns.add((Object)this.createColumn("Model", "\u89c4\u683c\u578b\u53f7", "TEXT", 22));
        columns.add((Object)this.createColumn("QuotedBasis", "\u62a5\u4ef7\u4f9d\u636e", "TEXT", 23));
        columns.add((Object)this.createColumn("Quantity", "\u6570\u91cf", "NUMBER", 24));
        columns.add((Object)this.createColumn("Unit", "\u5355\u4f4d", "TEXT", 25));
        columns.add((Object)this.createColumn("TaxRate", "\u7a0e\u7387", "TEXT", 26));
        columns.add((Object)this.createColumn("TaxAmount", "\u7a0e\u989d", "NUMBER", 27));
        columns.add((Object)this.createColumn("QuotedPrice", "\u542b\u7a0e\u5355\u4ef7", "NUMBER", 28));
        columns.add((Object)this.createColumn("ExcludeTaxUnitPrice", "\u4e0d\u542b\u7a0e\u5355\u4ef7", "NUMBER", 29));
        columns.add((Object)this.createColumn("Valence", "\u5408\u4ef7", "NUMBER", 30));
        columns.add((Object)this.createColumn("ExcludeTaxTotalPrice", "\u4e0d\u542b\u7a0e\u5408\u4ef7", "NUMBER", 31));
        columns.add((Object)this.createColumn("materialCode", "\u7269\u8d44\u7f16\u7801", "TEXT", 1));
        columns.add((Object)this.createColumn("materialName", "\u6807\u7684\u540d\u79f0", "TEXT", 2));
        columns.add((Object)this.createColumn("strengthGrade", "\u5f3a\u5ea6\u7b49\u7ea7", "TEXT", 3));
        columns.add((Object)this.createColumn("materialSpec", "\u89c4\u683c\u578b\u53f7", "TEXT", 4));
        columns.add((Object)this.createColumn("brandTrademark", "\u54c1\u724c\u5546\u6807", "TEXT", 5));
        columns.add((Object)this.createColumn("materialUnit", "\u8ba1\u91cf\u5355\u4f4d", "TEXT", 6));
        columns.add((Object)this.createColumn("quantity", "\u6682\u5b9a\u6570\u91cf", "NUMBER", 7));
        columns.add((Object)this.createColumn("untaxUnitPrice", "\u4e0d\u542b\u7a0e\u5355\u4ef7", "NUMBER", 8));
        columns.add((Object)this.createColumn("taxUnitPrice", "\u542b\u7a0e\u5355\u4ef7", "NUMBER", 10));
        columns.add((Object)this.createColumn("totalPrice", "\u5408\u4ef7", "NUMBER", 11));
        data.put("columns", (Object)columns);
        JSONArray instance = new JSONArray();
        for (OutcontractMaterialEntity vo : materialList) {
            JSONObject ins = new JSONObject();
            ins.put("outSkuNo", (Object)vo.getId().toString());
            ins.put("Model", (Object)vo.getMaterialSpec());
            ins.put("QuotedBasis", (Object)vo.getBrandTrademark());
            ins.put("Quantity", (Object)vo.getQuantity());
            ins.put("TaxRate", (Object)vo.getTaxRate());
            ins.put("TaxAmount", (Object)0);
            ins.put("QuotedPrice", (Object)vo.getTaxUnitPrice());
            ins.put("ExcludeTaxUnitPrice", (Object)vo.getUntaxUnitPrice());
            ins.put("Valence", (Object)vo.getTotalPrice());
            ins.put("ExcludeTaxTotalPrice", (Object)vo.getUntaxUnitPrice().multiply(vo.getQuantity()));
            ins.put("materialCode", (Object)vo.getMaterialCode());
            ins.put("materialName", (Object)vo.getMaterialName());
            ins.put("strengthGrade", (Object)vo.getStrengthGrade());
            ins.put("materialSpec", (Object)vo.getMaterialSpec());
            ins.put("brandTrademark", (Object)vo.getBrandTrademark());
            ins.put("materialUnit", (Object)vo.getMaterialUnit());
            ins.put("quantity", (Object)vo.getQuantity());
            ins.put("untaxUnitPrice", (Object)vo.getUntaxUnitPrice());
            ins.put("taxUnitPrice", (Object)vo.getTaxUnitPrice());
            ins.put("totalPrice", (Object)vo.getTotalPrice());
            instance.add((Object)ins);
        }
        data.put("instance", (Object)instance);
        listData.add((Object)data);
        return listData;
    }

    private JSONArray dealEquipmentListLeaseItemData(List<OutcontractEquipmentLeaseItemEntity> outcontractEquipmentLeaseItemList) {
        JSONArray listData = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("listName", (Object)"\u79df\u8d41\u7269\u8fdb\u51fa\u573a\u8d39\u660e\u7ec6");
        data.put("source", (Object)"yql");
        data.put("listType", (Object)"PRODUCT");
        data.put("priceTaxSeparation", (Object)true);
        data.put("quoteType", (Object)"FLOAT");
        data.put("systemCategory", (Object)"0003");
        JSONArray columns = new JSONArray();
        columns.add((Object)this.createColumn("equipmentCode", "\u7f16\u7801", "TEXT", 1));
        columns.add((Object)this.createColumn("equipmentName", "\u8bbe\u5907\u540d\u79f0", "TEXT", 2));
        columns.add((Object)this.createColumn("equipmentSpec", "\u89c4\u683c", "TEXT", 3));
        columns.add((Object)this.createColumn("entranceExitFee", "\u8fdb\u51fa\u573a\u8d39\uff08\u5143/\u53f0\uff09", "NUMBER", 4));
        columns.add((Object)this.createColumn("quantity", "\u53f0\u6570", "NUMBER", 5));
        columns.add((Object)this.createColumn("taxRate", "\u7a0e\u7387\uff08%\uff09", "NUMBER", 6));
        columns.add((Object)this.createColumn("totalPrice", "\u5408\u8ba1\uff08\u5143\uff09", "NUMBER", 7));
        columns.add((Object)this.createColumn("remark", "\u5907\u6ce8", "TEXT", 8));
        data.put("columns", (Object)columns);
        JSONArray instance = new JSONArray();
        for (OutcontractEquipmentLeaseItemEntity vo : outcontractEquipmentLeaseItemList) {
            JSONObject ins = new JSONObject();
            ins.put("equipmentCode", (Object)vo.getEquipmentCode());
            ins.put("equipmentName", (Object)vo.getEquipmentName());
            ins.put("equipmentSpec", (Object)vo.getEquipmentSpec());
            ins.put("entranceExitFee", (Object)vo.getEntranceExitFee());
            ins.put("quantity", (Object)vo.getQuantity());
            ins.put("taxRate", (Object)vo.getTaxRate());
            ins.put("totalPrice", (Object)vo.getTotalPrice());
            ins.put("remark", (Object)vo.getRemark());
            instance.add((Object)ins);
        }
        data.put("instance", (Object)instance);
        listData.add((Object)data);
        return listData;
    }

    private JSONObject createColumn(String columnCode, String columnName, String valueType, Integer sortIndex) {
        JSONObject column = new JSONObject();
        column.put("columnCode", (Object)columnCode);
        column.put("columnName", (Object)columnName);
        column.put("valueType", (Object)valueType);
        column.put("sortIndex", (Object)sortIndex);
        return column;
    }
}

