package com.ejianc.foundation.report.service.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportOrgMapper;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportOrgEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryReportOrgService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryService;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryReportVO;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;

/**
 * 集团-供方合同签约统计汇总表
 *
 * @author generator
 */
@Service("outcontractSignSummaryService")
public class OutcontractSignSummaryServiceImpl implements IOutcontractSignSummaryService {
    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final static String ESSignSummary = "ejc_zjkj_outcontract_sign_summary";

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private IOutcontractSignSummaryReportOrgService outcontractSignSummaryReportOrgService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private OutcontractMapper contractMapper;
    @Autowired
    private OutcontractSignSummaryReportOrgMapper outcontractSignSummaryReportOrgMapper;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        //1、生成关系表
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("集团-供方合同签约统计汇总表");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        outcontractReportService.saveOrUpdate(reportEntity, false);
        //获取当前合同数据
        QueryParam queryParam = new QueryParam();
        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }

        List<RecordOutcontractVO> list = queryList(queryParam, null, noExitProjectName);
        List<Long> orgIds = new ArrayList<>();
        List<OutcontractSignSummaryReportOrgEntity> entityList = new ArrayList<>();


        BulkRequest bulkRequest = new BulkRequest();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<Long,String> signDateMap = new HashMap<>();
        for (RecordOutcontractVO entity : list) {
        	if(entity.getSignDate()!=null){
        		if(signDateMap.get(entity.getOrgId())!=null){
            		String signDate = signDateMap.get(entity.getOrgId());
            		signDate += (","+dateFormat.format(entity.getSignDate()));
            		signDateMap.put(entity.getOrgId(), signDate);
            	}else{
            		signDateMap.put(entity.getOrgId(), dateFormat.format(entity.getSignDate()));
            	}
        	}
        }
        for (RecordOutcontractVO entity : list) {
            try {
                if(!orgIds.contains(entity.getOrgId())){
                	orgIds.add(entity.getOrgId());
                	OutcontractSignSummaryReportOrgEntity e = new OutcontractSignSummaryReportOrgEntity();
                	e.setReportId(reportId);
                	e.setOrgId(entity.getOrgId());
                	e.setTenantId(entity.getTenantId());
                	e.setCreateTime(e.getCreateTime());
                	e.setSignDate(signDateMap.get(entity.getOrgId()));
					entityList.add(e);
                }
                OutcontractSignSummaryVO outcontractSignSummaryVO = BeanMapper.map(entity, OutcontractSignSummaryVO.class);
                Map<String, Object> dataMap = BeanMapper.map(outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummary);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成集团-供方合同签约统计汇总表数据异常，", e);
                throw new BusinessException("生成集团-供方合同签约统计汇总表数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if(entityList!=null&&entityList.size()>0){
            	outcontractSignSummaryReportOrgService.saveOrUpdateBatch(entityList, entityList.size(), false);
            }
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成集团-供方合同签约统计汇总表执行 完事 *********** ");
        return CommonResponse.success("生成集团-供方合同签约统计汇总表成功");
    }

    @Override
    public CommonResponse<String> addESData(String curDate, String signDate) {
        //1、生成关系表
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName("集团-供方合同签约统计汇总表（自动）"+curDate);
        reportEntity.setReportType("集团-供方合同签约统计汇总表");
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        outcontractReportService.saveOrUpdate(reportEntity, false);
        //获取当前合同数据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("signDate", new Parameter(QueryParam.EQ, signDate));
        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }

        List<RecordOutcontractVO> list = queryList(queryParam, null, noExitProjectName);
        List<Long> orgIds = new ArrayList<>();
        List<OutcontractSignSummaryReportOrgEntity> entityList = new ArrayList<>();


        BulkRequest bulkRequest = new BulkRequest();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<Long,String> signDateMap = new HashMap<>();
        for (RecordOutcontractVO entity : list) {
            if(entity.getSignDate()!=null){
                if(signDateMap.get(entity.getOrgId())!=null){
                    String signDat = signDateMap.get(entity.getOrgId());
                    signDat += (","+dateFormat.format(entity.getSignDate()));
                    signDateMap.put(entity.getOrgId(), signDat);
                }else{
                    signDateMap.put(entity.getOrgId(), dateFormat.format(entity.getSignDate()));
                }
            }
        }
        for (RecordOutcontractVO entity : list) {
            try {
                if(!orgIds.contains(entity.getOrgId())){
                    orgIds.add(entity.getOrgId());
                    OutcontractSignSummaryReportOrgEntity e = new OutcontractSignSummaryReportOrgEntity();
                    e.setReportId(reportId);
                    e.setOrgId(entity.getOrgId());
                    e.setTenantId(entity.getTenantId());
                    e.setCreateTime(e.getCreateTime());
                    e.setSignDate(signDateMap.get(entity.getOrgId()));
                    entityList.add(e);
                }
                OutcontractSignSummaryVO outcontractSignSummaryVO = BeanMapper.map(entity, OutcontractSignSummaryVO.class);
                Map<String, Object> dataMap = BeanMapper.map(outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummary);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成集团-供方合同签约统计汇总表数据异常，", e);
                throw new BusinessException("生成集团-供方合同签约统计汇总表数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if(entityList!=null&&entityList.size()>0){
                outcontractSignSummaryReportOrgService.saveOrUpdateBatch(entityList, entityList.size(), false);
            }
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成集团-供方合同签约统计汇总表执行 完事 *********** ");
        return CommonResponse.success("生成集团-供方合同签约统计汇总表成功");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractSignSummaryReportVO> queryPage(HttpServletRequest request, QueryParam param) {
        IPage<OutcontractSignSummaryReportVO> page = new Page<>();
        List<OutcontractSignSummaryReportVO> resultList = new ArrayList<>();
        Map<String, Parameter> params = param.getParams();
        //获取不统计的项目的名称
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> noExitProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                noExitProjectName.add(item.getName());
            });
        }
        OrgVO selforgVO = null;
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        for (OrgVO org : orgVOList){
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
                if(org.getId().equals(InvocationInfoProxy.getOrgId())){
                    selforgVO = org;
                }
            }
        }
        page.setCurrent(param.getPageIndex());

        //查询所有的二级组织
        List<OrgVO> secondOrg = new ArrayList<>();
        CommonResponse<OrgVO> rootOrg = iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
        if(rootOrg.isSuccess() && rootOrg.getData()!=null){
            CommonResponse<List<OrgVO>> secondOrgResponse = iOrgApi.getDirectChildrenByPid(rootOrg.getData().getId(), null);
            if(secondOrgResponse.isSuccess() && secondOrgResponse.getData().size()> 0){
                secondOrg = secondOrgResponse.getData();
            }
        }
        //判断当前组织是否是跟组织，二级组织，二级下的组织
        String orglevel = "";
        Integer level = selforgVO.getInnerCode().length() - selforgVO.getInnerCode().replaceAll("\\|","").length();
        if(selforgVO.getId().toString().equals(selforgVO.getInnerCode())){
            orglevel = "root";
        }else if(level==1 && selforgVO.getOrgType()==4){
            orglevel = "root";
        }else{
            OrgVO second = null;
            for(OrgVO orgVO : secondOrg){
                if(selforgVO.getInnerCode().contains(orgVO.getInnerCode())){
                    second = orgVO;
                }
            }
            if(second!=null){
                secondOrg = new ArrayList<>();
                secondOrg.add(second);
            }
        }


        if(commonOrgIds.size()==0){
            page = new Page<>(param.getPageIndex(), param.getPageSize(), resultList.size());
            page.setRecords(resultList);
            return page;
        }
        params.put("commonOrgIds", new Parameter(QueryParam.IN, commonOrgIds));
        if (params.get("range") != null && "es".equals(params.get("range").getValue().toString())) {
            params.remove("range");
            //获取es中数据
            String reportId = params.get("reportId").getValue().toString();
            try {
            	IPage<OutcontractSignSummaryReportOrgEntity> list = null;

                String authority = request.getHeader("authority");
                //创建一个固定数量的线程池
                ExecutorService threadPool = Executors.newFixedThreadPool(5);
                Integer total = 0;
                try {
                    for(OrgVO orgVO : secondOrg){
                        if(orgVO.getOrgType() != 5 && orgVO.getOrgType() != 4){
                            Callable<OutcontractSignSummaryReportVO> esCallable = new EsCallable(reportId, orgVO.getId(), InvocationInfoProxy.getTenantid(),param,noExitProjectName, authority, RequestContextHolder.getRequestAttributes());
                            Future<OutcontractSignSummaryReportVO> dataFuture = threadPool.submit(esCallable);
                            OutcontractSignSummaryReportVO data = dataFuture.get();
                            data.setCompany(orgVO.getName());
                            if(data.getSumContract()!=null && data.getSumContract()>0){
                                total++;
                                resultList.add(data);
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error("首页信息查询异常：", e);
                } finally {
                    threadPool.shutdown();
                }
				page.setTotal(total);
                page.setRecords(resultList);
            } catch (Exception e) {
                throw new BusinessException("查询全部记录索引失败，MSG：", e);
            }
        } else {
            if (params.get("range") != null) {
                params.remove("range");
            }
            IPage<OutcontractEntity> page1 = new Page<>(param.getPageIndex(), param.getPageSize());
            //根据二级组织id获取数据

            String authority = request.getHeader("authority");
            //创建一个固定数量的线程池
            ExecutorService threadPool = Executors.newFixedThreadPool(5);
            Integer total = 0;
            try {
                for(OrgVO orgVO : secondOrg){
                    if(orgVO.getOrgType() != 5 && orgVO.getOrgType() != 4){
                        Callable<OutcontractSignSummaryReportVO> dataCallable = new DataCallable(orgVO.getId(),param,noExitProjectName, authority, RequestContextHolder.getRequestAttributes());
                        Future<OutcontractSignSummaryReportVO> dataFuture = threadPool.submit(dataCallable);
                        OutcontractSignSummaryReportVO data = dataFuture.get();
                        data.setCompany(orgVO.getName());
                        if(data.getSumContract()!=null && data.getSumContract()>0){
                            total++;
                            resultList.add(data);
                        }
                    }
                }
            } catch (Exception e) {
                logger.error("首页信息查询异常：", e);
            } finally {
                threadPool.shutdown();
            }

            page1.setTotal(total);
            page = new Page<>(param.getPageIndex(), param.getPageSize(), page1.getTotal());
            page.setRecords(resultList);
        }
        return page;
    }

    class DataCallable implements Callable<OutcontractSignSummaryReportVO> {

        private RequestAttributes context;
        private Long orgId;
        private String authority;
        private List<String> noExitProjectName;
        private QueryParam param;
        public DataCallable(Long orgId, QueryParam param, List<String> noExitProjectName, String authority, RequestAttributes context) {
            this.orgId = orgId;
            this.param = param;
            this.noExitProjectName = noExitProjectName;
            this.authority = authority;
            this.context = context;
        }

        @Override
        public OutcontractSignSummaryReportVO call() throws Exception {
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(this.orgId), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
//                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            return this.processData(commonOrgIds,param,noExitProjectName);

        }

        //查询本地数据处理
        public OutcontractSignSummaryReportVO processData(List<Long> orgIds,QueryParam param, List<String> noExitProjectName) {
            OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
            vo.setPackLight(0);
            vo.setExpandSub(0);
            vo.setOtherform(0);
            vo.setLaborAndMaterials(0);
            vo.setWorkersAndAuxiliaryMaterials(0);
            vo.setOtherForms(0);
            List<RecordOutcontractVO> vos = queryList(param, orgIds, noExitProjectName);
            if (vos.size() > 0) {
                vo.setCompany(vos.get(0).getOrgName());//公司
                vo.setSumContract(vos.size());//合同个数
                vo.setSumSubcontractingContent(vos.size());//分包内容合计

                for (RecordOutcontractVO e : vos) {
                    if ("劳务分包".equals(e.getType())) {
                        if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                            switch (e.getLaborSubcontracteMode()) {
                                case "包轻工":
                                    vo.setPackLight(vo.getPackLight() + 1);
                                    break;
                                case "扩大劳务分包":
                                    vo.setExpandSub(vo.getExpandSub() + 1);
                                    break;
                                case "其他形式":
                                    vo.setOtherform(vo.getOtherform() + 1);
                                    break;
                            }
                        }
                    } else if("专业分包".equals(e.getType())){
                        if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                            switch (e.getLaborSubcontracteMode()) {
                                case "包工包料":
                                    vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                                    break;
                                case "包清工辅材":
                                    vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                                    break;
                                case "其他形式":
                                    vo.setOtherForms(vo.getOtherForms() + 1);
                                    break;
                            }
                        }
                    }
                }

                //劳务分包方式
                vos.forEach(e -> {
                    if ("劳务分包".equals(e.getType())) {
                        if (vo.getLabor() == null) {
                            vo.setLabor(0);
                        }
                        vo.setLabor(vo.getLabor() + 1);
                        if (vo.getSumLabor() == null) {
                            vo.setSumLabor(0);
                        }
                        vo.setSumLabor(vo.getSumLabor() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "按实体工程量对应的固定单价":
                                    if (vo.getLaborPrice() == null) {
                                        vo.setLaborPrice(0);
                                    }
                                    vo.setLaborPrice(vo.getLaborPrice() + 1);
                                    break;
                                case "按建筑面积平米的每平米固定单价":
                                    if (vo.getLaborArea() == null) {
                                        vo.setLaborArea(0);
                                    }
                                    vo.setLaborArea(vo.getLaborArea() + 1);
                                    break;
                                case "固定单价":
                                    if (vo.getLaborFixedPrice() == null) {
                                        vo.setLaborFixedPrice(0);
                                    }
                                    vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                    break;
                                case "固定总价":
                                    if (vo.getLaborTotalPrice() == null) {
                                        vo.setLaborTotalPrice(0);
                                    }
                                    vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                    break;
                                case "定额计价":
                                    if (vo.getLaborQuotaValuation() == null) {
                                        vo.setLaborQuotaValuation(0);
                                    }
                                    vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                                    break;
                            }
                        }
                    }
                    if ("专业分包".equals(e.getType())) {
                        if (vo.getMajor() == null) {
                            vo.setMajor(0);
                        }
                        vo.setMajor(vo.getMajor() + 1);
                        if (vo.getSumMajor() == null) {
                            vo.setSumMajor(0);
                        }
                        vo.setSumMajor(vo.getSumMajor() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "按实体工程量对应的固定单价":
                                    if (vo.getMajorPrice() == null) {
                                        vo.setMajorPrice(0);
                                    }
                                    vo.setMajorPrice(vo.getMajorPrice() + 1);
                                    break;
                                case "按承包合同价款让利费率下浮":
                                    if (vo.getRateLower() == null) {
                                        vo.setRateLower(0);
                                    }
                                    vo.setRateLower(vo.getRateLower() + 1);
                                    break;
                                case "固定总价":
                                    if (vo.getMajorTotalPrice() == null) {
                                        vo.setMajorTotalPrice(0);
                                    }
                                    vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                    break;
                                case "定额计价":
                                    if (vo.getMajorQuotaValuation() == null) {
                                        vo.setMajorQuotaValuation(0);
                                    }
                                    vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                                    break;
                            }
                        }
                    }
                    if ("物资采购".equals(e.getType())) {
                        if (vo.getMaterial() == null) {
                            vo.setMaterial(0);
                        }
                        vo.setMaterial(vo.getMaterial() + 1);
                        if (vo.getSumMaterial() == null) {
                            vo.setSumMaterial(0);
                        }
                        vo.setSumMaterial(vo.getSumMaterial() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getMaterialFixedPrice() == null) {
                                        vo.setMaterialFixedPrice(0);
                                    }
                                    vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                    break;
                                case "可调价格":
                                    if (vo.getAdjustablePrice() == null) {
                                        vo.setAdjustablePrice(0);
                                    }
                                    vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                                    break;
                            }
                        }
                    }
                    if ("机械租赁".equals(e.getType())) {
                        if (vo.getEquipment() == null) {
                            vo.setEquipment(0);
                        }
                        vo.setEquipment(vo.getEquipment() + 1);
                        if (vo.getSumEquipment() == null) {
                            vo.setSumEquipment(0);
                        }
                        vo.setSumEquipment(vo.getSumEquipment() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getEquipmentFixedPrice() == null) {
                                        vo.setEquipmentFixedPrice(0);
                                    }
                                    vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getEquipmentOther() == null) {
                                        vo.setEquipmentOther(0);
                                    }
                                    vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("周转材租赁".equals(e.getType())) {
                        if (vo.getTurnoverMaterial() == null) {
                            vo.setTurnoverMaterial(0);
                        }
                        vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                        if (vo.getSumTurnoverMaterial() == null) {
                            vo.setSumTurnoverMaterial(0);
                        }
                        vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getTurnoverMaterialFixedPrice() == null) {
                                        vo.setTurnoverMaterialFixedPrice(0);
                                    }
                                    vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getTurnoverMaterialOther() == null) {
                                        vo.setTurnoverMaterialOther(0);
                                    }
                                    vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("设计勘察".equals(e.getType())) {
                        if (vo.getDesign() == null) {
                            vo.setDesign(0);
                        }
                        vo.setDesign(vo.getDesign() + 1);
                        if (vo.getSumDesign() == null) {
                            vo.setSumDesign(0);
                        }
                        vo.setSumDesign(vo.getSumDesign() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定总价":
                                    if (vo.getDesignTotalPrice() == null) {
                                        vo.setDesignTotalPrice(0);
                                    }
                                    vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                    break;
                                case "固定单价":
                                    if (vo.getDesignFixedPrice() == null) {
                                        vo.setDesignFixedPrice(0);
                                    }
                                    vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getDesignOther() == null) {
                                        vo.setDesignOther(0);
                                    }
                                    vo.setDesignOther(vo.getDesignOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("咨询服务".equals(e.getType())) {
                        if (vo.getConsultancy() == null) {
                            vo.setConsultancy(0);
                        }
                        vo.setConsultancy(vo.getConsultancy() + 1);
                        if (vo.getSumConsultancy() == null) {
                            vo.setSumConsultancy(0);
                        }
                        vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getConsultancyFixedPrice() == null) {
                                        vo.setConsultancyFixedPrice(0);
                                    }
                                    vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getConsultancyOther() == null) {
                                        vo.setConsultancyOther(0);
                                    }
                                    vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("其它合同".equals(e.getType())) {
                        if (vo.getOther() == null) {
                            vo.setOther(0);
                        }
                        vo.setOther(vo.getOther() + 1);
                        if (vo.getSumOther() == null) {
                            vo.setSumOther(0);
                        }
                        vo.setSumOther(vo.getSumOther() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())){
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getOtherFixedPrice() == null) {
                                        vo.setOtherFixedPrice(0);
                                    }
                                    vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getOther1() == null) {
                                        vo.setOther1(0);
                                    }
                                    vo.setOther1(vo.getOther1() + 1);
                                    break;
                            }
                        }
                    }
                });//合同价格形式
                if (vo.getPackLight() == null) {
                    vo.setPackLight(0);
                }
                if (vo.getSmallMechanical() == null) {
                    vo.setSmallMechanical(0);
                }
                if (vo.getExpandSub() == null) {
                    vo.setExpandSub(0);
                }
                if (vo.getOtherform() == null) {
                    vo.setOtherform(0);
                }
                Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
                Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
                vo.setSumLaborSubcontracteMode(Integer.sum(a, b));//劳务分包方式合计
            }
            return vo;
        }

        public List<RecordOutcontractVO> queryList(@RequestBody QueryParam param, List<Long> orgIds, List<String> noExitProjectName) {
            Map<String,Object> params = new HashMap<>();
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            if(StringUtils.isNotBlank(param.getSearchText())){
                params.put("searchText", param.getSearchText());
            }
            if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
                String sql = " order by ";
                for(String key : param.getOrderMap().keySet()){
                    sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
                }
                params.put("ordersql", sql);
            }
            if(orgIds!=null){
                params.put("orgIds", orgIds);
            }
            if(param.getParams().get("commonOrgIds")!=null){
                params.put("commonOrgIds", param.getParams().get("commonOrgIds").getValue());
            }

            params.put("noProject", "noProject");
            if(noExitProjectName!=null && noExitProjectName.size()>0){
                params.put("noExitProjectName", noExitProjectName);
            }

            //签约日期
            if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
                String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
                String sql = "( o.sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
                params.put("signDate", sql);
                String sql1 = "( o.supplementary_sign_time  BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
                params.put("supplementarySignTime", sql1);
            }
            //查询签约日期是本年的
            if(params.get("signDate")==null){
                SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
                String curDate = format2.format(new Date());
                String sql = "( o.sign_date > '"+ curDate + "' )";
                params.put("signDate", sql);
                String sql1 = "( o.supplementary_sign_time > '"+ curDate + "' )";
                params.put("supplementarySignTime", sql1);
            }
            List<Integer> billState = new ArrayList<>();
            billState.add(1);
            billState.add(3);
            params.put("billState", billState);
            List<RecordOutcontractVO> list = contractMapper.queryAllList(params);
            return list;
        }
    }

    public List<RecordOutcontractVO> queryList(@RequestBody QueryParam param, List<Long> orgIds, List<String> noExitProjectName) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
            String sql = " order by ";
            for(String key : param.getOrderMap().keySet()){
                sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
            }
            params.put("ordersql", sql);
        }
        if(orgIds!=null){
            params.put("orgIds", orgIds);
        }

        params.put("noProject", "noProject");
        if(noExitProjectName!=null && noExitProjectName.size()>0){
            params.put("noExitProjectName", noExitProjectName);
        }

        //签约日期
        if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
            String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            String sql = "( o.sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("signDate", sql);
            String sql1 = "( o.supplementary_sign_time  BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("supplementarySignTime", sql1);
        }
        //查询签约日期是本年的
        if(params.get("signDate")==null){
            SimpleDateFormat format2 = new SimpleDateFormat("YYYY");
            String curDate = format2.format(new Date());
            String sql = "( o.sign_date > '"+ curDate + "' )";
            params.put("signDate", sql);
            String sql1 = "( o.supplementary_sign_time > '"+ curDate + "' )";
            params.put("supplementarySignTime", sql1);
        }
        List<Integer> billState = new ArrayList<>();
        billState.add(1);
        billState.add(3);
        params.put("billState", billState);
        List<RecordOutcontractVO> list = contractMapper.queryAllList(params);
        return list;
    }

    class EsCallable implements Callable<OutcontractSignSummaryReportVO> {

        private RequestAttributes context;
        private String reportId;
        private Long orgId;
        private Long tenantId;
        private String authority;
        private List<String> noExitProjectName;
        private QueryParam param;
        public EsCallable(String reportId, Long orgId, Long tenantId, QueryParam param, List<String> noExitProjectName, String authority, RequestAttributes context) {
            this.orgId = orgId;
            this.tenantId = tenantId;
            this.reportId = reportId;
            this.param = param;
            this.noExitProjectName = noExitProjectName;
            this.authority = authority;
            this.context = context;
        }

        @Override
        public OutcontractSignSummaryReportVO call() throws Exception {
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(this.orgId), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<String> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
//                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId().toString());
                }
            });
            return this.selectOrg(reportId, commonOrgIds,param,noExitProjectName);

        }
        //es查询数据处理
        public OutcontractSignSummaryReportVO selectOrg(String reportId, List<String> commonOrgIds, QueryParam param, List<String> noExitProjectName) {
            OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
            vo.setPackLight(0);
            vo.setExpandSub(0);
            vo.setOtherform(0);
            vo.setLaborAndMaterials(0);
            vo.setWorkersAndAuxiliaryMaterials(0);
            vo.setOtherForms(0);
            //查询es中数据
            SearchRequest searchRequest = new SearchRequest(ESSignSummary);
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            //查询参数
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            //获取es中数据
            boolQuery.must(QueryBuilders.matchQuery("reportId", reportId));
            boolQuery.must(QueryBuilders.matchQuery("tenantId", tenantId));
            try {
                if(param.getParams().get("signDate")!=null){
                    String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
                    boolQuery.must(QueryBuilders.rangeQuery("signDate").from(signDate[0]).to(signDate[1]));
                }
//                boolQuery.must(QueryBuilders.matchQuery("orgId", orgId));
                boolQuery.must(QueryBuilders.termsQuery("orgId", commonOrgIds.toArray(new String[commonOrgIds.size()])));

                if(param.getParams().get("commonOrgIds")!=null){
                    List<Long> oids = (List<Long>) param.getParams().get("commonOrgIds").getValue();
                    String[] s = new String[oids.size()];
                    for(int i=0; i<oids.size(); i++){
                        Long d = oids.get(i);
                        s[i] = d.toString();
                    }
                    boolQuery.must(QueryBuilders.termsQuery("orgId", s));
                }

                boolQuery.mustNot(QueryBuilders.matchQuery("type.keyword", "课题支出类合同"));
                if(noExitProjectName!=null && noExitProjectName.size() > 0){
                    for(String name : noExitProjectName){
                        boolQuery.mustNot(QueryBuilders.matchQuery("projectName.keyword", name));
                    }
                }

                sourceBuilder.query(boolQuery);
                CountRequest count = new CountRequest(ESSignSummary);
                count.query(boolQuery);
                CountResponse countResponse = client.count(count, RequestOptions.DEFAULT);
                sourceBuilder.query(boolQuery);
                sourceBuilder.from(0);
                sourceBuilder.size((int) countResponse.getCount());
                sourceBuilder.trackTotalHits(true);
                sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间
                searchRequest.source(sourceBuilder);
                SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                List<OutcontractSignSummaryReportVO> list = new ArrayList<>();
                for(SearchHit hit : hits){
                    Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                    OutcontractSignSummaryReportVO outcontractSignSummaryReportVO = JSON.parseObject(JSON.toJSONString(sourceAsMap), OutcontractSignSummaryReportVO.class);
                    outcontractSignSummaryReportVO.setCompany((String) sourceAsMap.get("orgName"));

                    list.add(outcontractSignSummaryReportVO);

                }

                if (list.size() > 0) {
                    vo.setCompany(list.get(0).getCompany());//公司
                    vo.setSumContract(list.size());//合同个数
                    vo.setSumSubcontractingContent(list.size());//分包项目内容合计
                }
                for (OutcontractSignSummaryReportVO e : list) {
                    if ("劳务分包".equals(e.getType())) {
                        if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                            switch (e.getLaborSubcontracteMode()) {
                                case "包轻工":
                                    vo.setPackLight(vo.getPackLight() + 1);
                                    break;
                                case "扩大劳务分包":
                                    vo.setExpandSub(vo.getExpandSub() + 1);
                                    break;
                                case "其他形式":
                                    vo.setOtherform(vo.getOtherform() + 1);
                                    break;
                            }
                        }
                    } else if("专业分包".equals(e.getType())){
                        if(StringUtils.isNotBlank(e.getLaborSubcontracteMode())) {
                            switch (e.getLaborSubcontracteMode()) {
                                case "包工包料":
                                    vo.setLaborAndMaterials(vo.getLaborAndMaterials() + 1);
                                    break;
                                case "包清工辅材":
                                    vo.setWorkersAndAuxiliaryMaterials(vo.getWorkersAndAuxiliaryMaterials() + 1);
                                    break;
                                case "其他形式":
                                    vo.setOtherForms(vo.getOtherForms() + 1);
                                    break;
                            }
                        }
                    }
                }

                //劳务分包方式
                list.forEach(e -> {
                    if ("劳务分包".equals(e.getType())) {
                        if (vo.getLabor() == null) {
                            vo.setLabor(0);
                        }
                        vo.setLabor(vo.getLabor() + 1);
                        if (vo.getSumLabor() == null) {
                            vo.setSumLabor(0);
                        }
                        vo.setSumLabor(vo.getSumLabor() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "按实体工程量对应的固定单价":
                                    if (vo.getLaborPrice() == null) {
                                        vo.setLaborPrice(0);
                                    }
                                    vo.setLaborPrice(vo.getLaborPrice() + 1);
                                    break;
                                case "按建筑面积平米的每平米固定单价":
                                    if (vo.getLaborArea() == null) {
                                        vo.setLaborArea(0);
                                    }
                                    vo.setLaborArea(vo.getLaborArea() + 1);
                                    break;
                                case "固定单价":
                                    if (vo.getLaborFixedPrice() == null) {
                                        vo.setLaborFixedPrice(0);
                                    }
                                    vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                                    break;
                                case "固定总价":
                                    if (vo.getLaborTotalPrice() == null) {
                                        vo.setLaborTotalPrice(0);
                                    }
                                    vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                                    break;
                                case "定额计价":
                                    if (vo.getLaborQuotaValuation() == null) {
                                        vo.setLaborQuotaValuation(0);
                                    }
                                    vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                                    break;
                            }
                        }
                    }
                    if ("专业分包".equals(e.getType())) {
                        if (vo.getMajor() == null) {
                            vo.setMajor(0);
                        }
                        vo.setMajor(vo.getMajor() + 1);
                        if (vo.getSumMajor() == null) {
                            vo.setSumMajor(0);
                        }
                        vo.setSumMajor(vo.getSumMajor() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "按实体工程量对应的固定单价":
                                    if (vo.getMajorPrice() == null) {
                                        vo.setMajorPrice(0);
                                    }
                                    vo.setMajorPrice(vo.getMajorPrice() + 1);
                                    break;
                                case "按承包合同价款让利费率下浮":
                                    if (vo.getRateLower() == null) {
                                        vo.setRateLower(0);
                                    }
                                    vo.setRateLower(vo.getRateLower() + 1);
                                    break;
                                case "固定总价":
                                    if (vo.getMajorTotalPrice() == null) {
                                        vo.setMajorTotalPrice(0);
                                    }
                                    vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                                    break;
                                case "定额计价":
                                    if (vo.getMajorQuotaValuation() == null) {
                                        vo.setMajorQuotaValuation(0);
                                    }
                                    vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                                    break;
                            }
                        }
                    }
                    if ("物资采购".equals(e.getType())) {
                        if (vo.getMaterial() == null) {
                            vo.setMaterial(0);
                        }
                        vo.setMaterial(vo.getMaterial() + 1);
                        if (vo.getSumMaterial() == null) {
                            vo.setSumMaterial(0);
                        }
                        vo.setSumMaterial(vo.getSumMaterial() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getMaterialFixedPrice() == null) {
                                        vo.setMaterialFixedPrice(0);
                                    }
                                    vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                                    break;
                                case "可调价格":
                                    if (vo.getAdjustablePrice() == null) {
                                        vo.setAdjustablePrice(0);
                                    }
                                    vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                                    break;
                            }
                        }
                    }
                    if ("机械租赁".equals(e.getType())) {
                        if (vo.getEquipment() == null) {
                            vo.setEquipment(0);
                        }
                        vo.setEquipment(vo.getEquipment() + 1);
                        if (vo.getSumEquipment() == null) {
                            vo.setSumEquipment(0);
                        }
                        vo.setSumEquipment(vo.getSumEquipment() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getEquipmentFixedPrice() == null) {
                                        vo.setEquipmentFixedPrice(0);
                                    }
                                    vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getEquipmentOther() == null) {
                                        vo.setEquipmentOther(0);
                                    }
                                    vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("周转材租赁".equals(e.getType())) {
                        if (vo.getTurnoverMaterial() == null) {
                            vo.setTurnoverMaterial(0);
                        }
                        vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                        if (vo.getSumTurnoverMaterial() == null) {
                            vo.setSumTurnoverMaterial(0);
                        }
                        vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getTurnoverMaterialFixedPrice() == null) {
                                        vo.setTurnoverMaterialFixedPrice(0);
                                    }
                                    vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getTurnoverMaterialOther() == null) {
                                        vo.setTurnoverMaterialOther(0);
                                    }
                                    vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("设计勘察".equals(e.getType())) {
                        if (vo.getDesign() == null) {
                            vo.setDesign(0);
                        }
                        vo.setDesign(vo.getDesign() + 1);
                        if (vo.getSumDesign() == null) {
                            vo.setSumDesign(0);
                        }
                        vo.setSumDesign(vo.getSumDesign() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定总价":
                                    if (vo.getDesignTotalPrice() == null) {
                                        vo.setDesignTotalPrice(0);
                                    }
                                    vo.setDesignTotalPrice(vo.getDesignTotalPrice() + 1);
                                    break;
                                case "固定单价":
                                    if (vo.getDesignFixedPrice() == null) {
                                        vo.setDesignFixedPrice(0);
                                    }
                                    vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getDesignOther() == null) {
                                        vo.setDesignOther(0);
                                    }
                                    vo.setDesignOther(vo.getDesignOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("咨询服务".equals(e.getType())) {
                        if (vo.getConsultancy() == null) {
                            vo.setConsultancy(0);
                        }
                        vo.setConsultancy(vo.getConsultancy() + 1);
                        if (vo.getSumConsultancy() == null) {
                            vo.setSumConsultancy(0);
                        }
                        vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getConsultancyFixedPrice() == null) {
                                        vo.setConsultancyFixedPrice(0);
                                    }
                                    vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getConsultancyOther() == null) {
                                        vo.setConsultancyOther(0);
                                    }
                                    vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                                    break;
                            }
                        }
                    }
                    if ("其它合同".equals(e.getType())) {
                        if (vo.getOther() == null) {
                            vo.setOther(0);
                        }
                        vo.setOther(vo.getOther() + 1);
                        if (vo.getSumOther() == null) {
                            vo.setSumOther(0);
                        }
                        vo.setSumOther(vo.getSumOther() + 1);
                        if(StringUtils.isNotBlank(e.getPricingForm())) {
                            switch (e.getPricingForm()) {
                                case "固定单价":
                                    if (vo.getOtherFixedPrice() == null) {
                                        vo.setOtherFixedPrice(0);
                                    }
                                    vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                                    break;
                                case "其它":
                                    if (vo.getOther1() == null) {
                                        vo.setOther1(0);
                                    }
                                    vo.setOther1(vo.getOther1() + 1);
                                    break;
                            }
                        }
                    }
                });//合同价格形式
                if (vo.getPackLight() == null) {
                    vo.setPackLight(0);
                }
                if (vo.getSmallMechanical() == null) {
                    vo.setSmallMechanical(0);
                }
                if (vo.getExpandSub() == null) {
                    vo.setExpandSub(0);
                }
                if (vo.getOtherform() == null) {
                    vo.setOtherform(0);
                }
                Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
                Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
                vo.setSumLaborSubcontracteMode(Integer.sum(a, b));//劳务分包方式合计
            } catch (Exception e) {
                throw new BusinessException("查询全部记录索引失败，MSG：", e);
            }
            return vo;
        }
    }

}
