package com.ejianc.foundation.yzwSync.util;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

public class AESUtil {
    /**
     * 密钥算法
     */
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;
    /**
     * 加密/解密算法-工作模式-填充模式
     */
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static void main(String[] args) throws Exception {
        String pw = "123456";
        String appId = "abc123";
        String openUId = "openuser";
// 计算签名值
        final String signature = signature(pw, appId, openUId);
        System.out.println(signature);
// 解密签名值
        final String decrypt = decrypt(signature, pw);
        System.out.println(decrypt);
    }

    public static String signature(String pw, String appId, String openUid) throws Exception {
        String text = appId + ":" + System.currentTimeMillis() + ":" + openUid;
        return encrypt(text, pw);
    }

    /**
     * 生成key
     */
    public static SecretKey generateKey(String password) throws Exception {
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
// 简单的密钥生成方法，实际应用中应使用更安全的方法
        byte[] keyBytes = new byte[KEY_SIZE / 8];
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(passwordBytes);
        System.arraycopy(digest, 0, keyBytes, 0, keyBytes.length);
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    public static String encrypt(String plainText, String pw) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, generateKey(pw));
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String decrypt(String encryptedText, String pw) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, generateKey(pw));
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedText);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

}
