/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bidWinDisclosure.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bidWinDisclosure.bean.BidWinDisclosureEntity;
import com.ejianc.foundation.bidWinDisclosure.service.IBidWinDisclosureService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="bidWinDisclosure")
public class BidWinDisclosureBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String bidWinDisclosure_sourceType = "zjkj-bidWinDisclosure";
    private static final String bidWinDisclosure_billtype_code = "BT220110000000002";
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBidWinDisclosureService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse list = this.attachmentApi.queryListBySourceId(billId, bidWinDisclosure_billtype_code, bidWinDisclosure_sourceType, "desc");
        if (list.isSuccess()) {
            if (list.getData() == null || ((List)list.getData()).size() <= 0) {
                throw new BusinessException("\u65e0\u9644\u4ef6\uff0c\u4e0d\u80fd\u63d0\u4ea4");
            }
        } else {
            throw new BusinessException("\u6821\u9a8c\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 0) {
            CommonResponse list = this.attachmentApi.queryListBySourceId(billId, bidWinDisclosure_billtype_code, bidWinDisclosure_sourceType, "desc");
            if (list.isSuccess()) {
                if (list.getData() == null || ((List)list.getData()).size() <= 0) {
                    throw new BusinessException("\u65e0\u9644\u4ef6\uff0c\u4e0d\u80fd\u63d0\u4ea4");
                }
            } else {
                throw new BusinessException("\u6821\u9a8c\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BidWinDisclosureEntity entity = (BidWinDisclosureEntity)((Object)this.service.getById(billId));
        if (StringUtils.isNotBlank((CharSequence)entity.getReceiverId())) {
            entity.setCcInfo("\u5df2\u6284\u9001\u7ed9\u63a5\u53d7\u4eba\u3010" + entity.getReceiver() + "\u3011");
            this.service.saveOrUpdate((Object)entity, false);
            String subject = this.getUserName(entity.getCreateUserCode()) + "\u521b\u5efa\u7684\u4e2d\u6807\u4ea4\u5e95\u5355\u636e\u3010\u5355\u636e\u7f16\u7801\uff1a" + entity.getBillCode() + ", \u5de5\u7a0b\u540d\u79f0\uff1a" + entity.getProjectName() + "\u3011\u5df2\u5ba1\u6279\u7ed3\u675f\uff0c\u6284\u9001\u7ed9\u60a8\u67e5\u770b\uff0c\u8bf7\u67e5\u6536";
            String pcurl = this.environmentTools.getBaseHost() + "ejc-outcontract-frontend/#/bidWinDisclosure/card?id=" + billId;
            String maurl = this.environmentTools.getBaseHost() + "ejc-zjkjapproval-mobile/#/disclosure/bidWinDisclosure?userid={userid}&id=" + billId;
            String content = subject + "\u3002<a href=" + '\"' + pcurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            channel.add("dingding");
            JSONObject dingdingParams = new JSONObject();
            dingdingParams.put("title", (Object)subject);
            String ddcontent = subject + ",\u901a\u77e5\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            dingdingParams.put("content", (Object)ddcontent);
            dingdingParams.put("maurl", (Object)maurl);
            dingdingParams.put("pcurl", (Object)pcurl);
            parameter.setDingdingParams(dingdingParams);
            String[] receivers = entity.getReceiverId().split(",");
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(subject);
            parameter.setContent(content);
            parameter.setPcUrl(pcurl);
            parameter.setMobileUrl(maurl);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public String getUserName(String userCode) {
        block10: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost()) || userCode.startsWith("admin") || "guoming".equals(userCode)) break block10;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String baseHost = urlconstants.getBaseHost();
                    if (StringUtils.isNotBlank((CharSequence)baseHost)) {
                        HashMap<String, String> reflist = new HashMap<String, String>();
                        reflist.put("userCode", userCode);
                        String url = baseHost + "ejc-idm-web/commonrefer/getAuditInfo";
                        String jsonbackstr = null;
                        try {
                            jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                            jsonObject = JSON.parseObject((String)jsonbackstr);
                            redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 1L, TimeUnit.DAYS);
                        } else {
                            redisTemplate.opsForValue().set((Object)cacheKey, (Object)userCode, 10L, TimeUnit.MINUTES);
                        }
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("userName");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }
}

