package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractReviewEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractReviewVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 变更分供方合同评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeOutcontractReview")
public class ChangeOutcontractReviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String REVIEW_BILL_CODE = "ZJKJ-OUTCONTRACTREVIEW";//此处需要根据实际修改

    @Autowired
    private IChangeOutcontractReviewService service;

    @Autowired
    private IChangeOutcontractService changeOutcontractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeOutcontractReviewVO> saveOrUpdate(@RequestBody ChangeOutcontractReviewVO saveOrUpdateVO) {
    	ChangeOutcontractReviewEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeOutcontractReviewEntity.class);
    	if(StringUtils.isBlank(entity.getApprovalFormCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(REVIEW_BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setApprovalFormCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ChangeOutcontractReviewVO vo = BeanMapper.map(entity, ChangeOutcontractReviewVO.class);
    	vo.setProjectId(saveOrUpdateVO.getProjectId());
    	vo.setContractName(saveOrUpdateVO.getContractName());
    	vo.setBillCode(saveOrUpdateVO.getBillCode());
    	vo.setSupplier(saveOrUpdateVO.getSupplier());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeOutcontractReviewVO> queryDetail(Long id) {
    	QueryWrapper<ChangeOutcontractReviewEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("change_outcontract_id", id);
    	queryWrapper.eq("dr", 0);
    	List<ChangeOutcontractReviewEntity> entitys = service.list(queryWrapper);
    	ChangeOutcontractReviewVO vo = new ChangeOutcontractReviewVO();
    	vo.setRowState("add");//判断当前数据是新增还是修改
    	if(entitys!=null&&entitys.size()>0){
    		vo = BeanMapper.map(entitys.get(0), ChangeOutcontractReviewVO.class);
        	vo.setRowState("edit");
    	}
    	vo.setChangeOutcontractId(id);
    	//查询项目信息
    	ChangeOutcontractEntity outcontractEntity = changeOutcontractService.selectById(id);
    	vo.setProjectId(outcontractEntity.getProjectId());
    	vo.setContractName(outcontractEntity.getContractName());
    	vo.setBillCode(outcontractEntity.getBillCode());
    	vo.setSupplier(outcontractEntity.getSupplier());
        vo.setContractBillState(outcontractEntity.getBillState());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
