package com.ejianc.foundation.calibration.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.calibration.bean.CalibrationProjectEntity;
import com.ejianc.foundation.calibration.bean.CalibrationSupplierEntity;
import com.ejianc.foundation.calibration.service.ICalibrationProjectService;
import com.ejianc.foundation.calibration.service.ICalibrationSupplierService;
import com.ejianc.foundation.calibration.vo.CalibrationVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.calibration.mapper.CalibrationMapper;
import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.service.ICalibrationService;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 招标(定标)信息
 * 
 * @author generator
 * 
 */
@Service("calibrationService")
public class CalibrationServiceImpl extends BaseServiceImpl<CalibrationMapper, CalibrationEntity> implements ICalibrationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CalibrationMapper calibrationMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareSupplierApi supplierApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private IYzwSyncService yzwSyncService;
    @Autowired
    private ICalibrationProjectService calibrationProjectService;
    @Autowired
    private ICalibrationSupplierService calibrationSupplierService;

    @Override
    public void syncList(String beginTime, String endTime) {
        List<String> idList = yzwSyncService.queryTenderCompletedList(beginTime, endTime);
        if(idList!=null && idList.size()>0){
            List<JSONObject> listJson = yzwSyncService.getTenderCompletedList(idList);
            List<CalibrationEntity> list = new ArrayList<>();
            List<String> codeList = new ArrayList<>();
            for (JSONObject jsonObject : listJson) {
                codeList.add(jsonObject.getString("TenderCode"));
            }
            QueryWrapper<CalibrationEntity> wrapper = new QueryWrapper<>();
            wrapper.in("tender_code", codeList);
            List<CalibrationEntity> exitlist = this.list(wrapper);
            Map<String, CalibrationEntity> maplist = new HashMap<>();
            if(exitlist!=null && exitlist.size()>0){
                for (CalibrationEntity calibrationEntity : exitlist) {
                    maplist.put(calibrationEntity.getTenderCode(), calibrationEntity);
                }
            }
            List<CalibrationProjectEntity> pList = new ArrayList<>();
            List<Long> delProIds = new ArrayList<>();
            List<CalibrationSupplierEntity> sList = new ArrayList<>();
            List<Long> delSupIds = new ArrayList<>();
            List<Integer> supplierNos = new ArrayList<>();
            for (JSONObject jsonObject : listJson) {
                CalibrationEntity entity = null;
                Boolean add = false;
                if(maplist!=null && maplist.get(jsonObject.getString("TenderCode"))!=null){
                    entity = maplist.get(jsonObject.getString("TenderCode"));
                }else{
                    entity = new CalibrationEntity();
                    entity.setId(IdWorker.getId());
                    add = true;
                }
                entity.setYsNo(jsonObject.getString("YsNo")); // 系统编号
                entity.setTenderCode(jsonObject.getString("TenderCode")); // 招标编码
                entity.setName(jsonObject.getString("Name")); // 招标名称
                entity.setOrganizationSysNo(jsonObject.getString("OrganizationSysNo")); // 组织机构系统编号
                entity.setOrganizationCode(jsonObject.getString("OrganizationCode")); // 组织机构代码
                entity.setOrganizationName(jsonObject.getString("OrganizationName")); // 组织机构名称
                entity.setContractType(jsonObject.getString("ContractType")); // 合同类型：0=Purchase=采购合同,1=Agreement=协议合同
//                //没有项目是框架协议，有项目是采购合同
//                if(jsonObject.get("ProjectList")!=null){
//                    entity.setContractType("0");
//                }else{
//                    entity.setContractType("1");
//                }
                entity.setSystemCategoryType(jsonObject.getString("SystemCategoryType")); // 品类类型：0=Material=物资,1=Equipment=设备,2=LaborSubcontract =劳务分包,3=SpecialtySubcontract=专业分包,4=SpecialtyService =专业服务5=Lease =租赁
                if(jsonObject.get("Amount")!=null){
                    entity.setAmount(jsonObject.getBigDecimal("Amount")); // 概算金额
                }
                if(jsonObject.get("CalibrationResultNoticeDate")!=null){
                    try {
                        String CalibrationResultNoticeDate = jsonObject.getString("CalibrationResultNoticeDate");
                        entity.setCalibrationResultNoticeDate(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(CalibrationResultNoticeDate)); // 定标结果发布时间
                    }catch (Exception e){}
                }
                entity.setTenderType(jsonObject.getString("TenderType")); // 招标方式：0=Public=公开招标,1=Invitation=邀请招标,2=Inquiry=询价采购,3=Protocol=议标采购——竞争性谈判,4=Sporadic=零星采购——单一来源采购,5=Emergent=紧急采购,6=Compare=询比采购,7=BiddingPrice=竞价采购,8=Negotiations=谈判采购,9=Direct=直接采购
                entity.setStatus(jsonObject.getString("Status")); // 状态：0=确认招标概要,10=确认招标清单,20=确认招标供应商,30=确认公告内容,40=发布公告预览,42=待发布公告,45=供应商报名,47=供应商报名截止,50=确认报名信息,60=通知报名结果,65=确认发标清单,85=开标人设置,90=确认招标文件内容,100=发布招标文件预览,105=待发布招标文件,110=回标中,115=回标截止,116=评标设置,117=评标概要汇总,118=评标人设置,119=供应商数据导入,120=开标设置,130=开标中,140=开标结果,145=已设置评标人,150=评标,155=调价中,157=调价结束160=确认定标报告,170=发布定标结果,180=结束

                System.out.println(jsonObject.get("BiddingResultAttachmentList"));
                if(jsonObject.get("BiddingResultAttachmentList")!=null){
                    JSONArray BiddingResultAttachmentList = jsonObject.getJSONArray("BiddingResultAttachmentList");
                    List<AttachmentVO> attachmentVOS = new ArrayList<>();
                    String billType = "EJCBT202509000001";
                    if(StringUtils.isNotBlank(entity.getYzwFileNo())){
                        String yzwFileNo = entity.getYzwFileNo();
                        for (Object o : BiddingResultAttachmentList) {
                            JSONObject l = (JSONObject) o;
                            String AttachSysNo = l.getString("AttachSysNo");
                            if(!yzwFileNo.contains(AttachSysNo)){
                                yzwFileNo += (","+l.getString("AttachSysNo"));
                                //添加文件到服务器
                                AttachmentVO vo = new AttachmentVO();
                                vo.setSourceId(entity.getId());
                                vo.setSourceType("BiddingResultAttachmentList");
                                vo.setBillType(billType);
                                vo.setFilePath(l.getString("FileURL"));
                                vo.setFileName(l.getString("FileName"));
                                attachmentVOS.add(vo);
                            }
                        }
                    }else{
                        String yzwFileNo = "";
                        for (Object o : BiddingResultAttachmentList) {
                            JSONObject l = (JSONObject) o;
                            if(yzwFileNo.length()>0){
                                yzwFileNo += (","+l.getString("AttachSysNo"));
                            }else{
                                yzwFileNo += l.getString("AttachSysNo");
                            }
                            AttachmentVO vo = new AttachmentVO();
                            vo.setSourceId(entity.getId());
                            vo.setSourceType("BiddingResultAttachmentList");
                            vo.setBillType(billType);
                            vo.setFilePath(l.getString("FileURL"));
                            vo.setFileName(l.getString("FileName"));
                            attachmentVOS.add(vo);
                        }
                        entity.setYzwFileNo(yzwFileNo);
                    }
                    if(attachmentVOS!=null && attachmentVOS.size()>0){
                        attachmentApi.uploadByUrl(attachmentVOS);
                    }
                }
                String allProject = "";
                if(jsonObject.get("ProjectList")!=null){
                    JSONArray projectList = jsonObject.getJSONArray("ProjectList");
                    if(projectList!=null && projectList.size()>0){
                        if(!add){
                            QueryWrapper<CalibrationProjectEntity> pwr = new QueryWrapper<>();
                            pwr.eq("calibration_id", entity.getId());
                            List<CalibrationProjectEntity> pl = calibrationProjectService.list(pwr);
                            if(pl!=null && pl.size()>0){
                                Map<String, CalibrationProjectEntity> mapPro = new HashMap<>();
                                for (CalibrationProjectEntity calibrationProjectEntity : pl) {
                                    mapPro.put(calibrationProjectEntity.getProjectSysNo(), calibrationProjectEntity);
                                }
                                List<String> cods = new ArrayList<>();
                                for (Object o : projectList) {
                                    JSONObject p = (JSONObject) o;
                                    if(allProject.length()>0){
                                        allProject += ("," + p.getString("ProjectName"));
                                    }else{
                                        allProject += p.getString("ProjectName");
                                    }
                                    cods.add(p.getString("ProjectSysNo"));
                                    CalibrationProjectEntity pe = null;
                                    if(mapPro.get(p.getString("ProjectSysNo"))!=null){
                                        pe = mapPro.get(p.getString("ProjectSysNo"));
                                        pe.setProjectName(p.getString("ProjectName"));
                                        pe.setRowState("edit");
                                        pList.add(pe);
                                    }else{
                                        pe = new CalibrationProjectEntity();
                                        pe.setProjectName(p.getString("ProjectName"));
                                        pe.setProjectSysNo(p.getString("ProjectSysNo"));
                                        pe.setRowState("add");
                                        pList.add(pe);
                                    }
                                }
                                for (CalibrationProjectEntity calibrationProjectEntity : pl) {
                                    if(!cods.contains(calibrationProjectEntity.getProjectSysNo())){
                                        delProIds.add(calibrationProjectEntity.getId());
                                    }
                                }
                            }else{
                                for (Object o : projectList) {
                                    JSONObject j = (JSONObject) o;
                                    if(allProject.length()>0){
                                        allProject += ("," + j.getString("ProjectName"));
                                    }else{
                                        allProject += j.getString("ProjectName");
                                    }
                                    CalibrationProjectEntity p = new CalibrationProjectEntity();
                                    p.setProjectName(j.getString("ProjectName"));
                                    p.setProjectSysNo(j.getString("ProjectSysNo"));
                                    p.setCalibrationId(entity.getId());
                                    p.setRowState("add");
                                    pList.add(p);
                                }
                            }
                        }else{
                            for (Object o : projectList) {
                                JSONObject j = (JSONObject) o;
                                CalibrationProjectEntity p = new CalibrationProjectEntity();
                                p.setProjectName(j.getString("ProjectName"));
                                p.setProjectSysNo(j.getString("ProjectSysNo"));
                                p.setCalibrationId(entity.getId());
                                p.setRowState("add");
                                pList.add(p);
                            }
                        }
                    }else{
                        if(!add){
                            QueryWrapper<CalibrationProjectEntity> pwr = new QueryWrapper<>();
                            pwr.eq("calibration_id", entity.getId());
                            List<CalibrationProjectEntity> pl = calibrationProjectService.list(pwr);
                            if(pl!=null && pl.size()>0){
                                for (CalibrationProjectEntity calibrationProjectEntity : pl) {
                                    delProIds.add(calibrationProjectEntity.getId());
                                }
                            }
                        }
                    }
                }
                entity.setAllProject(allProject);
                if(jsonObject.get("TenderSupplierList")!=null){
                    JSONArray supplierList = jsonObject.getJSONArray("TenderSupplierList");
                    if(supplierList!=null && supplierList.size()>0){
                        if(!add){
                            QueryWrapper<CalibrationSupplierEntity> pwr = new QueryWrapper<>();
                            pwr.eq("calibration_id", entity.getId());
                            List<CalibrationSupplierEntity> pl = calibrationSupplierService.list(pwr);
                            if(pl!=null && pl.size()>0){
                                Map<String, CalibrationSupplierEntity> mapPro = new HashMap<>();
                                for (CalibrationSupplierEntity calibrationSupplierEntity : pl) {
                                    mapPro.put(calibrationSupplierEntity.getSupplierSysNo(), calibrationSupplierEntity);
                                }
                                List<String> cods = new ArrayList<>();
                                for (Object o : supplierList) {
                                    JSONObject p = (JSONObject) o;
                                    String supplierStatus = p.getString("Status");
                                    switch (p.getString("Status")){
                                        case "0":supplierStatus = "未签收公告";break;
                                        case "10":supplierStatus = "签收公告";break;
                                        case "20":supplierStatus = "未报名";break;
                                        case "30":supplierStatus = "已报名";break;
                                        case "40":supplierStatus = "资审中";break;
                                        case "50":supplierStatus = "资审未通过";break;
                                        case "60":supplierStatus = "资审通过";break;
                                        case "70":supplierStatus = "未签收招标";break;
                                        case "80":supplierStatus = "签收招标";break;
                                        case "90":supplierStatus = "未投保";break;
                                        case "100":supplierStatus = "已投标";break;
                                        case "110":supplierStatus = "未中标";break;
                                        case "120":supplierStatus = "已中标";break;
                                    }
                                    cods.add(p.getString("SupplierSysNo"));
                                    supplierNos.add(p.getInteger("SupplierSysNo"));
                                    CalibrationSupplierEntity pe = null;
                                    if(mapPro.get(p.getString("SupplierSysNo"))!=null){
                                        pe = mapPro.get(p.getString("SupplierSysNo"));
                                        pe.setSupplierName(p.getString("SupplierName"));
                                        pe.setSupplierStatus(supplierStatus);
                                        pe.setRowState("edit");
                                        sList.add(pe);
                                    }else{
                                        pe = new CalibrationSupplierEntity();
                                        pe.setSupplierStatus(supplierStatus);
                                        pe.setSupplierName(p.getString("SupplierName"));
                                        pe.setSupplierSysNo(p.getString("SupplierSysNo"));
                                        pe.setSupplierMainSysNo(p.getString("SupplierMainSysNo"));
                                        pe.setCalibrationId(entity.getId());
                                        pe.setRowState("add");
                                        sList.add(pe);
                                    }
                                }
                                for (CalibrationSupplierEntity calibrationSupplierEntity : pl) {
                                    if(!cods.contains(calibrationSupplierEntity.getSupplierSysNo())){
                                        delSupIds.add(calibrationSupplierEntity.getId());
                                    }
                                }
                            }else{
                                for (Object o : supplierList) {
                                    JSONObject j = (JSONObject) o;
                                    String supplierStatus = j.getString("Status");
                                    switch (j.getString("Status")){
                                        case "0":supplierStatus = "未签收公告";break;
                                        case "10":supplierStatus = "签收公告";break;
                                        case "20":supplierStatus = "未报名";break;
                                        case "30":supplierStatus = "已报名";break;
                                        case "40":supplierStatus = "资审中";break;
                                        case "50":supplierStatus = "资审未通过";break;
                                        case "60":supplierStatus = "资审通过";break;
                                        case "70":supplierStatus = "未签收招标";break;
                                        case "80":supplierStatus = "签收招标";break;
                                        case "90":supplierStatus = "未投保";break;
                                        case "100":supplierStatus = "已投标";break;
                                        case "110":supplierStatus = "未中标";break;
                                        case "120":supplierStatus = "已中标";break;
                                    }
                                    supplierNos.add(j.getInteger("SupplierSysNo"));
                                    CalibrationSupplierEntity p = new CalibrationSupplierEntity();
                                    p.setSupplierStatus(supplierStatus);
                                    p.setSupplierName(j.getString("SupplierName"));
                                    p.setSupplierSysNo(j.getString("SupplierSysNo"));
                                    p.setSupplierMainSysNo(j.getString("SupplierMainSysNo"));
                                    p.setCalibrationId(entity.getId());
                                    p.setRowState("add");
                                    sList.add(p);
                                }
                            }
                        }else{
                            for (Object o : supplierList) {
                                JSONObject j = (JSONObject) o;
                                String supplierStatus = j.getString("Status");
                                switch (j.getString("Status")){
                                    case "0":supplierStatus = "未签收公告";break;
                                    case "10":supplierStatus = "签收公告";break;
                                    case "20":supplierStatus = "未报名";break;
                                    case "30":supplierStatus = "已报名";break;
                                    case "40":supplierStatus = "资审中";break;
                                    case "50":supplierStatus = "资审未通过";break;
                                    case "60":supplierStatus = "资审通过";break;
                                    case "70":supplierStatus = "未签收招标";break;
                                    case "80":supplierStatus = "签收招标";break;
                                    case "90":supplierStatus = "未投保";break;
                                    case "100":supplierStatus = "已投标";break;
                                    case "110":supplierStatus = "未中标";break;
                                    case "120":supplierStatus = "已中标";break;
                                }
                                supplierNos.add(j.getInteger("SupplierSysNo"));
                                CalibrationSupplierEntity p = new CalibrationSupplierEntity();
                                p.setSupplierStatus(supplierStatus);
                                p.setSupplierName(j.getString("SupplierName"));
                                p.setSupplierSysNo(j.getString("SupplierSysNo"));
                                p.setSupplierMainSysNo(j.getString("SupplierMainSysNo"));
                                p.setCalibrationId(entity.getId());
                                p.setRowState("add");
                                sList.add(p);
                            }
                        }
                    }else{
                        if(!add){
                            QueryWrapper<CalibrationSupplierEntity> pwr = new QueryWrapper<>();
                            pwr.eq("calibration_id", entity.getId());
                            List<CalibrationSupplierEntity> pl = calibrationSupplierService.list(pwr);
                            if(pl!=null && pl.size()>0){
                                for (CalibrationSupplierEntity calibrationSupplierEntity : pl) {
                                    delSupIds.add(calibrationSupplierEntity.getId());
                                }
                            }
                        }
                    }
                }

                list.add(entity);
            }

            this.saveOrUpdateBatch(list, list.size(), false);
            if(pList!=null && pList.size()>0){
                calibrationProjectService.saveOrUpdateBatch(pList, pList.size(), false);
            }
            if(delProIds!=null && delProIds.size()>0){
                calibrationProjectService.removeByIds(delProIds);
            }
            if(sList!=null && sList.size()>0){
                calibrationSupplierService.saveOrUpdateBatch(sList, sList.size(), false);
            }
            if(delSupIds!=null && delSupIds.size()>0){
                calibrationSupplierService.removeByIds(delSupIds);
            }
            if(supplierNos!=null && supplierNos.size()>0){
                List<SupplierVO> sVOs = new ArrayList<>();
                List<JSONObject> supplierList = yzwSyncService.getTenderSupplierBidDetailList(supplierNos);
                if(supplierList!=null && supplierList.size()>0){
                    CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("tax_payer_type");
                    Map<String, Long> dofMap = new HashMap<>();
                    if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
                        defdocResponse.getData().forEach(item -> {
                            dofMap.put(item.getName(), item.getId());
                        });
                    }
                    for (JSONObject jsonObject : supplierList) {
                        SupplierVO vo = new SupplierVO();
                        vo.setCode(jsonObject.getString("SupplierSysNo"));//新集采平台中供方系统编号	云筑供应商编号
                        vo.setYzwSupplierCode(jsonObject.getString("SupplierSysNo"));//新集采平台中供方系统编号	云筑供应商编号
                        vo.setName(jsonObject.getString("SupplierName"));//供方名称
                        vo.setLegal(jsonObject.getString("Representative"));//法人代表
                        vo.setSocialCreditCode(jsonObject.getString("UnifiedSocialCode"));//统一社会信用代码
                        vo.setBusinessScope(jsonObject.getString("PrimaryBusiness"));//主营业务	经营业务范围
                        vo.setBankName(jsonObject.getString("OpenBank"));//开户行
                        vo.setBankCode(jsonObject.getString("BankAccount"));//银行账号
                        vo.setBankName(jsonObject.getString("OpenCompanyName"));//开户单位名称	账号名
                        vo.setLinkman(jsonObject.getString("ContactPerson"));//联系人
                        vo.setCellphone(jsonObject.getString("Mobile"));//手机
                        if(jsonObject.get("Mobile")!=null){
                            if("1".equals(jsonObject.getString("Mobile"))){
                                vo.setTaxPayerType(dofMap.get("一般纳税人"));
                                vo.setTaxPayerTypeName("一般纳税人");
                            }else if("2".equals(jsonObject.getString("Mobile"))){
                                vo.setTaxPayerType(dofMap.get("小规模纳税人"));
                                vo.setTaxPayerTypeName("小规模纳税人");
                            }
                        }
                        sVOs.add(vo);
                    }
                }
                logger.info("供应商参数：{}", BeanMapper.mapList(sVOs, JSONObject.class));
                CommonResponse<String> dd = supplierApi.syncYzwSupplierList(sVOs);
                logger.info("供应商结果：{},{}",dd.getCode(),dd.getMsg());
            }
        }

    }

    @Override
    public IPage<CalibrationVO> refCalibrationData(Map<String, Object> params) {

        //判断是否公共项目
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
        List<String> plProjectName = new ArrayList<>();
        if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
            defdocResponse.getData().forEach(item -> {
                plProjectName.add(item.getName());
            });
        }
        if(params.get("projectId")!=null){
            String projectId = (String) params.get("projectId");
            CommonResponse<ProjectVO> projectResponse = zjkjProjectApi.queryDetailById(Long.parseLong(projectId));
            if(projectResponse.isSuccess() && projectResponse.getData()!=null){
                params.put("projectSysNo", projectResponse.getData().getYzwProjectCode());
            }
            if(plProjectName.contains(projectResponse.getData().getProjectName())){
                params.put("publicProject", "publicProject");
            }
        }
        if(params.get("supplierId")!=null){
            String supplierId = (String) params.get("supplierId");
            CommonResponse<SupplierVO> supplierResponse = supplierApi.queryById(Long.parseLong(supplierId));
            if(supplierResponse.isSuccess() && supplierResponse.getData()!=null){
                params.put("supplierSysNo", supplierResponse.getData().getYzwSupplierCode());
            }
        }

        logger.info("---------------------");
        logger.info(BeanMapper.map(params, JSONObject.class).toJSONString());
        Long count = calibrationMapper.countRefer(params);
        Integer pageIndex = (Integer) params.get("pageIndex");
        Integer pageSize = (Integer) params.get("pageSize");
        IPage<CalibrationVO> pageData = new Page<>(pageIndex, pageSize, count);
        if(count>0){
            List<CalibrationVO> list = calibrationMapper.queryReferList(params);
            List<String> supplierCodes = new ArrayList<>();
            List<Long> ids = new ArrayList<>();
            for(CalibrationVO vo : list){
                ids.add(vo.getId());
                if(!supplierCodes.contains(vo.getSupplierSysNo())){
                    supplierCodes.add(vo.getSupplierSysNo());
                }
            }
            Map<String, SupplierVO> supMap = new HashMap<>();
            CommonResponse<List<SupplierVO>> supplierResponse = supplierApi.getYzwSupplierList(supplierCodes);
            if(supplierResponse.isSuccess() && supplierResponse.getData()!=null && supplierResponse.getData().size()>0){
                for (SupplierVO datum : supplierResponse.getData()) {
                    supMap.put(datum.getYzwSupplierCode(), datum);
                }
                for(CalibrationVO vo : list){
                    ids.add(vo.getId());
                    if(supMap.get(vo.getSupplierSysNo())!=null){
                        SupplierVO data = supMap.get(vo.getSupplierSysNo());
                        vo.setSupplierId(data.getId());
                        vo.setSupplierTaxPayerType(data.getTaxPayerType());
                        vo.setSupplierSocialCreditCode(data.getSocialCreditCode());
                        vo.setSupplierBank(data.getBankCode());
                        vo.setSupplierBankAccount(data.getBankAccount());
                        vo.setSupplierLegal(data.getLegal());
                        vo.setSupplierTelephone(data.getTelephone());
                    }
                }
            }
            pageData.setRecords(list);
        }
        return pageData;
    }

    @Override
    public List<String> queryYzwCode(Map<String, Object> params){
        List<String> codeList = calibrationMapper.queryYzwCode(params);
        return codeList;
    }
}
