package com.ejianc.foundation.calibration.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.calibration.bean.CalibrationProjectEntity;
import com.ejianc.foundation.calibration.service.ICalibrationProjectService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.service.ICalibrationService;
import com.ejianc.foundation.calibration.vo.CalibrationVO;

/**
 * 招标(定标)信息
 *
 * @author generator
 */
@Controller
@RequestMapping("calibration")
public class CalibrationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalibrationService service;
    @Autowired
    private ICalibrationProjectService projectService;
    @Autowired
    private IYzwSyncService yzwSyncService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CalibrationVO> saveOrUpdate(@RequestBody CalibrationVO saveOrUpdateVO) {
        CalibrationEntity entity = BeanMapper.map(saveOrUpdateVO, CalibrationEntity.class);
        service.saveOrUpdate(entity, false);
        CalibrationVO vo = BeanMapper.map(entity, CalibrationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CalibrationVO> queryDetail(Long id) {
        CalibrationEntity entity = service.selectById(id);
        CalibrationVO vo = BeanMapper.map(entity, CalibrationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CalibrationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CalibrationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CalibrationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("allProject");
        fuzzyFields.add("organizationName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //获取本下组织项目

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> projectParams = new HashMap<>();
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            projectParams.put("orgId", commonOrgIds);
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            projectParams.put("projectDepartmentId", departmentIds);
        }
        List<String> codeList = service.queryYzwCode(projectParams);
        QueryWrapper<CalibrationProjectEntity> wrapper = new QueryWrapper<>();
        wrapper.in("project_sys_no", codeList);
        List<CalibrationProjectEntity> list = projectService.list(wrapper);
        List<Long> idList = new ArrayList<>();
        if(list!=null && list.size()>0){
            for (CalibrationProjectEntity calibrationProjectEntity : list) {
                if(!idList.contains(calibrationProjectEntity.getCalibrationId())){
                    idList.add(calibrationProjectEntity.getCalibrationId());
                }
            }
        }
        param.getParams().put("id", new Parameter(QueryParam.IN,idList));
        IPage<CalibrationEntity> page = service.queryPage(param, false);
        IPage<CalibrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CalibrationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("organizationName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CalibrationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Calibration-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryTenderCompletedList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> queryTenderCompletedList(String beginTime, String endTime) {
        return CommonResponse.success("查询成功！", yzwSyncService.queryTenderCompletedList(beginTime, endTime));
    }
    @RequestMapping(value = "/getTenderSupplierBidDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> getTenderSupplierBidDetailList(List<Integer> SupplierSysNos) {
        return CommonResponse.success("查询成功！", yzwSyncService.getTenderSupplierBidDetailList(SupplierSysNos));
    }

    @RequestMapping(value = "/syncList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncList(String beginTime, String endTime) {
        service.syncList(beginTime, endTime);
        return CommonResponse.success("同步成功！");
    }


    @RequestMapping(value = "/syncCalibrationList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncCalibrationList() {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        String beginTime = df1.format(calendar.getTime()) + " 00:00:00";
        String endTime = df1.format(new Date()) + " 00:00:00";
        service.syncList(beginTime, endTime);
        return CommonResponse.success("同步成功！");
    }


    /**
     * @Description 参照---供应商
     * @Return void
     */
    @RequestMapping(value = "/refCalibrationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> refCalibrationData(@RequestParam Integer pageNumber,
                                                                        @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {

        Map<String,Object> params = new HashMap<>();
        long startLine = (pageNumber < 1 ? 0 : pageNumber -  1) * pageSize;
        params.put("startLine", startLine);
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                params.put("projectId", _con.get("projectId"));
            }
            if(_con.get("supplierId")!=null){
                params.put("supplierId", _con.get("supplierId"));
            }
            if(_con.get("contractId")!=null){
                params.put("contractId", _con.get("contractId"));
            }
        }
        IPage<CalibrationVO> page = service.refCalibrationData(params);

        return CommonResponse.success("查询参照数据成功！",page);
    }

}
