/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.calibration.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.bean.CalibrationProjectEntity;
import com.ejianc.foundation.calibration.service.ICalibrationProjectService;
import com.ejianc.foundation.calibration.service.ICalibrationService;
import com.ejianc.foundation.calibration.vo.CalibrationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"calibration"})
public class CalibrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalibrationService service;
    @Autowired
    private ICalibrationProjectService projectService;
    @Autowired
    private IYzwSyncService yzwSyncService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CalibrationVO> saveOrUpdate(@RequestBody CalibrationVO saveOrUpdateVO) {
        CalibrationEntity entity = (CalibrationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CalibrationEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CalibrationVO vo = (CalibrationVO)BeanMapper.map((Object)((Object)entity), CalibrationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CalibrationVO> queryDetail(Long id) {
        CalibrationEntity entity = (CalibrationEntity)((Object)this.service.selectById(id));
        CalibrationVO vo = (CalibrationVO)BeanMapper.map((Object)((Object)entity), CalibrationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CalibrationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CalibrationVO calibrationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("allProject");
        fuzzyFields.add("organizationName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        HashMap<String, Object> projectParams = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            projectParams.put("orgId", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            projectParams.put("projectDepartmentId", departmentIds);
        }
        List<String> codeList = this.service.queryYzwCode(projectParams);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"project_sys_no", codeList);
        List list = this.projectService.list((Wrapper)wrapper);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            for (CalibrationProjectEntity calibrationProjectEntity : list) {
                if (idList.contains(calibrationProjectEntity.getCalibrationId())) continue;
                idList.add(calibrationProjectEntity.getCalibrationId());
            }
        }
        param.getParams().put("id", new Parameter("in", idList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CalibrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("ysNo");
        fuzzyFields.add("tenderCode");
        fuzzyFields.add("name");
        fuzzyFields.add("organizationSysNo");
        fuzzyFields.add("organizationCode");
        fuzzyFields.add("organizationName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Calibration-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryTenderCompletedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> queryTenderCompletedList(String beginTime, String endTime) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.yzwSyncService.queryTenderCompletedList(beginTime, endTime));
    }

    @RequestMapping(value={"/getTenderSupplierBidDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> getTenderSupplierBidDetailList(List<Integer> SupplierSysNos) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.yzwSyncService.getTenderSupplierBidDetailList(SupplierSysNos));
    }

    @RequestMapping(value={"/syncList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncList(String beginTime, String endTime) {
        this.service.syncList(beginTime, endTime);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/syncCalibrationList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncCalibrationList() {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String beginTime = df1.format(calendar.getTime()) + " 00:00:00";
        String endTime = df1.format(new Date()) + " 00:00:00";
        this.service.syncList(beginTime, endTime);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refCalibrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CalibrationVO>> refCalibrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        long startLine = (pageNumber < 1 ? 0 : pageNumber - 1) * pageSize;
        params.put("startLine", startLine);
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                params.put("projectId", _con.get((Object)"projectId"));
            }
            if (_con.get((Object)"supplierId") != null) {
                params.put("supplierId", _con.get((Object)"supplierId"));
            }
            if (_con.get((Object)"contractId") != null) {
                params.put("contractId", _con.get((Object)"contractId"));
            }
        }
        IPage<CalibrationVO> page = this.service.refCalibrationData(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", page);
    }
}

