/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import cn.hutool.poi.excel.ExcelUtil;
import com.ejianc.framework.core.exception.BusinessException;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtilManySheet {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static void exportSheets(List<String> sheetsName, List<String> titleNames, List<List<List<Object>>> datas, HttpServletResponse response) {
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            ExcelUtilManySheet.dealSheets(sheetsName, titleNames, datas, wb);
            String filename = "test";
            response.setContentType("application/octet-stream");
            response.setHeader("content-type", "application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25,\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    public static void dealSheets(List<String> sheetsName, List<String> titleNames, List<List<List<Object>>> datas, XSSFWorkbook wb) throws IOException {
        for (int i = 0; i < sheetsName.size(); ++i) {
            List<List<Object>> data;
            String sheetName = sheetsName.get(i);
            XSSFSheet sheet = wb.createSheet(sheetName);
            if (titleNames != null && titleNames.size() > 0) {
                String titleName = titleNames.get(i);
                XSSFRow row1 = sheet.createRow(0);
                XSSFCell cell = row1.createCell(0);
                cell.setCellValue(titleName);
                if (datas.get(i).size() > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, datas.get(i).get(0).size() - 1));
                }
                cell.getCellStyle().setBorderBottom(BorderStyle.THIN);
                cell.getCellStyle().setBorderLeft(BorderStyle.THIN);
                cell.getCellStyle().setBorderRight(BorderStyle.THIN);
                cell.getCellStyle().setBorderTop(BorderStyle.THIN);
                cell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
                cell.getCellStyle().setVerticalAlignment(VerticalAlignment.CENTER);
                cell.getCellStyle().setFillBackgroundColor(new XSSFColor(new Color(230, 230, 230)));
                XSSFFont font = wb.createFont();
                font.setBold(true);
                cell.getCellStyle().setFont((Font)font);
            }
            if ((data = datas.get(i)) == null || data.size() <= 0) continue;
            for (int k = 0; k < data.size(); ++k) {
                List<Object> da = data.get(k);
                XSSFRow row = sheet.createRow(k + 1);
                for (int j = 0; j < da.size(); ++j) {
                    String value = null;
                    if (da.get(j) instanceof BigDecimal) {
                        if (da.get(j) != null) {
                            BigDecimal va = (BigDecimal)da.get(j);
                            va = va.setScale(2, 4);
                            value = va.toString();
                        }
                    } else {
                        value = da.get(j) != null ? da.get(j).toString() : null;
                    }
                    XSSFCell cell = row.createCell(j);
                    cell.setCellValue(value);
                    cell.getCellStyle().setBorderBottom(BorderStyle.THIN);
                    cell.getCellStyle().setBorderLeft(BorderStyle.THIN);
                    cell.getCellStyle().setBorderRight(BorderStyle.THIN);
                    cell.getCellStyle().setBorderTop(BorderStyle.THIN);
                }
            }
        }
    }
}

