package com.ejianc.foundation.calibration.controller.api;

import com.ejianc.foundation.calibration.bean.CalibrationEntity;
import com.ejianc.foundation.calibration.service.ICalibrationService;
import com.ejianc.foundation.calibration.vo.CalibrationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 招标(定标)信息
 *
 * @author generator
 */
@Controller
@RequestMapping("api/calibration")
public class CalibrationApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalibrationService service;

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CalibrationVO> queryDetail(Long id) {
        CalibrationEntity entity = service.selectById(id);
        CalibrationVO vo = BeanMapper.map(entity, CalibrationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

}
