/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.yzwSync.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static void main(String[] args) throws Exception {
        String pw = "123456";
        String appId = "abc123";
        String openUId = "openuser";
        String signature = AESUtil.signature(pw, appId, openUId);
        System.out.println(signature);
        String decrypt = AESUtil.decrypt(signature, pw);
        System.out.println(decrypt);
    }

    public static String signature(String pw, String appId, String openUid) throws Exception {
        String text = appId + ":" + System.currentTimeMillis() + ":" + openUid;
        return AESUtil.encrypt(text, pw);
    }

    public static SecretKey generateKey(String password) throws Exception {
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = new byte[16];
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(passwordBytes);
        System.arraycopy(digest, 0, keyBytes, 0, keyBytes.length);
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    public static String encrypt(String plainText, String pw) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, AESUtil.generateKey(pw));
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String decrypt(String encryptedText, String pw) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, AESUtil.generateKey(pw));
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedText);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }
}

